// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package networkmanageriface provides an interface to enable mocking the AWS Network Manager service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package networkmanageriface

import (
	"github.com/aws/aws-sdk-go-v2/service/networkmanager"
)

// ClientAPI provides an interface to enable mocking the
// networkmanager.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // NetworkManager.
//    func myFunc(svc networkmanageriface.ClientAPI) bool {
//        // Make svc.AssociateCustomerGateway request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := networkmanager.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        networkmanageriface.ClientPI
//    }
//    func (m *mockClientClient) AssociateCustomerGateway(input *networkmanager.AssociateCustomerGatewayInput) (*networkmanager.AssociateCustomerGatewayOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	AssociateCustomerGatewayRequest(*networkmanager.AssociateCustomerGatewayInput) networkmanager.AssociateCustomerGatewayRequest

	AssociateLinkRequest(*networkmanager.AssociateLinkInput) networkmanager.AssociateLinkRequest

	CreateDeviceRequest(*networkmanager.CreateDeviceInput) networkmanager.CreateDeviceRequest

	CreateGlobalNetworkRequest(*networkmanager.CreateGlobalNetworkInput) networkmanager.CreateGlobalNetworkRequest

	CreateLinkRequest(*networkmanager.CreateLinkInput) networkmanager.CreateLinkRequest

	CreateSiteRequest(*networkmanager.CreateSiteInput) networkmanager.CreateSiteRequest

	DeleteDeviceRequest(*networkmanager.DeleteDeviceInput) networkmanager.DeleteDeviceRequest

	DeleteGlobalNetworkRequest(*networkmanager.DeleteGlobalNetworkInput) networkmanager.DeleteGlobalNetworkRequest

	DeleteLinkRequest(*networkmanager.DeleteLinkInput) networkmanager.DeleteLinkRequest

	DeleteSiteRequest(*networkmanager.DeleteSiteInput) networkmanager.DeleteSiteRequest

	DeregisterTransitGatewayRequest(*networkmanager.DeregisterTransitGatewayInput) networkmanager.DeregisterTransitGatewayRequest

	DescribeGlobalNetworksRequest(*networkmanager.DescribeGlobalNetworksInput) networkmanager.DescribeGlobalNetworksRequest

	DisassociateCustomerGatewayRequest(*networkmanager.DisassociateCustomerGatewayInput) networkmanager.DisassociateCustomerGatewayRequest

	DisassociateLinkRequest(*networkmanager.DisassociateLinkInput) networkmanager.DisassociateLinkRequest

	GetCustomerGatewayAssociationsRequest(*networkmanager.GetCustomerGatewayAssociationsInput) networkmanager.GetCustomerGatewayAssociationsRequest

	GetDevicesRequest(*networkmanager.GetDevicesInput) networkmanager.GetDevicesRequest

	GetLinkAssociationsRequest(*networkmanager.GetLinkAssociationsInput) networkmanager.GetLinkAssociationsRequest

	GetLinksRequest(*networkmanager.GetLinksInput) networkmanager.GetLinksRequest

	GetSitesRequest(*networkmanager.GetSitesInput) networkmanager.GetSitesRequest

	GetTransitGatewayRegistrationsRequest(*networkmanager.GetTransitGatewayRegistrationsInput) networkmanager.GetTransitGatewayRegistrationsRequest

	ListTagsForResourceRequest(*networkmanager.ListTagsForResourceInput) networkmanager.ListTagsForResourceRequest

	RegisterTransitGatewayRequest(*networkmanager.RegisterTransitGatewayInput) networkmanager.RegisterTransitGatewayRequest

	TagResourceRequest(*networkmanager.TagResourceInput) networkmanager.TagResourceRequest

	UntagResourceRequest(*networkmanager.UntagResourceInput) networkmanager.UntagResourceRequest

	UpdateDeviceRequest(*networkmanager.UpdateDeviceInput) networkmanager.UpdateDeviceRequest

	UpdateGlobalNetworkRequest(*networkmanager.UpdateGlobalNetworkInput) networkmanager.UpdateGlobalNetworkRequest

	UpdateLinkRequest(*networkmanager.UpdateLinkInput) networkmanager.UpdateLinkRequest

	UpdateSiteRequest(*networkmanager.UpdateSiteInput) networkmanager.UpdateSiteRequest
}

var _ ClientAPI = (*networkmanager.Client)(nil)
