// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworks

import (
	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Describes an agent version.
type AgentVersion struct {
	_ struct{} `type:"structure"`

	// The configuration manager.
	ConfigurationManager *StackConfigurationManager `type:"structure"`

	// The agent version.
	Version *string `type:"string"`
}

// String returns the string representation
func (s AgentVersion) String() string {
	return awsutil.Prettify(s)
}

// A description of the app.
type App struct {
	_ struct{} `type:"structure"`

	// The app ID.
	AppId *string `type:"string"`

	// A Source object that describes the app repository.
	AppSource *Source `type:"structure"`

	// The stack attributes.
	Attributes map[string]string `type:"map"`

	// When the app was created.
	CreatedAt *string `type:"string"`

	// The app's data sources.
	DataSources []DataSource `type:"list"`

	// A description of the app.
	Description *string `type:"string"`

	// The app vhost settings with multiple domains separated by commas. For example:
	// 'www.example.com, example.com'
	Domains []string `type:"list"`

	// Whether to enable SSL for the app.
	EnableSsl *bool `type:"boolean"`

	// An array of EnvironmentVariable objects that specify environment variables
	// to be associated with the app. After you deploy the app, these variables
	// are defined on the associated app server instances. For more information,
	// see Environment Variables (https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment).
	//
	// There is no specific limit on the number of environment variables. However,
	// the size of the associated data structure - which includes the variable names,
	// values, and protected flag values - cannot exceed 20 KB. This limit should
	// accommodate most if not all use cases, but if you do exceed it, you will
	// cause an exception (API) with an "Environment: is too large (maximum is 20
	// KB)" message.
	Environment []EnvironmentVariable `type:"list"`

	// The app name.
	Name *string `type:"string"`

	// The app's short name.
	Shortname *string `type:"string"`

	// An SslConfiguration object with the SSL configuration.
	SslConfiguration *SslConfiguration `type:"structure"`

	// The app stack ID.
	StackId *string `type:"string"`

	// The app type.
	Type AppType `type:"string" enum:"true"`
}

// String returns the string representation
func (s App) String() string {
	return awsutil.Prettify(s)
}

// Describes a load-based auto scaling upscaling or downscaling threshold configuration,
// which specifies when AWS OpsWorks Stacks starts or stops load-based instances.
type AutoScalingThresholds struct {
	_ struct{} `type:"structure"`

	// Custom Cloudwatch auto scaling alarms, to be used as thresholds. This parameter
	// takes a list of up to five alarm names, which are case sensitive and must
	// be in the same region as the stack.
	//
	// To use custom alarms, you must update your service role to allow cloudwatch:DescribeAlarms.
	// You can either have AWS OpsWorks Stacks update the role for you when you
	// first use this feature or you can edit the role manually. For more information,
	// see Allowing AWS OpsWorks Stacks to Act on Your Behalf (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-servicerole.html).
	Alarms []string `type:"list"`

	// The CPU utilization threshold, as a percent of the available CPU. A value
	// of -1 disables the threshold.
	CpuThreshold *float64 `type:"double"`

	// The amount of time (in minutes) after a scaling event occurs that AWS OpsWorks
	// Stacks should ignore metrics and suppress additional scaling events. For
	// example, AWS OpsWorks Stacks adds new instances following an upscaling event
	// but the instances won't start reducing the load until they have been booted
	// and configured. There is no point in raising additional scaling events during
	// that operation, which typically takes several minutes. IgnoreMetricsTime
	// allows you to direct AWS OpsWorks Stacks to suppress scaling events long
	// enough to get the new instances online.
	IgnoreMetricsTime *int64 `min:"1" type:"integer"`

	// The number of instances to add or remove when the load exceeds a threshold.
	InstanceCount *int64 `type:"integer"`

	// The load threshold. A value of -1 disables the threshold. For more information
	// about how load is computed, see Load (computing) (http://en.wikipedia.org/wiki/Load_%28computing%29).
	LoadThreshold *float64 `type:"double"`

	// The memory utilization threshold, as a percent of the available memory. A
	// value of -1 disables the threshold.
	MemoryThreshold *float64 `type:"double"`

	// The amount of time, in minutes, that the load must exceed a threshold before
	// more instances are added or removed.
	ThresholdsWaitTime *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s AutoScalingThresholds) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoScalingThresholds) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AutoScalingThresholds"}
	if s.IgnoreMetricsTime != nil && *s.IgnoreMetricsTime < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("IgnoreMetricsTime", 1))
	}
	if s.ThresholdsWaitTime != nil && *s.ThresholdsWaitTime < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("ThresholdsWaitTime", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a block device mapping. This data type maps directly to the Amazon
// EC2 BlockDeviceMapping (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_BlockDeviceMapping.html)
// data type.
type BlockDeviceMapping struct {
	_ struct{} `type:"structure"`

	// The device name that is exposed to the instance, such as /dev/sdh. For the
	// root device, you can use the explicit device name or you can set this parameter
	// to ROOT_DEVICE and AWS OpsWorks Stacks will provide the correct device name.
	DeviceName *string `type:"string"`

	// An EBSBlockDevice that defines how to configure an Amazon EBS volume when
	// the instance is launched.
	Ebs *EbsBlockDevice `type:"structure"`

	// Suppresses the specified device included in the AMI's block device mapping.
	NoDevice *string `type:"string"`

	// The virtual device name. For more information, see BlockDeviceMapping (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_BlockDeviceMapping.html).
	VirtualName *string `type:"string"`
}

// String returns the string representation
func (s BlockDeviceMapping) String() string {
	return awsutil.Prettify(s)
}

// Describes the Chef configuration.
type ChefConfiguration struct {
	_ struct{} `type:"structure"`

	// The Berkshelf version.
	BerkshelfVersion *string `type:"string"`

	// Whether to enable Berkshelf.
	ManageBerkshelf *bool `type:"boolean"`
}

// String returns the string representation
func (s ChefConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Describes the Amazon CloudWatch logs configuration for a layer.
type CloudWatchLogsConfiguration struct {
	_ struct{} `type:"structure"`

	// Whether CloudWatch Logs is enabled for a layer.
	Enabled *bool `type:"boolean"`

	// A list of configuration options for CloudWatch Logs.
	LogStreams []CloudWatchLogsLogStream `type:"list"`
}

// String returns the string representation
func (s CloudWatchLogsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Describes the Amazon CloudWatch logs configuration for a layer. For detailed
// information about members of this data type, see the CloudWatch Logs Agent
// Reference (https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AgentReference.html).
type CloudWatchLogsLogStream struct {
	_ struct{} `type:"structure"`

	// Specifies the max number of log events in a batch, up to 10000. The default
	// value is 1000.
	BatchCount *int64 `type:"integer"`

	// Specifies the maximum size of log events in a batch, in bytes, up to 1048576
	// bytes. The default value is 32768 bytes. This size is calculated as the sum
	// of all event messages in UTF-8, plus 26 bytes for each log event.
	BatchSize *int64 `type:"integer"`

	// Specifies the time duration for the batching of log events. The minimum value
	// is 5000ms and default value is 5000ms.
	BufferDuration *int64 `type:"integer"`

	// Specifies how the time stamp is extracted from logs. For more information,
	// see the CloudWatch Logs Agent Reference (https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AgentReference.html).
	DatetimeFormat *string `type:"string"`

	// Specifies the encoding of the log file so that the file can be read correctly.
	// The default is utf_8. Encodings supported by Python codecs.decode() can be
	// used here.
	Encoding CloudWatchLogsEncoding `type:"string" enum:"true"`

	// Specifies log files that you want to push to CloudWatch Logs.
	//
	// File can point to a specific file or multiple files (by using wild card characters
	// such as /var/log/system.log*). Only the latest file is pushed to CloudWatch
	// Logs, based on file modification time. We recommend that you use wild card
	// characters to specify a series of files of the same type, such as access_log.2014-06-01-01,
	// access_log.2014-06-01-02, and so on by using a pattern like access_log.*.
	// Don't use a wildcard to match multiple file types, such as access_log_80
	// and access_log_443. To specify multiple, different file types, add another
	// log stream entry to the configuration file, so that each log file type is
	// stored in a different log group.
	//
	// Zipped files are not supported.
	File *string `type:"string"`

	// Specifies the range of lines for identifying a file. The valid values are
	// one number, or two dash-delimited numbers, such as '1', '2-5'. The default
	// value is '1', meaning the first line is used to calculate the fingerprint.
	// Fingerprint lines are not sent to CloudWatch Logs unless all specified lines
	// are available.
	FileFingerprintLines *string `type:"string"`

	// Specifies where to start to read data (start_of_file or end_of_file). The
	// default is start_of_file. This setting is only used if there is no state
	// persisted for that log stream.
	InitialPosition CloudWatchLogsInitialPosition `type:"string" enum:"true"`

	// Specifies the destination log group. A log group is created automatically
	// if it doesn't already exist. Log group names can be between 1 and 512 characters
	// long. Allowed characters include a-z, A-Z, 0-9, '_' (underscore), '-' (hyphen),
	// '/' (forward slash), and '.' (period).
	LogGroupName *string `type:"string"`

	// Specifies the pattern for identifying the start of a log message.
	MultiLineStartPattern *string `type:"string"`

	// Specifies the time zone of log event time stamps.
	TimeZone CloudWatchLogsTimeZone `type:"string" enum:"true"`
}

// String returns the string representation
func (s CloudWatchLogsLogStream) String() string {
	return awsutil.Prettify(s)
}

// Describes a command.
type Command struct {
	_ struct{} `type:"structure"`

	// Date and time when the command was acknowledged.
	AcknowledgedAt *string `type:"string"`

	// The command ID.
	CommandId *string `type:"string"`

	// Date when the command completed.
	CompletedAt *string `type:"string"`

	// Date and time when the command was run.
	CreatedAt *string `type:"string"`

	// The command deployment ID.
	DeploymentId *string `type:"string"`

	// The command exit code.
	ExitCode *int64 `type:"integer"`

	// The ID of the instance where the command was executed.
	InstanceId *string `type:"string"`

	// The URL of the command log.
	LogUrl *string `type:"string"`

	// The command status:
	//
	//    * failed
	//
	//    * successful
	//
	//    * skipped
	//
	//    * pending
	Status *string `type:"string"`

	// The command type:
	//
	//    * configure
	//
	//    * deploy
	//
	//    * execute_recipes
	//
	//    * install_dependencies
	//
	//    * restart
	//
	//    * rollback
	//
	//    * setup
	//
	//    * start
	//
	//    * stop
	//
	//    * undeploy
	//
	//    * update_custom_cookbooks
	//
	//    * update_dependencies
	Type *string `type:"string"`
}

// String returns the string representation
func (s Command) String() string {
	return awsutil.Prettify(s)
}

// Describes an app's data source.
type DataSource struct {
	_ struct{} `type:"structure"`

	// The data source's ARN.
	Arn *string `type:"string"`

	// The database name.
	DatabaseName *string `type:"string"`

	// The data source's type, AutoSelectOpsworksMysqlInstance, OpsworksMysqlInstance,
	// RdsDbInstance, or None.
	Type *string `type:"string"`
}

// String returns the string representation
func (s DataSource) String() string {
	return awsutil.Prettify(s)
}

// Describes a deployment of a stack or app.
type Deployment struct {
	_ struct{} `type:"structure"`

	// The app ID.
	AppId *string `type:"string"`

	// Used to specify a stack or deployment command.
	Command *DeploymentCommand `type:"structure"`

	// A user-defined comment.
	Comment *string `type:"string"`

	// Date when the deployment completed.
	CompletedAt *string `type:"string"`

	// Date when the deployment was created.
	CreatedAt *string `type:"string"`

	// A string that contains user-defined custom JSON. It can be used to override
	// the corresponding default stack configuration attribute values for stack
	// or to pass data to recipes. The string should be in the following format:
	//
	// "{\"key1\": \"value1\", \"key2\": \"value2\",...}"
	//
	// For more information on custom JSON, see Use Custom JSON to Modify the Stack
	// Configuration Attributes (https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html).
	CustomJson *string `type:"string"`

	// The deployment ID.
	DeploymentId *string `type:"string"`

	// The deployment duration.
	Duration *int64 `type:"integer"`

	// The user's IAM ARN.
	IamUserArn *string `type:"string"`

	// The IDs of the target instances.
	InstanceIds []string `type:"list"`

	// The stack ID.
	StackId *string `type:"string"`

	// The deployment status:
	//
	//    * running
	//
	//    * successful
	//
	//    * failed
	Status *string `type:"string"`
}

// String returns the string representation
func (s Deployment) String() string {
	return awsutil.Prettify(s)
}

// Used to specify a stack or deployment command.
type DeploymentCommand struct {
	_ struct{} `type:"structure"`

	// The arguments of those commands that take arguments. It should be set to
	// a JSON object with the following format:
	//
	// {"arg_name1" : ["value1", "value2", ...], "arg_name2" : ["value1", "value2",
	// ...], ...}
	//
	// The update_dependencies command takes two arguments:
	//
	//    * upgrade_os_to - Specifies the desired Amazon Linux version for instances
	//    whose OS you want to upgrade, such as Amazon Linux 2016.09. You must also
	//    set the allow_reboot argument to true.
	//
	//    * allow_reboot - Specifies whether to allow AWS OpsWorks Stacks to reboot
	//    the instances if necessary, after installing the updates. This argument
	//    can be set to either true or false. The default value is false.
	//
	// For example, to upgrade an instance to Amazon Linux 2016.09, set Args to
	// the following.
	//
	// { "upgrade_os_to":["Amazon Linux 2016.09"], "allow_reboot":["true"] }
	Args map[string][]string `type:"map"`

	// Specifies the operation. You can specify only one command.
	//
	// For stacks, the following commands are available:
	//
	//    * execute_recipes: Execute one or more recipes. To specify the recipes,
	//    set an Args parameter named recipes to the list of recipes to be executed.
	//    For example, to execute phpapp::appsetup, set Args to {"recipes":["phpapp::appsetup"]}.
	//
	//    * install_dependencies: Install the stack's dependencies.
	//
	//    * update_custom_cookbooks: Update the stack's custom cookbooks.
	//
	//    * update_dependencies: Update the stack's dependencies.
	//
	// The update_dependencies and install_dependencies commands are supported only
	// for Linux instances. You can run the commands successfully on Windows instances,
	// but they do nothing.
	//
	// For apps, the following commands are available:
	//
	//    * deploy: Deploy an app. Ruby on Rails apps have an optional Args parameter
	//    named migrate. Set Args to {"migrate":["true"]} to migrate the database.
	//    The default setting is {"migrate":["false"]}.
	//
	//    * rollback Roll the app back to the previous version. When you update
	//    an app, AWS OpsWorks Stacks stores the previous version, up to a maximum
	//    of five versions. You can use this command to roll an app back as many
	//    as four versions.
	//
	//    * start: Start the app's web or application server.
	//
	//    * stop: Stop the app's web or application server.
	//
	//    * restart: Restart the app's web or application server.
	//
	//    * undeploy: Undeploy the app.
	//
	// Name is a required field
	Name DeploymentCommandName `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s DeploymentCommand) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeploymentCommand) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeploymentCommand"}
	if len(s.Name) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes an Amazon EBS volume. This data type maps directly to the Amazon
// EC2 EbsBlockDevice (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html)
// data type.
type EbsBlockDevice struct {
	_ struct{} `type:"structure"`

	// Whether the volume is deleted on instance termination.
	DeleteOnTermination *bool `type:"boolean"`

	// The number of I/O operations per second (IOPS) that the volume supports.
	// For more information, see EbsBlockDevice (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html).
	Iops *int64 `type:"integer"`

	// The snapshot ID.
	SnapshotId *string `type:"string"`

	// The volume size, in GiB. For more information, see EbsBlockDevice (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html).
	VolumeSize *int64 `type:"integer"`

	// The volume type. gp2 for General Purpose (SSD) volumes, io1 for Provisioned
	// IOPS (SSD) volumes, st1 for Throughput Optimized hard disk drives (HDD),
	// sc1 for Cold HDD,and standard for Magnetic volumes.
	//
	// If you specify the io1 volume type, you must also specify a value for the
	// Iops attribute. The maximum ratio of provisioned IOPS to requested volume
	// size (in GiB) is 50:1. AWS uses the default volume size (in GiB) specified
	// in the AMI attributes to set IOPS to 50 x (volume size).
	VolumeType VolumeType `type:"string" enum:"true"`
}

// String returns the string representation
func (s EbsBlockDevice) String() string {
	return awsutil.Prettify(s)
}

// Describes a registered Amazon ECS cluster.
type EcsCluster struct {
	_ struct{} `type:"structure"`

	// The cluster's ARN.
	EcsClusterArn *string `type:"string"`

	// The cluster name.
	EcsClusterName *string `type:"string"`

	// The time and date that the cluster was registered with the stack.
	RegisteredAt *string `type:"string"`

	// The stack ID.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s EcsCluster) String() string {
	return awsutil.Prettify(s)
}

// Describes an Elastic IP address.
type ElasticIp struct {
	_ struct{} `type:"structure"`

	// The domain.
	Domain *string `type:"string"`

	// The ID of the instance that the address is attached to.
	InstanceId *string `type:"string"`

	// The IP address.
	Ip *string `type:"string"`

	// The name.
	Name *string `type:"string"`

	// The AWS region. For more information, see Regions and Endpoints (https://docs.aws.amazon.com/general/latest/gr/rande.html).
	Region *string `type:"string"`
}

// String returns the string representation
func (s ElasticIp) String() string {
	return awsutil.Prettify(s)
}

// Describes an Elastic Load Balancing instance.
type ElasticLoadBalancer struct {
	_ struct{} `type:"structure"`

	// A list of Availability Zones.
	AvailabilityZones []string `type:"list"`

	// The instance's public DNS name.
	DnsName *string `type:"string"`

	// A list of the EC2 instances that the Elastic Load Balancing instance is managing
	// traffic for.
	Ec2InstanceIds []string `type:"list"`

	// The Elastic Load Balancing instance's name.
	ElasticLoadBalancerName *string `type:"string"`

	// The ID of the layer that the instance is attached to.
	LayerId *string `type:"string"`

	// The instance's AWS region.
	Region *string `type:"string"`

	// The ID of the stack that the instance is associated with.
	StackId *string `type:"string"`

	// A list of subnet IDs, if the stack is running in a VPC.
	SubnetIds []string `type:"list"`

	// The VPC ID.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s ElasticLoadBalancer) String() string {
	return awsutil.Prettify(s)
}

// Represents an app's environment variable.
type EnvironmentVariable struct {
	_ struct{} `type:"structure"`

	// (Required) The environment variable's name, which can consist of up to 64
	// characters and must be specified. The name can contain upper- and lowercase
	// letters, numbers, and underscores (_), but it must start with a letter or
	// underscore.
	//
	// Key is a required field
	Key *string `type:"string" required:"true"`

	// (Optional) Whether the variable's value will be returned by the DescribeApps
	// action. To conceal an environment variable's value, set Secure to true. DescribeApps
	// then returns *****FILTERED***** instead of the actual value. The default
	// value for Secure is false.
	Secure *bool `type:"boolean"`

	// (Optional) The environment variable's value, which can be left empty. If
	// you specify a value, it can contain up to 256 characters, which must all
	// be printable.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EnvironmentVariable) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnvironmentVariable) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EnvironmentVariable"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes an instance.
type Instance struct {
	_ struct{} `type:"structure"`

	// The agent version. This parameter is set to INHERIT if the instance inherits
	// the default stack setting or to a a version number for a fixed agent version.
	AgentVersion *string `type:"string"`

	// A custom AMI ID to be used to create the instance. For more information,
	// see Instances (https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html)
	AmiId *string `type:"string"`

	// The instance architecture: "i386" or "x86_64".
	Architecture Architecture `type:"string" enum:"true"`

	// The instance's Amazon Resource Number (ARN).
	Arn *string `type:"string"`

	// For load-based or time-based instances, the type.
	AutoScalingType AutoScalingType `type:"string" enum:"true"`

	// The instance Availability Zone. For more information, see Regions and Endpoints
	// (https://docs.aws.amazon.com/general/latest/gr/rande.html).
	AvailabilityZone *string `type:"string"`

	// An array of BlockDeviceMapping objects that specify the instance's block
	// device mappings.
	BlockDeviceMappings []BlockDeviceMapping `type:"list"`

	// The time that the instance was created.
	CreatedAt *string `type:"string"`

	// Whether this is an Amazon EBS-optimized instance.
	EbsOptimized *bool `type:"boolean"`

	// The ID of the associated Amazon EC2 instance.
	Ec2InstanceId *string `type:"string"`

	// For container instances, the Amazon ECS cluster's ARN.
	EcsClusterArn *string `type:"string"`

	// For container instances, the instance's ARN.
	EcsContainerInstanceArn *string `type:"string"`

	// The instance Elastic IP address (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html).
	ElasticIp *string `type:"string"`

	// The instance host name.
	Hostname *string `type:"string"`

	// For registered instances, the infrastructure class: ec2 or on-premises.
	InfrastructureClass *string `type:"string"`

	// Whether to install operating system and package updates when the instance
	// boots. The default value is true. If this value is set to false, you must
	// then update your instances manually by using CreateDeployment to run the
	// update_dependencies stack command or by manually running yum (Amazon Linux)
	// or apt-get (Ubuntu) on the instances.
	//
	// We strongly recommend using the default value of true, to ensure that your
	// instances have the latest security updates.
	InstallUpdatesOnBoot *bool `type:"boolean"`

	// The instance ID.
	InstanceId *string `type:"string"`

	// The ARN of the instance's IAM profile. For more information about IAM ARNs,
	// see Using Identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
	InstanceProfileArn *string `type:"string"`

	// The instance type, such as t2.micro.
	InstanceType *string `type:"string"`

	// The ID of the last service error. For more information, call DescribeServiceErrors.
	LastServiceErrorId *string `type:"string"`

	// An array containing the instance layer IDs.
	LayerIds []string `type:"list"`

	// The instance's operating system.
	Os *string `type:"string"`

	// The instance's platform.
	Platform *string `type:"string"`

	// The instance's private DNS name.
	PrivateDns *string `type:"string"`

	// The instance's private IP address.
	PrivateIp *string `type:"string"`

	// The instance public DNS name.
	PublicDns *string `type:"string"`

	// The instance public IP address.
	PublicIp *string `type:"string"`

	// For registered instances, who performed the registration.
	RegisteredBy *string `type:"string"`

	// The instance's reported AWS OpsWorks Stacks agent version.
	ReportedAgentVersion *string `type:"string"`

	// For registered instances, the reported operating system.
	ReportedOs *ReportedOs `type:"structure"`

	// The instance's root device type. For more information, see Storage for the
	// Root Device (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device).
	RootDeviceType RootDeviceType `type:"string" enum:"true"`

	// The root device volume ID.
	RootDeviceVolumeId *string `type:"string"`

	// An array containing the instance security group IDs.
	SecurityGroupIds []string `type:"list"`

	// The SSH key's Deep Security Agent (DSA) fingerprint.
	SshHostDsaKeyFingerprint *string `type:"string"`

	// The SSH key's RSA fingerprint.
	SshHostRsaKeyFingerprint *string `type:"string"`

	// The instance's Amazon EC2 key-pair name.
	SshKeyName *string `type:"string"`

	// The stack ID.
	StackId *string `type:"string"`

	// The instance status:
	//
	//    * booting
	//
	//    * connection_lost
	//
	//    * online
	//
	//    * pending
	//
	//    * rebooting
	//
	//    * requested
	//
	//    * running_setup
	//
	//    * setup_failed
	//
	//    * shutting_down
	//
	//    * start_failed
	//
	//    * stop_failed
	//
	//    * stopped
	//
	//    * stopping
	//
	//    * terminated
	//
	//    * terminating
	Status *string `type:"string"`

	// The instance's subnet ID; applicable only if the stack is running in a VPC.
	SubnetId *string `type:"string"`

	// The instance's tenancy option, such as dedicated or host.
	Tenancy *string `type:"string"`

	// The instance's virtualization type: paravirtual or hvm.
	VirtualizationType VirtualizationType `type:"string" enum:"true"`
}

// String returns the string representation
func (s Instance) String() string {
	return awsutil.Prettify(s)
}

// Contains a description of an Amazon EC2 instance from the Amazon EC2 metadata
// service. For more information, see Instance Metadata and User Data (https://docs.aws.amazon.com/sdkfornet/latest/apidocs/Index.html).
type InstanceIdentity struct {
	_ struct{} `type:"structure"`

	// A JSON document that contains the metadata.
	Document *string `type:"string"`

	// A signature that can be used to verify the document's accuracy and authenticity.
	Signature *string `type:"string"`
}

// String returns the string representation
func (s InstanceIdentity) String() string {
	return awsutil.Prettify(s)
}

// Describes how many instances a stack has for each status.
type InstancesCount struct {
	_ struct{} `type:"structure"`

	// The number of instances in the Assigning state.
	Assigning *int64 `type:"integer"`

	// The number of instances with booting status.
	Booting *int64 `type:"integer"`

	// The number of instances with connection_lost status.
	ConnectionLost *int64 `type:"integer"`

	// The number of instances in the Deregistering state.
	Deregistering *int64 `type:"integer"`

	// The number of instances with online status.
	Online *int64 `type:"integer"`

	// The number of instances with pending status.
	Pending *int64 `type:"integer"`

	// The number of instances with rebooting status.
	Rebooting *int64 `type:"integer"`

	// The number of instances in the Registered state.
	Registered *int64 `type:"integer"`

	// The number of instances in the Registering state.
	Registering *int64 `type:"integer"`

	// The number of instances with requested status.
	Requested *int64 `type:"integer"`

	// The number of instances with running_setup status.
	RunningSetup *int64 `type:"integer"`

	// The number of instances with setup_failed status.
	SetupFailed *int64 `type:"integer"`

	// The number of instances with shutting_down status.
	ShuttingDown *int64 `type:"integer"`

	// The number of instances with start_failed status.
	StartFailed *int64 `type:"integer"`

	// The number of instances with stop_failed status.
	StopFailed *int64 `type:"integer"`

	// The number of instances with stopped status.
	Stopped *int64 `type:"integer"`

	// The number of instances with stopping status.
	Stopping *int64 `type:"integer"`

	// The number of instances with terminated status.
	Terminated *int64 `type:"integer"`

	// The number of instances with terminating status.
	Terminating *int64 `type:"integer"`

	// The number of instances in the Unassigning state.
	Unassigning *int64 `type:"integer"`
}

// String returns the string representation
func (s InstancesCount) String() string {
	return awsutil.Prettify(s)
}

// Describes a layer.
type Layer struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of a layer.
	Arn *string `type:"string"`

	// The layer attributes.
	//
	// For the HaproxyStatsPassword, MysqlRootPassword, and GangliaPassword attributes,
	// AWS OpsWorks Stacks returns *****FILTERED***** instead of the actual value
	//
	// For an ECS Cluster layer, AWS OpsWorks Stacks the EcsClusterArn attribute
	// is set to the cluster's ARN.
	Attributes map[string]string `type:"map"`

	// Whether to automatically assign an Elastic IP address (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html)
	// to the layer's instances. For more information, see How to Edit a Layer (https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html).
	AutoAssignElasticIps *bool `type:"boolean"`

	// For stacks that are running in a VPC, whether to automatically assign a public
	// IP address to the layer's instances. For more information, see How to Edit
	// a Layer (https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html).
	AutoAssignPublicIps *bool `type:"boolean"`

	// The Amazon CloudWatch Logs configuration settings for the layer.
	CloudWatchLogsConfiguration *CloudWatchLogsConfiguration `type:"structure"`

	// Date when the layer was created.
	CreatedAt *string `type:"string"`

	// The ARN of the default IAM profile to be used for the layer's EC2 instances.
	// For more information about IAM ARNs, see Using Identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
	CustomInstanceProfileArn *string `type:"string"`

	// A JSON formatted string containing the layer's custom stack configuration
	// and deployment attributes.
	CustomJson *string `type:"string"`

	// A LayerCustomRecipes object that specifies the layer's custom recipes.
	CustomRecipes *Recipes `type:"structure"`

	// An array containing the layer's custom security group IDs.
	CustomSecurityGroupIds []string `type:"list"`

	// AWS OpsWorks Stacks supports five lifecycle events: setup, configuration,
	// deploy, undeploy, and shutdown. For each layer, AWS OpsWorks Stacks runs
	// a set of standard recipes for each event. You can also provide custom recipes
	// for any or all layers and events. AWS OpsWorks Stacks runs custom event recipes
	// after the standard recipes. LayerCustomRecipes specifies the custom recipes
	// for a particular layer to be run in response to each of the five events.
	//
	// To specify a recipe, use the cookbook's directory name in the repository
	// followed by two colons and the recipe name, which is the recipe's file name
	// without the .rb extension. For example: phpapp2::dbsetup specifies the dbsetup.rb
	// recipe in the repository's phpapp2 folder.
	DefaultRecipes *Recipes `type:"structure"`

	// An array containing the layer's security group names.
	DefaultSecurityGroupNames []string `type:"list"`

	// Whether auto healing is disabled for the layer.
	EnableAutoHealing *bool `type:"boolean"`

	// Whether to install operating system and package updates when the instance
	// boots. The default value is true. If this value is set to false, you must
	// then update your instances manually by using CreateDeployment to run the
	// update_dependencies stack command or manually running yum (Amazon Linux)
	// or apt-get (Ubuntu) on the instances.
	//
	// We strongly recommend using the default value of true, to ensure that your
	// instances have the latest security updates.
	InstallUpdatesOnBoot *bool `type:"boolean"`

	// The layer ID.
	LayerId *string `type:"string"`

	// A LifeCycleEventConfiguration object that specifies the Shutdown event configuration.
	LifecycleEventConfiguration *LifecycleEventConfiguration `type:"structure"`

	// The layer name.
	Name *string `type:"string"`

	// An array of Package objects that describe the layer's packages.
	Packages []string `type:"list"`

	// The layer short name.
	Shortname *string `type:"string"`

	// The layer stack ID.
	StackId *string `type:"string"`

	// The layer type.
	Type LayerType `type:"string" enum:"true"`

	// Whether the layer uses Amazon EBS-optimized instances.
	UseEbsOptimizedInstances *bool `type:"boolean"`

	// A VolumeConfigurations object that describes the layer's Amazon EBS volumes.
	VolumeConfigurations []VolumeConfiguration `type:"list"`
}

// String returns the string representation
func (s Layer) String() string {
	return awsutil.Prettify(s)
}

// Specifies the lifecycle event configuration
type LifecycleEventConfiguration struct {
	_ struct{} `type:"structure"`

	// A ShutdownEventConfiguration object that specifies the Shutdown event configuration.
	Shutdown *ShutdownEventConfiguration `type:"structure"`
}

// String returns the string representation
func (s LifecycleEventConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Describes a layer's load-based auto scaling configuration.
type LoadBasedAutoScalingConfiguration struct {
	_ struct{} `type:"structure"`

	// An AutoScalingThresholds object that describes the downscaling configuration,
	// which defines how and when AWS OpsWorks Stacks reduces the number of instances.
	DownScaling *AutoScalingThresholds `type:"structure"`

	// Whether load-based auto scaling is enabled for the layer.
	Enable *bool `type:"boolean"`

	// The layer ID.
	LayerId *string `type:"string"`

	// An AutoScalingThresholds object that describes the upscaling configuration,
	// which defines how and when AWS OpsWorks Stacks increases the number of instances.
	UpScaling *AutoScalingThresholds `type:"structure"`
}

// String returns the string representation
func (s LoadBasedAutoScalingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Describes supported operating systems in AWS OpsWorks Stacks.
type OperatingSystem struct {
	_ struct{} `type:"structure"`

	// Supported configuration manager name and versions for an AWS OpsWorks Stacks
	// operating system.
	ConfigurationManagers []OperatingSystemConfigurationManager `type:"list"`

	// The ID of a supported operating system, such as Amazon Linux 2018.03.
	Id *string `type:"string"`

	// The name of the operating system, such as Amazon Linux 2018.03.
	Name *string `type:"string"`

	// A short name for the operating system manufacturer.
	ReportedName *string `type:"string"`

	// The version of the operating system, including the release and edition, if
	// applicable.
	ReportedVersion *string `type:"string"`

	// Indicates that an operating system is not supported for new instances.
	Supported *bool `type:"boolean"`

	// The type of a supported operating system, either Linux or Windows.
	Type *string `type:"string"`
}

// String returns the string representation
func (s OperatingSystem) String() string {
	return awsutil.Prettify(s)
}

// A block that contains information about the configuration manager (Chef)
// and the versions of the configuration manager that are supported for an operating
// system.
type OperatingSystemConfigurationManager struct {
	_ struct{} `type:"structure"`

	// The name of the configuration manager, which is Chef.
	Name *string `type:"string"`

	// The versions of the configuration manager that are supported by an operating
	// system.
	Version *string `type:"string"`
}

// String returns the string representation
func (s OperatingSystemConfigurationManager) String() string {
	return awsutil.Prettify(s)
}

// Describes stack or user permissions.
type Permission struct {
	_ struct{} `type:"structure"`

	// Whether the user can use SSH.
	AllowSsh *bool `type:"boolean"`

	// Whether the user can use sudo.
	AllowSudo *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) for an AWS Identity and Access Management
	// (IAM) role. For more information about IAM ARNs, see Using Identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
	IamUserArn *string `type:"string"`

	// The user's permission level, which must be the following:
	//
	//    * deny
	//
	//    * show
	//
	//    * deploy
	//
	//    * manage
	//
	//    * iam_only
	//
	// For more information on the permissions associated with these levels, see
	// Managing User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html)
	Level *string `type:"string"`

	// A stack ID.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s Permission) String() string {
	return awsutil.Prettify(s)
}

// Describes an instance's RAID array.
type RaidArray struct {
	_ struct{} `type:"structure"`

	// The array's Availability Zone. For more information, see Regions and Endpoints
	// (https://docs.aws.amazon.com/general/latest/gr/rande.html).
	AvailabilityZone *string `type:"string"`

	// When the RAID array was created.
	CreatedAt *string `type:"string"`

	// The array's Linux device. For example /dev/mdadm0.
	Device *string `type:"string"`

	// The instance ID.
	InstanceId *string `type:"string"`

	// For PIOPS volumes, the IOPS per disk.
	Iops *int64 `type:"integer"`

	// The array's mount point.
	MountPoint *string `type:"string"`

	// The array name.
	Name *string `type:"string"`

	// The number of disks in the array.
	NumberOfDisks *int64 `type:"integer"`

	// The array ID.
	RaidArrayId *string `type:"string"`

	// The RAID level (http://en.wikipedia.org/wiki/Standard_RAID_levels).
	RaidLevel *int64 `type:"integer"`

	// The array's size.
	Size *int64 `type:"integer"`

	// The stack ID.
	StackId *string `type:"string"`

	// The volume type, standard or PIOPS.
	VolumeType *string `type:"string"`
}

// String returns the string representation
func (s RaidArray) String() string {
	return awsutil.Prettify(s)
}

// Describes an Amazon RDS instance.
type RdsDbInstance struct {
	_ struct{} `type:"structure"`

	// The instance's address.
	Address *string `type:"string"`

	// The DB instance identifier.
	DbInstanceIdentifier *string `type:"string"`

	// AWS OpsWorks Stacks returns *****FILTERED***** instead of the actual value.
	DbPassword *string `type:"string"`

	// The master user name.
	DbUser *string `type:"string"`

	// The instance's database engine.
	Engine *string `type:"string"`

	// Set to true if AWS OpsWorks Stacks is unable to discover the Amazon RDS instance.
	// AWS OpsWorks Stacks attempts to discover the instance only once. If this
	// value is set to true, you must deregister the instance, and then register
	// it again.
	MissingOnRds *bool `type:"boolean"`

	// The instance's ARN.
	RdsDbInstanceArn *string `type:"string"`

	// The instance's AWS region.
	Region *string `type:"string"`

	// The ID of the stack with which the instance is registered.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s RdsDbInstance) String() string {
	return awsutil.Prettify(s)
}

// AWS OpsWorks Stacks supports five lifecycle events: setup, configuration,
// deploy, undeploy, and shutdown. For each layer, AWS OpsWorks Stacks runs
// a set of standard recipes for each event. In addition, you can provide custom
// recipes for any or all layers and events. AWS OpsWorks Stacks runs custom
// event recipes after the standard recipes. LayerCustomRecipes specifies the
// custom recipes for a particular layer to be run in response to each of the
// five events.
//
// To specify a recipe, use the cookbook's directory name in the repository
// followed by two colons and the recipe name, which is the recipe's file name
// without the .rb extension. For example: phpapp2::dbsetup specifies the dbsetup.rb
// recipe in the repository's phpapp2 folder.
type Recipes struct {
	_ struct{} `type:"structure"`

	// An array of custom recipe names to be run following a configure event.
	Configure []string `type:"list"`

	// An array of custom recipe names to be run following a deploy event.
	Deploy []string `type:"list"`

	// An array of custom recipe names to be run following a setup event.
	Setup []string `type:"list"`

	// An array of custom recipe names to be run following a shutdown event.
	Shutdown []string `type:"list"`

	// An array of custom recipe names to be run following a undeploy event.
	Undeploy []string `type:"list"`
}

// String returns the string representation
func (s Recipes) String() string {
	return awsutil.Prettify(s)
}

// A registered instance's reported operating system.
type ReportedOs struct {
	_ struct{} `type:"structure"`

	// The operating system family.
	Family *string `type:"string"`

	// The operating system name.
	Name *string `type:"string"`

	// The operating system version.
	Version *string `type:"string"`
}

// String returns the string representation
func (s ReportedOs) String() string {
	return awsutil.Prettify(s)
}

// Describes a user's SSH information.
type SelfUserProfile struct {
	_ struct{} `type:"structure"`

	// The user's IAM ARN.
	IamUserArn *string `type:"string"`

	// The user's name.
	Name *string `type:"string"`

	// The user's SSH public key.
	SshPublicKey *string `type:"string"`

	// The user's SSH user name.
	SshUsername *string `type:"string"`
}

// String returns the string representation
func (s SelfUserProfile) String() string {
	return awsutil.Prettify(s)
}

// Describes an AWS OpsWorks Stacks service error.
type ServiceError struct {
	_ struct{} `type:"structure"`

	// When the error occurred.
	CreatedAt *string `type:"string"`

	// The instance ID.
	InstanceId *string `type:"string"`

	// A message that describes the error.
	Message *string `type:"string"`

	// The error ID.
	ServiceErrorId *string `type:"string"`

	// The stack ID.
	StackId *string `type:"string"`

	// The error type.
	Type *string `type:"string"`
}

// String returns the string representation
func (s ServiceError) String() string {
	return awsutil.Prettify(s)
}

// The Shutdown event configuration.
type ShutdownEventConfiguration struct {
	_ struct{} `type:"structure"`

	// Whether to enable Elastic Load Balancing connection draining. For more information,
	// see Connection Draining (https://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/TerminologyandKeyConcepts.html#conn-drain)
	DelayUntilElbConnectionsDrained *bool `type:"boolean"`

	// The time, in seconds, that AWS OpsWorks Stacks will wait after triggering
	// a Shutdown event before shutting down an instance.
	ExecutionTimeout *int64 `type:"integer"`
}

// String returns the string representation
func (s ShutdownEventConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Contains the information required to retrieve an app or cookbook from a repository.
// For more information, see Creating Apps (https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html)
// or Custom Recipes and Cookbooks (https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html).
type Source struct {
	_ struct{} `type:"structure"`

	// When included in a request, the parameter depends on the repository type.
	//
	//    * For Amazon S3 bundles, set Password to the appropriate IAM secret access
	//    key.
	//
	//    * For HTTP bundles and Subversion repositories, set Password to the password.
	//
	// For more information on how to safely handle IAM credentials, see https://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html
	// (https://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html).
	//
	// In responses, AWS OpsWorks Stacks returns *****FILTERED***** instead of the
	// actual value.
	Password *string `type:"string"`

	// The application's version. AWS OpsWorks Stacks enables you to easily deploy
	// new versions of an application. One of the simplest approaches is to have
	// branches or revisions in your repository that represent different versions
	// that can potentially be deployed.
	Revision *string `type:"string"`

	// In requests, the repository's SSH key.
	//
	// In responses, AWS OpsWorks Stacks returns *****FILTERED***** instead of the
	// actual value.
	SshKey *string `type:"string"`

	// The repository type.
	Type SourceType `type:"string" enum:"true"`

	// The source URL. The following is an example of an Amazon S3 source URL: https://s3.amazonaws.com/opsworks-demo-bucket/opsworks_cookbook_demo.tar.gz.
	Url *string `type:"string"`

	// This parameter depends on the repository type.
	//
	//    * For Amazon S3 bundles, set Username to the appropriate IAM access key
	//    ID.
	//
	//    * For HTTP bundles, Git repositories, and Subversion repositories, set
	//    Username to the user name.
	Username *string `type:"string"`
}

// String returns the string representation
func (s Source) String() string {
	return awsutil.Prettify(s)
}

// Describes an app's SSL configuration.
type SslConfiguration struct {
	_ struct{} `type:"structure"`

	// The contents of the certificate's domain.crt file.
	//
	// Certificate is a required field
	Certificate *string `type:"string" required:"true"`

	// Optional. Can be used to specify an intermediate certificate authority key
	// or client authentication.
	Chain *string `type:"string"`

	// The private key; the contents of the certificate's domain.kex file.
	//
	// PrivateKey is a required field
	PrivateKey *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SslConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SslConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SslConfiguration"}

	if s.Certificate == nil {
		invalidParams.Add(aws.NewErrParamRequired("Certificate"))
	}

	if s.PrivateKey == nil {
		invalidParams.Add(aws.NewErrParamRequired("PrivateKey"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a stack.
type Stack struct {
	_ struct{} `type:"structure"`

	// The agent version. This parameter is set to LATEST for auto-update. or a
	// version number for a fixed agent version.
	AgentVersion *string `type:"string"`

	// The stack's ARN.
	Arn *string `type:"string"`

	// The stack's attributes.
	Attributes map[string]string `type:"map"`

	// A ChefConfiguration object that specifies whether to enable Berkshelf and
	// the Berkshelf version. For more information, see Create a New Stack (https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html).
	ChefConfiguration *ChefConfiguration `type:"structure"`

	// The configuration manager.
	ConfigurationManager *StackConfigurationManager `type:"structure"`

	// The date when the stack was created.
	CreatedAt *string `type:"string"`

	// Contains the information required to retrieve an app or cookbook from a repository.
	// For more information, see Adding Apps (https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html)
	// or Cookbooks and Recipes (https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html).
	CustomCookbooksSource *Source `type:"structure"`

	// A JSON object that contains user-defined attributes to be added to the stack
	// configuration and deployment attributes. You can use custom JSON to override
	// the corresponding default stack configuration attribute values or to pass
	// data to recipes. The string should be in the following format:
	//
	// "{\"key1\": \"value1\", \"key2\": \"value2\",...}"
	//
	// For more information on custom JSON, see Use Custom JSON to Modify the Stack
	// Configuration Attributes (https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html).
	CustomJson *string `type:"string"`

	// The stack's default Availability Zone. For more information, see Regions
	// and Endpoints (https://docs.aws.amazon.com/general/latest/gr/rande.html).
	DefaultAvailabilityZone *string `type:"string"`

	// The ARN of an IAM profile that is the default profile for all of the stack's
	// EC2 instances. For more information about IAM ARNs, see Using Identifiers
	// (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
	DefaultInstanceProfileArn *string `type:"string"`

	// The stack's default operating system.
	DefaultOs *string `type:"string"`

	// The default root device type. This value is used by default for all instances
	// in the stack, but you can override it when you create an instance. For more
	// information, see Storage for the Root Device (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device).
	DefaultRootDeviceType RootDeviceType `type:"string" enum:"true"`

	// A default Amazon EC2 key pair for the stack's instances. You can override
	// this value when you create or update an instance.
	DefaultSshKeyName *string `type:"string"`

	// The default subnet ID; applicable only if the stack is running in a VPC.
	DefaultSubnetId *string `type:"string"`

	// The stack host name theme, with spaces replaced by underscores.
	HostnameTheme *string `type:"string"`

	// The stack name.
	Name *string `type:"string"`

	// The stack AWS region, such as "ap-northeast-2". For more information about
	// AWS regions, see Regions and Endpoints (https://docs.aws.amazon.com/general/latest/gr/rande.html).
	Region *string `type:"string"`

	// The stack AWS Identity and Access Management (IAM) role.
	ServiceRoleArn *string `type:"string"`

	// The stack ID.
	StackId *string `type:"string"`

	// Whether the stack uses custom cookbooks.
	UseCustomCookbooks *bool `type:"boolean"`

	// Whether the stack automatically associates the AWS OpsWorks Stacks built-in
	// security groups with the stack's layers.
	UseOpsworksSecurityGroups *bool `type:"boolean"`

	// The VPC ID; applicable only if the stack is running in a VPC.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s Stack) String() string {
	return awsutil.Prettify(s)
}

// Describes the configuration manager.
type StackConfigurationManager struct {
	_ struct{} `type:"structure"`

	// The name. This parameter must be set to "Chef".
	Name *string `type:"string"`

	// The Chef version. This parameter must be set to 12, 11.10, or 11.4 for Linux
	// stacks, and to 12.2 for Windows stacks. The default value for Linux stacks
	// is 11.4.
	Version *string `type:"string"`
}

// String returns the string representation
func (s StackConfigurationManager) String() string {
	return awsutil.Prettify(s)
}

// Summarizes the number of layers, instances, and apps in a stack.
type StackSummary struct {
	_ struct{} `type:"structure"`

	// The number of apps.
	AppsCount *int64 `type:"integer"`

	// The stack's ARN.
	Arn *string `type:"string"`

	// An InstancesCount object with the number of instances in each status.
	InstancesCount *InstancesCount `type:"structure"`

	// The number of layers.
	LayersCount *int64 `type:"integer"`

	// The stack name.
	Name *string `type:"string"`

	// The stack ID.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s StackSummary) String() string {
	return awsutil.Prettify(s)
}

// Contains the data needed by RDP clients such as the Microsoft Remote Desktop
// Connection to log in to the instance.
type TemporaryCredential struct {
	_ struct{} `type:"structure"`

	// The instance's AWS OpsWorks Stacks ID.
	InstanceId *string `type:"string"`

	// The password.
	Password *string `type:"string"`

	// The user name.
	Username *string `type:"string"`

	// The length of time (in minutes) that the grant is valid. When the grant expires,
	// at the end of this period, the user will no longer be able to use the credentials
	// to log in. If they are logged in at the time, they will be automatically
	// logged out.
	ValidForInMinutes *int64 `type:"integer"`
}

// String returns the string representation
func (s TemporaryCredential) String() string {
	return awsutil.Prettify(s)
}

// Describes an instance's time-based auto scaling configuration.
type TimeBasedAutoScalingConfiguration struct {
	_ struct{} `type:"structure"`

	// A WeeklyAutoScalingSchedule object with the instance schedule.
	AutoScalingSchedule *WeeklyAutoScalingSchedule `type:"structure"`

	// The instance ID.
	InstanceId *string `type:"string"`
}

// String returns the string representation
func (s TimeBasedAutoScalingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Describes a user's SSH information.
type UserProfile struct {
	_ struct{} `type:"structure"`

	// Whether users can specify their own SSH public key through the My Settings
	// page. For more information, see Managing User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/security-settingsshkey.html).
	AllowSelfManagement *bool `type:"boolean"`

	// The user's IAM ARN.
	IamUserArn *string `type:"string"`

	// The user's name.
	Name *string `type:"string"`

	// The user's SSH public key.
	SshPublicKey *string `type:"string"`

	// The user's SSH user name.
	SshUsername *string `type:"string"`
}

// String returns the string representation
func (s UserProfile) String() string {
	return awsutil.Prettify(s)
}

// Describes an instance's Amazon EBS volume.
type Volume struct {
	_ struct{} `type:"structure"`

	// The volume Availability Zone. For more information, see Regions and Endpoints
	// (https://docs.aws.amazon.com/general/latest/gr/rande.html).
	AvailabilityZone *string `type:"string"`

	// The device name.
	Device *string `type:"string"`

	// The Amazon EC2 volume ID.
	Ec2VolumeId *string `type:"string"`

	// Specifies whether an Amazon EBS volume is encrypted. For more information,
	// see Amazon EBS Encryption (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html).
	Encrypted *bool `type:"boolean"`

	// The instance ID.
	InstanceId *string `type:"string"`

	// For PIOPS volumes, the IOPS per disk.
	Iops *int64 `type:"integer"`

	// The volume mount point. For example, "/mnt/disk1".
	MountPoint *string `type:"string"`

	// The volume name.
	Name *string `type:"string"`

	// The RAID array ID.
	RaidArrayId *string `type:"string"`

	// The AWS region. For more information about AWS regions, see Regions and Endpoints
	// (https://docs.aws.amazon.com/general/latest/gr/rande.html).
	Region *string `type:"string"`

	// The volume size.
	Size *int64 `type:"integer"`

	// The value returned by DescribeVolumes (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeVolumes.html).
	Status *string `type:"string"`

	// The volume ID.
	VolumeId *string `type:"string"`

	// The volume type. For more information, see Amazon EBS Volume Types (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html).
	//
	//    * standard - Magnetic. Magnetic volumes must have a minimum size of 1
	//    GiB and a maximum size of 1024 GiB.
	//
	//    * io1 - Provisioned IOPS (SSD). PIOPS volumes must have a minimum size
	//    of 4 GiB and a maximum size of 16384 GiB.
	//
	//    * gp2 - General Purpose (SSD). General purpose volumes must have a minimum
	//    size of 1 GiB and a maximum size of 16384 GiB.
	//
	//    * st1 - Throughput Optimized hard disk drive (HDD). Throughput optimized
	//    HDD volumes must have a minimum size of 500 GiB and a maximum size of
	//    16384 GiB.
	//
	//    * sc1 - Cold HDD. Cold HDD volumes must have a minimum size of 500 GiB
	//    and a maximum size of 16384 GiB.
	VolumeType *string `type:"string"`
}

// String returns the string representation
func (s Volume) String() string {
	return awsutil.Prettify(s)
}

// Describes an Amazon EBS volume configuration.
type VolumeConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies whether an Amazon EBS volume is encrypted. For more information,
	// see Amazon EBS Encryption (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html).
	Encrypted *bool `type:"boolean"`

	// For PIOPS volumes, the IOPS per disk.
	Iops *int64 `type:"integer"`

	// The volume mount point. For example "/dev/sdh".
	//
	// MountPoint is a required field
	MountPoint *string `type:"string" required:"true"`

	// The number of disks in the volume.
	//
	// NumberOfDisks is a required field
	NumberOfDisks *int64 `type:"integer" required:"true"`

	// The volume RAID level (http://en.wikipedia.org/wiki/Standard_RAID_levels).
	RaidLevel *int64 `type:"integer"`

	// The volume size.
	//
	// Size is a required field
	Size *int64 `type:"integer" required:"true"`

	// The volume type. For more information, see Amazon EBS Volume Types (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html).
	//
	//    * standard - Magnetic. Magnetic volumes must have a minimum size of 1
	//    GiB and a maximum size of 1024 GiB.
	//
	//    * io1 - Provisioned IOPS (SSD). PIOPS volumes must have a minimum size
	//    of 4 GiB and a maximum size of 16384 GiB.
	//
	//    * gp2 - General Purpose (SSD). General purpose volumes must have a minimum
	//    size of 1 GiB and a maximum size of 16384 GiB.
	//
	//    * st1 - Throughput Optimized hard disk drive (HDD). Throughput optimized
	//    HDD volumes must have a minimum size of 500 GiB and a maximum size of
	//    16384 GiB.
	//
	//    * sc1 - Cold HDD. Cold HDD volumes must have a minimum size of 500 GiB
	//    and a maximum size of 16384 GiB.
	VolumeType *string `type:"string"`
}

// String returns the string representation
func (s VolumeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VolumeConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VolumeConfiguration"}

	if s.MountPoint == nil {
		invalidParams.Add(aws.NewErrParamRequired("MountPoint"))
	}

	if s.NumberOfDisks == nil {
		invalidParams.Add(aws.NewErrParamRequired("NumberOfDisks"))
	}

	if s.Size == nil {
		invalidParams.Add(aws.NewErrParamRequired("Size"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a time-based instance's auto scaling schedule. The schedule consists
// of a set of key-value pairs.
//
//    * The key is the time period (a UTC hour) and must be an integer from
//    0 - 23.
//
//    * The value indicates whether the instance should be online or offline
//    for the specified period, and must be set to "on" or "off"
//
// The default setting for all time periods is off, so you use the following
// parameters primarily to specify the online periods. You don't have to explicitly
// specify offline periods unless you want to change an online period to an
// offline period.
//
// The following example specifies that the instance should be online for four
// hours, from UTC 1200 - 1600. It will be off for the remainder of the day.
//
// { "12":"on", "13":"on", "14":"on", "15":"on" }
type WeeklyAutoScalingSchedule struct {
	_ struct{} `type:"structure"`

	// The schedule for Friday.
	Friday map[string]string `type:"map"`

	// The schedule for Monday.
	Monday map[string]string `type:"map"`

	// The schedule for Saturday.
	Saturday map[string]string `type:"map"`

	// The schedule for Sunday.
	Sunday map[string]string `type:"map"`

	// The schedule for Thursday.
	Thursday map[string]string `type:"map"`

	// The schedule for Tuesday.
	Tuesday map[string]string `type:"map"`

	// The schedule for Wednesday.
	Wednesday map[string]string `type:"map"`
}

// String returns the string representation
func (s WeeklyAutoScalingSchedule) String() string {
	return awsutil.Prettify(s)
}
