// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package organizations

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeAccountInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) of the AWS account that you want information about.
	// You can get the ID from the ListAccounts or ListAccountsForParent operations.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for an account ID string
	// requires exactly 12 digits.
	//
	// AccountId is a required field
	AccountId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAccountInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAccountInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeAccountInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeAccountOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains information about the requested account.
	Account *Account `type:"structure"`
}

// String returns the string representation
func (s DescribeAccountOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeAccount = "DescribeAccount"

// DescribeAccountRequest returns a request value for making API operation for
// AWS Organizations.
//
// Retrieves AWS Organizations related information about the specified account.
//
// This operation can be called only from the organization's master account.
//
//    // Example sending a request using DescribeAccountRequest.
//    req := client.DescribeAccountRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeAccount
func (c *Client) DescribeAccountRequest(input *DescribeAccountInput) DescribeAccountRequest {
	op := &aws.Operation{
		Name:       opDescribeAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAccountInput{}
	}

	req := c.newRequest(op, input, &DescribeAccountOutput{})
	return DescribeAccountRequest{Request: req, Input: input, Copy: c.DescribeAccountRequest}
}

// DescribeAccountRequest is the request type for the
// DescribeAccount API operation.
type DescribeAccountRequest struct {
	*aws.Request
	Input *DescribeAccountInput
	Copy  func(*DescribeAccountInput) DescribeAccountRequest
}

// Send marshals and sends the DescribeAccount API request.
func (r DescribeAccountRequest) Send(ctx context.Context) (*DescribeAccountResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeAccountResponse{
		DescribeAccountOutput: r.Request.Data.(*DescribeAccountOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeAccountResponse is the response type for the
// DescribeAccount API operation.
type DescribeAccountResponse struct {
	*DescribeAccountOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeAccount request.
func (r *DescribeAccountResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
