// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package pinpointsmsvoiceiface provides an interface to enable mocking the Amazon Pinpoint SMS and Voice Service service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package pinpointsmsvoiceiface

import (
	"github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoice"
)

// ClientAPI provides an interface to enable mocking the
// pinpointsmsvoice.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Pinpoint SMS Voice.
//    func myFunc(svc pinpointsmsvoiceiface.ClientAPI) bool {
//        // Make svc.CreateConfigurationSet request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := pinpointsmsvoice.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        pinpointsmsvoiceiface.ClientPI
//    }
//    func (m *mockClientClient) CreateConfigurationSet(input *pinpointsmsvoice.CreateConfigurationSetInput) (*pinpointsmsvoice.CreateConfigurationSetOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	CreateConfigurationSetRequest(*pinpointsmsvoice.CreateConfigurationSetInput) pinpointsmsvoice.CreateConfigurationSetRequest

	CreateConfigurationSetEventDestinationRequest(*pinpointsmsvoice.CreateConfigurationSetEventDestinationInput) pinpointsmsvoice.CreateConfigurationSetEventDestinationRequest

	DeleteConfigurationSetRequest(*pinpointsmsvoice.DeleteConfigurationSetInput) pinpointsmsvoice.DeleteConfigurationSetRequest

	DeleteConfigurationSetEventDestinationRequest(*pinpointsmsvoice.DeleteConfigurationSetEventDestinationInput) pinpointsmsvoice.DeleteConfigurationSetEventDestinationRequest

	GetConfigurationSetEventDestinationsRequest(*pinpointsmsvoice.GetConfigurationSetEventDestinationsInput) pinpointsmsvoice.GetConfigurationSetEventDestinationsRequest

	ListConfigurationSetsRequest(*pinpointsmsvoice.ListConfigurationSetsInput) pinpointsmsvoice.ListConfigurationSetsRequest

	SendVoiceMessageRequest(*pinpointsmsvoice.SendVoiceMessageInput) pinpointsmsvoice.SendVoiceMessageRequest

	UpdateConfigurationSetEventDestinationRequest(*pinpointsmsvoice.UpdateConfigurationSetEventDestinationInput) pinpointsmsvoice.UpdateConfigurationSetEventDestinationRequest
}

var _ ClientAPI = (*pinpointsmsvoice.Client)(nil)
