// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateClusterSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The cluster identifier for which you want a snapshot.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`

	// The number of days that a manual snapshot is retained. If the value is -1,
	// the manual snapshot is retained indefinitely.
	//
	// The value must be either -1 or an integer between 1 and 3,653.
	//
	// The default value is -1.
	ManualSnapshotRetentionPeriod *int64 `type:"integer"`

	// A unique identifier for the snapshot that you are requesting. This identifier
	// must be unique for all snapshots within the AWS account.
	//
	// Constraints:
	//
	//    * Cannot be null, empty, or blank
	//
	//    * Must contain from 1 to 255 alphanumeric characters or hyphens
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	// Example: my-snapshot-id
	//
	// SnapshotIdentifier is a required field
	SnapshotIdentifier *string `type:"string" required:"true"`

	// A list of tag instances.
	Tags []Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateClusterSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateClusterSnapshotInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateClusterSnapshotInput"}

	if s.ClusterIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClusterIdentifier"))
	}

	if s.SnapshotIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("SnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateClusterSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Describes a snapshot.
	Snapshot *Snapshot `type:"structure"`
}

// String returns the string representation
func (s CreateClusterSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateClusterSnapshot = "CreateClusterSnapshot"

// CreateClusterSnapshotRequest returns a request value for making API operation for
// Amazon Redshift.
//
// Creates a manual snapshot of the specified cluster. The cluster must be in
// the available state.
//
// For more information about working with snapshots, go to Amazon Redshift
// Snapshots (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html)
// in the Amazon Redshift Cluster Management Guide.
//
//    // Example sending a request using CreateClusterSnapshotRequest.
//    req := client.CreateClusterSnapshotRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterSnapshot
func (c *Client) CreateClusterSnapshotRequest(input *CreateClusterSnapshotInput) CreateClusterSnapshotRequest {
	op := &aws.Operation{
		Name:       opCreateClusterSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateClusterSnapshotInput{}
	}

	req := c.newRequest(op, input, &CreateClusterSnapshotOutput{})
	return CreateClusterSnapshotRequest{Request: req, Input: input, Copy: c.CreateClusterSnapshotRequest}
}

// CreateClusterSnapshotRequest is the request type for the
// CreateClusterSnapshot API operation.
type CreateClusterSnapshotRequest struct {
	*aws.Request
	Input *CreateClusterSnapshotInput
	Copy  func(*CreateClusterSnapshotInput) CreateClusterSnapshotRequest
}

// Send marshals and sends the CreateClusterSnapshot API request.
func (r CreateClusterSnapshotRequest) Send(ctx context.Context) (*CreateClusterSnapshotResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateClusterSnapshotResponse{
		CreateClusterSnapshotOutput: r.Request.Data.(*CreateClusterSnapshotOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateClusterSnapshotResponse is the response type for the
// CreateClusterSnapshot API operation.
type CreateClusterSnapshotResponse struct {
	*CreateClusterSnapshotOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateClusterSnapshot request.
func (r *CreateClusterSnapshotResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
