// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// A complex type that contains change information for the resource record set.
type ChangeResourceRecordSetsInput struct {
	_ struct{} `locationName:"ChangeResourceRecordSetsRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// A complex type that contains an optional comment and the Changes element.
	//
	// ChangeBatch is a required field
	ChangeBatch *ChangeBatch `type:"structure" required:"true"`

	// The ID of the hosted zone that contains the resource record sets that you
	// want to change.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s ChangeResourceRecordSetsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChangeResourceRecordSetsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ChangeResourceRecordSetsInput"}

	if s.ChangeBatch == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChangeBatch"))
	}

	if s.HostedZoneId == nil {
		invalidParams.Add(aws.NewErrParamRequired("HostedZoneId"))
	}
	if s.ChangeBatch != nil {
		if err := s.ChangeBatch.Validate(); err != nil {
			invalidParams.AddNested("ChangeBatch", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ChangeResourceRecordSetsInput) MarshalFields(e protocol.FieldEncoder) error {

	e.SetFields(protocol.BodyTarget, "ChangeResourceRecordSetsRequest", protocol.FieldMarshalerFunc(func(e protocol.FieldEncoder) error {
		if s.ChangeBatch != nil {
			v := s.ChangeBatch

			metadata := protocol.Metadata{}
			e.SetFields(protocol.BodyTarget, "ChangeBatch", v, metadata)
		}
		return nil
	}), protocol.Metadata{XMLNamespaceURI: "https://route53.amazonaws.com/doc/2013-04-01/"})
	if s.HostedZoneId != nil {
		v := *s.HostedZoneId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Id", protocol.StringValue(v), metadata)
	}
	return nil
}

// A complex type containing the response for the request.
type ChangeResourceRecordSetsOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about changes made to your hosted
	// zone.
	//
	// This element contains an ID that you use when performing a GetChange (https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetChange.html)
	// action to get detailed information about the change.
	//
	// ChangeInfo is a required field
	ChangeInfo *ChangeInfo `type:"structure" required:"true"`
}

// String returns the string representation
func (s ChangeResourceRecordSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ChangeResourceRecordSetsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ChangeInfo != nil {
		v := s.ChangeInfo

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ChangeInfo", v, metadata)
	}
	return nil
}

const opChangeResourceRecordSets = "ChangeResourceRecordSets"

// ChangeResourceRecordSetsRequest returns a request value for making API operation for
// Amazon Route 53.
//
// Creates, changes, or deletes a resource record set, which contains authoritative
// DNS information for a specified domain name or subdomain name. For example,
// you can use ChangeResourceRecordSets to create a resource record set that
// routes traffic for test.example.com to a web server that has an IP address
// of 192.0.2.44.
//
// Change Batches and Transactional Changes
//
// The request body must include a document with a ChangeResourceRecordSetsRequest
// element. The request body contains a list of change items, known as a change
// batch. Change batches are considered transactional changes. When using the
// Amazon Route 53 API to change resource record sets, Route 53 either makes
// all or none of the changes in a change batch request. This ensures that Route
// 53 never partially implements the intended changes to the resource record
// sets in a hosted zone.
//
// For example, a change batch request that deletes the CNAME record for www.example.com
// and creates an alias resource record set for www.example.com. Route 53 deletes
// the first resource record set and creates the second resource record set
// in a single operation. If either the DELETE or the CREATE action fails, then
// both changes (plus any other changes in the batch) fail, and the original
// CNAME record continues to exist.
//
// Due to the nature of transactional changes, you can't delete the same resource
// record set more than once in a single change batch. If you attempt to delete
// the same change batch more than once, Route 53 returns an InvalidChangeBatch
// error.
//
// Traffic Flow
//
// To create resource record sets for complex routing configurations, use either
// the traffic flow visual editor in the Route 53 console or the API actions
// for traffic policies and traffic policy instances. Save the configuration
// as a traffic policy, then associate the traffic policy with one or more domain
// names (such as example.com) or subdomain names (such as www.example.com),
// in the same hosted zone or in multiple hosted zones. You can roll back the
// updates if the new configuration isn't performing as expected. For more information,
// see Using Traffic Flow to Route DNS Traffic (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/traffic-flow.html)
// in the Amazon Route 53 Developer Guide.
//
// Create, Delete, and Upsert
//
// Use ChangeResourceRecordsSetsRequest to perform the following actions:
//
//    * CREATE: Creates a resource record set that has the specified values.
//
//    * DELETE: Deletes an existing resource record set that has the specified
//    values.
//
//    * UPSERT: If a resource record set does not already exist, AWS creates
//    it. If a resource set does exist, Route 53 updates it with the values
//    in the request.
//
// Syntaxes for Creating, Updating, and Deleting Resource Record Sets
//
// The syntax for a request depends on the type of resource record set that
// you want to create, delete, or update, such as weighted, alias, or failover.
// The XML elements in your request must appear in the order listed in the syntax.
//
// For an example for each type of resource record set, see "Examples."
//
// Don't refer to the syntax in the "Parameter Syntax" section, which includes
// all of the elements for every kind of resource record set that you can create,
// delete, or update by using ChangeResourceRecordSets.
//
// Change Propagation to Route 53 DNS Servers
//
// When you submit a ChangeResourceRecordSets request, Route 53 propagates your
// changes to all of the Route 53 authoritative DNS servers. While your changes
// are propagating, GetChange returns a status of PENDING. When propagation
// is complete, GetChange returns a status of INSYNC. Changes generally propagate
// to all Route 53 name servers within 60 seconds. For more information, see
// GetChange (https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetChange.html).
//
// Limits on ChangeResourceRecordSets Requests
//
// For information about the limits on a ChangeResourceRecordSets request, see
// Limits (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html)
// in the Amazon Route 53 Developer Guide.
//
//    // Example sending a request using ChangeResourceRecordSetsRequest.
//    req := client.ChangeResourceRecordSetsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ChangeResourceRecordSets
func (c *Client) ChangeResourceRecordSetsRequest(input *ChangeResourceRecordSetsInput) ChangeResourceRecordSetsRequest {
	op := &aws.Operation{
		Name:       opChangeResourceRecordSets,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}/rrset/",
	}

	if input == nil {
		input = &ChangeResourceRecordSetsInput{}
	}

	req := c.newRequest(op, input, &ChangeResourceRecordSetsOutput{})
	return ChangeResourceRecordSetsRequest{Request: req, Input: input, Copy: c.ChangeResourceRecordSetsRequest}
}

// ChangeResourceRecordSetsRequest is the request type for the
// ChangeResourceRecordSets API operation.
type ChangeResourceRecordSetsRequest struct {
	*aws.Request
	Input *ChangeResourceRecordSetsInput
	Copy  func(*ChangeResourceRecordSetsInput) ChangeResourceRecordSetsRequest
}

// Send marshals and sends the ChangeResourceRecordSets API request.
func (r ChangeResourceRecordSetsRequest) Send(ctx context.Context) (*ChangeResourceRecordSetsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ChangeResourceRecordSetsResponse{
		ChangeResourceRecordSetsOutput: r.Request.Data.(*ChangeResourceRecordSetsOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ChangeResourceRecordSetsResponse is the response type for the
// ChangeResourceRecordSets API operation.
type ChangeResourceRecordSetsResponse struct {
	*ChangeResourceRecordSetsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ChangeResourceRecordSets request.
func (r *ChangeResourceRecordSetsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
