// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateCodeRepositoryInput struct {
	_ struct{} `type:"structure"`

	// The name of the Git repository. The name must have 1 to 63 characters. Valid
	// characters are a-z, A-Z, 0-9, and - (hyphen).
	//
	// CodeRepositoryName is a required field
	CodeRepositoryName *string `min:"1" type:"string" required:"true"`

	// Specifies details about the repository, including the URL where the repository
	// is located, the default branch, and credentials to use to access the repository.
	//
	// GitConfig is a required field
	GitConfig *GitConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateCodeRepositoryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCodeRepositoryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateCodeRepositoryInput"}

	if s.CodeRepositoryName == nil {
		invalidParams.Add(aws.NewErrParamRequired("CodeRepositoryName"))
	}
	if s.CodeRepositoryName != nil && len(*s.CodeRepositoryName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CodeRepositoryName", 1))
	}

	if s.GitConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("GitConfig"))
	}
	if s.GitConfig != nil {
		if err := s.GitConfig.Validate(); err != nil {
			invalidParams.AddNested("GitConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateCodeRepositoryOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the new repository.
	//
	// CodeRepositoryArn is a required field
	CodeRepositoryArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateCodeRepositoryOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateCodeRepository = "CreateCodeRepository"

// CreateCodeRepositoryRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Creates a Git repository as a resource in your Amazon SageMaker account.
// You can associate the repository with notebook instances so that you can
// use Git source control for the notebooks you create. The Git repository is
// a resource in your Amazon SageMaker account, so it can be associated with
// more than one notebook instance, and it persists independently from the lifecycle
// of any notebook instances it is associated with.
//
// The repository can be hosted either in AWS CodeCommit (https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html)
// or in any other Git repository.
//
//    // Example sending a request using CreateCodeRepositoryRequest.
//    req := client.CreateCodeRepositoryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateCodeRepository
func (c *Client) CreateCodeRepositoryRequest(input *CreateCodeRepositoryInput) CreateCodeRepositoryRequest {
	op := &aws.Operation{
		Name:       opCreateCodeRepository,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCodeRepositoryInput{}
	}

	req := c.newRequest(op, input, &CreateCodeRepositoryOutput{})
	return CreateCodeRepositoryRequest{Request: req, Input: input, Copy: c.CreateCodeRepositoryRequest}
}

// CreateCodeRepositoryRequest is the request type for the
// CreateCodeRepository API operation.
type CreateCodeRepositoryRequest struct {
	*aws.Request
	Input *CreateCodeRepositoryInput
	Copy  func(*CreateCodeRepositoryInput) CreateCodeRepositoryRequest
}

// Send marshals and sends the CreateCodeRepository API request.
func (r CreateCodeRepositoryRequest) Send(ctx context.Context) (*CreateCodeRepositoryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateCodeRepositoryResponse{
		CreateCodeRepositoryOutput: r.Request.Data.(*CreateCodeRepositoryOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateCodeRepositoryResponse is the response type for the
// CreateCodeRepository API operation.
type CreateCodeRepositoryResponse struct {
	*CreateCodeRepositoryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateCodeRepository request.
func (r *CreateCodeRepositoryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
