// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListTrialsInput struct {
	_ struct{} `type:"structure"`

	// A filter that returns only trials created after the specified time.
	CreatedAfter *time.Time `type:"timestamp"`

	// A filter that returns only trials created before the specified time.
	CreatedBefore *time.Time `type:"timestamp"`

	// A filter that returns only trials that are part of the specified experiment.
	ExperimentName *string `min:"1" type:"string"`

	// The maximum number of trials to return in the response.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous call to ListTrials didn't return the full set of trials,
	// the call returns a token for getting the next set of trials.
	NextToken *string `type:"string"`

	// The property used to sort results. The default value is CreationTime.
	SortBy SortTrialsBy `type:"string" enum:"true"`

	// The sort order. The default value is Descending.
	SortOrder SortOrder `type:"string" enum:"true"`
}

// String returns the string representation
func (s ListTrialsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTrialsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListTrialsInput"}
	if s.ExperimentName != nil && len(*s.ExperimentName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ExperimentName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListTrialsOutput struct {
	_ struct{} `type:"structure"`

	// A token for getting the next set of trials, if there are any.
	NextToken *string `type:"string"`

	// A list of the summaries of your trials.
	TrialSummaries []TrialSummary `type:"list"`
}

// String returns the string representation
func (s ListTrialsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListTrials = "ListTrials"

// ListTrialsRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Lists the trials in your account. Specify an experiment name to limit the
// list to the trials that are part of that experiment. The list can be filtered
// to show only trials that were created in a specific time range. The list
// can be sorted by trial name or creation time.
//
//    // Example sending a request using ListTrialsRequest.
//    req := client.ListTrialsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTrials
func (c *Client) ListTrialsRequest(input *ListTrialsInput) ListTrialsRequest {
	op := &aws.Operation{
		Name:       opListTrials,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTrialsInput{}
	}

	req := c.newRequest(op, input, &ListTrialsOutput{})
	return ListTrialsRequest{Request: req, Input: input, Copy: c.ListTrialsRequest}
}

// ListTrialsRequest is the request type for the
// ListTrials API operation.
type ListTrialsRequest struct {
	*aws.Request
	Input *ListTrialsInput
	Copy  func(*ListTrialsInput) ListTrialsRequest
}

// Send marshals and sends the ListTrials API request.
func (r ListTrialsRequest) Send(ctx context.Context) (*ListTrialsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListTrialsResponse{
		ListTrialsOutput: r.Request.Data.(*ListTrialsOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListTrialsRequestPaginator returns a paginator for ListTrials.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListTrialsRequest(input)
//   p := sagemaker.NewListTrialsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListTrialsPaginator(req ListTrialsRequest) ListTrialsPaginator {
	return ListTrialsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListTrialsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListTrialsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListTrialsPaginator struct {
	aws.Pager
}

func (p *ListTrialsPaginator) CurrentPage() *ListTrialsOutput {
	return p.Pager.CurrentPage().(*ListTrialsOutput)
}

// ListTrialsResponse is the response type for the
// ListTrials API operation.
type ListTrialsResponse struct {
	*ListTrialsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListTrials request.
func (r *ListTrialsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
