// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateCodeRepositoryInput struct {
	_ struct{} `type:"structure"`

	// The name of the Git repository to update.
	//
	// CodeRepositoryName is a required field
	CodeRepositoryName *string `min:"1" type:"string" required:"true"`

	// The configuration of the git repository, including the URL and the Amazon
	// Resource Name (ARN) of the AWS Secrets Manager secret that contains the credentials
	// used to access the repository. The secret must have a staging label of AWSCURRENT
	// and must be in the following format:
	//
	// {"username": UserName, "password": Password}
	GitConfig *GitConfigForUpdate `type:"structure"`
}

// String returns the string representation
func (s UpdateCodeRepositoryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCodeRepositoryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateCodeRepositoryInput"}

	if s.CodeRepositoryName == nil {
		invalidParams.Add(aws.NewErrParamRequired("CodeRepositoryName"))
	}
	if s.CodeRepositoryName != nil && len(*s.CodeRepositoryName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CodeRepositoryName", 1))
	}
	if s.GitConfig != nil {
		if err := s.GitConfig.Validate(); err != nil {
			invalidParams.AddNested("GitConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateCodeRepositoryOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the Git repository.
	//
	// CodeRepositoryArn is a required field
	CodeRepositoryArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateCodeRepositoryOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateCodeRepository = "UpdateCodeRepository"

// UpdateCodeRepositoryRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Updates the specified Git repository with the specified values.
//
//    // Example sending a request using UpdateCodeRepositoryRequest.
//    req := client.UpdateCodeRepositoryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateCodeRepository
func (c *Client) UpdateCodeRepositoryRequest(input *UpdateCodeRepositoryInput) UpdateCodeRepositoryRequest {
	op := &aws.Operation{
		Name:       opUpdateCodeRepository,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateCodeRepositoryInput{}
	}

	req := c.newRequest(op, input, &UpdateCodeRepositoryOutput{})
	return UpdateCodeRepositoryRequest{Request: req, Input: input, Copy: c.UpdateCodeRepositoryRequest}
}

// UpdateCodeRepositoryRequest is the request type for the
// UpdateCodeRepository API operation.
type UpdateCodeRepositoryRequest struct {
	*aws.Request
	Input *UpdateCodeRepositoryInput
	Copy  func(*UpdateCodeRepositoryInput) UpdateCodeRepositoryRequest
}

// Send marshals and sends the UpdateCodeRepository API request.
func (r UpdateCodeRepositoryRequest) Send(ctx context.Context) (*UpdateCodeRepositoryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateCodeRepositoryResponse{
		UpdateCodeRepositoryOutput: r.Request.Data.(*UpdateCodeRepositoryOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateCodeRepositoryResponse is the response type for the
// UpdateCodeRepository API operation.
type UpdateCodeRepositoryResponse struct {
	*UpdateCodeRepositoryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateCodeRepository request.
func (r *UpdateCodeRepositoryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
