// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package sagemakera2iruntimeiface provides an interface to enable mocking the Amazon Augmented AI Runtime service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package sagemakera2iruntimeiface

import (
	"github.com/aws/aws-sdk-go-v2/service/sagemakera2iruntime"
)

// ClientAPI provides an interface to enable mocking the
// sagemakera2iruntime.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon Augmented AI Runtime.
//    func myFunc(svc sagemakera2iruntimeiface.ClientAPI) bool {
//        // Make svc.DeleteHumanLoop request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := sagemakera2iruntime.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        sagemakera2iruntimeiface.ClientPI
//    }
//    func (m *mockClientClient) DeleteHumanLoop(input *sagemakera2iruntime.DeleteHumanLoopInput) (*sagemakera2iruntime.DeleteHumanLoopOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	DeleteHumanLoopRequest(*sagemakera2iruntime.DeleteHumanLoopInput) sagemakera2iruntime.DeleteHumanLoopRequest

	DescribeHumanLoopRequest(*sagemakera2iruntime.DescribeHumanLoopInput) sagemakera2iruntime.DescribeHumanLoopRequest

	ListHumanLoopsRequest(*sagemakera2iruntime.ListHumanLoopsInput) sagemakera2iruntime.ListHumanLoopsRequest

	StartHumanLoopRequest(*sagemakera2iruntime.StartHumanLoopInput) sagemakera2iruntime.StartHumanLoopRequest

	StopHumanLoopRequest(*sagemakera2iruntime.StopHumanLoopInput) sagemakera2iruntime.StopHumanLoopRequest
}

var _ ClientAPI = (*sagemakera2iruntime.Client)(nil)
