// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ses

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListTemplatesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of templates to return. This value must be at least 1
	// and less than or equal to 10. If you do not specify a value, or if you specify
	// a value less than 1 or greater than 10, the operation will return up to 10
	// results.
	MaxItems *int64 `type:"integer"`

	// A token returned from a previous call to ListTemplates to indicate the position
	// in the list of email templates.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

type ListTemplatesOutput struct {
	_ struct{} `type:"structure"`

	// A token indicating that there are additional email templates available to
	// be listed. Pass this token to a subsequent call to ListTemplates to retrieve
	// the next 50 email templates.
	NextToken *string `type:"string"`

	// An array the contains the name and creation time stamp for each template
	// in your Amazon SES account.
	TemplatesMetadata []TemplateMetadata `type:"list"`
}

// String returns the string representation
func (s ListTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListTemplates = "ListTemplates"

// ListTemplatesRequest returns a request value for making API operation for
// Amazon Simple Email Service.
//
// Lists the email templates present in your Amazon SES account in the current
// AWS Region.
//
// You can execute this operation no more than once per second.
//
//    // Example sending a request using ListTemplatesRequest.
//    req := client.ListTemplatesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListTemplates
func (c *Client) ListTemplatesRequest(input *ListTemplatesInput) ListTemplatesRequest {
	op := &aws.Operation{
		Name:       opListTemplates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTemplatesInput{}
	}

	req := c.newRequest(op, input, &ListTemplatesOutput{})
	return ListTemplatesRequest{Request: req, Input: input, Copy: c.ListTemplatesRequest}
}

// ListTemplatesRequest is the request type for the
// ListTemplates API operation.
type ListTemplatesRequest struct {
	*aws.Request
	Input *ListTemplatesInput
	Copy  func(*ListTemplatesInput) ListTemplatesRequest
}

// Send marshals and sends the ListTemplates API request.
func (r ListTemplatesRequest) Send(ctx context.Context) (*ListTemplatesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListTemplatesResponse{
		ListTemplatesOutput: r.Request.Data.(*ListTemplatesOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListTemplatesResponse is the response type for the
// ListTemplates API operation.
type ListTemplatesResponse struct {
	*ListTemplatesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListTemplates request.
func (r *ListTemplatesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
