// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package snowball

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeAddressInput struct {
	_ struct{} `type:"structure"`

	// The automatically generated ID for a specific address.
	//
	// AddressId is a required field
	AddressId *string `min:"40" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAddressInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAddressInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeAddressInput"}

	if s.AddressId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AddressId"))
	}
	if s.AddressId != nil && len(*s.AddressId) < 40 {
		invalidParams.Add(aws.NewErrParamMinLen("AddressId", 40))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeAddressOutput struct {
	_ struct{} `type:"structure"`

	// The address that you want the Snowball or Snowballs associated with a specific
	// job to be shipped to.
	Address *Address `type:"structure"`
}

// String returns the string representation
func (s DescribeAddressOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeAddress = "DescribeAddress"

// DescribeAddressRequest returns a request value for making API operation for
// Amazon Import/Export Snowball.
//
// Takes an AddressId and returns specific details about that address in the
// form of an Address object.
//
//    // Example sending a request using DescribeAddressRequest.
//    req := client.DescribeAddressRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/DescribeAddress
func (c *Client) DescribeAddressRequest(input *DescribeAddressInput) DescribeAddressRequest {
	op := &aws.Operation{
		Name:       opDescribeAddress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAddressInput{}
	}

	req := c.newRequest(op, input, &DescribeAddressOutput{})
	return DescribeAddressRequest{Request: req, Input: input, Copy: c.DescribeAddressRequest}
}

// DescribeAddressRequest is the request type for the
// DescribeAddress API operation.
type DescribeAddressRequest struct {
	*aws.Request
	Input *DescribeAddressInput
	Copy  func(*DescribeAddressInput) DescribeAddressRequest
}

// Send marshals and sends the DescribeAddress API request.
func (r DescribeAddressRequest) Send(ctx context.Context) (*DescribeAddressResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeAddressResponse{
		DescribeAddressOutput: r.Request.Data.(*DescribeAddressOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeAddressResponse is the response type for the
// DescribeAddress API operation.
type DescribeAddressResponse struct {
	*DescribeAddressOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeAddress request.
func (r *DescribeAddressResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
