// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sqs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListQueueTagsInput struct {
	_ struct{} `type:"structure"`

	// The URL of the queue.
	//
	// QueueUrl is a required field
	QueueUrl *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListQueueTagsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListQueueTagsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListQueueTagsInput"}

	if s.QueueUrl == nil {
		invalidParams.Add(aws.NewErrParamRequired("QueueUrl"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListQueueTagsOutput struct {
	_ struct{} `type:"structure"`

	// The list of all tags added to the specified queue.
	Tags map[string]string `locationName:"Tag" locationNameKey:"Key" locationNameValue:"Value" type:"map" flattened:"true"`
}

// String returns the string representation
func (s ListQueueTagsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListQueueTags = "ListQueueTags"

// ListQueueTagsRequest returns a request value for making API operation for
// Amazon Simple Queue Service.
//
// List all cost allocation tags added to the specified Amazon SQS queue. For
// an overview, see Tagging Your Amazon SQS Queues (https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-tags.html)
// in the Amazon Simple Queue Service Developer Guide.
//
// Cross-account permissions don't apply to this action. For more information,
// see Grant Cross-Account Permissions to a Role and a User Name (https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name)
// in the Amazon Simple Queue Service Developer Guide.
//
//    // Example sending a request using ListQueueTagsRequest.
//    req := client.ListQueueTagsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sqs-2012-11-05/ListQueueTags
func (c *Client) ListQueueTagsRequest(input *ListQueueTagsInput) ListQueueTagsRequest {
	op := &aws.Operation{
		Name:       opListQueueTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListQueueTagsInput{}
	}

	req := c.newRequest(op, input, &ListQueueTagsOutput{})
	return ListQueueTagsRequest{Request: req, Input: input, Copy: c.ListQueueTagsRequest}
}

// ListQueueTagsRequest is the request type for the
// ListQueueTags API operation.
type ListQueueTagsRequest struct {
	*aws.Request
	Input *ListQueueTagsInput
	Copy  func(*ListQueueTagsInput) ListQueueTagsRequest
}

// Send marshals and sends the ListQueueTags API request.
func (r ListQueueTagsRequest) Send(ctx context.Context) (*ListQueueTagsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListQueueTagsResponse{
		ListQueueTagsOutput: r.Request.Data.(*ListQueueTagsOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListQueueTagsResponse is the response type for the
// ListQueueTags API operation.
type ListQueueTagsResponse struct {
	*ListQueueTagsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListQueueTags request.
func (r *ListQueueTagsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
