// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package storagegateway

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteSnapshotScheduleInput struct {
	_ struct{} `type:"structure"`

	// The volume which snapshot schedule to delete.
	//
	// VolumeARN is a required field
	VolumeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSnapshotScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSnapshotScheduleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteSnapshotScheduleInput"}

	if s.VolumeARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("VolumeARN"))
	}
	if s.VolumeARN != nil && len(*s.VolumeARN) < 50 {
		invalidParams.Add(aws.NewErrParamMinLen("VolumeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteSnapshotScheduleOutput struct {
	_ struct{} `type:"structure"`

	// The volume which snapshot schedule was deleted.
	VolumeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DeleteSnapshotScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteSnapshotSchedule = "DeleteSnapshotSchedule"

// DeleteSnapshotScheduleRequest returns a request value for making API operation for
// AWS Storage Gateway.
//
// Deletes a snapshot of a volume.
//
// You can take snapshots of your gateway volumes on a scheduled or ad hoc basis.
// This API action enables you to delete a snapshot schedule for a volume. For
// more information, see Working with Snapshots (https://docs.aws.amazon.com/storagegateway/latest/userguide/WorkingWithSnapshots.html).
// In the DeleteSnapshotSchedule request, you identify the volume by providing
// its Amazon Resource Name (ARN). This operation is only supported in stored
// and cached volume gateway types.
//
// To list or delete a snapshot, you must use the Amazon EC2 API. in Amazon
// Elastic Compute Cloud API Reference.
//
//    // Example sending a request using DeleteSnapshotScheduleRequest.
//    req := client.DeleteSnapshotScheduleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteSnapshotSchedule
func (c *Client) DeleteSnapshotScheduleRequest(input *DeleteSnapshotScheduleInput) DeleteSnapshotScheduleRequest {
	op := &aws.Operation{
		Name:       opDeleteSnapshotSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSnapshotScheduleInput{}
	}

	req := c.newRequest(op, input, &DeleteSnapshotScheduleOutput{})
	return DeleteSnapshotScheduleRequest{Request: req, Input: input, Copy: c.DeleteSnapshotScheduleRequest}
}

// DeleteSnapshotScheduleRequest is the request type for the
// DeleteSnapshotSchedule API operation.
type DeleteSnapshotScheduleRequest struct {
	*aws.Request
	Input *DeleteSnapshotScheduleInput
	Copy  func(*DeleteSnapshotScheduleInput) DeleteSnapshotScheduleRequest
}

// Send marshals and sends the DeleteSnapshotSchedule API request.
func (r DeleteSnapshotScheduleRequest) Send(ctx context.Context) (*DeleteSnapshotScheduleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteSnapshotScheduleResponse{
		DeleteSnapshotScheduleOutput: r.Request.Data.(*DeleteSnapshotScheduleOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteSnapshotScheduleResponse is the response type for the
// DeleteSnapshotSchedule API operation.
type DeleteSnapshotScheduleResponse struct {
	*DeleteSnapshotScheduleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteSnapshotSchedule request.
func (r *DeleteSnapshotScheduleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
