// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package textract

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetDocumentTextDetectionInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the text detection job. The JobId is returned from
	// StartDocumentTextDetection. A JobId value is only valid for 7 days.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`

	// The maximum number of results to return per paginated call. The largest value
	// you can specify is 1,000. If you specify a value greater than 1,000, a maximum
	// of 1,000 results is returned. The default value is 1,000.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous response was incomplete (because there are more blocks to
	// retrieve), Amazon Textract returns a pagination token in the response. You
	// can use this pagination token to retrieve the next set of blocks.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetDocumentTextDetectionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDocumentTextDetectionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetDocumentTextDetectionInput"}

	if s.JobId == nil {
		invalidParams.Add(aws.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JobId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetDocumentTextDetectionOutput struct {
	_ struct{} `type:"structure"`

	// The results of the text-detection operation.
	Blocks []Block `type:"list"`

	DetectDocumentTextModelVersion *string `type:"string"`

	// Information about a document that Amazon Textract processed. DocumentMetadata
	// is returned in every page of paginated responses from an Amazon Textract
	// video operation.
	DocumentMetadata *DocumentMetadata `type:"structure"`

	// The current status of the text detection job.
	JobStatus JobStatus `type:"string" enum:"true"`

	// If the response is truncated, Amazon Textract returns this token. You can
	// use this token in the subsequent request to retrieve the next set of text-detection
	// results.
	NextToken *string `min:"1" type:"string"`

	// The current status of an asynchronous text-detection operation for the document.
	StatusMessage *string `type:"string"`

	// A list of warnings that occurred during the text-detection operation for
	// the document.
	Warnings []Warning `type:"list"`
}

// String returns the string representation
func (s GetDocumentTextDetectionOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetDocumentTextDetection = "GetDocumentTextDetection"

// GetDocumentTextDetectionRequest returns a request value for making API operation for
// Amazon Textract.
//
// Gets the results for an Amazon Textract asynchronous operation that detects
// text in a document. Amazon Textract can detect lines of text and the words
// that make up a line of text.
//
// You start asynchronous text detection by calling StartDocumentTextDetection,
// which returns a job identifier (JobId). When the text detection operation
// finishes, Amazon Textract publishes a completion status to the Amazon Simple
// Notification Service (Amazon SNS) topic that's registered in the initial
// call to StartDocumentTextDetection. To get the results of the text-detection
// operation, first check that the status value published to the Amazon SNS
// topic is SUCCEEDED. If so, call GetDocumentTextDetection, and pass the job
// identifier (JobId) from the initial call to StartDocumentTextDetection.
//
// GetDocumentTextDetection returns an array of Block objects.
//
// Each document page has as an associated Block of type PAGE. Each PAGE Block
// object is the parent of LINE Block objects that represent the lines of detected
// text on a page. A LINE Block object is a parent for each word that makes
// up the line. Words are represented by Block objects of type WORD.
//
// Use the MaxResults parameter to limit the number of blocks that are returned.
// If there are more results than specified in MaxResults, the value of NextToken
// in the operation response contains a pagination token for getting the next
// set of results. To get the next page of results, call GetDocumentTextDetection,
// and populate the NextToken request parameter with the token value that's
// returned from the previous call to GetDocumentTextDetection.
//
// For more information, see Document Text Detection (https://docs.aws.amazon.com/textract/latest/dg/how-it-works-detecting.html).
//
//    // Example sending a request using GetDocumentTextDetectionRequest.
//    req := client.GetDocumentTextDetectionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/GetDocumentTextDetection
func (c *Client) GetDocumentTextDetectionRequest(input *GetDocumentTextDetectionInput) GetDocumentTextDetectionRequest {
	op := &aws.Operation{
		Name:       opGetDocumentTextDetection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDocumentTextDetectionInput{}
	}

	req := c.newRequest(op, input, &GetDocumentTextDetectionOutput{})
	return GetDocumentTextDetectionRequest{Request: req, Input: input, Copy: c.GetDocumentTextDetectionRequest}
}

// GetDocumentTextDetectionRequest is the request type for the
// GetDocumentTextDetection API operation.
type GetDocumentTextDetectionRequest struct {
	*aws.Request
	Input *GetDocumentTextDetectionInput
	Copy  func(*GetDocumentTextDetectionInput) GetDocumentTextDetectionRequest
}

// Send marshals and sends the GetDocumentTextDetection API request.
func (r GetDocumentTextDetectionRequest) Send(ctx context.Context) (*GetDocumentTextDetectionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetDocumentTextDetectionResponse{
		GetDocumentTextDetectionOutput: r.Request.Data.(*GetDocumentTextDetectionOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetDocumentTextDetectionResponse is the response type for the
// GetDocumentTextDetection API operation.
type GetDocumentTextDetectionResponse struct {
	*GetDocumentTextDetectionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetDocumentTextDetection request.
func (r *GetDocumentTextDetectionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
