// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package worklink

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeAuditStreamConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the fleet.
	//
	// FleetArn is a required field
	FleetArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAuditStreamConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAuditStreamConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeAuditStreamConfigurationInput"}

	if s.FleetArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("FleetArn"))
	}
	if s.FleetArn != nil && len(*s.FleetArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("FleetArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeAuditStreamConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.FleetArn != nil {
		v := *s.FleetArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FleetArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeAuditStreamConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the Amazon Kinesis data stream that will receive the audit events.
	AuditStreamArn *string `type:"string"`
}

// String returns the string representation
func (s DescribeAuditStreamConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeAuditStreamConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AuditStreamArn != nil {
		v := *s.AuditStreamArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AuditStreamArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opDescribeAuditStreamConfiguration = "DescribeAuditStreamConfiguration"

// DescribeAuditStreamConfigurationRequest returns a request value for making API operation for
// Amazon WorkLink.
//
// Describes the configuration for delivering audit streams to the customer
// account.
//
//    // Example sending a request using DescribeAuditStreamConfigurationRequest.
//    req := client.DescribeAuditStreamConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeAuditStreamConfiguration
func (c *Client) DescribeAuditStreamConfigurationRequest(input *DescribeAuditStreamConfigurationInput) DescribeAuditStreamConfigurationRequest {
	op := &aws.Operation{
		Name:       opDescribeAuditStreamConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/describeAuditStreamConfiguration",
	}

	if input == nil {
		input = &DescribeAuditStreamConfigurationInput{}
	}

	req := c.newRequest(op, input, &DescribeAuditStreamConfigurationOutput{})
	return DescribeAuditStreamConfigurationRequest{Request: req, Input: input, Copy: c.DescribeAuditStreamConfigurationRequest}
}

// DescribeAuditStreamConfigurationRequest is the request type for the
// DescribeAuditStreamConfiguration API operation.
type DescribeAuditStreamConfigurationRequest struct {
	*aws.Request
	Input *DescribeAuditStreamConfigurationInput
	Copy  func(*DescribeAuditStreamConfigurationInput) DescribeAuditStreamConfigurationRequest
}

// Send marshals and sends the DescribeAuditStreamConfiguration API request.
func (r DescribeAuditStreamConfigurationRequest) Send(ctx context.Context) (*DescribeAuditStreamConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeAuditStreamConfigurationResponse{
		DescribeAuditStreamConfigurationOutput: r.Request.Data.(*DescribeAuditStreamConfigurationOutput),
		response:                               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeAuditStreamConfigurationResponse is the response type for the
// DescribeAuditStreamConfiguration API operation.
type DescribeAuditStreamConfigurationResponse struct {
	*DescribeAuditStreamConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeAuditStreamConfiguration request.
func (r *DescribeAuditStreamConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
