// Code generated by the feature package; DO NOT EDIT.

package feature

import (
	"context"

	"github.com/influxdata/flux/internal/pkg/feature"
)

type (
	Flag       = feature.Flag
	Flagger    = feature.Flagger
	StringFlag = feature.StringFlag
	FloatFlag  = feature.FloatFlag
	IntFlag    = feature.IntFlag
	BoolFlag   = feature.BoolFlag
)

var aggregateTransformationTransport = feature.MakeBoolFlag(
	"Aggregate Transformation Transport",
	"aggregateTransformationTransport",
	"Jonathan Sternberg",
	false,
)

// AggregateTransformationTransport - Enable Transport interface for AggregateTransformation
func AggregateTransformationTransport() BoolFlag {
	return aggregateTransformationTransport
}

var groupTransformationGroup = feature.MakeBoolFlag(
	"Group Transformation Group",
	"groupTransformationGroup",
	"Sean Brickley",
	false,
)

// GroupTransformationGroup - Enable GroupTransformation interface for the group function
func GroupTransformationGroup() BoolFlag {
	return groupTransformationGroup
}

var queryConcurrencyLimit = feature.MakeIntFlag(
	"Query Concurrency Limit",
	"queryConcurrencyLimit",
	"Jonathan Sternberg",
	0,
)

// QueryConcurrencyLimit - Sets the query concurrency limit for the planner
func QueryConcurrencyLimit() IntFlag {
	return queryConcurrencyLimit
}

var optimizeUnionTransformation = feature.MakeBoolFlag(
	"Optimize Union Transformation",
	"optimizeUnionTransformation",
	"Jonathan Sternberg",
	false,
)

// OptimizeUnionTransformation - Optimize the union transformation
func OptimizeUnionTransformation() BoolFlag {
	return optimizeUnionTransformation
}

var vectorizedMap = feature.MakeBoolFlag(
	"Vectorized Map",
	"vectorizedMap",
	"Jonathan Sternberg",
	false,
)

// VectorizedMap - Enables the version of map that supports vectorized functions
func VectorizedMap() BoolFlag {
	return vectorizedMap
}

var narrowTransformationDifference = feature.MakeBoolFlag(
	"Narrow Transformation Difference",
	"narrowTransformationDifference",
	"Markus Westerlind",
	false,
)

// NarrowTransformationDifference - Enable the NarrowTransformation implementation of difference
func NarrowTransformationDifference() BoolFlag {
	return narrowTransformationDifference
}

var narrowTransformationFill = feature.MakeBoolFlag(
	"Narrow Transformation Fill",
	"narrowTransformationFill",
	"Sunil Kartikey",
	false,
)

// NarrowTransformationFill - Enable the NarrowTransformation implementation of Fill
func NarrowTransformationFill() BoolFlag {
	return narrowTransformationFill
}

var optimizeAggregateWindow = feature.MakeBoolFlag(
	"Optimize Aggregate Window",
	"optimizeAggregateWindow",
	"Jonathan Sternberg",
	false,
)

// OptimizeAggregateWindow - Enables a version of aggregateWindow written in Go
func OptimizeAggregateWindow() BoolFlag {
	return optimizeAggregateWindow
}

var narrowTransformationLimit = feature.MakeBoolFlag(
	"Narrow Transformation Limit",
	"narrowTransformationLimit",
	"Owen Nelson",
	false,
)

// NarrowTransformationLimit - Enable the NarrowStateTransformation implementation of limit
func NarrowTransformationLimit() BoolFlag {
	return narrowTransformationLimit
}

var optimizeStateTracking = feature.MakeBoolFlag(
	"Optimize State Tracking",
	"optimizeStateTracking",
	"Sean Brickley",
	false,
)

// OptimizeStateTracking - Enable implementation of NarrowStateTransformation of stateTracking
func OptimizeStateTracking() BoolFlag {
	return optimizeStateTracking
}

var vectorizeAddition = feature.MakeBoolFlag(
	"Vectorize addition",
	"vectorizeAddition",
	"Markus Westerlind",
	false,
)

// VectorizeAddition - Vectorizes addition expressions inside map
func VectorizeAddition() BoolFlag {
	return vectorizeAddition
}

var vectorizeOperators = feature.MakeBoolFlag(
	"Vectorize operators",
	"vectorizeOperators",
	"Markus Westerlind",
	false,
)

// VectorizeOperators - Vectorizes all operator expressions inside map
func VectorizeOperators() BoolFlag {
	return vectorizeOperators
}

var vectorizeLogicalOperators = feature.MakeBoolFlag(
	"Vectorize Logical Operators",
	"vectorizeLogicalOperators",
	"Jonathan Sternberg",
	false,
)

// VectorizeLogicalOperators - Vectorizes logical operators inside map
func VectorizeLogicalOperators() BoolFlag {
	return vectorizeLogicalOperators
}

var labelPolymorphism = feature.MakeBoolFlag(
	"Label polymorphism",
	"labelPolymorphism",
	"Markus Westerlind",
	false,
)

// LabelPolymorphism - Enables label polymorphism in the type system
func LabelPolymorphism() BoolFlag {
	return labelPolymorphism
}

var optimizeSetTransformation = feature.MakeBoolFlag(
	"Optimize Set Transformation",
	"optimizeSetTransformation",
	"Jonathan Sternberg",
	false,
)

// OptimizeSetTransformation - Enables a version of set that is optimized
func OptimizeSetTransformation() BoolFlag {
	return optimizeSetTransformation
}

var unusedSymbolWarnings = feature.MakeBoolFlag(
	"Unused Symbol Warnings",
	"unusedSymbolWarnings",
	"Markus Westerlind",
	false,
)

// UnusedSymbolWarnings - Enables warnings for unused symbols
func UnusedSymbolWarnings() BoolFlag {
	return unusedSymbolWarnings
}

// Inject will inject the Flagger into the context.
func Inject(ctx context.Context, flagger Flagger) context.Context {
	return feature.Inject(ctx, flagger)
}

var all = []Flag{
	aggregateTransformationTransport,
	groupTransformationGroup,
	queryConcurrencyLimit,
	optimizeUnionTransformation,
	vectorizedMap,
	narrowTransformationDifference,
	narrowTransformationFill,
	optimizeAggregateWindow,
	narrowTransformationLimit,
	optimizeStateTracking,
	vectorizeAddition,
	vectorizeOperators,
	vectorizeLogicalOperators,
	labelPolymorphism,
	optimizeSetTransformation,
	unusedSymbolWarnings,
}

var byKey = map[string]Flag{
	"aggregateTransformationTransport": aggregateTransformationTransport,
	"groupTransformationGroup":         groupTransformationGroup,
	"queryConcurrencyLimit":            queryConcurrencyLimit,
	"optimizeUnionTransformation":      optimizeUnionTransformation,
	"vectorizedMap":                    vectorizedMap,
	"narrowTransformationDifference":   narrowTransformationDifference,
	"narrowTransformationFill":         narrowTransformationFill,
	"optimizeAggregateWindow":          optimizeAggregateWindow,
	"narrowTransformationLimit":        narrowTransformationLimit,
	"optimizeStateTracking":            optimizeStateTracking,
	"vectorizeAddition":                vectorizeAddition,
	"vectorizeOperators":               vectorizeOperators,
	"vectorizeLogicalOperators":        vectorizeLogicalOperators,
	"labelPolymorphism":                labelPolymorphism,
	"optimizeSetTransformation":        optimizeSetTransformation,
	"unusedSymbolWarnings":             unusedSymbolWarnings,
}

// Flags returns all feature flags.
func Flags() []Flag {
	return all
}

// ByKey returns the Flag corresponding to the given key.
func ByKey(k string) (Flag, bool) {
	v, found := byKey[k]
	return v, found
}

type Metrics = feature.Metrics

// SetMetrics sets the metric store for feature flags.
func SetMetrics(m Metrics) {
	feature.SetMetrics(m)
}
