/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.xml.handlers;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.xml.handlers.BaseURLHandler;
import com.adobe.epubcheck.xml.handlers.DelegateLocator;
import com.adobe.epubcheck.xml.model.XMLAttribute;
import com.adobe.epubcheck.xml.model.XMLElement;
import io.mola.galimatias.URL;
import org.w3c.epubcheck.core.references.Reference;
import org.w3c.epubcheck.core.references.ReferenceRegistry;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.ext.Locator2;

public abstract class XMLHandler
extends BaseURLHandler {
    private XMLElement currentElement = null;
    private Locator2 locator;
    protected final ValidationContext context;
    protected final Report report;
    protected final String path;

    public XMLHandler(ValidationContext context) {
        this(context, context.url);
    }

    public XMLHandler(ValidationContext context, URL baseURL) {
        super(context, baseURL);
        this.context = context;
        this.report = context.report;
        this.path = context.path;
    }

    @Override
    public final void setDocumentLocator(Locator locator) {
        this.locator = new DelegateLocator(locator);
        super.setDocumentLocator(this.locator);
    }

    @Override
    public final void startElement(String uri, String localName, String qName, Attributes attribs) {
        String name;
        String prefix;
        int index;
        super.startElement(uri, localName, qName, attribs);
        if (this.currentElement == null) {
            this.checkXMLVersion();
        }
        if ((index = qName.indexOf(58)) < 0) {
            prefix = null;
            name = qName;
        } else {
            prefix = qName.substring(0, index);
            name = qName.substring(index + 1);
        }
        int count = attribs.getLength();
        XMLAttribute[] attributes = count == 0 ? null : new XMLAttribute[count];
        for (int i = 0; i < count; ++i) {
            String attPrefix;
            String attName = attribs.getLocalName(i);
            String attNamespace = attribs.getURI(i);
            String attQName = attribs.getQName(i);
            int attIndex = attQName.indexOf(58);
            if (attIndex < 0) {
                attPrefix = null;
                attNamespace = null;
            } else {
                attPrefix = attQName.substring(0, attIndex);
            }
            String attValue = attribs.getValue(i);
            assert (attributes != null);
            attributes[i] = new XMLAttribute(attNamespace, attPrefix, attName, attValue);
        }
        this.currentElement = new XMLElement(uri, prefix, name, attributes, this.currentElement);
        this.startElement();
    }

    protected void startElement() {
    }

    @Override
    public final void endElement(String uri, String localName, String qName) {
        this.endElement();
        this.currentElement = this.currentElement.getParent();
    }

    protected void endElement() {
    }

    protected final XMLElement currentElement() {
        return this.currentElement;
    }

    private void checkXMLVersion() {
        String version = this.locator.getXMLVersion();
        if (version == null) {
            throw new AssertionError((Object)"XML version is null");
        }
        if (!"1.0".equals(version)) {
            this.report.message(MessageId.HTM_001, EPUBLocation.of(this.context), version);
        }
    }

    protected final void registerReference(URL url, Reference.Type type) {
        this.registerReference(url, type, false);
    }

    protected final void registerReference(URL url, Reference.Type type, boolean hasIntrinsicFallback) {
        if (url == null) {
            return;
        }
        if (this.context.referenceRegistry.isPresent()) {
            ((ReferenceRegistry)this.context.referenceRegistry.get()).registerReference(url, type, this.location(), hasIntrinsicFallback);
        }
    }
}

