// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: metricsquery.proto

package metrics

import (
	context "context"
	encoding_binary "encoding/binary"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	_ "github.com/gogo/protobuf/types"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
	time "time"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// MetricsQueryBaseRequest is the base request parameter accompanying a MetricsQueryService RPC call.
type MetricsQueryBaseRequest struct {
	// service_names are the service names to fetch metrics from.
	// The results will be grouped by service_name.
	// Required. At least one service name must be provided.
	ServiceNames []string `protobuf:"bytes,1,rep,name=service_names,json=serviceNames,proto3" json:"service_names,omitempty"`
	// groupByOperation determines if the metrics returned should be grouped by operation.
	// Optional. Default = false.
	GroupByOperation bool `protobuf:"varint,2,opt,name=groupByOperation,proto3" json:"groupByOperation,omitempty"`
	// end_time is the ending time of the time series query range.
	// Optional. Default = now.
	EndTime *time.Time `protobuf:"bytes,3,opt,name=end_time,json=endTime,proto3,stdtime" json:"end_time,omitempty"`
	// lookback is the duration from the end_time to look back on for metrics data points.
	// For example, if set to 1h, the query would span from end_time-1h to end_time.
	// Optional. Default = 1h.
	Lookback *time.Duration `protobuf:"bytes,4,opt,name=lookback,proto3,stdduration" json:"lookback,omitempty"`
	// step size is the duration between data points of the query results.
	// For example, if set to 5s, the results would produce a data point every 5 seconds
	// from the start_time to end_time.
	// Optional. Default = 5s.
	Step *time.Duration `protobuf:"bytes,5,opt,name=step,proto3,stdduration" json:"step,omitempty"`
	// ratePer is the duration in which the per-second rate of change is calculated for a cumulative counter metric.
	// Optional. Default = 10m.
	RatePer *time.Duration `protobuf:"bytes,6,opt,name=ratePer,proto3,stdduration" json:"ratePer,omitempty"`
	// spanKinds is the list of span kinds to include (logical OR) in the resulting metrics aggregation.
	// Optional. Default = [SPAN_KIND_SERVER].
	SpanKinds            []SpanKind `protobuf:"varint,7,rep,packed,name=spanKinds,proto3,enum=jaeger.api_v2.metrics.SpanKind" json:"spanKinds,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *MetricsQueryBaseRequest) Reset()         { *m = MetricsQueryBaseRequest{} }
func (m *MetricsQueryBaseRequest) String() string { return proto.CompactTextString(m) }
func (*MetricsQueryBaseRequest) ProtoMessage()    {}
func (*MetricsQueryBaseRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_212ad953da609219, []int{0}
}
func (m *MetricsQueryBaseRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MetricsQueryBaseRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MetricsQueryBaseRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MetricsQueryBaseRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MetricsQueryBaseRequest.Merge(m, src)
}
func (m *MetricsQueryBaseRequest) XXX_Size() int {
	return m.Size()
}
func (m *MetricsQueryBaseRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MetricsQueryBaseRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MetricsQueryBaseRequest proto.InternalMessageInfo

func (m *MetricsQueryBaseRequest) GetServiceNames() []string {
	if m != nil {
		return m.ServiceNames
	}
	return nil
}

func (m *MetricsQueryBaseRequest) GetGroupByOperation() bool {
	if m != nil {
		return m.GroupByOperation
	}
	return false
}

func (m *MetricsQueryBaseRequest) GetEndTime() *time.Time {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *MetricsQueryBaseRequest) GetLookback() *time.Duration {
	if m != nil {
		return m.Lookback
	}
	return nil
}

func (m *MetricsQueryBaseRequest) GetStep() *time.Duration {
	if m != nil {
		return m.Step
	}
	return nil
}

func (m *MetricsQueryBaseRequest) GetRatePer() *time.Duration {
	if m != nil {
		return m.RatePer
	}
	return nil
}

func (m *MetricsQueryBaseRequest) GetSpanKinds() []SpanKind {
	if m != nil {
		return m.SpanKinds
	}
	return nil
}

// GetLatenciesRequest contains parameters for the GetLatencies RPC call.
type GetLatenciesRequest struct {
	BaseRequest *MetricsQueryBaseRequest `protobuf:"bytes,1,opt,name=baseRequest,proto3" json:"baseRequest,omitempty"`
	// quantile is the quantile to compute from latency histogram metrics.
	// Valid range: (0, 1]
	//
	// e.g. 0.99 will return the 99th percentile or P99 which is the worst latency
	// observed from 99% of all spans for the given service (and operation).
	//
	// Required.
	Quantile             float64  `protobuf:"fixed64,2,opt,name=quantile,proto3" json:"quantile,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetLatenciesRequest) Reset()         { *m = GetLatenciesRequest{} }
func (m *GetLatenciesRequest) String() string { return proto.CompactTextString(m) }
func (*GetLatenciesRequest) ProtoMessage()    {}
func (*GetLatenciesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_212ad953da609219, []int{1}
}
func (m *GetLatenciesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetLatenciesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetLatenciesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetLatenciesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetLatenciesRequest.Merge(m, src)
}
func (m *GetLatenciesRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetLatenciesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetLatenciesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetLatenciesRequest proto.InternalMessageInfo

func (m *GetLatenciesRequest) GetBaseRequest() *MetricsQueryBaseRequest {
	if m != nil {
		return m.BaseRequest
	}
	return nil
}

func (m *GetLatenciesRequest) GetQuantile() float64 {
	if m != nil {
		return m.Quantile
	}
	return 0
}

// GetCallRatesRequest contains parameters for the GetCallRates RPC call.
type GetCallRatesRequest struct {
	BaseRequest          *MetricsQueryBaseRequest `protobuf:"bytes,1,opt,name=baseRequest,proto3" json:"baseRequest,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *GetCallRatesRequest) Reset()         { *m = GetCallRatesRequest{} }
func (m *GetCallRatesRequest) String() string { return proto.CompactTextString(m) }
func (*GetCallRatesRequest) ProtoMessage()    {}
func (*GetCallRatesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_212ad953da609219, []int{2}
}
func (m *GetCallRatesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetCallRatesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetCallRatesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetCallRatesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetCallRatesRequest.Merge(m, src)
}
func (m *GetCallRatesRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetCallRatesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetCallRatesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetCallRatesRequest proto.InternalMessageInfo

func (m *GetCallRatesRequest) GetBaseRequest() *MetricsQueryBaseRequest {
	if m != nil {
		return m.BaseRequest
	}
	return nil
}

// GetErrorRatesRequest contains parameters for the GetErrorRates RPC call.
type GetErrorRatesRequest struct {
	BaseRequest          *MetricsQueryBaseRequest `protobuf:"bytes,1,opt,name=baseRequest,proto3" json:"baseRequest,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *GetErrorRatesRequest) Reset()         { *m = GetErrorRatesRequest{} }
func (m *GetErrorRatesRequest) String() string { return proto.CompactTextString(m) }
func (*GetErrorRatesRequest) ProtoMessage()    {}
func (*GetErrorRatesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_212ad953da609219, []int{3}
}
func (m *GetErrorRatesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetErrorRatesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetErrorRatesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetErrorRatesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetErrorRatesRequest.Merge(m, src)
}
func (m *GetErrorRatesRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetErrorRatesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetErrorRatesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetErrorRatesRequest proto.InternalMessageInfo

func (m *GetErrorRatesRequest) GetBaseRequest() *MetricsQueryBaseRequest {
	if m != nil {
		return m.BaseRequest
	}
	return nil
}

type GetMinStepDurationRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetMinStepDurationRequest) Reset()         { *m = GetMinStepDurationRequest{} }
func (m *GetMinStepDurationRequest) String() string { return proto.CompactTextString(m) }
func (*GetMinStepDurationRequest) ProtoMessage()    {}
func (*GetMinStepDurationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_212ad953da609219, []int{4}
}
func (m *GetMinStepDurationRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetMinStepDurationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetMinStepDurationRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetMinStepDurationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetMinStepDurationRequest.Merge(m, src)
}
func (m *GetMinStepDurationRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetMinStepDurationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetMinStepDurationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetMinStepDurationRequest proto.InternalMessageInfo

type GetMinStepDurationResponse struct {
	MinStep              time.Duration `protobuf:"bytes,1,opt,name=minStep,proto3,stdduration" json:"minStep"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *GetMinStepDurationResponse) Reset()         { *m = GetMinStepDurationResponse{} }
func (m *GetMinStepDurationResponse) String() string { return proto.CompactTextString(m) }
func (*GetMinStepDurationResponse) ProtoMessage()    {}
func (*GetMinStepDurationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_212ad953da609219, []int{5}
}
func (m *GetMinStepDurationResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetMinStepDurationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetMinStepDurationResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetMinStepDurationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetMinStepDurationResponse.Merge(m, src)
}
func (m *GetMinStepDurationResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetMinStepDurationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetMinStepDurationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetMinStepDurationResponse proto.InternalMessageInfo

func (m *GetMinStepDurationResponse) GetMinStep() time.Duration {
	if m != nil {
		return m.MinStep
	}
	return 0
}

type GetMetricsResponse struct {
	Metrics              MetricFamily `protobuf:"bytes,1,opt,name=metrics,proto3" json:"metrics"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *GetMetricsResponse) Reset()         { *m = GetMetricsResponse{} }
func (m *GetMetricsResponse) String() string { return proto.CompactTextString(m) }
func (*GetMetricsResponse) ProtoMessage()    {}
func (*GetMetricsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_212ad953da609219, []int{6}
}
func (m *GetMetricsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetMetricsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetMetricsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetMetricsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetMetricsResponse.Merge(m, src)
}
func (m *GetMetricsResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetMetricsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetMetricsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetMetricsResponse proto.InternalMessageInfo

func (m *GetMetricsResponse) GetMetrics() MetricFamily {
	if m != nil {
		return m.Metrics
	}
	return MetricFamily{}
}

func init() {
	proto.RegisterType((*MetricsQueryBaseRequest)(nil), "jaeger.api_v2.metrics.MetricsQueryBaseRequest")
	proto.RegisterType((*GetLatenciesRequest)(nil), "jaeger.api_v2.metrics.GetLatenciesRequest")
	proto.RegisterType((*GetCallRatesRequest)(nil), "jaeger.api_v2.metrics.GetCallRatesRequest")
	proto.RegisterType((*GetErrorRatesRequest)(nil), "jaeger.api_v2.metrics.GetErrorRatesRequest")
	proto.RegisterType((*GetMinStepDurationRequest)(nil), "jaeger.api_v2.metrics.GetMinStepDurationRequest")
	proto.RegisterType((*GetMinStepDurationResponse)(nil), "jaeger.api_v2.metrics.GetMinStepDurationResponse")
	proto.RegisterType((*GetMetricsResponse)(nil), "jaeger.api_v2.metrics.GetMetricsResponse")
}

func init() { proto.RegisterFile("metricsquery.proto", fileDescriptor_212ad953da609219) }

var fileDescriptor_212ad953da609219 = []byte{
	// 593 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x53, 0x4f, 0x6f, 0xd3, 0x3c,
	0x18, 0x7f, 0xf3, 0x76, 0xac, 0x9d, 0xb7, 0x21, 0xf0, 0x86, 0xc8, 0x82, 0xd4, 0x56, 0xdd, 0xa5,
	0x0c, 0x29, 0x83, 0x22, 0xc1, 0x69, 0x42, 0xea, 0x80, 0x1e, 0x60, 0x30, 0x52, 0x2e, 0xc0, 0xa1,
	0x72, 0xdb, 0x87, 0x60, 0x9a, 0xd8, 0xa9, 0xed, 0x4c, 0xea, 0x99, 0x2f, 0xc0, 0x91, 0x3b, 0x1f,
	0x86, 0x1d, 0xf9, 0x04, 0x80, 0xfa, 0x49, 0x50, 0x62, 0xa7, 0xeb, 0xda, 0xa5, 0xac, 0x87, 0xdd,
	0xe2, 0xc7, 0xcf, 0xef, 0xcf, 0xe3, 0xe7, 0x17, 0x84, 0x43, 0x50, 0x82, 0xf6, 0xe4, 0x30, 0x06,
	0x31, 0x72, 0x23, 0xc1, 0x15, 0xc7, 0xb7, 0x3e, 0x13, 0xf0, 0x41, 0xb8, 0x24, 0xa2, 0x9d, 0x93,
	0x86, 0x6b, 0x3a, 0x9c, 0x9b, 0x3c, 0x02, 0x66, 0x0e, 0xba, 0xd3, 0xc1, 0x5c, 0x41, 0x20, 0x23,
	0xc2, 0x06, 0x94, 0xf5, 0x4d, 0x6d, 0xdb, 0xe7, 0x3e, 0x4f, 0x3f, 0xf7, 0x93, 0x2f, 0x53, 0xad,
	0xf8, 0x9c, 0xfb, 0x01, 0xec, 0xa7, 0xa7, 0x6e, 0xfc, 0x71, 0x5f, 0xd1, 0x10, 0xa4, 0x22, 0x61,
	0x64, 0x1a, 0xca, 0xb3, 0x0d, 0xfd, 0x58, 0x10, 0x45, 0x39, 0xd3, 0xf7, 0xb5, 0xef, 0x05, 0x74,
	0xfb, 0x48, 0x8b, 0xbf, 0x49, 0xbc, 0x36, 0x89, 0x04, 0x0f, 0x86, 0x31, 0x48, 0x85, 0x77, 0xd1,
	0xa6, 0x04, 0x71, 0x42, 0x7b, 0xd0, 0x61, 0x24, 0x04, 0x69, 0x5b, 0xd5, 0x42, 0x7d, 0xcd, 0xdb,
	0x30, 0xc5, 0x57, 0x49, 0x0d, 0xef, 0xa1, 0x1b, 0xbe, 0xe0, 0x71, 0xd4, 0x1c, 0xbd, 0x8e, 0x40,
	0x53, 0xdb, 0xff, 0x57, 0xad, 0x7a, 0xc9, 0x9b, 0xab, 0xe3, 0x27, 0xa8, 0x04, 0xac, 0xdf, 0x49,
	0x3c, 0xda, 0x85, 0xaa, 0x55, 0x5f, 0x6f, 0x38, 0xae, 0xf6, 0xe7, 0x66, 0xfe, 0xdc, 0xb7, 0xd9,
	0x00, 0xcd, 0xd2, 0xe9, 0xaf, 0x8a, 0xf5, 0xf5, 0x77, 0xc5, 0xf2, 0x8a, 0xc0, 0xfa, 0x49, 0x3d,
	0x21, 0x08, 0x38, 0x1f, 0x74, 0x49, 0x6f, 0x60, 0xaf, 0xa4, 0x04, 0x3b, 0x73, 0x04, 0x4f, 0xcd,
	0x80, 0x1a, 0xff, 0x2d, 0xc1, 0x4f, 0x40, 0xf8, 0x31, 0x5a, 0x91, 0x0a, 0x22, 0xfb, 0xda, 0xe5,
	0xc1, 0x29, 0x00, 0x1f, 0xa0, 0xa2, 0x20, 0x0a, 0x8e, 0x41, 0xd8, 0xab, 0x97, 0xc7, 0x66, 0x18,
	0x7c, 0x80, 0xd6, 0x92, 0x7d, 0xbe, 0xa0, 0xac, 0x2f, 0xed, 0x62, 0xb5, 0x50, 0xbf, 0xde, 0xa8,
	0xb8, 0x17, 0xe6, 0xc1, 0x6d, 0x9b, 0x3e, 0xef, 0x0c, 0x51, 0xfb, 0x62, 0xa1, 0xad, 0x16, 0xa8,
	0x97, 0x44, 0x01, 0xeb, 0x51, 0x90, 0xd9, 0x86, 0x8e, 0xd1, 0x7a, 0xf7, 0x6c, 0x61, 0xb6, 0x95,
	0x3a, 0x73, 0x73, 0x88, 0x73, 0xd6, 0xec, 0x4d, 0x53, 0x60, 0x07, 0x95, 0x86, 0x31, 0x61, 0x8a,
	0x06, 0x90, 0xae, 0xd1, 0xf2, 0x26, 0xe7, 0x9a, 0x9f, 0x9a, 0x38, 0x24, 0x41, 0xe0, 0x11, 0x75,
	0x85, 0x26, 0x6a, 0x9f, 0xd0, 0x76, 0x0b, 0xd4, 0x33, 0x21, 0xb8, 0xb8, 0x62, 0xa5, 0x3b, 0x68,
	0xa7, 0x05, 0xea, 0x88, 0xb2, 0xb6, 0x82, 0x28, 0x5b, 0x60, 0x76, 0xf9, 0x01, 0x39, 0x17, 0x5d,
	0xca, 0x88, 0x33, 0x09, 0x49, 0x22, 0x42, 0x7d, 0x65, 0x8c, 0xfc, 0x23, 0x11, 0xff, 0xe9, 0x44,
	0x18, 0x4c, 0xed, 0x1d, 0xc2, 0x09, 0xb9, 0x36, 0x39, 0x21, 0x3d, 0x44, 0x45, 0xe3, 0xdf, 0x90,
	0xee, 0x2e, 0x9c, 0xee, 0x39, 0x09, 0x69, 0x30, 0x6a, 0xae, 0x24, 0xf4, 0x5e, 0x86, 0x6c, 0xfc,
	0x28, 0xa0, 0xad, 0xe9, 0xe9, 0xdb, 0xfa, 0x7f, 0xc5, 0x23, 0x2d, 0x79, 0x7e, 0x1e, 0x7c, 0x3f,
	0x47, 0x21, 0xf7, 0x5d, 0x9c, 0x07, 0x4b, 0x20, 0xcc, 0x5c, 0x80, 0x36, 0xa6, 0xf3, 0x8b, 0xf7,
	0xf2, 0x29, 0x66, 0x43, 0xee, 0xdc, 0x5d, 0x20, 0x37, 0xf3, 0x7c, 0x5a, 0x66, 0x92, 0xd0, 0x45,
	0x32, 0xb3, 0x31, 0x5e, 0x46, 0xc6, 0x47, 0x9b, 0xe7, 0xf2, 0x89, 0xef, 0xe5, 0x63, 0xe7, 0x52,
	0xbc, 0x84, 0x50, 0xf3, 0xd1, 0xe9, 0xb8, 0x6c, 0xfd, 0x1c, 0x97, 0xad, 0x3f, 0xe3, 0xb2, 0x85,
	0x2a, 0x94, 0x1b, 0xa8, 0x12, 0xa4, 0x47, 0x99, 0x3f, 0xc3, 0xf0, 0x3e, 0x4b, 0x40, 0x77, 0x35,
	0x8d, 0xe0, 0xc3, 0xbf, 0x01, 0x00, 0x00, 0xff, 0xff, 0x22, 0x5c, 0x1d, 0xae, 0x87, 0x06, 0x00,
	0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// MetricsQueryServiceClient is the client API for MetricsQueryService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type MetricsQueryServiceClient interface {
	// GetMinStepDuration gets the min time resolution supported by the backing metrics store,
	// e.g. 10s means the backend can only return data points that are at least 10s apart, not closer.
	GetMinStepDuration(ctx context.Context, in *GetMinStepDurationRequest, opts ...grpc.CallOption) (*GetMinStepDurationResponse, error)
	// GetLatencies gets the latency metrics for a given list of services grouped by service
	// and optionally grouped by operation.
	GetLatencies(ctx context.Context, in *GetLatenciesRequest, opts ...grpc.CallOption) (*GetMetricsResponse, error)
	// GetCallRates gets the call rate metrics for a given list of services grouped by service
	// and optionally grouped by operation.
	GetCallRates(ctx context.Context, in *GetCallRatesRequest, opts ...grpc.CallOption) (*GetMetricsResponse, error)
	// GetErrorRates gets the error rate metrics for a given list of services grouped by service
	// and optionally grouped by operation.
	GetErrorRates(ctx context.Context, in *GetErrorRatesRequest, opts ...grpc.CallOption) (*GetMetricsResponse, error)
}

type metricsQueryServiceClient struct {
	cc *grpc.ClientConn
}

func NewMetricsQueryServiceClient(cc *grpc.ClientConn) MetricsQueryServiceClient {
	return &metricsQueryServiceClient{cc}
}

func (c *metricsQueryServiceClient) GetMinStepDuration(ctx context.Context, in *GetMinStepDurationRequest, opts ...grpc.CallOption) (*GetMinStepDurationResponse, error) {
	out := new(GetMinStepDurationResponse)
	err := c.cc.Invoke(ctx, "/jaeger.api_v2.metrics.MetricsQueryService/GetMinStepDuration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metricsQueryServiceClient) GetLatencies(ctx context.Context, in *GetLatenciesRequest, opts ...grpc.CallOption) (*GetMetricsResponse, error) {
	out := new(GetMetricsResponse)
	err := c.cc.Invoke(ctx, "/jaeger.api_v2.metrics.MetricsQueryService/GetLatencies", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metricsQueryServiceClient) GetCallRates(ctx context.Context, in *GetCallRatesRequest, opts ...grpc.CallOption) (*GetMetricsResponse, error) {
	out := new(GetMetricsResponse)
	err := c.cc.Invoke(ctx, "/jaeger.api_v2.metrics.MetricsQueryService/GetCallRates", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metricsQueryServiceClient) GetErrorRates(ctx context.Context, in *GetErrorRatesRequest, opts ...grpc.CallOption) (*GetMetricsResponse, error) {
	out := new(GetMetricsResponse)
	err := c.cc.Invoke(ctx, "/jaeger.api_v2.metrics.MetricsQueryService/GetErrorRates", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MetricsQueryServiceServer is the server API for MetricsQueryService service.
type MetricsQueryServiceServer interface {
	// GetMinStepDuration gets the min time resolution supported by the backing metrics store,
	// e.g. 10s means the backend can only return data points that are at least 10s apart, not closer.
	GetMinStepDuration(context.Context, *GetMinStepDurationRequest) (*GetMinStepDurationResponse, error)
	// GetLatencies gets the latency metrics for a given list of services grouped by service
	// and optionally grouped by operation.
	GetLatencies(context.Context, *GetLatenciesRequest) (*GetMetricsResponse, error)
	// GetCallRates gets the call rate metrics for a given list of services grouped by service
	// and optionally grouped by operation.
	GetCallRates(context.Context, *GetCallRatesRequest) (*GetMetricsResponse, error)
	// GetErrorRates gets the error rate metrics for a given list of services grouped by service
	// and optionally grouped by operation.
	GetErrorRates(context.Context, *GetErrorRatesRequest) (*GetMetricsResponse, error)
}

// UnimplementedMetricsQueryServiceServer can be embedded to have forward compatible implementations.
type UnimplementedMetricsQueryServiceServer struct {
}

func (*UnimplementedMetricsQueryServiceServer) GetMinStepDuration(ctx context.Context, req *GetMinStepDurationRequest) (*GetMinStepDurationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMinStepDuration not implemented")
}
func (*UnimplementedMetricsQueryServiceServer) GetLatencies(ctx context.Context, req *GetLatenciesRequest) (*GetMetricsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLatencies not implemented")
}
func (*UnimplementedMetricsQueryServiceServer) GetCallRates(ctx context.Context, req *GetCallRatesRequest) (*GetMetricsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCallRates not implemented")
}
func (*UnimplementedMetricsQueryServiceServer) GetErrorRates(ctx context.Context, req *GetErrorRatesRequest) (*GetMetricsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetErrorRates not implemented")
}

func RegisterMetricsQueryServiceServer(s *grpc.Server, srv MetricsQueryServiceServer) {
	s.RegisterService(&_MetricsQueryService_serviceDesc, srv)
}

func _MetricsQueryService_GetMinStepDuration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMinStepDurationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetricsQueryServiceServer).GetMinStepDuration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/jaeger.api_v2.metrics.MetricsQueryService/GetMinStepDuration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetricsQueryServiceServer).GetMinStepDuration(ctx, req.(*GetMinStepDurationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetricsQueryService_GetLatencies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLatenciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetricsQueryServiceServer).GetLatencies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/jaeger.api_v2.metrics.MetricsQueryService/GetLatencies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetricsQueryServiceServer).GetLatencies(ctx, req.(*GetLatenciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetricsQueryService_GetCallRates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCallRatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetricsQueryServiceServer).GetCallRates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/jaeger.api_v2.metrics.MetricsQueryService/GetCallRates",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetricsQueryServiceServer).GetCallRates(ctx, req.(*GetCallRatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetricsQueryService_GetErrorRates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetErrorRatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetricsQueryServiceServer).GetErrorRates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/jaeger.api_v2.metrics.MetricsQueryService/GetErrorRates",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetricsQueryServiceServer).GetErrorRates(ctx, req.(*GetErrorRatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _MetricsQueryService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "jaeger.api_v2.metrics.MetricsQueryService",
	HandlerType: (*MetricsQueryServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetMinStepDuration",
			Handler:    _MetricsQueryService_GetMinStepDuration_Handler,
		},
		{
			MethodName: "GetLatencies",
			Handler:    _MetricsQueryService_GetLatencies_Handler,
		},
		{
			MethodName: "GetCallRates",
			Handler:    _MetricsQueryService_GetCallRates_Handler,
		},
		{
			MethodName: "GetErrorRates",
			Handler:    _MetricsQueryService_GetErrorRates_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "metricsquery.proto",
}

func (m *MetricsQueryBaseRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MetricsQueryBaseRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MetricsQueryBaseRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.SpanKinds) > 0 {
		dAtA2 := make([]byte, len(m.SpanKinds)*10)
		var j1 int
		for _, num := range m.SpanKinds {
			for num >= 1<<7 {
				dAtA2[j1] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j1++
			}
			dAtA2[j1] = uint8(num)
			j1++
		}
		i -= j1
		copy(dAtA[i:], dAtA2[:j1])
		i = encodeVarintMetricsquery(dAtA, i, uint64(j1))
		i--
		dAtA[i] = 0x3a
	}
	if m.RatePer != nil {
		n3, err3 := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.RatePer, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(*m.RatePer):])
		if err3 != nil {
			return 0, err3
		}
		i -= n3
		i = encodeVarintMetricsquery(dAtA, i, uint64(n3))
		i--
		dAtA[i] = 0x32
	}
	if m.Step != nil {
		n4, err4 := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.Step, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(*m.Step):])
		if err4 != nil {
			return 0, err4
		}
		i -= n4
		i = encodeVarintMetricsquery(dAtA, i, uint64(n4))
		i--
		dAtA[i] = 0x2a
	}
	if m.Lookback != nil {
		n5, err5 := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.Lookback, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(*m.Lookback):])
		if err5 != nil {
			return 0, err5
		}
		i -= n5
		i = encodeVarintMetricsquery(dAtA, i, uint64(n5))
		i--
		dAtA[i] = 0x22
	}
	if m.EndTime != nil {
		n6, err6 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.EndTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.EndTime):])
		if err6 != nil {
			return 0, err6
		}
		i -= n6
		i = encodeVarintMetricsquery(dAtA, i, uint64(n6))
		i--
		dAtA[i] = 0x1a
	}
	if m.GroupByOperation {
		i--
		if m.GroupByOperation {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.ServiceNames) > 0 {
		for iNdEx := len(m.ServiceNames) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ServiceNames[iNdEx])
			copy(dAtA[i:], m.ServiceNames[iNdEx])
			i = encodeVarintMetricsquery(dAtA, i, uint64(len(m.ServiceNames[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *GetLatenciesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetLatenciesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetLatenciesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Quantile != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Quantile))))
		i--
		dAtA[i] = 0x11
	}
	if m.BaseRequest != nil {
		{
			size, err := m.BaseRequest.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMetricsquery(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetCallRatesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetCallRatesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetCallRatesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.BaseRequest != nil {
		{
			size, err := m.BaseRequest.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMetricsquery(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetErrorRatesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetErrorRatesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetErrorRatesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.BaseRequest != nil {
		{
			size, err := m.BaseRequest.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMetricsquery(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetMinStepDurationRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetMinStepDurationRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetMinStepDurationRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *GetMinStepDurationResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetMinStepDurationResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetMinStepDurationResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	n10, err10 := github_com_gogo_protobuf_types.StdDurationMarshalTo(m.MinStep, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(m.MinStep):])
	if err10 != nil {
		return 0, err10
	}
	i -= n10
	i = encodeVarintMetricsquery(dAtA, i, uint64(n10))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *GetMetricsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetMetricsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetMetricsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	{
		size, err := m.Metrics.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintMetricsquery(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func encodeVarintMetricsquery(dAtA []byte, offset int, v uint64) int {
	offset -= sovMetricsquery(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *MetricsQueryBaseRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.ServiceNames) > 0 {
		for _, s := range m.ServiceNames {
			l = len(s)
			n += 1 + l + sovMetricsquery(uint64(l))
		}
	}
	if m.GroupByOperation {
		n += 2
	}
	if m.EndTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.EndTime)
		n += 1 + l + sovMetricsquery(uint64(l))
	}
	if m.Lookback != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.Lookback)
		n += 1 + l + sovMetricsquery(uint64(l))
	}
	if m.Step != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.Step)
		n += 1 + l + sovMetricsquery(uint64(l))
	}
	if m.RatePer != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.RatePer)
		n += 1 + l + sovMetricsquery(uint64(l))
	}
	if len(m.SpanKinds) > 0 {
		l = 0
		for _, e := range m.SpanKinds {
			l += sovMetricsquery(uint64(e))
		}
		n += 1 + sovMetricsquery(uint64(l)) + l
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetLatenciesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.BaseRequest != nil {
		l = m.BaseRequest.Size()
		n += 1 + l + sovMetricsquery(uint64(l))
	}
	if m.Quantile != 0 {
		n += 9
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetCallRatesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.BaseRequest != nil {
		l = m.BaseRequest.Size()
		n += 1 + l + sovMetricsquery(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetErrorRatesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.BaseRequest != nil {
		l = m.BaseRequest.Size()
		n += 1 + l + sovMetricsquery(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetMinStepDurationRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetMinStepDurationResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = github_com_gogo_protobuf_types.SizeOfStdDuration(m.MinStep)
	n += 1 + l + sovMetricsquery(uint64(l))
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetMetricsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Metrics.Size()
	n += 1 + l + sovMetricsquery(uint64(l))
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovMetricsquery(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozMetricsquery(x uint64) (n int) {
	return sovMetricsquery(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *MetricsQueryBaseRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetricsquery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MetricsQueryBaseRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MetricsQueryBaseRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServiceNames", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetricsquery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetricsquery
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMetricsquery
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ServiceNames = append(m.ServiceNames, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupByOperation", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetricsquery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.GroupByOperation = bool(v != 0)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetricsquery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetricsquery
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetricsquery
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EndTime == nil {
				m.EndTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.EndTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Lookback", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetricsquery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetricsquery
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetricsquery
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Lookback == nil {
				m.Lookback = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.Lookback, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Step", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetricsquery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetricsquery
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetricsquery
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Step == nil {
				m.Step = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.Step, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RatePer", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetricsquery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetricsquery
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetricsquery
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RatePer == nil {
				m.RatePer = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.RatePer, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType == 0 {
				var v SpanKind
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMetricsquery
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= SpanKind(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.SpanKinds = append(m.SpanKinds, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMetricsquery
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthMetricsquery
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthMetricsquery
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				if elementCount != 0 && len(m.SpanKinds) == 0 {
					m.SpanKinds = make([]SpanKind, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v SpanKind
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMetricsquery
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= SpanKind(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.SpanKinds = append(m.SpanKinds, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanKinds", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMetricsquery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetricsquery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetLatenciesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetricsquery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetLatenciesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetLatenciesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BaseRequest", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetricsquery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetricsquery
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetricsquery
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.BaseRequest == nil {
				m.BaseRequest = &MetricsQueryBaseRequest{}
			}
			if err := m.BaseRequest.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Quantile", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Quantile = float64(math.Float64frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipMetricsquery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetricsquery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetCallRatesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetricsquery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetCallRatesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetCallRatesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BaseRequest", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetricsquery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetricsquery
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetricsquery
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.BaseRequest == nil {
				m.BaseRequest = &MetricsQueryBaseRequest{}
			}
			if err := m.BaseRequest.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetricsquery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetricsquery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetErrorRatesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetricsquery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetErrorRatesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetErrorRatesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BaseRequest", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetricsquery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetricsquery
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetricsquery
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.BaseRequest == nil {
				m.BaseRequest = &MetricsQueryBaseRequest{}
			}
			if err := m.BaseRequest.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetricsquery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetricsquery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetMinStepDurationRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetricsquery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetMinStepDurationRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetMinStepDurationRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipMetricsquery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetricsquery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetMinStepDurationResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetricsquery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetMinStepDurationResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetMinStepDurationResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinStep", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetricsquery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetricsquery
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetricsquery
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(&m.MinStep, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetricsquery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetricsquery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetMetricsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetricsquery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetMetricsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetMetricsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metrics", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetricsquery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetricsquery
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetricsquery
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Metrics.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetricsquery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetricsquery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipMetricsquery(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowMetricsquery
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMetricsquery
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMetricsquery
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthMetricsquery
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupMetricsquery
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthMetricsquery
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthMetricsquery        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowMetricsquery          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupMetricsquery = fmt.Errorf("proto: unexpected end of group")
)
