// Code generated by protoc-gen-go-grpc. DO NOT EDIT.

package gribi

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// GRIBIClient is the client API for GRIBI service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type GRIBIClient interface {
	// Modify provides a bidirectional streaming RPC that can be used to issue
	// modifications to the AFT in the form of ModifyRequest(s).
	// The network element responds (asynchronously) with a ModifyResponse
	// for each ModifyRequest indicating what action was taken, once each
	// Operation within the request has been completed.
	Modify(ctx context.Context, opts ...grpc.CallOption) (GRIBI_ModifyClient, error)
	// Get provides a client a means to retrieve the contents of the installed
	// AFTs from the gRIBI daemon. The client requests a Get, and the server
	// responds with the set of currently installed entries (that have been ACK'd
	// according to the underlying resource to be programmed to) via the
	// GetResponse stream. Once all entries have been sent, the server closes the
	// RPC.
	//
	// The Get RPC is typically used to allow reconcilation between a client and
	// a server or for periodical consistency checking.
	Get(ctx context.Context, in *GetRequest, opts ...grpc.CallOption) (GRIBI_GetClient, error)
}

type gRIBIClient struct {
	cc grpc.ClientConnInterface
}

func NewGRIBIClient(cc grpc.ClientConnInterface) GRIBIClient {
	return &gRIBIClient{cc}
}

func (c *gRIBIClient) Modify(ctx context.Context, opts ...grpc.CallOption) (GRIBI_ModifyClient, error) {
	stream, err := c.cc.NewStream(ctx, &GRIBI_ServiceDesc.Streams[0], "/gribi.gRIBI/Modify", opts...)
	if err != nil {
		return nil, err
	}
	x := &gRIBIModifyClient{stream}
	return x, nil
}

type GRIBI_ModifyClient interface {
	Send(*ModifyRequest) error
	Recv() (*ModifyResponse, error)
	grpc.ClientStream
}

type gRIBIModifyClient struct {
	grpc.ClientStream
}

func (x *gRIBIModifyClient) Send(m *ModifyRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *gRIBIModifyClient) Recv() (*ModifyResponse, error) {
	m := new(ModifyResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *gRIBIClient) Get(ctx context.Context, in *GetRequest, opts ...grpc.CallOption) (GRIBI_GetClient, error) {
	stream, err := c.cc.NewStream(ctx, &GRIBI_ServiceDesc.Streams[1], "/gribi.gRIBI/Get", opts...)
	if err != nil {
		return nil, err
	}
	x := &gRIBIGetClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type GRIBI_GetClient interface {
	Recv() (*GetResponse, error)
	grpc.ClientStream
}

type gRIBIGetClient struct {
	grpc.ClientStream
}

func (x *gRIBIGetClient) Recv() (*GetResponse, error) {
	m := new(GetResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// GRIBIServer is the server API for GRIBI service.
// All implementations must embed UnimplementedGRIBIServer
// for forward compatibility
type GRIBIServer interface {
	// Modify provides a bidirectional streaming RPC that can be used to issue
	// modifications to the AFT in the form of ModifyRequest(s).
	// The network element responds (asynchronously) with a ModifyResponse
	// for each ModifyRequest indicating what action was taken, once each
	// Operation within the request has been completed.
	Modify(GRIBI_ModifyServer) error
	// Get provides a client a means to retrieve the contents of the installed
	// AFTs from the gRIBI daemon. The client requests a Get, and the server
	// responds with the set of currently installed entries (that have been ACK'd
	// according to the underlying resource to be programmed to) via the
	// GetResponse stream. Once all entries have been sent, the server closes the
	// RPC.
	//
	// The Get RPC is typically used to allow reconcilation between a client and
	// a server or for periodical consistency checking.
	Get(*GetRequest, GRIBI_GetServer) error
	mustEmbedUnimplementedGRIBIServer()
}

// UnimplementedGRIBIServer must be embedded to have forward compatible implementations.
type UnimplementedGRIBIServer struct {
}

func (UnimplementedGRIBIServer) Modify(GRIBI_ModifyServer) error {
	return status.Errorf(codes.Unimplemented, "method Modify not implemented")
}
func (UnimplementedGRIBIServer) Get(*GetRequest, GRIBI_GetServer) error {
	return status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedGRIBIServer) mustEmbedUnimplementedGRIBIServer() {}

// UnsafeGRIBIServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to GRIBIServer will
// result in compilation errors.
type UnsafeGRIBIServer interface {
	mustEmbedUnimplementedGRIBIServer()
}

func RegisterGRIBIServer(s grpc.ServiceRegistrar, srv GRIBIServer) {
	s.RegisterService(&GRIBI_ServiceDesc, srv)
}

func _GRIBI_Modify_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(GRIBIServer).Modify(&gRIBIModifyServer{stream})
}

type GRIBI_ModifyServer interface {
	Send(*ModifyResponse) error
	Recv() (*ModifyRequest, error)
	grpc.ServerStream
}

type gRIBIModifyServer struct {
	grpc.ServerStream
}

func (x *gRIBIModifyServer) Send(m *ModifyResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *gRIBIModifyServer) Recv() (*ModifyRequest, error) {
	m := new(ModifyRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _GRIBI_Get_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(GRIBIServer).Get(m, &gRIBIGetServer{stream})
}

type GRIBI_GetServer interface {
	Send(*GetResponse) error
	grpc.ServerStream
}

type gRIBIGetServer struct {
	grpc.ServerStream
}

func (x *gRIBIGetServer) Send(m *GetResponse) error {
	return x.ServerStream.SendMsg(m)
}

// GRIBI_ServiceDesc is the grpc.ServiceDesc for GRIBI service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var GRIBI_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "gribi.gRIBI",
	HandlerType: (*GRIBIServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Modify",
			Handler:       _GRIBI_Modify_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "Get",
			Handler:       _GRIBI_Get_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "v1/proto/service/gribi.proto",
}
