/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.systemlog.admin.activity.changes;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AdminChangeLogUtils {
    private static final Pattern COLLECTION_KEY_VALUE_PATTERN = Pattern.compile("\\[(.*?)]");

    private AdminChangeLogUtils() {
    }

    public static Optional<String> getCollectionKeyValueFromPropertyPath(String string) {
        Matcher matcher = COLLECTION_KEY_VALUE_PATTERN.matcher(string);
        return matcher.find() ? Optional.of(matcher.group(1)) : Optional.empty();
    }

    public static String getPropertyFromPropertyPath(String string) {
        return string.replaceAll(COLLECTION_KEY_VALUE_PATTERN.pattern(), "");
    }

    public static Optional<String> getCollectionKeyProperty(String string, @Nullable String string3) {
        return Optional.ofNullable(string3).map(string2 -> {
            String string3 = AdminChangeLogUtils.getPropertyFromPropertyPath(string);
            int n2 = string3.lastIndexOf(".");
            return StringUtils.joinWith((String)".", (Object[])new Object[]{n2 != -1 ? string3.substring(0, n2) : string3, string2});
        });
    }
}

