/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.systemlog;

import com.ubnt.data.Site;
import com.ubnt.model.api.PaginatedSortableRequestWithTimestamp;
import com.ubnt.model.api.alert.AlertCountDto;
import com.ubnt.model.api.alert.AlertDto;
import com.ubnt.model.api.alert.AlertListDto;
import com.ubnt.model.api.alert.AlertSettingDto;
import com.ubnt.model.api.alert.AlertSettingItemUpdateDto;
import com.ubnt.model.api.alert.AlertSettingUpdateDto;
import com.ubnt.model.api.alert.AllSystemLogListParameterDto;
import com.ubnt.model.api.alert.CefLogDto;
import com.ubnt.model.api.alert.CountSystemLogsParameterDto;
import com.ubnt.model.api.alert.CriticalSystemLogListParameterDto;
import com.ubnt.net.security.G;
import com.ubnt.net.security.role.A;
import com.ubnt.net.security.role.String;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowReadPrivileges;
import com.ubnt.net.v2.exception.UserNotAuthenticatedException;
import com.ubnt.service.alert.AlertDocument;
import com.ubnt.service.alert.T;
import com.ubnt.service.alert.Z;
import com.ubnt.service.alert.c;
import com.ubnt.service.alert.null;
import com.ubnt.service.alert.p;
import com.ubnt.service.alert.setting.AlertSettingDocument;
import com.ubnt.service.alert.setting.OoOO;
import com.ubnt.service.alert.setting.SystemLogItemSettingDocumentPart;
import com.ubnt.service.alert.setting.return;
import com.ubnt.service.alert.superObject;
import com.ubnt.service.remotelog.H;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.function.TriFunction;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Tag(name="System Log")
public class SystemLogController {
    private final superObject new;
    private final p o00000;
    private final return \u00d500000;
    private final H return;
    private final G \u00d400000;
    private final null \u00d300000;
    private final A \u00d800000;

    @AllowReadPrivileges
    @PostMapping(value={"/api/site/{siteName}/system-log/all"})
    public AlertListDto listAllSystemLogs(@PathVariable(value="siteName") Site site, @RequestBody @Valid AllSystemLogListParameterDto allSystemLogListParameterDto, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.\u00d300000(httpServletRequest, httpServletResponse, site, allSystemLogListParameterDto, this.o00000::private);
    }

    @AllowReadPrivileges
    @PostMapping(value={"/api/site/{siteName}/system-log/count"})
    public AlertCountDto countSystemLogs(@PathVariable(value="siteName") Site site, @RequestBody @Valid CountSystemLogsParameterDto countSystemLogsParameterDto, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.oO0000(httpServletRequest, httpServletResponse, site, countSystemLogsParameterDto);
    }

    @GetMapping(value={"/api/site/{siteName}/system-log/{id}/cef"})
    public ResponseEntity<CefLogDto> getCefLog(@PathVariable(value="siteName") Site site, @PathVariable(value="id") java.lang.String string2, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string3 = this.\u00f600000(site, httpServletRequest, httpServletResponse);
        return this.o00000.returnsuper(site.getId(), string2, string3).map(this.return::o00000).map(string -> CefLogDto.builder().cefLog((java.lang.String)string).build()).map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @AllowReadPrivileges
    @PostMapping(value={"/api/site/{siteName}/system-log/critical"})
    public List<AlertDto> listCriticalSystemLogs(@PathVariable(value="siteName") Site site, @RequestBody @Valid CriticalSystemLogListParameterDto criticalSystemLogListParameterDto, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = this.\u00f600000(site, httpServletRequest, httpServletResponse);
        List<AlertDocument> list = this.\u00d300000.o00000(site.getId(), string, criticalSystemLogListParameterDto);
        return this.new.\u00d400000(list, false);
    }

    @PutMapping(value={"/api/site/{siteName}/system-log/critical/mark-all-as-read"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Mark as read aggregated Critical logs. It means that marking one of them as read should mark also another from the same group")
    public void markAllCriticalLogsAsRead(@PathVariable(value="siteName") Site site, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = this.\u00f600000(site, httpServletRequest, httpServletResponse);
        this.\u00d300000.\u00d4o0000(site.getId(), string);
    }

    @PutMapping(value={"/api/site/{siteName}/system-log/critical/{alertId}/mark-as-read"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Mark as read a single aggregated critical log. It means that marking as read should mark also another from the same group")
    public void markCriticalLogsAsRead(@PathVariable(value="siteName") Site site, @PathVariable(value="alertId") java.lang.String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string2 = this.\u00f600000(site, httpServletRequest, httpServletResponse);
        this.\u00d300000.return(site.getId(), string2, string);
    }

    @GetMapping(value={"/api/site/{siteName}/system-log/setting"})
    @Operation(summary="Get System log settings")
    public AlertSettingDto getSystemLogSettings(@PathVariable(value="siteName") Site site, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.\u00d800000(httpServletRequest, httpServletResponse, string -> AlertSettingDto.fromDocument(this.\u00d500000.\u00d200000((java.lang.String)string, site.getId())));
    }

    @GetMapping(value={"/api/site/{siteName}/system-log/setting/defaults"})
    @Operation(summary="Get System log setting defaults")
    public AlertSettingDto getSystemLogSettingDefaults(@PathVariable(value="siteName") Site site, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.\u00d800000(httpServletRequest, httpServletResponse, string -> AlertSettingDto.fromDocument(this.\u00d500000.\u00d300000((java.lang.String)string, site.getId())));
    }

    @PutMapping(value={"/api/site/{siteName}/system-log/setting"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Update System log settings")
    public AlertSettingDto updateSystemLogSettings(@PathVariable(value="siteName") Site site, @RequestBody AlertSettingUpdateDto alertSettingUpdateDto, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.\u00d800000(httpServletRequest, httpServletResponse, string -> {
            this.\u00d500000.String((java.lang.String)string, alertSettingDocument -> this.\u00f500000(alertSettingUpdateDto, (AlertSettingDocument)alertSettingDocument));
            return AlertSettingDto.fromDocument(this.\u00d500000.\u00d200000((java.lang.String)string, site.getId()));
        });
    }

    private AlertCountDto oO0000(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Site site, CountSystemLogsParameterDto countSystemLogsParameterDto) {
        String string = this.\u00f600000(site, httpServletRequest, httpServletResponse);
        return this.o00000.\u00d2o0000(site, countSystemLogsParameterDto, string);
    }

    private <T extends PaginatedSortableRequestWithTimestamp> AlertListDto \u00d300000(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Site site, T t2, TriFunction<Site, T, String, T> triFunction) {
        String string = this.\u00f600000(site, httpServletRequest, httpServletResponse);
        T t3 = (T)triFunction.apply((Object)site, t2, (Object)string);
        return AlertListDto.builder().totalElementCount(t3.\u00d300000()).totalPageCount(t3.\u00d400000()).pageNumber(t3.o00000()).data(this.new.\u00d400000(t3.new(), false)).build();
    }

    private AlertSettingDto \u00d800000(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Function<java.lang.String, AlertSettingDto> function) {
        return this.\u00d400000.o00000(httpServletRequest, httpServletResponse).flatMap(x2 -> Optional.ofNullable(x2.getString("admin_id"))).map(function).orElseThrow(() -> new UserNotAuthenticatedException(httpServletRequest.getRequestURI()));
    }

    private String \u00f600000(Site site, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.\u00d800000.\u00d300000(httpServletRequest, httpServletResponse, site.getId());
    }

    private AlertSettingDocument \u00f500000(AlertSettingUpdateDto alertSettingUpdateDto, AlertSettingDocument alertSettingDocument) {
        return alertSettingDocument.builderOfCurrent().super(alertSettingUpdateDto.settingPreference()).int(this.for(alertSettingUpdateDto)).\u00d200000();
    }

    private Map<Z, SystemLogItemSettingDocumentPart> for(AlertSettingUpdateDto alertSettingUpdateDto) {
        if (OoOO.o00000 == alertSettingUpdateDto.settingPreference()) {
            if (alertSettingUpdateDto.alertTypeSettings() == null || alertSettingUpdateDto.alertTypeSettings().isEmpty()) {
                return alertSettingUpdateDto.alertEventSettings().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((AlertSettingItemUpdateDto)entry.getValue()).toDocument()));
            }
            Map<c, AlertSettingItemUpdateDto> map = alertSettingUpdateDto.alertTypeSettings();
            return Z.Oo0000.stream().filter(z2 -> z2.\u00d800000() != null).collect(Collectors.toMap(Function.identity(), z2 -> Optional.ofNullable((AlertSettingItemUpdateDto)map.get((Object)z2.\u00d800000())).map(AlertSettingItemUpdateDto::toDocument).orElse(SystemLogItemSettingDocumentPart.ALL_OFF)));
        }
        return Collections.emptyMap();
    }

    @ConstructorProperties(value={"alertDocumentMapper", "alertSearchService", "alertSettingService", "cefLogService", "loginInfoService", "nextAiLogDashboardService", "roleManager"})
    @Generated
    public SystemLogController(superObject superObject2, p p2, return return_, H h2, G g2, null nullVal, A a2) {
        this.new = superObject2;
        this.o00000 = p2;
        this.\u00d500000 = return_;
        this.return = h2;
        this.\u00d400000 = g2;
        this.\u00d300000 = nullVal;
        this.\u00d800000 = a2;
    }
}

