/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.wifiai;

import com.ubnt.data.Site;
import com.ubnt.model.api.wifi.RadioAiIsolationMatrixDto;
import com.ubnt.model.api.wifi.RadioBandFilter;
import com.ubnt.model.api.wifi.radio.AutoChannelUpdateInfoListDto;
import com.ubnt.model.api.wifi.radio.RadioAiOptimizationStatusDto;
import com.ubnt.model.api.wifi.radio.RadioAiRadiosDto;
import com.ubnt.model.api.wifi.radio.RadioAiRequestDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.service.autochannel.OoOO.I;
import com.ubnt.service.devmgr.thissuper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@V2RestController
@Validated
@Tag(name="Radio AI")
public class RadioAiController {
    private final thissuper o00000;

    @PostMapping(value={"/api/site/{siteName}/radio-ai/optimize/preview"})
    @Operation(summary="Run optimization without actually applying the result, the result will be sent through websocket")
    public void previewRadioAi(@PathVariable(value="siteName") Site site, @Valid @RequestBody RadioAiRequestDto radioAiRequestDto) {
        this.o00000.\u00f6\u00f5O000(site.getId(), radioAiRequestDto.calculationId(), I.\u00d500000().\u00d800000(site.getId()).do(radioAiRequestDto.radios()).super(radioAiRequestDto.includeAllDevices()).\u00d200000(radioAiRequestDto.includeDevices()).OO0000(true).interface(radioAiRequestDto.method()).\u00d600000());
    }

    @PostMapping(value={"/api/site/{siteName}/radio-ai/optimize/apply/{calculationId}"})
    @Operation(summary="Apply previous optimization results")
    public void applyRadioAiResults(@PathVariable(value="siteName") Site site, @PathVariable(value="calculationId") String string) {
        this.o00000.nullprivate(site.getId(), string);
    }

    @GetMapping(value={"/api/radio-ai/optimize/preview/{calculationId}"})
    @Operation(summary="Return optimisation results")
    public AutoChannelUpdateInfoListDto getRadioAiResult(@PathVariable(value="calculationId") String string) {
        return this.o00000.\u00d2\u00f5O000(string);
    }

    @PostMapping(value={"/api/site/{siteName}/radio-ai/optimize/apply-last"})
    @Operation(summary="Apply last optimisation results")
    public void applyLastRadioAiResults(@PathVariable(value="siteName") Site site, @Valid @RequestBody RadioAiRadiosDto radioAiRadiosDto) {
        this.o00000.\u00d3\u00d8O000(site.getId(), radioAiRadiosDto.radios());
    }

    @PostMapping(value={"/api/site/{siteName}/radio-ai/optimize/preview-last"})
    @Operation(summary="Return last optimisation results")
    public AutoChannelUpdateInfoListDto getLastRadioAiResult(@PathVariable(value="siteName") Site site, @Valid @RequestBody RadioAiRadiosDto radioAiRadiosDto) {
        return this.o00000.\u00f5\u00f6O000(site.getId(), radioAiRadiosDto.radios());
    }

    @GetMapping(value={"/api/site/{siteName}/radio-ai/optimize/status"})
    @Operation(summary="Get optimization status")
    public RadioAiOptimizationStatusDto getOptimizationStatus(@PathVariable(value="siteName") Site site) {
        return this.o00000.nullwhile(site.getId());
    }

    @GetMapping(value={"/api/site/{siteName}/radio-ai/isolation-matrix"})
    public RadioAiIsolationMatrixDto getIsolationMatrix(@PathVariable(value="siteName") Site site, @RequestParam(value="radioBand", required=false) RadioBandFilter radioBandFilter) {
        return this.o00000.\u00d6\u00f5O000(site.getId(), radioBandFilter);
    }

    @ConstructorProperties(value={"radioAIManager"})
    @Generated
    public RadioAiController(thissuper thissuper2) {
        this.o00000 = thissuper2;
    }
}

