// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package honeycode

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opGetScreenData = "GetScreenData"

// GetScreenDataRequest generates a "aws/request.Request" representing the
// client's request for the GetScreenData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetScreenData for more information on using the GetScreenData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetScreenDataRequest method.
//    req, resp := client.GetScreenDataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/GetScreenData
func (c *Honeycode) GetScreenDataRequest(input *GetScreenDataInput) (req *request.Request, output *GetScreenDataOutput) {
	op := &request.Operation{
		Name:       opGetScreenData,
		HTTPMethod: "POST",
		HTTPPath:   "/screendata",
	}

	if input == nil {
		input = &GetScreenDataInput{}
	}

	output = &GetScreenDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetScreenData API operation for Amazon Honeycode.
//
// The GetScreenData API allows retrieval of data from a screen in a Honeycode
// app. The API allows setting local variables in the screen to filter, sort
// or otherwise affect what will be displayed on the screen.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Honeycode's
// API operation GetScreenData for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient access to perform this action. Check that the
//   workbook is owned by you and your IAM policy allows access to the screen/automation
//   in the request.
//
//   * InternalServerException
//   There were unexpected errors from the server.
//
//   * RequestTimeoutException
//   The request timed out.
//
//   * ResourceNotFoundException
//   A Workbook, App, Screen or Screen Automation was not found with the given
//   ID.
//
//   * ServiceUnavailableException
//   Remote service is unreachable.
//
//   * ThrottlingException
//   Tps(transactions per second) rate reached.
//
//   * ValidationException
//   Request is invalid. The message in the response contains details on why the
//   request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/GetScreenData
func (c *Honeycode) GetScreenData(input *GetScreenDataInput) (*GetScreenDataOutput, error) {
	req, out := c.GetScreenDataRequest(input)
	return out, req.Send()
}

// GetScreenDataWithContext is the same as GetScreenData with the addition of
// the ability to pass a context and additional request options.
//
// See GetScreenData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Honeycode) GetScreenDataWithContext(ctx aws.Context, input *GetScreenDataInput, opts ...request.Option) (*GetScreenDataOutput, error) {
	req, out := c.GetScreenDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opInvokeScreenAutomation = "InvokeScreenAutomation"

// InvokeScreenAutomationRequest generates a "aws/request.Request" representing the
// client's request for the InvokeScreenAutomation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See InvokeScreenAutomation for more information on using the InvokeScreenAutomation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the InvokeScreenAutomationRequest method.
//    req, resp := client.InvokeScreenAutomationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/InvokeScreenAutomation
func (c *Honeycode) InvokeScreenAutomationRequest(input *InvokeScreenAutomationInput) (req *request.Request, output *InvokeScreenAutomationOutput) {
	op := &request.Operation{
		Name:       opInvokeScreenAutomation,
		HTTPMethod: "POST",
		HTTPPath:   "/workbooks/{workbookId}/apps/{appId}/screens/{screenId}/automations/{automationId}",
	}

	if input == nil {
		input = &InvokeScreenAutomationInput{}
	}

	output = &InvokeScreenAutomationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// InvokeScreenAutomation API operation for Amazon Honeycode.
//
// The InvokeScreenAutomation API allows invoking an action defined in a screen
// in a Honeycode app. The API allows setting local variables, which can then
// be used in the automation being invoked. This allows automating the Honeycode
// app interactions to write, update or delete data in the workbook.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Honeycode's
// API operation InvokeScreenAutomation for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient access to perform this action. Check that the
//   workbook is owned by you and your IAM policy allows access to the screen/automation
//   in the request.
//
//   * InternalServerException
//   There were unexpected errors from the server.
//
//   * ResourceNotFoundException
//   A Workbook, App, Screen or Screen Automation was not found with the given
//   ID.
//
//   * ValidationException
//   Request is invalid. The message in the response contains details on why the
//   request is invalid.
//
//   * ThrottlingException
//   Tps(transactions per second) rate reached.
//
//   * ServiceUnavailableException
//   Remote service is unreachable.
//
//   * AutomationExecutionException
//   The automation execution did not end successfully.
//
//   * AutomationExecutionTimeoutException
//   The automation execution timed out.
//
//   * RequestTimeoutException
//   The request timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/InvokeScreenAutomation
func (c *Honeycode) InvokeScreenAutomation(input *InvokeScreenAutomationInput) (*InvokeScreenAutomationOutput, error) {
	req, out := c.InvokeScreenAutomationRequest(input)
	return out, req.Send()
}

// InvokeScreenAutomationWithContext is the same as InvokeScreenAutomation with the addition of
// the ability to pass a context and additional request options.
//
// See InvokeScreenAutomation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Honeycode) InvokeScreenAutomationWithContext(ctx aws.Context, input *InvokeScreenAutomationInput, opts ...request.Option) (*InvokeScreenAutomationOutput, error) {
	req, out := c.InvokeScreenAutomationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action. Check that the
// workbook is owned by you and your IAM policy allows access to the screen/automation
// in the request.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The automation execution did not end successfully.
type AutomationExecutionException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s AutomationExecutionException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutomationExecutionException) GoString() string {
	return s.String()
}

func newErrorAutomationExecutionException(v protocol.ResponseMetadata) error {
	return &AutomationExecutionException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AutomationExecutionException) Code() string {
	return "AutomationExecutionException"
}

// Message returns the exception's message.
func (s *AutomationExecutionException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AutomationExecutionException) OrigErr() error {
	return nil
}

func (s *AutomationExecutionException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AutomationExecutionException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AutomationExecutionException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The automation execution timed out.
type AutomationExecutionTimeoutException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s AutomationExecutionTimeoutException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutomationExecutionTimeoutException) GoString() string {
	return s.String()
}

func newErrorAutomationExecutionTimeoutException(v protocol.ResponseMetadata) error {
	return &AutomationExecutionTimeoutException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AutomationExecutionTimeoutException) Code() string {
	return "AutomationExecutionTimeoutException"
}

// Message returns the exception's message.
func (s *AutomationExecutionTimeoutException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AutomationExecutionTimeoutException) OrigErr() error {
	return nil
}

func (s *AutomationExecutionTimeoutException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AutomationExecutionTimeoutException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AutomationExecutionTimeoutException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Metadata for column in the table.
type ColumnMetadata struct {
	_ struct{} `type:"structure"`

	// The format of the column.
	//
	// Format is a required field
	Format *string `locationName:"format" type:"string" required:"true" enum:"Format"`

	// The name of the column.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s ColumnMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ColumnMetadata) GoString() string {
	return s.String()
}

// SetFormat sets the Format field's value.
func (s *ColumnMetadata) SetFormat(v string) *ColumnMetadata {
	s.Format = &v
	return s
}

// SetName sets the Name field's value.
func (s *ColumnMetadata) SetName(v string) *ColumnMetadata {
	s.Name = &v
	return s
}

// The data in a particular data cell defined on the screen.
type DataItem struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The formatted value of the data. e.g. John Smith.
	FormattedValue *string `locationName:"formattedValue" type:"string"`

	// The overrideFormat is optional and is specified only if a particular row
	// of data has a different format for the data than the default format defined
	// on the screen or the table.
	OverrideFormat *string `locationName:"overrideFormat" type:"string" enum:"Format"`

	// The raw value of the data. e.g. jsmith@example.com
	RawValue *string `locationName:"rawValue" type:"string"`
}

// String returns the string representation
func (s DataItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataItem) GoString() string {
	return s.String()
}

// SetFormattedValue sets the FormattedValue field's value.
func (s *DataItem) SetFormattedValue(v string) *DataItem {
	s.FormattedValue = &v
	return s
}

// SetOverrideFormat sets the OverrideFormat field's value.
func (s *DataItem) SetOverrideFormat(v string) *DataItem {
	s.OverrideFormat = &v
	return s
}

// SetRawValue sets the RawValue field's value.
func (s *DataItem) SetRawValue(v string) *DataItem {
	s.RawValue = &v
	return s
}

type GetScreenDataInput struct {
	_ struct{} `type:"structure"`

	// The ID of the app that contains the screem.
	//
	// AppId is a required field
	AppId *string `locationName:"appId" type:"string" required:"true"`

	// The number of results to be returned on a single page. Specify a number between
	// 1 and 100. The maximum value is 100.
	//
	// This parameter is optional. If you don't specify this parameter, the default
	// page size is 100.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// This parameter is optional. If a nextToken is not specified, the API returns
	// the first page of data.
	//
	// Pagination tokens expire after 1 hour. If you use a token that was returned
	// more than an hour back, the API will throw ValidationException.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The ID of the screen.
	//
	// ScreenId is a required field
	ScreenId *string `locationName:"screenId" type:"string" required:"true"`

	// Variables are optional and are needed only if the screen requires them to
	// render correctly. Variables are specified as a map where the key is the name
	// of the variable as defined on the screen. The value is an object which currently
	// has only one property, rawValue, which holds the value of the variable to
	// be passed to the screen.
	Variables map[string]*VariableValue `locationName:"variables" type:"map" sensitive:"true"`

	// The ID of the workbook that contains the screen.
	//
	// WorkbookId is a required field
	WorkbookId *string `locationName:"workbookId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetScreenDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetScreenDataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetScreenDataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetScreenDataInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ScreenId == nil {
		invalidParams.Add(request.NewErrParamRequired("ScreenId"))
	}
	if s.WorkbookId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkbookId"))
	}
	if s.Variables != nil {
		for i, v := range s.Variables {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Variables", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *GetScreenDataInput) SetAppId(v string) *GetScreenDataInput {
	s.AppId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetScreenDataInput) SetMaxResults(v int64) *GetScreenDataInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetScreenDataInput) SetNextToken(v string) *GetScreenDataInput {
	s.NextToken = &v
	return s
}

// SetScreenId sets the ScreenId field's value.
func (s *GetScreenDataInput) SetScreenId(v string) *GetScreenDataInput {
	s.ScreenId = &v
	return s
}

// SetVariables sets the Variables field's value.
func (s *GetScreenDataInput) SetVariables(v map[string]*VariableValue) *GetScreenDataInput {
	s.Variables = v
	return s
}

// SetWorkbookId sets the WorkbookId field's value.
func (s *GetScreenDataInput) SetWorkbookId(v string) *GetScreenDataInput {
	s.WorkbookId = &v
	return s
}

type GetScreenDataOutput struct {
	_ struct{} `type:"structure"`

	// Provides the pagination token to load the next page if there are more results
	// matching the request. If a pagination token is not present in the response,
	// it means that all data matching the query has been loaded.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A map of all the rows on the screen keyed by block name.
	//
	// Results is a required field
	Results map[string]*ResultSet `locationName:"results" type:"map" required:"true"`

	// Indicates the cursor of the workbook at which the data returned by this workbook
	// is read. Workbook cursor keeps increasing with every update and the increments
	// are not sequential.
	//
	// WorkbookCursor is a required field
	WorkbookCursor *int64 `locationName:"workbookCursor" type:"long" required:"true"`
}

// String returns the string representation
func (s GetScreenDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetScreenDataOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetScreenDataOutput) SetNextToken(v string) *GetScreenDataOutput {
	s.NextToken = &v
	return s
}

// SetResults sets the Results field's value.
func (s *GetScreenDataOutput) SetResults(v map[string]*ResultSet) *GetScreenDataOutput {
	s.Results = v
	return s
}

// SetWorkbookCursor sets the WorkbookCursor field's value.
func (s *GetScreenDataOutput) SetWorkbookCursor(v int64) *GetScreenDataOutput {
	s.WorkbookCursor = &v
	return s
}

// There were unexpected errors from the server.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type InvokeScreenAutomationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the app that contains the screen automation.
	//
	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	// The request token for performing the automation action. Request tokens help
	// to identify duplicate requests. If a call times out or fails due to a transient
	// error like a failed network connection, you can retry the call with the same
	// request token. The service ensures that if the first call using that request
	// token is successfully performed, the second call will return the response
	// of the previous call rather than performing the action again.
	//
	// Note that request tokens are valid only for a few minutes. You cannot use
	// request tokens to dedupe requests spanning hours or days.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"32" type:"string"`

	// The row ID for the automation if the automation is defined inside a block
	// with source or list.
	RowId *string `locationName:"rowId" type:"string"`

	// The ID of the automation action to be performed.
	//
	// ScreenAutomationId is a required field
	ScreenAutomationId *string `location:"uri" locationName:"automationId" type:"string" required:"true"`

	// The ID of the screen that contains the screen automation.
	//
	// ScreenId is a required field
	ScreenId *string `location:"uri" locationName:"screenId" type:"string" required:"true"`

	// Variables are optional and are needed only if the screen requires them to
	// render correctly. Variables are specified as a map where the key is the name
	// of the variable as defined on the screen. The value is an object which currently
	// has only one property, rawValue, which holds the value of the variable to
	// be passed to the screen.
	Variables map[string]*VariableValue `locationName:"variables" type:"map" sensitive:"true"`

	// The ID of the workbook that contains the screen automation.
	//
	// WorkbookId is a required field
	WorkbookId *string `location:"uri" locationName:"workbookId" type:"string" required:"true"`
}

// String returns the string representation
func (s InvokeScreenAutomationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvokeScreenAutomationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InvokeScreenAutomationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InvokeScreenAutomationInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 32))
	}
	if s.ScreenAutomationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ScreenAutomationId"))
	}
	if s.ScreenAutomationId != nil && len(*s.ScreenAutomationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScreenAutomationId", 1))
	}
	if s.ScreenId == nil {
		invalidParams.Add(request.NewErrParamRequired("ScreenId"))
	}
	if s.ScreenId != nil && len(*s.ScreenId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScreenId", 1))
	}
	if s.WorkbookId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkbookId"))
	}
	if s.WorkbookId != nil && len(*s.WorkbookId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkbookId", 1))
	}
	if s.Variables != nil {
		for i, v := range s.Variables {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Variables", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *InvokeScreenAutomationInput) SetAppId(v string) *InvokeScreenAutomationInput {
	s.AppId = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *InvokeScreenAutomationInput) SetClientRequestToken(v string) *InvokeScreenAutomationInput {
	s.ClientRequestToken = &v
	return s
}

// SetRowId sets the RowId field's value.
func (s *InvokeScreenAutomationInput) SetRowId(v string) *InvokeScreenAutomationInput {
	s.RowId = &v
	return s
}

// SetScreenAutomationId sets the ScreenAutomationId field's value.
func (s *InvokeScreenAutomationInput) SetScreenAutomationId(v string) *InvokeScreenAutomationInput {
	s.ScreenAutomationId = &v
	return s
}

// SetScreenId sets the ScreenId field's value.
func (s *InvokeScreenAutomationInput) SetScreenId(v string) *InvokeScreenAutomationInput {
	s.ScreenId = &v
	return s
}

// SetVariables sets the Variables field's value.
func (s *InvokeScreenAutomationInput) SetVariables(v map[string]*VariableValue) *InvokeScreenAutomationInput {
	s.Variables = v
	return s
}

// SetWorkbookId sets the WorkbookId field's value.
func (s *InvokeScreenAutomationInput) SetWorkbookId(v string) *InvokeScreenAutomationInput {
	s.WorkbookId = &v
	return s
}

type InvokeScreenAutomationOutput struct {
	_ struct{} `type:"structure"`

	// The updated workbook cursor after performing the automation action.
	//
	// WorkbookCursor is a required field
	WorkbookCursor *int64 `locationName:"workbookCursor" type:"long" required:"true"`
}

// String returns the string representation
func (s InvokeScreenAutomationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvokeScreenAutomationOutput) GoString() string {
	return s.String()
}

// SetWorkbookCursor sets the WorkbookCursor field's value.
func (s *InvokeScreenAutomationOutput) SetWorkbookCursor(v int64) *InvokeScreenAutomationOutput {
	s.WorkbookCursor = &v
	return s
}

// The request timed out.
type RequestTimeoutException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s RequestTimeoutException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestTimeoutException) GoString() string {
	return s.String()
}

func newErrorRequestTimeoutException(v protocol.ResponseMetadata) error {
	return &RequestTimeoutException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *RequestTimeoutException) Code() string {
	return "RequestTimeoutException"
}

// Message returns the exception's message.
func (s *RequestTimeoutException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *RequestTimeoutException) OrigErr() error {
	return nil
}

func (s *RequestTimeoutException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *RequestTimeoutException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *RequestTimeoutException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A Workbook, App, Screen or Screen Automation was not found with the given
// ID.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A single row in the ResultSet.
type ResultRow struct {
	_ struct{} `type:"structure"`

	// List of all the data cells in a row.
	//
	// DataItems is a required field
	DataItems []*DataItem `locationName:"dataItems" type:"list" required:"true"`

	// The ID for a particular row.
	RowId *string `locationName:"rowId" type:"string"`
}

// String returns the string representation
func (s ResultRow) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResultRow) GoString() string {
	return s.String()
}

// SetDataItems sets the DataItems field's value.
func (s *ResultRow) SetDataItems(v []*DataItem) *ResultRow {
	s.DataItems = v
	return s
}

// SetRowId sets the RowId field's value.
func (s *ResultRow) SetRowId(v string) *ResultRow {
	s.RowId = &v
	return s
}

// ResultSet contains the results of the request for a single block or list
// defined on the screen.
type ResultSet struct {
	_ struct{} `type:"structure"`

	// List of headers for all the data cells in the block. The header identifies
	// the name and default format of the data cell. Data cells appear in the same
	// order in all rows as defined in the header. The names and formats are not
	// repeated in the rows. If a particular row does not have a value for a data
	// cell, a blank value is used.
	//
	// For example, a task list that displays the task name, due date and assigned
	// person might have headers [ { "name": "Task Name"}, {"name": "Due Date",
	// "format": "DATE"}, {"name": "Assigned", "format": "CONTACT"} ]. Every row
	// in the result will have the task name as the first item, due date as the
	// second item and assigned person as the third item. If a particular task does
	// not have a due date, that row will still have a blank value in the second
	// element and the assigned person will still be in the third element.
	//
	// Headers is a required field
	Headers []*ColumnMetadata `locationName:"headers" type:"list" required:"true"`

	// List of rows returned by the request. Each row has a row Id and a list of
	// data cells in that row. The data cells will be present in the same order
	// as they are defined in the header.
	//
	// Rows is a required field
	Rows []*ResultRow `locationName:"rows" type:"list" required:"true"`
}

// String returns the string representation
func (s ResultSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResultSet) GoString() string {
	return s.String()
}

// SetHeaders sets the Headers field's value.
func (s *ResultSet) SetHeaders(v []*ColumnMetadata) *ResultSet {
	s.Headers = v
	return s
}

// SetRows sets the Rows field's value.
func (s *ResultSet) SetRows(v []*ResultRow) *ResultSet {
	s.Rows = v
	return s
}

// Remote service is unreachable.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Tps(transactions per second) rate reached.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Request is invalid. The message in the response contains details on why the
// request is invalid.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The input variables to the app to be used by the InvokeScreenAutomation action
// request.
type VariableValue struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Raw value of the variable.
	//
	// RawValue is a required field
	RawValue *string `locationName:"rawValue" type:"string" required:"true"`
}

// String returns the string representation
func (s VariableValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VariableValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VariableValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VariableValue"}
	if s.RawValue == nil {
		invalidParams.Add(request.NewErrParamRequired("RawValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRawValue sets the RawValue field's value.
func (s *VariableValue) SetRawValue(v string) *VariableValue {
	s.RawValue = &v
	return s
}

const (
	// FormatAuto is a Format enum value
	FormatAuto = "AUTO"

	// FormatNumber is a Format enum value
	FormatNumber = "NUMBER"

	// FormatCurrency is a Format enum value
	FormatCurrency = "CURRENCY"

	// FormatDate is a Format enum value
	FormatDate = "DATE"

	// FormatTime is a Format enum value
	FormatTime = "TIME"

	// FormatDateTime is a Format enum value
	FormatDateTime = "DATE_TIME"

	// FormatPercentage is a Format enum value
	FormatPercentage = "PERCENTAGE"

	// FormatText is a Format enum value
	FormatText = "TEXT"

	// FormatAccounting is a Format enum value
	FormatAccounting = "ACCOUNTING"

	// FormatContact is a Format enum value
	FormatContact = "CONTACT"

	// FormatRowlink is a Format enum value
	FormatRowlink = "ROWLINK"
)
