/*
 * PGFConsole: A PGF-codec demonstration
 * $Date: 2006-05-09 20:13:33 +0200 (Di, 09 Mai 2006) $
 * $Revision: 187 $

 * This file Copyright (C) 2006 xeraina GmbH, Switzerland
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

// CImage.h : FreeImagePlus wrapper for loading and saving images

#pragma once

// <FreeImagePlus.h> must not be included because of type conflicts
#define __PNMEXSUPPORT__	// modifies FreeImage to support PNM with more than 8 and less than 16 bit per channel

//-------------------------------------------------------------------------------
//	Defines -- Adobe image modes.
//-------------------------------------------------------------------------------
#define ImageModeBitmap				0
#define ImageModeGrayScale			1
#define ImageModeIndexedColor		2
#define ImageModeRGBColor			3
#define ImageModeCMYKColor			4
#define ImageModeHSLColor			5
#define ImageModeHSBColor			6
#define ImageModeMultichannel		7
#define ImageModeDuotone			8
#define ImageModeLabColor			9
#define ImageModeGray16				10
#define ImageModeRGB48				11
#define ImageModeLab48				12
#define ImageModeCMYK64				13
#define ImageModeDeepMultichannel	14
#define ImageModeDuotone16			15
// pgf extension
#define ImageModeRGBA				17
#define ImageModeGray31				18
#define ImageModeRGB12				19
#define ImageModeRGB16				20
#define ImageModeUnknown			255

class fipImage;

class CImage {
	fipImage *m_image;	// must be a pointer because of class prototyping

public:
	CImage();
	virtual ~CImage();

	bool Create(int width, int height, int bpp);
	bool Create(int width, int height, unsigned char type);
	unsigned char* GetBits() const;
	int GetPitch() const;
	unsigned char GetBPP() const;
	unsigned int GetHeight() const;
	unsigned int GetWidth() const;
	bool Save(const char* dest);
	bool Load(const char* source);
	bool IsTransparencySupported();
	bool IsIndexed();
	int GetMaxColorTableEntries();
	void GetColorTable(int firstColor, int numColors, void* prgbColors);
	void SetColorTable(int firstColor, int numColors, const void* prgbColors);
	unsigned char GetColorType() const;
	int GetChannelDepth() const;
	int GetChannels() const;

#ifdef __PNMEXSUPPORT__
	void SetMaxValue(int maxValue);
	int GetMaxValue() const;

	static void RegisterPNM();
#endif

};
