// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package operator_api

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/minio/console/models"
)

// DisableTenantLoggingOKCode is the HTTP code returned for type DisableTenantLoggingOK
const DisableTenantLoggingOKCode int = 200

/*
DisableTenantLoggingOK A successful response.

swagger:response disableTenantLoggingOK
*/
type DisableTenantLoggingOK struct {

	/*
	  In: Body
	*/
	Payload bool `json:"body,omitempty"`
}

// NewDisableTenantLoggingOK creates DisableTenantLoggingOK with default headers values
func NewDisableTenantLoggingOK() *DisableTenantLoggingOK {

	return &DisableTenantLoggingOK{}
}

// WithPayload adds the payload to the disable tenant logging o k response
func (o *DisableTenantLoggingOK) WithPayload(payload bool) *DisableTenantLoggingOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the disable tenant logging o k response
func (o *DisableTenantLoggingOK) SetPayload(payload bool) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DisableTenantLoggingOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
DisableTenantLoggingDefault Generic error response.

swagger:response disableTenantLoggingDefault
*/
type DisableTenantLoggingDefault struct {
	_statusCode int

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDisableTenantLoggingDefault creates DisableTenantLoggingDefault with default headers values
func NewDisableTenantLoggingDefault(code int) *DisableTenantLoggingDefault {
	if code <= 0 {
		code = 500
	}

	return &DisableTenantLoggingDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the disable tenant logging default response
func (o *DisableTenantLoggingDefault) WithStatusCode(code int) *DisableTenantLoggingDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the disable tenant logging default response
func (o *DisableTenantLoggingDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithPayload adds the payload to the disable tenant logging default response
func (o *DisableTenantLoggingDefault) WithPayload(payload *models.Error) *DisableTenantLoggingDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the disable tenant logging default response
func (o *DisableTenantLoggingDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DisableTenantLoggingDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
