// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package operator_api

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/minio/console/models"
)

// OperatorSubnetRegisterAPIKeyOKCode is the HTTP code returned for type OperatorSubnetRegisterAPIKeyOK
const OperatorSubnetRegisterAPIKeyOKCode int = 200

/*
OperatorSubnetRegisterAPIKeyOK A successful response.

swagger:response operatorSubnetRegisterApiKeyOK
*/
type OperatorSubnetRegisterAPIKeyOK struct {

	/*
	  In: Body
	*/
	Payload *models.OperatorSubnetRegisterAPIKeyResponse `json:"body,omitempty"`
}

// NewOperatorSubnetRegisterAPIKeyOK creates OperatorSubnetRegisterAPIKeyOK with default headers values
func NewOperatorSubnetRegisterAPIKeyOK() *OperatorSubnetRegisterAPIKeyOK {

	return &OperatorSubnetRegisterAPIKeyOK{}
}

// WithPayload adds the payload to the operator subnet register Api key o k response
func (o *OperatorSubnetRegisterAPIKeyOK) WithPayload(payload *models.OperatorSubnetRegisterAPIKeyResponse) *OperatorSubnetRegisterAPIKeyOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the operator subnet register Api key o k response
func (o *OperatorSubnetRegisterAPIKeyOK) SetPayload(payload *models.OperatorSubnetRegisterAPIKeyResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *OperatorSubnetRegisterAPIKeyOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
OperatorSubnetRegisterAPIKeyDefault Generic error response.

swagger:response operatorSubnetRegisterApiKeyDefault
*/
type OperatorSubnetRegisterAPIKeyDefault struct {
	_statusCode int

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewOperatorSubnetRegisterAPIKeyDefault creates OperatorSubnetRegisterAPIKeyDefault with default headers values
func NewOperatorSubnetRegisterAPIKeyDefault(code int) *OperatorSubnetRegisterAPIKeyDefault {
	if code <= 0 {
		code = 500
	}

	return &OperatorSubnetRegisterAPIKeyDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the operator subnet register API key default response
func (o *OperatorSubnetRegisterAPIKeyDefault) WithStatusCode(code int) *OperatorSubnetRegisterAPIKeyDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the operator subnet register API key default response
func (o *OperatorSubnetRegisterAPIKeyDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithPayload adds the payload to the operator subnet register API key default response
func (o *OperatorSubnetRegisterAPIKeyDefault) WithPayload(payload *models.Error) *OperatorSubnetRegisterAPIKeyDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the operator subnet register API key default response
func (o *OperatorSubnetRegisterAPIKeyDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *OperatorSubnetRegisterAPIKeyDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
