// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const BucketReplicationIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={"min-icon"}
    viewBox="0 0 256 256"
    {...props}
  >
    <defs>
      <clipPath id="clip-path">
        <rect
          id="Rectángulo_1021"
          data-name="Rectángulo 1021"
          width="256"
          height="191.369"
          fill="#4ccb92"
        />
      </clipPath>
      <clipPath id="clip-Set_Bucket_Replication">
        <rect width="256" height="256" />
      </clipPath>
    </defs>
    <g
      id="Set_Bucket_Replication"
      data-name="Set Bucket Replication"
      clipPath="url(#clip-Set_Bucket_Replication)"
    >
      <rect width="256" height="256" fill="#fff" />
      <g
        id="Set_Bucket_Replication_icon"
        data-name="Set Bucket Replication icon"
      >
        <g id="Grupo_2409" data-name="Grupo 2409" transform="translate(0 32)">
          <g id="Grupo_2408" data-name="Grupo 2408">
            <path
              id="Trazado_7146"
              data-name="Trazado 7146"
              d="M21.3,87.4l-1.578-9.192H46.838c-.123-.722-.249-1.449-.371-2.162-1.931-11.245-3.66-21.315-4.976-28.97l-27.171.006-1.577-9.19H40.71a20.546,20.546,0,0,1,3.951-10.1,17.7,17.7,0,0,1,14.016-7.169h62.949l1.169-6.805a12.394,12.394,0,0,0-2.281-9.6A10.335,10.335,0,0,0,112.289,0H10.7A10.33,10.33,0,0,0,2.474,4.215a12.426,12.426,0,0,0-2.284,9.6C2.7,28.413,7.977,59.178,12.2,83.733l.007.048c2.141,12.491,4,23.369,5.1,29.683.943,5.519,5.354,9.523,10.5,9.523H54.529C52.5,111.17,50.4,98.923,48.415,87.392Z"
              transform="translate(0)"
              fill="#4ccb92"
            />
            <path
              id="Trazado_7147"
              data-name="Trazado 7147"
              d="M264.2,97.863l2.41-14.045.037-.18,6.887-40.172.024-.117,5.074-29.533a12.4,12.4,0,0,0-2.281-9.6A10.336,10.336,0,0,0,268.128,0H166.535a10.331,10.331,0,0,0-8.223,4.215,12.425,12.425,0,0,0-2.283,9.6c.341,1.985.735,4.278,1.169,6.805H220.27A17.746,17.746,0,0,1,234.334,27.8a20.491,20.491,0,0,1,3.944,10.091h27.69l-1.514,9.169-26.959.006-5.351,31.141H259.1l-1.514,9.17-7.244,0A54.53,54.53,0,0,0,228,81.1l6.547-38.106a16.846,16.846,0,0,0-3.1-13.05,14.048,14.048,0,0,0-11.179-5.728H82.193a14.042,14.042,0,0,0-11.176,5.728,16.889,16.889,0,0,0-3.1,13.05C71.324,62.83,78.5,104.644,84.236,138.017l.01.065c2.91,16.977,5.443,31.762,6.932,40.344,1.282,7.5,7.277,12.942,14.267,12.942h91.579a13.777,13.777,0,0,0,9.436-3.82A54.824,54.824,0,0,0,264.2,97.863M87.119,88.2l-2.144-12.49H217.335l-.974,5.9a54.43,54.43,0,0,0-18.853,6.571ZM96.611,143l-2.144-12.492h75.608c-.168,1.748-.261,3.518-.261,5.31a55.27,55.27,0,0,0,.481,7.163Zm128.363,36.14A43.322,43.322,0,1,1,268.3,135.817a43.322,43.322,0,0,1-43.322,43.322"
              transform="translate(-23.479)"
              fill="#4ccb92"
            />
            <path
              id="Trazado_7148"
              data-name="Trazado 7148"
              d="M313.356,176.316c-.055.053-.11.107-.163.162h-.014l-25.036,24.646-8.883-8.767a6.569,6.569,0,1,0-9.224,9.354l18.121,17.855,34.329-33.735a6.594,6.594,0,1,0-9.13-9.516"
              transform="translate(-93.036 -60.553)"
              fill="#4ccb92"
            />
          </g>
        </g>
        <rect
          id="Rectángulo_1022"
          data-name="Rectángulo 1022"
          width="256"
          height="256"
          fill="none"
        />
      </g>
    </g>
  </svg>
);

export default BucketReplicationIcon;
