// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const FileMissingIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={`min-icon`}
    fill={"currentcolor"}
    viewBox="0 0 256 256"
    {...props}
  >
    <defs>
      <clipPath id="prefix__a">
        <path d="M0 0h256v256H0z" />
      </clipPath>
    </defs>
    <g clipPath="url(#prefix__a)">
      <path fill="none" d="M0 0h256v256H0z" />
      <path
        data-name="Trazado 452"
        d="M235.994 77.199c.388-15.754.958-32.243-.5-47.941-1.094-11.756-6.193-21.735-17.831-25.915a42.633 42.633 0 0 0-5.017-1.448c-6.549-1.478-13.432-1.6-20.09-1.8-11.726-.345-23.448.364-35.175.314-23.493-.1-46.985.322-70.479.414q-4.228.015-8.456.017H36.243a17.26 17.26 0 0 0-17.241 17.24v220.679A17.26 17.26 0 0 0 36.243 256h182.541a17.26 17.26 0 0 0 17.241-17.241V128.816c-.006-17.183-.453-34.459-.031-51.617Zm-20.922 145.986a14.888 14.888 0 0 1-14.888 14.888H51.816a14.888 14.888 0 0 1-14.888-14.888V33.662a14.887 14.887 0 0 1 14.888-14.887h99.548v25.463a37.8 37.8 0 0 0 37.758 37.759h25.951Zm0-157.656h-25.951a21.321 21.321 0 0 1-21.3-21.3V18.771h32.359a14.887 14.887 0 0 1 14.888 14.888Z"
      />
      <path
        data-name="Trazado 453"
        d="m84.317 135.27 10.527-10.778 10.528 10.778a2.112 2.112 0 0 0 1.512.637 2.113 2.113 0 0 0 1.512-.637l8.915-9.127a2.114 2.114 0 0 0 0-2.954l-10.6-10.849 10.6-10.851a2.114 2.114 0 0 0 0-2.954l-8.915-9.126a2.175 2.175 0 0 0-3.025 0l-10.528 10.778-10.527-10.778a2.109 2.109 0 0 0-1.511-.637 2.113 2.113 0 0 0-1.512.637l-8.916 9.126a2.116 2.116 0 0 0 0 2.954l10.6 10.851-10.6 10.849a2.116 2.116 0 0 0 0 2.954l8.916 9.127a2.174 2.174 0 0 0 3.024 0Z"
      />
      <path
        data-name="Trazado 454"
        d="m181.539 98.535-8.915-9.126a2.176 2.176 0 0 0-3.024 0l-10.523 10.778-10.528-10.778a2.114 2.114 0 0 0-1.512-.637 2.112 2.112 0 0 0-1.512.637l-8.915 9.126a2.114 2.114 0 0 0 0 2.954l10.6 10.851-10.6 10.849a2.114 2.114 0 0 0 0 2.954l8.915 9.127a2.175 2.175 0 0 0 3.025 0l10.528-10.778 10.523 10.778a2.114 2.114 0 0 0 1.511.637 2.114 2.114 0 0 0 1.511-.637l8.915-9.127a2.114 2.114 0 0 0 0-2.954l-10.594-10.849 10.594-10.851a2.114 2.114 0 0 0 0-2.954Z"
      />
      <path
        data-name="Trazado 455"
        d="M169.529 160.901a66.964 66.964 0 0 0-40.3-13.344 8.524 8.524 0 0 0-1.513.143 8.5 8.5 0 0 0-1.513-.143 66.96 66.96 0 0 0-40.3 13.344 8.455 8.455 0 0 0-1.729 11.83 8.442 8.442 0 0 0 6.786 3.406 8.417 8.417 0 0 0 5.046-1.677 50.177 50.177 0 0 1 30.2-9.993 8.478 8.478 0 0 0 1.513-.143 8.479 8.479 0 0 0 1.513.143 50.182 50.182 0 0 1 30.2 9.993 8.416 8.416 0 0 0 5.044 1.677 8.44 8.44 0 0 0 6.786-3.406 8.454 8.454 0 0 0-1.733-11.83Z"
      />
      <path data-name="Rect\xE1ngulo 905" fill="none" d="M0 0h256v256H0z" />
    </g>
  </svg>
);

export default FileMissingIcon;
