// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const IAMPoliciesIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={`min-icon`}
    fill={"currentcolor"}
    viewBox="0 0 256 256"
    {...props}
  >
    <defs>
      <clipPath id="prefix__a">
        <path d="M0 0h256v256H0z" />
      </clipPath>
    </defs>
    <g data-name="IAM Policies" clipPath="url(#prefix__a)">
      <path fill="none" d="M0 0h256v256H0z" />
      <g data-name="iam-policies-icn">
        <path
          data-name="Trazado 339"
          d="M234.915 46.468v-.073a12.276 12.276 0 0 0-12.458-11.593c-19.233.3-55.932-3-86.768-28.92a12.132 12.132 0 0 0-15.811-.046C88.971 31.804 52.271 35.119 33.152 34.81a12.226 12.226 0 0 0-12.561 11.657c-1.8 46.628-1.509 112.307 21.777 144.214 21.779 29.942 64.527 54.463 77.79 60.687a17.75 17.75 0 0 0 7.584 1.7 17.744 17.744 0 0 0 7.619-1.713c14.233-6.71 55.947-30.7 77.768-60.659 23.292-31.913 23.59-97.599 21.786-144.228Zm-33.666 135.567c-19.9 27.341-59.77 50.186-72.17 56.035a3.18 3.18 0 0 1-2.687 0c-12.364-5.814-52.168-28.577-72.141-56.044-22.29-30.539-20.117-104.8-19.071-132.5h.273c21.464 0 59.431-4.411 92.3-31.128 32.821 26.709 70.8 31.119 92.384 31.119h.18c1.052 27.835 3.211 101.997-19.068 132.518Z"
        />
        <path
          data-name="Trazado 339 - Contorno"
          d="M127.739.004a15.2 15.2 0 0 1 9.855 3.655c29.229 24.565 64.3 28.236 82.6 28.236l2.217-.017h.01a15.346 15.346 0 0 1 15.422 14.381c1.821 47.169 1.485 113.518-22.347 146.172-22.2 30.473-64.469 54.785-78.885 61.582a20.555 20.555 0 0 1-8.869 1.993 20.584 20.584 0 0 1-8.833-1.978c-13.426-6.3-56.751-31.147-78.912-61.614-23.821-32.639-24.156-98.986-22.335-146.052a15.124 15.124 0 0 1 15.023-14.484l2.764.028c18.245 0 53.229-3.677 82.542-28.306a15.029 15.029 0 0 1 9.748-3.596Zm92.455 37.753c-19.1 0-55.72-3.849-86.39-29.625a9.344 9.344 0 0 0-6.065-2.265 9.18 9.18 0 0 0-5.956 2.2c-30.753 25.84-67.289 29.7-86.332 29.7l-2.345-.019h-.019a9.344 9.344 0 0 0-9.568 8.874c-1.785 46.156-1.53 111.17 21.217 142.338 21.44 29.477 63.592 53.625 76.668 59.761a14.916 14.916 0 0 0 12.7-.009c14.043-6.621 55.179-30.255 76.653-59.736 22.757-31.181 23.013-96.2 21.227-142.389a9.343 9.343 0 0 0-9.2-8.852Zm-92.44-23.131 1.849 1.5c32.569 26.5 70.7 30.462 90.534 30.462h2.822l.286 2.82c.957 25.27 3.867 102.168-19.628 134.352-20.261 27.833-60.713 51.027-73.287 56.958a6.169 6.169 0 0 1-5.167.01c-12.568-5.909-52.967-29.043-73.282-56.98C28.394 151.57 31.298 74.683 32.252 49.417l.107-2.821h2.822c20.053 0 58.106-3.959 90.724-30.471Zm89.734 37.8c-21.007-.373-57.672-5.123-89.736-30.274-32.229 25.255-68.984 29.947-89.744 30.287-2.23 64.873 4.028 107.88 18.61 127.858 19.6 26.948 58.824 49.384 71.021 55.119l.1.019a.225.225 0 0 0 .1-.021c12.214-5.762 51.5-28.26 71.043-55.106 14.585-19.984 20.843-63.004 18.606-127.883Z"
        />
        <path
          data-name="Trazado 339 - Contorno"
          d="M127.739 2.837a12.358 12.358 0 0 1 8.015 2.976 120.447 120.447 0 0 0 45.936 23.8 142.22 142.22 0 0 0 21.155 4.1 149.679 149.679 0 0 0 17.35 1.015c.753 0 1.514-.006 2.262-.018h.333a12.159 12.159 0 0 1 8.378 3.393 12.225 12.225 0 0 1 3.846 8.3v.077c1.8 46.64 1.506 112.345-21.805 144.286-21.848 29.994-63.571 53.979-77.8 60.689a17.751 17.751 0 0 1-7.66 1.722 17.771 17.771 0 0 1-7.625-1.708c-13.258-6.222-56.016-30.731-77.828-60.718-23.3-31.93-23.6-97.632-21.8-144.275a12.414 12.414 0 0 1 3.8-8.343 12.055 12.055 0 0 1 8.393-3.417c.156 0 .314 0 .47.009.757.012 1.529.018 2.294.018a148.3 148.3 0 0 0 17.294-1.019 141.918 141.918 0 0 0 21.123-4.113 120.786 120.786 0 0 0 45.948-23.838 12.209 12.209 0 0 1 7.921-2.936Zm92.455 32.086a149.9 149.9 0 0 1-17.373-1.016 142.431 142.431 0 0 1-21.184-4.107 120.644 120.644 0 0 1-46.01-23.838 12.163 12.163 0 0 0-7.888-2.929 12.012 12.012 0 0 0-7.8 2.883 120.985 120.985 0 0 1-46.021 23.877 142.125 142.125 0 0 1-21.153 4.119 148.491 148.491 0 0 1-17.317 1.021c-.766 0-1.54-.006-2.3-.018a12.138 12.138 0 0 0-.465-.009 11.861 11.861 0 0 0-8.258 3.362 12.22 12.22 0 0 0-3.739 8.211c-1.8 46.613-1.509 112.271 21.758 144.151 21.788 29.954 64.506 54.44 77.753 60.656a17.576 17.576 0 0 0 7.542 1.69 17.555 17.555 0 0 0 7.577-1.7c14.221-6.7 55.907-30.666 77.73-60.628 23.276-31.892 23.571-97.552 21.768-144.167v-.076a12.027 12.027 0 0 0-3.785-8.16 11.963 11.963 0 0 0-8.243-3.339h-.329c-.746.006-1.508.012-2.263.012Zm-92.441-16.645.062.05a135.656 135.656 0 0 0 50.371 25.557 157.366 157.366 0 0 0 23.039 4.435 163.564 163.564 0 0 0 18.913 1.106h.273v.094c.294 7.782.6 17.213.6 28.16 0 13.373-.462 25.856-1.382 37.1-2.583 31.568-8.74 54.215-18.3 67.312-19.915 27.358-59.8 50.216-72.208 56.066a3.228 3.228 0 0 1-1.38.307 3.288 3.288 0 0 1-1.389-.307c-12.38-5.821-52.213-28.618-72.179-56.075-9.563-13.1-15.723-35.768-18.3-67.365-.919-11.247-1.384-23.729-1.381-37.1 0-10.914.3-20.327.6-28.1v-.094h.367a162.536 162.536 0 0 0 18.844-1.106 157.194 157.194 0 0 0 23-4.436 135.97 135.97 0 0 0 50.391-25.564Zm92.469 31.343h-.085a163.735 163.735 0 0 1-18.936-1.107 157.57 157.57 0 0 1-23.067-4.44 135.854 135.854 0 0 1-50.381-25.544 136.178 136.178 0 0 1-50.4 25.551 157.4 157.4 0 0 1-23.033 4.441 162.713 162.713 0 0 1-18.866 1.107h-.179c-.292 7.748-.59 17.127-.592 27.994 0 13.364.461 25.84 1.38 37.082 2.579 31.56 8.725 54.192 18.268 67.266 19.942 27.424 59.736 50.2 72.1 56.013a3.094 3.094 0 0 0 1.307.288 3.035 3.035 0 0 0 1.3-.288c12.392-5.845 52.242-28.68 72.132-56 9.541-13.068 15.686-35.681 18.265-67.213.919-11.241 1.384-23.719 1.382-37.086-.002-10.91-.301-20.307-.594-28.069Z"
        />
        <path
          data-name="Trazado 340"
          d="m154.932 82.763-7.4-3.7-5.737-2.866-14.1-7.057v12.363l-15.307 6.115 15.307-6.115v-12.37L100.447 82.76v9.628l-5.029 2.014v18.257l5.029.589v8.032l11.941-1.191v54.127l7.145 2.86v11.538l8.162 4.08v-86.488l-7.206 1.441V90.14l7.206-2.528v.007l7.195 2.521v17.5l-7.195-1.435v86.488l8.159-4.08v-11.538l13.528-5.367-.024-10.18-13.5 4.006v-11.54l13.528-2.689v-9.99l5.55-.5v-9.9h-11.929v-10.822l5.524.552 6.4.639v-9.628l5.036 1.008V94.407l-5.036-2.014Zm3.2 12.886v14.772l-2.83-.567-2.2-.44v9.843l-4.4-.441-5.525-.552-2.019-.206v14.7h11.941v6.387l-3.88.344-1.67.147v10.166l-12.063 2.4-1.473.293v15.51l2.353-.7 11.151-3.315.032 6.476-12.376 4.909-1.16.455v11.657l-4.487 2.242v-81.286l5 1.008 2.2.434v-1.876l6.277 1.265V87.622l-7.149-2.866-4.933-1.971-1.39-.552v-10.12l11.433 5.717 5.749 2.875 6.391 3.19v9.745l1.152.457Z"
        />
        <path
          data-name="Trazado 340 - Contorno"
          d="m126.229 66.764 1.465.734 1.466-.733v1.466l13.293 6.652 5.736 2.866 8.208 4.11V91.4l5.036 2.014v21.037l-5.036-1.008v9.46l-11.93-1.191v7.741h11.93v12.707l-5.55.5v9.853l-13.529 2.689v8.373l13.5-4 .032 13.136-13.531 5.368v11.449l-8.158 4.08v1.465l-1.466-.733-1.465.733v-1.466l-8.163-4.08v-11.452l-7.145-2.86v-53.5l-11.941 1.191v-8.347l-5.028-.589V93.417l5.028-2.014v-9.542l27.249-13.627Zm0 13.743v-9l-24.317 12.161v9.714l-5.029 2.014v15.961l5.029.589v7.717l11.941-1.191v54.754l7.145 2.86v11.624l5.231 2.615v-82.33l-7.206 1.441V89.102l10.137-3.556v1.035l7.195 2.521v17.336l5.181 1.044v-18.87l-6.229-2.5-4.932-1.971-2.311-.917v-.3L112.93 88.97l-1.088-2.722Zm25.408 4.3-5.58-2.786-15.061-7.532v6.754l.464.184 4.937 1.973 8.07 3.235v24.434l-6.276-1.265v1.869l-3.954-.781-3.241-.654v77.122l1.555-.777v-11.751l2.086-.818 11.446-4.54-.018-3.52-13.514 4.017v-18.682l2.653-.528 10.884-2.162v-10.3l5.549-.491v-3.581h-11.941V116.44l3.633.37 8.308.831V107.63l5.029 1.007V96.645l-2.95-1.182-2.079-.823Zm-18.214 6.38-5.739-2.011-5.73 2.01v14.68l4.275-.855v-.585l1.465.292 1.466-.293v.586l4.263.85Z"
        />
        <path
          data-name="Trazado 340 - Contorno"
          d="m127.597 68.978.1.049.1-.049v.1l14.049 7.03 5.737 2.866 7.451 3.731v9.623l5.037 2.014v18.443l-5.037-1.008v9.617l-11.929-1.191v10.621h11.929v10.088l-5.549.5v9.98l-.079.016-13.45 2.674v11.329l13.5-4.006v.131l.025 10.246-.062.025-13.467 5.342v11.532l-.054.027-8.1 4.053v.1l-.1-.049-.1.049v-.1l-8.162-4.08v-11.532l-7.145-2.86v-54.085l-11.941 1.191v-8.058l-5.029-.589V94.337l.062-.025 4.967-1.99v-9.623l.054-.027 27.194-13.6Zm0 12.455V69.294l-27.053 13.529v9.634l-5.028 2.014v18.1l5.028.589v8.011l11.941-1.191v54.168l7.145 2.86v11.544l7.967 3.982v-86.211l-7.206 1.441v-17.7l.065-.023 7.336-2.573v.076l7.194 2.521v17.689l-.117-.023-7.078-1.411v86.217l7.962-3.982v-11.544l.062-.024 13.467-5.342-.024-9.983-13.5 4.006v-11.751l.079-.016 13.45-2.674v-10l5.55-.5v-9.714h-11.93v-11.032l11.93 1.191v-9.64l5.036 1.008V94.468l-5.036-2.014V82.82l-7.343-3.677-5.736-2.866-13.961-6.986v12.271l-.062.025-15.308 6.115-.072-.181Zm7.195 8.779-7.107-2.49-7.1 2.49v17.319l7.011-1.4v-.039l.1.019.1-.019v.039l7 1.4Zm-5.359-18.257.142.071 17.181 8.592 6.445 3.217v9.739l1.091.432 3.938 1.577v14.954l-5.029-1.008v9.831l-4.5-.452-5.525-.552-1.912-.195v14.493h11.941v6.574l-5.55.492v10.156l-13.536 2.689v15.3l13.5-4.014v.13l.032 6.542-.062.025-12.376 4.909-1.1.431v11.651l-.054.027-4.628 2.313v-81.561l5.113 1.031 2.082.411v-1.876l6.276 1.265V87.683l-7.087-2.841-4.933-1.971-1.451-.576Zm23.573 12-6.337-3.163-17.04-8.521v9.9l1.328.527 4.933 1.971 7.21 2.891v21.837l-6.277-1.265v1.876l-2.315-.457-4.879-.984v81.007l4.291-2.145v-11.664l1.222-.479 12.313-4.885-.031-6.279-13.5 4.014v-15.721l1.552-.309 11.984-2.38v-10.179l5.55-.492v-6.2h-11.941v-14.9l2.127.217 9.814.982V109.3l5.028 1.008V95.721l-3.814-1.528-1.214-.481Z"
        />
      </g>
      <path data-name="Rect\xE1ngulo 887" fill="none" d="M0 0h256v256H0z" />
    </g>
  </svg>
);

export default IAMPoliciesIcon;
