// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const OIDCIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    fill={"currentcolor"}
    className={`min-icon`}
    viewBox="0 0 275 275"
    xmlns="http://www.w3.org/2000/svg"
    {...props}
  >
    <defs id="defs3736" />
    <g
      transform="matrix(1.3333333,0,0,-1.3333333,-286.36662,267.54837)"
      id="g3740"
    >
      <path
        d="M 310.77497,185.02828 V 25.08918 5.02828 l 32,15.0609 v 180.5721 z"
        id="path3746"
      />
      <path
        d="m 421.59727,132.22848 4.417,-45.864 -61.883,13.464"
        id="path3748"
      />
      <path
        d="m 246.77497,73.53608 c 0,22.674 24.707,41.769 58.383,47.598 v 20.325 c -51.51,-6.226 -90.383,-34.267 -90.383,-67.923 0,-34.869 41.725,-63.709 96,-68.508 v 20.061 c -36.516,4.578 -64,24.528 -64,48.447 m 101.617,67.915 v -20.317 c 13.399,-2.319 25.385,-6.727 34.9511,-12.64 l 22.6269,13.984 c -15.42,9.531 -35.322,16.283 -57.578,18.973"
        id="path3750"
      />
      <path
        d="m 421.59727,132.22848 4.417,-45.864 -61.883,13.464"
        id="path3766"
      />
      <path
        d="M 310.77497,185.02828 V 25.08918 5.02828 l 32,15.0609 v 180.5721 z"
        id="path3764"
      />
      <path d="m 246.77497,73.53608 c 0,22.674 24.707,41.769 58.383,47.598 v 20.325 c -51.51,-6.226 -90.383,-34.267 -90.383,-67.923 0,-34.869 41.725,-63.709 96,-68.508 v 20.061 c -36.516,4.578 -64,24.528 -64,48.447 m 101.617,67.915 v -20.317 c 13.399,-2.319 25.385,-6.727 34.9511,-12.64 l 22.6269,13.984 c -15.42,9.531 -35.322,16.283 -57.578,18.973" />
    </g>
  </svg>
);

export default OIDCIcon;
