// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package operator_api

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/strfmt"
)

// NewGetDirectPVDriveListParams creates a new GetDirectPVDriveListParams object
//
// There are no default values defined in the spec.
func NewGetDirectPVDriveListParams() GetDirectPVDriveListParams {

	return GetDirectPVDriveListParams{}
}

// GetDirectPVDriveListParams contains all the bound params for the get direct p v drive list operation
// typically these are obtained from a http.Request
//
// swagger:parameters GetDirectPVDriveList
type GetDirectPVDriveListParams struct {

	// HTTP Request Object
	HTTPRequest *http.Request `json:"-"`

	/*
	  In: query
	*/
	Drives *string
	/*
	  In: query
	*/
	Nodes *string
}

// BindRequest both binds and validates a request, it assumes that complex things implement a Validatable(strfmt.Registry) error interface
// for simple values it will use straight method calls.
//
// To ensure default values, the struct must have been initialized with NewGetDirectPVDriveListParams() beforehand.
func (o *GetDirectPVDriveListParams) BindRequest(r *http.Request, route *middleware.MatchedRoute) error {
	var res []error

	o.HTTPRequest = r

	qs := runtime.Values(r.URL.Query())

	qDrives, qhkDrives, _ := qs.GetOK("drives")
	if err := o.bindDrives(qDrives, qhkDrives, route.Formats); err != nil {
		res = append(res, err)
	}

	qNodes, qhkNodes, _ := qs.GetOK("nodes")
	if err := o.bindNodes(qNodes, qhkNodes, route.Formats); err != nil {
		res = append(res, err)
	}
	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindDrives binds and validates parameter Drives from query.
func (o *GetDirectPVDriveListParams) bindDrives(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false

	if raw == "" { // empty values pass all other validations
		return nil
	}
	o.Drives = &raw

	return nil
}

// bindNodes binds and validates parameter Nodes from query.
func (o *GetDirectPVDriveListParams) bindNodes(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false

	if raw == "" { // empty values pass all other validations
		return nil
	}
	o.Nodes = &raw

	return nil
}
