// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const CreateGroupIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={"min-icon"}
    viewBox="0 0 256 256"
    {...props}
  >
    <defs>
      <clipPath id="clip-path">
        <rect
          id="Rectángulo_1039"
          data-name="Rectángulo 1039"
          width="256"
          height="215.188"
          fill="none"
        />
      </clipPath>
      <clipPath id="clip-Create_Group">
        <rect width="256" height="256" />
      </clipPath>
    </defs>
    <g
      id="Create_Group"
      data-name="Create Group"
      clipPath="url(#clip-Create_Group)"
    >
      <rect width="256" height="256" fill="#fff" />
      <g id="Create_Group_Icon" data-name="Create Group Icon">
        <g id="Grupo_2428" data-name="Grupo 2428" transform="translate(0 20)">
          <g id="Grupo_2427" data-name="Grupo 2427">
            <path
              id="Trazado_7184"
              data-name="Trazado 7184"
              d="M498.413,74.672a63.2,63.2,0,0,1-3.786,21.575c.9.049,1.8.078,2.709.078,26.871,0,48.733-21.605,48.733-48.162S524.2,0,497.337,0a48.855,48.855,0,0,0-36.642,16.469,64.109,64.109,0,0,1,37.719,58.2"
              transform="translate(-305.609 0)"
              fill="#4ccb92"
            />
            <path
              id="Trazado_7185"
              data-name="Trazado 7185"
              d="M95.34,96.326c.921,0,1.836-.031,2.744-.081A63.2,63.2,0,0,1,94.3,74.674a64.109,64.109,0,0,1,37.693-58.2A48.867,48.867,0,0,0,95.34,0C68.473,0,46.614,21.605,46.614,48.163S68.473,96.326,95.34,96.326"
              transform="translate(-30.922 0)"
              fill="#4ccb92"
            />
            <path
              id="Trazado_7186"
              data-name="Trazado 7186"
              d="M80.135,346.621a97.66,97.66,0,0,1,21.039-9.138,64.833,64.833,0,0,1-30.526-28.792c-2.2-.2-4.4-.306-6.612-.308-1.071,0-2.152.027-3.221.075-.121,0-.243.005-.365.011a70.315,70.315,0,0,0-7.835.841c-18.427,3-35.857,13.09-46.8,27.434-.419.55-.838,1.119-1.223,1.65l-.005.008a24.616,24.616,0,0,0-1.906,25.48,22.559,22.559,0,0,0,3.644,5.089,22.224,22.224,0,0,0,4.817,3.812,23.01,23.01,0,0,0,5.736,2.385,24.94,24.94,0,0,0,6.409.823H49.714a37.659,37.659,0,0,1,2.685-4.371l.027-.038.046-.063c.569-.785,1.067-1.457,1.525-2.058a90.337,90.337,0,0,1,26.138-22.841"
              transform="translate(0 -204.572)"
              fill="#4ccb92"
            />
            <path
              id="Trazado_7187"
              data-name="Trazado 7187"
              d="M215.477,113.623c0,30.276,24.92,54.907,55.549,54.907s55.557-24.63,55.557-54.907-24.929-54.907-55.557-54.907-55.549,24.63-55.549,54.907"
              transform="translate(-142.94 -38.95)"
              fill="#4ccb92"
            />
            <path
              id="Trazado_7188"
              data-name="Trazado 7188"
              d="M358.424,337.287l0,0a73.77,73.77,0,0,0-27.955-21.978A77.668,77.668,0,0,0,315,310.141a74.21,74.21,0,0,0-15.959-1.757c-1.071,0-2.152.028-3.22.075-.122.005-.244.006-.365.011-.73.036-1.46.088-2.189.147a64.831,64.831,0,0,1-14.437,18.4,47.462,47.462,0,0,0-24.218,17.921c-.357-.083-.713-.172-1.071-.252a84.586,84.586,0,0,0-18.192-2c-1.221,0-2.454.031-3.671.085-.138.005-.277.006-.416.012a80.086,80.086,0,0,0-8.933.959c-21.008,3.419-40.879,14.924-53.349,31.275-.478.628-.955,1.276-1.394,1.882l-.006.008a28.062,28.062,0,0,0-2.177,29.05,25.77,25.77,0,0,0,4.155,5.8,25.368,25.368,0,0,0,5.491,4.346,26.29,26.29,0,0,0,6.541,2.718,28.435,28.435,0,0,0,7.306.938h93.79a28.421,28.421,0,0,0,5.814-.589,47.926,47.926,0,0,0,4.917.253A47.353,47.353,0,0,0,340.6,375.992a24.947,24.947,0,0,0,6.424-.835,22.741,22.741,0,0,0,5.751-2.418,21.778,21.778,0,0,0,4.793-3.867,22.122,22.122,0,0,0,3.581-5.16,25.152,25.152,0,0,0-2.726-26.426m-64.729,72.2a37.411,37.411,0,1,1,37.411-37.411A37.411,37.411,0,0,1,293.7,409.484"
              transform="translate(-107.694 -204.572)"
              fill="#4ccb92"
            />
            <path
              id="Trazado_7189"
              data-name="Trazado 7189"
              d="M523.713,445.287H511.978v11.735H500.243v11.735h11.735v11.735h11.735V468.757h11.735V457.022H523.713Z"
              transform="translate(-331.844 -295.388)"
              fill="#4ccb92"
            />
          </g>
        </g>
        <rect
          id="Rectángulo_1040"
          data-name="Rectángulo 1040"
          width="256"
          height="256"
          fill="none"
        />
      </g>
    </g>
  </svg>
);

export default CreateGroupIcon;
