// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const FileZipIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={`min-icon`}
    fill={"currentcolor"}
    viewBox="0 0 256 256"
    {...props}
  >
    <defs>
      <clipPath id="prefix__a">
        <path d="M0 0h256v256H0z" />
      </clipPath>
    </defs>
    <g clipPath="url(#prefix__a)">
      <path fill="none" d="M0 0h256v256H0z" />
      <g transform="translate(3486.336 -3812.001)">
        <path
          data-name="Trazado 436"
          d="M-3395.774 3897.42a17.685 17.685 0 0 0-5.245-10.691c-2.691-2.615-7.129-5.479-11.512-5.676-10-.465-18.68 6.74-19.754 16.366l-2.853 25.542a21.788 21.788 0 0 0-.126 2.327 21.263 21.263 0 0 0 21.193 21.28h.043a20.635 20.635 0 0 0 18.294-11.19 27.971 27.971 0 0 0 2.932-12.257c.2-5.784-.8-11.752-1.756-17.522-.475-2.872-.926-5.585-1.216-8.179Zm-18.24-3.68a4.229 4.229 0 0 1 4.224 4.224 4.23 4.23 0 0 1-4.224 4.225 4.231 4.231 0 0 1-4.225-4.225 4.23 4.23 0 0 1 4.226-4.224Zm0 40.129a10.573 10.573 0 0 1-10.561-10.561 10.572 10.572 0 0 1 10.561-10.56 10.573 10.573 0 0 1 10.561 10.56 10.574 10.574 0 0 1-10.56 10.561Z"
        />
        <circle
          data-name="Elipse 63"
          cx={2.111}
          cy={2.111}
          r={2.111}
          transform="translate(-3416.125 3921.197)"
        />
        <path
          data-name="Trazado 437"
          d="M-3250.337 3889.2c.387-15.754.958-32.242-.5-47.942-1.093-11.755-6.192-21.735-17.832-25.915a42.461 42.461 0 0 0-5.016-1.447c-6.549-1.479-13.432-1.6-20.09-1.8-11.727-.344-23.449.364-35.176.314-23.494-.1-46.986.322-70.479.414q-4.228.016-8.456.017h-42.206a17.26 17.26 0 0 0-17.241 17.24v220.68a17.26 17.26 0 0 0 17.241 17.24h182.54a17.26 17.26 0 0 0 17.241-17.24v-109.942c-.001-17.184-.448-34.459-.026-51.619Zm-20.922 145.987a14.888 14.888 0 0 1-14.886 14.887h-118.622v-21.342c.206.015.412.032.621.032h16.262a8.456 8.456 0 0 0 8.455-8.454 8.455 8.455 0 0 0-8.456-8.456h-16.261c-.209 0-.415.016-.621.031v-23.6c.206.015.412.032.621.032h16.262a8.455 8.455 0 0 0 8.455-8.455 8.455 8.455 0 0 0-8.455-8.455h-16.262c-.209 0-.415.017-.621.031v-20.75a20.4 20.4 0 0 1-9.259 2.222h-.043a21.069 21.069 0 0 1-7.607-1.45l-.567-.029h-16.257a8.454 8.454 0 0 0-8.455 8.456 8.454 8.454 0 0 0 8.455 8.454h16.261c.192 0 .379-.016.567-.028v23.187a8.726 8.726 0 0 0-.8-.04h-16.261a8.455 8.455 0 0 0-8.455 8.455 8.455 8.455 0 0 0 8.455 8.455h16.261c.269 0 .535-.016.8-.041v41.751h-12.839a14.89 14.89 0 0 1-14.889-14.886v-189.529a14.889 14.889 0 0 1 14.888-14.888h99.549v25.458a37.8 37.8 0 0 0 37.757 37.76h25.952Zm0-157.657h-25.952a21.319 21.319 0 0 1-21.3-21.3v-25.458h32.359a14.888 14.888 0 0 1 14.888 14.888Z"
        />
      </g>
      <path data-name="Rect\xE1ngulo 912" fill="none" d="M0 0h256v256H0z" />
    </g>
  </svg>
);

export default FileZipIcon;
