// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const LifecycleConfigIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={"min-icon"}
    viewBox="0 0 256 256"
    fill={"currentcolor"}
    {...props}
  >
    <g transform="translate(23.344 0.006)">
      <g>
        <g>
          <g>
            <path
              d="M76.7,73.6c4.6,4.6,11.9,4.6,16.5,0l0,0l25-25c4.6-4.6,4.6-11.9,0-16.5l0,0l-25-25
								c-4.6-4.6-11.9-4.6-16.5,0s-4.6,11.9,0,16.5l7.2,7.2c-47,9.9-80.8,51.3-80.8,99.4c0,6.4,5.2,11.7,11.7,11.7
								s11.7-5.2,11.7-11.7c0-32.4,20-61.4,50.2-73C72.2,61.8,72.2,69.1,76.7,73.6"
            />
            <path
              d="M208.8,126.8c0-6.4-5.2-11.7-11.7-11.7c-6.4,0-11.7,5.2-11.7,11.7c0,32.4-20,61.4-50.2,73
								c4.5-4.6,4.4-12-0.2-16.5c-4.6-4.5-11.9-4.4-16.4,0.1l-25,25c-1.4,1.4-2.4,3.1-2.9,4.9c-0.5,1.8-0.6,3.7-0.3,5.5
								c0.4,2.3,1.6,4.4,3.2,6l0,0l25,25c4.6,4.6,11.9,4.6,16.5,0s4.6-11.9,0-16.5l-7.2-7.2C175,216.3,208.7,174.9,208.8,126.8"
            />
            <path
              d="M92.8,157.8l6-4.5c0.9,0.4,1.8,0.8,2.8,1.2l1.1,7.5c0.2,1.4,1.4,2.4,2.8,2.4h10.6
								c1.4,0,2.6-1,2.8-2.4l1.1-7.5c0.9-0.3,1.9-0.7,2.8-1.2l6,4.5c1.1,0.8,2.6,0.7,3.6-0.2l7.5-7.5c1-1,1.1-2.5,0.2-3.6l-4.5-6
								c0.4-0.9,0.8-1.8,1.2-2.8l7.5-1.1c1.4-0.2,2.4-1.4,2.4-2.8v-10.7c0-1.4-1-2.5-2.3-2.7l-7.5-1.1c-0.3-0.9-0.7-1.9-1.2-2.8
								l4.5-6c0.8-1.1,0.7-2.6-0.3-3.6l-7.5-7.6c-1-1-2.5-1.1-3.6-0.2l-6,4.5c-0.9-0.4-1.8-0.8-2.8-1.2l-1.1-7.5
								c-0.2-1.4-1.4-2.4-2.8-2.4h-10.7c-1.4,0-2.6,1-2.7,2.4l-1.1,7.5c-0.9,0.3-1.9,0.7-2.8,1.2l-6-4.5c-1.1-0.8-2.6-0.7-3.6,0.2
								l-7.5,7.5c-1,1-1.1,2.5-0.3,3.6l4.5,6c-0.4,0.9-0.8,1.8-1.2,2.8l-7.5,1.1c-1.4,0.2-2.4,1.4-2.4,2.8v10.6c0,1.4,1,2.6,2.4,2.8
								l7.5,1.1c0.3,0.9,0.7,1.9,1.2,2.8l-4.5,6.1c-0.8,1.1-0.7,2.6,0.3,3.6l7.5,7.5C90.2,158.6,91.7,158.7,92.8,157.8 M102.5,128.5
								c-0.1-4.6,3.6-8.3,8.2-8.3c4.6-0.1,8.3,3.6,8.3,8.2c0,0.1,0,0.1,0,0.2l0,0c0,4.6-3.7,8.3-8.2,8.3l0,0
								C106.2,136.8,102.5,133.1,102.5,128.5L102.5,128.5L102.5,128.5z"
            />
          </g>
        </g>
      </g>
    </g>
  </svg>
);

export default LifecycleConfigIcon;
