/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.LinkedList;
import org.traccar.BaseMqttProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class IotmProtocolDecoder
extends BaseMqttProtocolDecoder {
    public IotmProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private Object readValue(ByteBuf buf, int sensorType) {
        return switch (sensorType) {
            case 0 -> false;
            case 1 -> true;
            case 3 -> 0;
            case 4 -> buf.readUnsignedByte();
            case 5 -> buf.readUnsignedShortLE();
            case 6 -> buf.readUnsignedIntLE();
            case 7, 11 -> buf.readLongLE();
            case 8 -> buf.readByte();
            case 9 -> buf.readShortLE();
            case 10 -> buf.readIntLE();
            case 12 -> Float.valueOf(buf.readFloatLE());
            case 13 -> buf.readDoubleLE();
            case 32 -> buf.readCharSequence((int)buf.readUnsignedByte(), StandardCharsets.US_ASCII).toString();
            case 33 -> ByteBufUtil.hexDump((ByteBuf)buf.readSlice((int)buf.readUnsignedByte()));
            case 64 -> buf.readCharSequence(buf.readUnsignedShortLE(), StandardCharsets.US_ASCII).toString();
            case 65 -> ByteBufUtil.hexDump((ByteBuf)buf.readSlice(buf.readUnsignedShortLE()));
            default -> null;
        };
    }

    private void decodeSensor(Position position, ByteBuf record, int sensorType, int sensorId) {
        switch (sensorId) {
            case 2: {
                position.set("motion", sensorType > 0);
                break;
            }
            case 8: 
            case 155: {
                if (sensorType <= 0) break;
                position.addAlarm("jamming");
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                String key = "in" + (sensorId - 16 + 2);
                position.set(key, sensorType > 0);
                break;
            }
            case 98: {
                position.set("doorFL", sensorType > 0);
                break;
            }
            case 99: {
                position.set("doorFR", sensorType > 0);
                break;
            }
            case 100: {
                position.set("doorRL", sensorType > 0);
                break;
            }
            case 101: {
                position.set("doorRR", sensorType > 0);
                break;
            }
            case 30: {
                position.set("buttonPresent", sensorType > 0);
                break;
            }
            case 109: {
                position.set("ignition", sensorType > 0);
                break;
            }
            case 139: {
                position.set("handBrake", sensorType > 0);
                break;
            }
            case 140: {
                position.set("footBrake", sensorType > 0);
                break;
            }
            case 148: 
            case 149: 
            case 150: {
                String key = "out" + (sensorId - 148 + 1);
                position.set(key, sensorType > 0);
                break;
            }
            case 154: {
                position.set("out4", sensorType > 0);
                break;
            }
            case 8192: {
                position.set("obdSpeed", record.readUnsignedByte());
                break;
            }
            case 8193: {
                position.set("sat", record.readUnsignedByte());
                break;
            }
            case 8198: {
                position.set("throttle", record.readUnsignedByte());
                break;
            }
            case 8199: {
                position.set("fuel", record.readUnsignedByte());
                break;
            }
            case 8200: {
                position.set("coolantTemp", record.readUnsignedByte());
                break;
            }
            case 8201: {
                position.set("fuel2", record.readUnsignedByte());
                break;
            }
            case 8202: {
                position.set("engineLoad", record.readUnsignedByte());
                break;
            }
            case 8257: {
                position.set("batteryLevel", record.readUnsignedByte());
                break;
            }
            case 12288: {
                position.set("power", (double)record.readUnsignedShortLE() * 0.001);
                break;
            }
            case 12289: 
            case 12290: 
            case 12291: {
                String key = "adc" + (12291 - sensorId + 3);
                position.set(key, (double)record.readUnsignedShortLE() * 0.001);
                break;
            }
            case 12292: {
                position.set("battery", (double)record.readUnsignedShortLE() * 0.001);
                break;
            }
            case 12300: {
                position.set("rpm", record.readUnsignedShortLE());
                break;
            }
            case 12321: {
                position.set("fuelConsumption", (double)record.readUnsignedShortLE() * 0.05);
                break;
            }
            case 12343: {
                position.set("cargoWeight", record.readUnsignedShortLE() * 2);
                break;
            }
            case 16385: {
                position.set("fuelUsed", record.readUnsignedIntLE());
                break;
            }
            case 16386: {
                position.set("hours", record.readUnsignedIntLE());
                break;
            }
            case 16387: {
                position.set("odometer", record.readUnsignedIntLE() * 5L);
                break;
            }
            case 16483: {
                position.set("axleWeight", record.readUnsignedIntLE());
                break;
            }
            case 20480: {
                position.set("driverUniqueId", String.valueOf(record.readLongLE()));
                break;
            }
            case 20484: 
            case 20485: 
            case 20486: 
            case 20487: {
                String key = "temp" + (sensorId - 20484 + 1);
                position.set(key, record.readLongLE());
                break;
            }
            case 20493: {
                position.set("trailerId", String.valueOf(record.readLongLE()));
                break;
            }
            case 40960: {
                position.set("deviceTemp", Float.valueOf(record.readFloatLE()));
                break;
            }
            case 40961: {
                position.set("acceleration", Float.valueOf(record.readFloatLE()));
                break;
            }
            case 40962: {
                position.set("cornering", Float.valueOf(record.readFloatLE()));
                break;
            }
            case 40983: 
            case 40984: 
            case 40985: 
            case 40986: {
                String key = "temp" + (sensorId - 40983 + 1);
                position.set(key, Float.valueOf(record.readFloatLE()));
                break;
            }
            case 45058: {
                position.set("obdOdometer", record.readDoubleLE());
                break;
            }
            default: {
                String key = "io" + sensorId;
                position.getAttributes().put(key, this.readValue(record, sensorType));
            }
        }
    }

    @Override
    protected Object decode(DeviceSession deviceSession, MqttPublishMessage message) throws Exception {
        LinkedList<Position> positions = new LinkedList<Position>();
        ByteBuf buf = message.payload();
        buf.readUnsignedByte();
        while (buf.readableBytes() > 1) {
            Position position;
            short type = buf.readUnsignedByte();
            int length = buf.readUnsignedShortLE();
            ByteBuf record = buf.readSlice(length);
            if (type == 1) {
                position = new Position(this.getProtocolName());
                position.setDeviceId(deviceSession.getDeviceId());
                position.setTime(new Date(record.readUnsignedIntLE() * 1000L));
                while (record.readableBytes() > 0) {
                    short sensorType = record.readUnsignedByte();
                    int sensorId = record.readUnsignedShortLE();
                    if (sensorType == 14) {
                        position.setValid(true);
                        position.setLatitude(record.readFloatLE());
                        position.setLongitude(record.readFloatLE());
                        position.setSpeed(UnitsConverter.knotsFromKph(record.readUnsignedShortLE()));
                        position.set("hdop", record.readUnsignedByte());
                        position.set("sat", record.readUnsignedByte());
                        position.setCourse(record.readUnsignedShortLE());
                        position.setAltitude(record.readShortLE());
                        continue;
                    }
                    if (sensorType == 3) continue;
                    this.decodeSensor(position, record, sensorType, sensorId);
                }
                positions.add(position);
                continue;
            }
            if (type != 3) continue;
            position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            this.getLastLocation(position, new Date(record.readUnsignedIntLE() * 1000L));
            record.readUnsignedByte();
            position.set("event", record.readUnsignedByte());
            positions.add(position);
        }
        buf.readUnsignedByte();
        return positions.isEmpty() ? null : positions;
    }
}

