/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.TxnOffsetCommitResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class TxnOffsetCommitResponse
extends AbstractResponse {
    private final TxnOffsetCommitResponseData data;

    public TxnOffsetCommitResponse(TxnOffsetCommitResponseData data) {
        super(ApiKeys.TXN_OFFSET_COMMIT);
        this.data = data;
    }

    public TxnOffsetCommitResponse(int requestThrottleMs, Map<TopicPartition, Errors> responseData) {
        super(ApiKeys.TXN_OFFSET_COMMIT);
        HashMap<String, TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic> responseTopicDataMap = new HashMap<String, TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic>();
        for (Map.Entry<TopicPartition, Errors> entry : responseData.entrySet()) {
            TopicPartition topicPartition = entry.getKey();
            String topicName = topicPartition.topic();
            TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic topic = responseTopicDataMap.getOrDefault(topicName, new TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic().setName(topicName));
            topic.partitions().add(new TxnOffsetCommitResponseData.TxnOffsetCommitResponsePartition().setErrorCode(entry.getValue().code()).setPartitionIndex(topicPartition.partition()));
            responseTopicDataMap.put(topicName, topic);
        }
        this.data = new TxnOffsetCommitResponseData().setTopics(new ArrayList<TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic>(responseTopicDataMap.values())).setThrottleTimeMs(requestThrottleMs);
    }

    @Override
    public TxnOffsetCommitResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return TxnOffsetCommitResponse.errorCounts(this.data.topics().stream().flatMap(topic -> topic.partitions().stream().map(partition -> Errors.forCode(partition.errorCode()))));
    }

    public Map<TopicPartition, Errors> errors() {
        HashMap<TopicPartition, Errors> errorMap = new HashMap<TopicPartition, Errors>();
        for (TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic topic : this.data.topics()) {
            for (TxnOffsetCommitResponseData.TxnOffsetCommitResponsePartition partition : topic.partitions()) {
                errorMap.put(new TopicPartition(topic.name(), partition.partitionIndex()), Errors.forCode(partition.errorCode()));
            }
        }
        return errorMap;
    }

    public static TxnOffsetCommitResponse parse(Readable readable, short version) {
        return new TxnOffsetCommitResponse(new TxnOffsetCommitResponseData(readable, version));
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 1;
    }

    public static class Builder {
        TxnOffsetCommitResponseData data = new TxnOffsetCommitResponseData();
        HashMap<String, TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic> byTopicName = new HashMap();

        private TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic getOrCreateTopic(String topicName) {
            TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic topic = this.byTopicName.get(topicName);
            if (topic == null) {
                topic = new TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic().setName(topicName);
                this.data.topics().add(topic);
                this.byTopicName.put(topicName, topic);
            }
            return topic;
        }

        public Builder addPartition(String topicName, int partitionIndex, Errors error) {
            TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic topicResponse = this.getOrCreateTopic(topicName);
            topicResponse.partitions().add(new TxnOffsetCommitResponseData.TxnOffsetCommitResponsePartition().setPartitionIndex(partitionIndex).setErrorCode(error.code()));
            return this;
        }

        public <P> Builder addPartitions(String topicName, List<P> partitions, Function<P, Integer> partitionIndex, Errors error) {
            TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic topicResponse = this.getOrCreateTopic(topicName);
            partitions.forEach(partition -> topicResponse.partitions().add(new TxnOffsetCommitResponseData.TxnOffsetCommitResponsePartition().setPartitionIndex((Integer)partitionIndex.apply(partition)).setErrorCode(error.code())));
            return this;
        }

        public Builder merge(TxnOffsetCommitResponseData newData) {
            if (this.data.topics().isEmpty()) {
                this.data = newData;
            } else {
                newData.topics().forEach(newTopic -> {
                    TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic existingTopic = this.byTopicName.get(newTopic.name());
                    if (existingTopic == null) {
                        this.data.topics().add((TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic)newTopic);
                        this.byTopicName.put(newTopic.name(), (TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic)newTopic);
                    } else {
                        existingTopic.partitions().addAll(newTopic.partitions());
                    }
                });
            }
            return this;
        }

        public TxnOffsetCommitResponse build() {
            return new TxnOffsetCommitResponse(this.data);
        }
    }
}

