// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpprofiles "go.opentelemetry.io/proto/slim/otlp/profiles/v1development"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigSample(t *testing.T) {
	for name, src := range genTestEncodingValuesSample() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewOrigSample()
				CopyOrigSample(dest, src)
				assert.Equal(t, src, dest)
				CopyOrigSample(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestMarshalAndUnmarshalJSONOrigSampleUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewOrigSample()
	UnmarshalJSONOrigSample(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewOrigSample(), dest)
}

func TestMarshalAndUnmarshalJSONOrigSample(t *testing.T) {
	for name, src := range genTestEncodingValuesSample() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				MarshalJSONOrigSample(src, stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewOrigSample()
				UnmarshalJSONOrigSample(dest, iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteOrigSample(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoOrigSampleFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesSample() {
		t.Run(name, func(t *testing.T) {
			dest := NewOrigSample()
			require.Error(t, UnmarshalProtoOrigSample(dest, buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigSampleUnknown(t *testing.T) {
	dest := NewOrigSample()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, UnmarshalProtoOrigSample(dest, []byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewOrigSample(), dest)
}

func TestMarshalAndUnmarshalProtoOrigSample(t *testing.T) {
	for name, src := range genTestEncodingValuesSample() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, SizeProtoOrigSample(src))
				gotSize := MarshalProtoOrigSample(src, buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewOrigSample()
				require.NoError(t, UnmarshalProtoOrigSample(dest, buf))

				assert.Equal(t, src, dest)
				DeleteOrigSample(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufSample(t *testing.T) {
	for name, src := range genTestEncodingValuesSample() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigSample(src))
			gotSize := MarshalProtoOrigSample(src, buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpprofiles.Sample{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewOrigSample()
			require.NoError(t, UnmarshalProtoOrigSample(dest, goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesSample() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                       {0x02},
		"LocationsStartIndex/wrong_wire_type": {0xc},
		"LocationsStartIndex/missing_value":   {0x8},
		"LocationsLength/wrong_wire_type":     {0x14},
		"LocationsLength/missing_value":       {0x10},
		"Value/wrong_wire_type":               {0x1c},
		"Value/missing_value":                 {0x1a},
		"AttributeIndices/wrong_wire_type":    {0x24},
		"AttributeIndices/missing_value":      {0x22},
		"LinkIndex/wrong_wire_type":           {0x2c},
		"LinkIndex/missing_value":             {0x28},
		"TimestampsUnixNano/wrong_wire_type":  {0x34},
		"TimestampsUnixNano/missing_value":    {0x32},
	}
}

func genTestEncodingValuesSample() map[string]*otlpprofiles.Sample {
	return map[string]*otlpprofiles.Sample{
		"empty":                             NewOrigSample(),
		"LocationsStartIndex/test":          {LocationsStartIndex: int32(13)},
		"LocationsLength/test":              {LocationsLength: int32(13)},
		"Value/default_and_test":            {Value: []int64{int64(0), int64(13)}},
		"AttributeIndices/default_and_test": {AttributeIndices: []int32{int32(0), int32(13)}}, "LinkIndex/default": {LinkIndex_: &otlpprofiles.Sample_LinkIndex{LinkIndex: int32(0)}},
		"LinkIndex/test":                      {LinkIndex_: &otlpprofiles.Sample_LinkIndex{LinkIndex: int32(13)}},
		"TimestampsUnixNano/default_and_test": {TimestampsUnixNano: []uint64{uint64(0), uint64(13)}},
	}
}
