// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"

	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
)

func TestCopyOrigScopeProfilesSlice(t *testing.T) {
	src := []*otlpprofiles.ScopeProfiles{}
	dest := []*otlpprofiles.ScopeProfiles{}
	// Test CopyTo empty
	dest = CopyOrigScopeProfilesSlice(dest, src)
	assert.Equal(t, []*otlpprofiles.ScopeProfiles{}, dest)

	// Test CopyTo larger slice
	src = GenerateOrigTestScopeProfilesSlice()
	dest = CopyOrigScopeProfilesSlice(dest, src)
	assert.Equal(t, GenerateOrigTestScopeProfilesSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyOrigScopeProfilesSlice(dest, src)
	assert.Equal(t, GenerateOrigTestScopeProfilesSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyOrigScopeProfilesSlice(dest, []*otlpprofiles.ScopeProfiles{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyOrigScopeProfilesSlice(dest, src)
	assert.Equal(t, GenerateOrigTestScopeProfilesSlice(), dest)
}
