// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pmetric

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/pcommon"
)

func TestNumberDataPoint_MoveTo(t *testing.T) {
	ms := generateTestNumberDataPoint()
	dest := NewNumberDataPoint()
	ms.MoveTo(dest)
	assert.Equal(t, NewNumberDataPoint(), ms)
	assert.Equal(t, generateTestNumberDataPoint(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestNumberDataPoint(), dest)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.MoveTo(newNumberDataPoint(internal.NewOrigNumberDataPoint(), sharedState)) })
	assert.Panics(t, func() { newNumberDataPoint(internal.NewOrigNumberDataPoint(), sharedState).MoveTo(dest) })
}

func TestNumberDataPoint_CopyTo(t *testing.T) {
	ms := NewNumberDataPoint()
	orig := NewNumberDataPoint()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestNumberDataPoint()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.CopyTo(newNumberDataPoint(internal.NewOrigNumberDataPoint(), sharedState)) })
}

func TestNumberDataPoint_Attributes(t *testing.T) {
	ms := NewNumberDataPoint()
	assert.Equal(t, pcommon.NewMap(), ms.Attributes())
	ms.orig.Attributes = internal.GenerateOrigTestKeyValueSlice()
	assert.Equal(t, pcommon.Map(internal.GenerateTestMap()), ms.Attributes())
}

func TestNumberDataPoint_StartTimestamp(t *testing.T) {
	ms := NewNumberDataPoint()
	assert.Equal(t, pcommon.Timestamp(0), ms.StartTimestamp())
	testValStartTimestamp := pcommon.Timestamp(1234567890)
	ms.SetStartTimestamp(testValStartTimestamp)
	assert.Equal(t, testValStartTimestamp, ms.StartTimestamp())
}

func TestNumberDataPoint_Timestamp(t *testing.T) {
	ms := NewNumberDataPoint()
	assert.Equal(t, pcommon.Timestamp(0), ms.Timestamp())
	testValTimestamp := pcommon.Timestamp(1234567890)
	ms.SetTimestamp(testValTimestamp)
	assert.Equal(t, testValTimestamp, ms.Timestamp())
}

func TestNumberDataPoint_ValueType(t *testing.T) {
	tv := NewNumberDataPoint()
	assert.Equal(t, NumberDataPointValueTypeEmpty, tv.ValueType())
}

func TestNumberDataPoint_DoubleValue(t *testing.T) {
	ms := NewNumberDataPoint()
	assert.InDelta(t, float64(0), ms.DoubleValue(), 0.01)
	ms.SetDoubleValue(float64(3.1415926))
	assert.InDelta(t, float64(3.1415926), ms.DoubleValue(), 0.01)
	assert.Equal(t, NumberDataPointValueTypeDouble, ms.ValueType())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() {
		newNumberDataPoint(&otlpmetrics.NumberDataPoint{}, sharedState).SetDoubleValue(float64(3.1415926))
	})
}

func TestNumberDataPoint_IntValue(t *testing.T) {
	ms := NewNumberDataPoint()
	assert.Equal(t, int64(0), ms.IntValue())
	ms.SetIntValue(int64(13))
	assert.Equal(t, int64(13), ms.IntValue())
	assert.Equal(t, NumberDataPointValueTypeInt, ms.ValueType())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newNumberDataPoint(&otlpmetrics.NumberDataPoint{}, sharedState).SetIntValue(int64(13)) })
}

func TestNumberDataPoint_Exemplars(t *testing.T) {
	ms := NewNumberDataPoint()
	assert.Equal(t, NewExemplarSlice(), ms.Exemplars())
	ms.orig.Exemplars = internal.GenerateOrigTestExemplarSlice()
	assert.Equal(t, generateTestExemplarSlice(), ms.Exemplars())
}

func TestNumberDataPoint_Flags(t *testing.T) {
	ms := NewNumberDataPoint()
	assert.Equal(t, DataPointFlags(0), ms.Flags())
	testValFlags := DataPointFlags(1)
	ms.SetFlags(testValFlags)
	assert.Equal(t, testValFlags, ms.Flags())
}

func generateTestNumberDataPoint() NumberDataPoint {
	ms := newNumberDataPoint(internal.GenTestOrigNumberDataPoint(), internal.NewState())
	return ms
}
