// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpmetrics "go.opentelemetry.io/proto/slim/otlp/metrics/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigScopeMetrics(t *testing.T) {
	for name, src := range genTestEncodingValuesScopeMetrics() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewOrigScopeMetrics()
				CopyOrigScopeMetrics(dest, src)
				assert.Equal(t, src, dest)
				CopyOrigScopeMetrics(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestMarshalAndUnmarshalJSONOrigScopeMetricsUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewOrigScopeMetrics()
	UnmarshalJSONOrigScopeMetrics(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewOrigScopeMetrics(), dest)
}

func TestMarshalAndUnmarshalJSONOrigScopeMetrics(t *testing.T) {
	for name, src := range genTestEncodingValuesScopeMetrics() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				MarshalJSONOrigScopeMetrics(src, stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewOrigScopeMetrics()
				UnmarshalJSONOrigScopeMetrics(dest, iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteOrigScopeMetrics(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoOrigScopeMetricsFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesScopeMetrics() {
		t.Run(name, func(t *testing.T) {
			dest := NewOrigScopeMetrics()
			require.Error(t, UnmarshalProtoOrigScopeMetrics(dest, buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigScopeMetricsUnknown(t *testing.T) {
	dest := NewOrigScopeMetrics()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, UnmarshalProtoOrigScopeMetrics(dest, []byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewOrigScopeMetrics(), dest)
}

func TestMarshalAndUnmarshalProtoOrigScopeMetrics(t *testing.T) {
	for name, src := range genTestEncodingValuesScopeMetrics() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, SizeProtoOrigScopeMetrics(src))
				gotSize := MarshalProtoOrigScopeMetrics(src, buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewOrigScopeMetrics()
				require.NoError(t, UnmarshalProtoOrigScopeMetrics(dest, buf))

				assert.Equal(t, src, dest)
				DeleteOrigScopeMetrics(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufScopeMetrics(t *testing.T) {
	for name, src := range genTestEncodingValuesScopeMetrics() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigScopeMetrics(src))
			gotSize := MarshalProtoOrigScopeMetrics(src, buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpmetrics.ScopeMetrics{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewOrigScopeMetrics()
			require.NoError(t, UnmarshalProtoOrigScopeMetrics(dest, goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesScopeMetrics() map[string][]byte {
	return map[string][]byte{
		"invalid_field":             {0x02},
		"Scope/wrong_wire_type":     {0xc},
		"Scope/missing_value":       {0xa},
		"Metrics/wrong_wire_type":   {0x14},
		"Metrics/missing_value":     {0x12},
		"SchemaUrl/wrong_wire_type": {0x1c},
		"SchemaUrl/missing_value":   {0x1a},
	}
}

func genTestEncodingValuesScopeMetrics() map[string]*otlpmetrics.ScopeMetrics {
	return map[string]*otlpmetrics.ScopeMetrics{
		"empty":                    NewOrigScopeMetrics(),
		"Scope/test":               {Scope: *GenTestOrigInstrumentationScope()},
		"Metrics/default_and_test": {Metrics: []*otlpmetrics.Metric{{}, GenTestOrigMetric()}},
		"SchemaUrl/test":           {SchemaUrl: "test_schemaurl"},
	}
}
