//go:build !ignore_autogenerated
// +build !ignore_autogenerated

// This file is part of MinIO DirectPV
// Copyright (c) 2021, 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

// Code generated by conversion-gen. DO NOT EDIT.

package v1beta1

import (
	unsafe "unsafe"

	v1alpha1 "github.com/minio/directpv/pkg/apis/direct.csi.min.io/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(s *runtime.Scheme) error {
	if err := s.AddGeneratedConversionFunc((*DirectCSIDrive)(nil), (*v1alpha1.DirectCSIDrive)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_DirectCSIDrive_To_v1alpha1_DirectCSIDrive(a.(*DirectCSIDrive), b.(*v1alpha1.DirectCSIDrive), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha1.DirectCSIDrive)(nil), (*DirectCSIDrive)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_DirectCSIDrive_To_v1beta1_DirectCSIDrive(a.(*v1alpha1.DirectCSIDrive), b.(*DirectCSIDrive), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*DirectCSIDriveList)(nil), (*v1alpha1.DirectCSIDriveList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_DirectCSIDriveList_To_v1alpha1_DirectCSIDriveList(a.(*DirectCSIDriveList), b.(*v1alpha1.DirectCSIDriveList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha1.DirectCSIDriveList)(nil), (*DirectCSIDriveList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_DirectCSIDriveList_To_v1beta1_DirectCSIDriveList(a.(*v1alpha1.DirectCSIDriveList), b.(*DirectCSIDriveList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*DirectCSIDriveSpec)(nil), (*v1alpha1.DirectCSIDriveSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_DirectCSIDriveSpec_To_v1alpha1_DirectCSIDriveSpec(a.(*DirectCSIDriveSpec), b.(*v1alpha1.DirectCSIDriveSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha1.DirectCSIDriveSpec)(nil), (*DirectCSIDriveSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_DirectCSIDriveSpec_To_v1beta1_DirectCSIDriveSpec(a.(*v1alpha1.DirectCSIDriveSpec), b.(*DirectCSIDriveSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*DirectCSIDriveStatus)(nil), (*v1alpha1.DirectCSIDriveStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_DirectCSIDriveStatus_To_v1alpha1_DirectCSIDriveStatus(a.(*DirectCSIDriveStatus), b.(*v1alpha1.DirectCSIDriveStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha1.DirectCSIDriveStatus)(nil), (*DirectCSIDriveStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_DirectCSIDriveStatus_To_v1beta1_DirectCSIDriveStatus(a.(*v1alpha1.DirectCSIDriveStatus), b.(*DirectCSIDriveStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*DirectCSIVolume)(nil), (*v1alpha1.DirectCSIVolume)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_DirectCSIVolume_To_v1alpha1_DirectCSIVolume(a.(*DirectCSIVolume), b.(*v1alpha1.DirectCSIVolume), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha1.DirectCSIVolume)(nil), (*DirectCSIVolume)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_DirectCSIVolume_To_v1beta1_DirectCSIVolume(a.(*v1alpha1.DirectCSIVolume), b.(*DirectCSIVolume), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*DirectCSIVolumeList)(nil), (*v1alpha1.DirectCSIVolumeList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_DirectCSIVolumeList_To_v1alpha1_DirectCSIVolumeList(a.(*DirectCSIVolumeList), b.(*v1alpha1.DirectCSIVolumeList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha1.DirectCSIVolumeList)(nil), (*DirectCSIVolumeList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_DirectCSIVolumeList_To_v1beta1_DirectCSIVolumeList(a.(*v1alpha1.DirectCSIVolumeList), b.(*DirectCSIVolumeList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*DirectCSIVolumeStatus)(nil), (*v1alpha1.DirectCSIVolumeStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_DirectCSIVolumeStatus_To_v1alpha1_DirectCSIVolumeStatus(a.(*DirectCSIVolumeStatus), b.(*v1alpha1.DirectCSIVolumeStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha1.DirectCSIVolumeStatus)(nil), (*DirectCSIVolumeStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_DirectCSIVolumeStatus_To_v1beta1_DirectCSIVolumeStatus(a.(*v1alpha1.DirectCSIVolumeStatus), b.(*DirectCSIVolumeStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*RequestedFormat)(nil), (*v1alpha1.RequestedFormat)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_RequestedFormat_To_v1alpha1_RequestedFormat(a.(*RequestedFormat), b.(*v1alpha1.RequestedFormat), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha1.RequestedFormat)(nil), (*RequestedFormat)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_RequestedFormat_To_v1beta1_RequestedFormat(a.(*v1alpha1.RequestedFormat), b.(*RequestedFormat), scope)
	}); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1beta1_DirectCSIDrive_To_v1alpha1_DirectCSIDrive(in *DirectCSIDrive, out *v1alpha1.DirectCSIDrive, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta1_DirectCSIDriveSpec_To_v1alpha1_DirectCSIDriveSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_DirectCSIDriveStatus_To_v1alpha1_DirectCSIDriveStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_DirectCSIDrive_To_v1alpha1_DirectCSIDrive is an autogenerated conversion function.
func Convert_v1beta1_DirectCSIDrive_To_v1alpha1_DirectCSIDrive(in *DirectCSIDrive, out *v1alpha1.DirectCSIDrive, s conversion.Scope) error {
	return autoConvert_v1beta1_DirectCSIDrive_To_v1alpha1_DirectCSIDrive(in, out, s)
}

func autoConvert_v1alpha1_DirectCSIDrive_To_v1beta1_DirectCSIDrive(in *v1alpha1.DirectCSIDrive, out *DirectCSIDrive, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha1_DirectCSIDriveSpec_To_v1beta1_DirectCSIDriveSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha1_DirectCSIDriveStatus_To_v1beta1_DirectCSIDriveStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_DirectCSIDrive_To_v1beta1_DirectCSIDrive is an autogenerated conversion function.
func Convert_v1alpha1_DirectCSIDrive_To_v1beta1_DirectCSIDrive(in *v1alpha1.DirectCSIDrive, out *DirectCSIDrive, s conversion.Scope) error {
	return autoConvert_v1alpha1_DirectCSIDrive_To_v1beta1_DirectCSIDrive(in, out, s)
}

func autoConvert_v1beta1_DirectCSIDriveList_To_v1alpha1_DirectCSIDriveList(in *DirectCSIDriveList, out *v1alpha1.DirectCSIDriveList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1alpha1.DirectCSIDrive, len(*in))
		for i := range *in {
			if err := Convert_v1beta1_DirectCSIDrive_To_v1alpha1_DirectCSIDrive(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1beta1_DirectCSIDriveList_To_v1alpha1_DirectCSIDriveList is an autogenerated conversion function.
func Convert_v1beta1_DirectCSIDriveList_To_v1alpha1_DirectCSIDriveList(in *DirectCSIDriveList, out *v1alpha1.DirectCSIDriveList, s conversion.Scope) error {
	return autoConvert_v1beta1_DirectCSIDriveList_To_v1alpha1_DirectCSIDriveList(in, out, s)
}

func autoConvert_v1alpha1_DirectCSIDriveList_To_v1beta1_DirectCSIDriveList(in *v1alpha1.DirectCSIDriveList, out *DirectCSIDriveList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]DirectCSIDrive, len(*in))
		for i := range *in {
			if err := Convert_v1alpha1_DirectCSIDrive_To_v1beta1_DirectCSIDrive(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha1_DirectCSIDriveList_To_v1beta1_DirectCSIDriveList is an autogenerated conversion function.
func Convert_v1alpha1_DirectCSIDriveList_To_v1beta1_DirectCSIDriveList(in *v1alpha1.DirectCSIDriveList, out *DirectCSIDriveList, s conversion.Scope) error {
	return autoConvert_v1alpha1_DirectCSIDriveList_To_v1beta1_DirectCSIDriveList(in, out, s)
}

func autoConvert_v1beta1_DirectCSIDriveSpec_To_v1alpha1_DirectCSIDriveSpec(in *DirectCSIDriveSpec, out *v1alpha1.DirectCSIDriveSpec, s conversion.Scope) error {
	out.RequestedFormat = (*v1alpha1.RequestedFormat)(unsafe.Pointer(in.RequestedFormat))
	out.DirectCSIOwned = in.DirectCSIOwned
	out.DriveTaint = *(*map[string]string)(unsafe.Pointer(&in.DriveTaint))
	return nil
}

// Convert_v1beta1_DirectCSIDriveSpec_To_v1alpha1_DirectCSIDriveSpec is an autogenerated conversion function.
func Convert_v1beta1_DirectCSIDriveSpec_To_v1alpha1_DirectCSIDriveSpec(in *DirectCSIDriveSpec, out *v1alpha1.DirectCSIDriveSpec, s conversion.Scope) error {
	return autoConvert_v1beta1_DirectCSIDriveSpec_To_v1alpha1_DirectCSIDriveSpec(in, out, s)
}

func autoConvert_v1alpha1_DirectCSIDriveSpec_To_v1beta1_DirectCSIDriveSpec(in *v1alpha1.DirectCSIDriveSpec, out *DirectCSIDriveSpec, s conversion.Scope) error {
	out.RequestedFormat = (*RequestedFormat)(unsafe.Pointer(in.RequestedFormat))
	out.DirectCSIOwned = in.DirectCSIOwned
	out.DriveTaint = *(*map[string]string)(unsafe.Pointer(&in.DriveTaint))
	return nil
}

// Convert_v1alpha1_DirectCSIDriveSpec_To_v1beta1_DirectCSIDriveSpec is an autogenerated conversion function.
func Convert_v1alpha1_DirectCSIDriveSpec_To_v1beta1_DirectCSIDriveSpec(in *v1alpha1.DirectCSIDriveSpec, out *DirectCSIDriveSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_DirectCSIDriveSpec_To_v1beta1_DirectCSIDriveSpec(in, out, s)
}

func autoConvert_v1beta1_DirectCSIDriveStatus_To_v1alpha1_DirectCSIDriveStatus(in *DirectCSIDriveStatus, out *v1alpha1.DirectCSIDriveStatus, s conversion.Scope) error {
	out.Path = in.Path
	out.AllocatedCapacity = in.AllocatedCapacity
	out.FreeCapacity = in.FreeCapacity
	out.RootPartition = in.RootPartition
	out.PartitionNum = in.PartitionNum
	out.Filesystem = in.Filesystem
	out.Mountpoint = in.Mountpoint
	out.MountOptions = *(*[]string)(unsafe.Pointer(&in.MountOptions))
	out.NodeName = in.NodeName
	out.DriveStatus = v1alpha1.DriveStatus(in.DriveStatus)
	out.ModelNumber = in.ModelNumber
	out.SerialNumber = in.SerialNumber
	out.TotalCapacity = in.TotalCapacity
	out.PhysicalBlockSize = in.PhysicalBlockSize
	out.LogicalBlockSize = in.LogicalBlockSize
	out.Topology = *(*map[string]string)(unsafe.Pointer(&in.Topology))
	// INFO: in.AccessTier opted out of conversion generation
	out.Conditions = *(*[]v1.Condition)(unsafe.Pointer(&in.Conditions))
	return nil
}

// Convert_v1beta1_DirectCSIDriveStatus_To_v1alpha1_DirectCSIDriveStatus is an autogenerated conversion function.
func Convert_v1beta1_DirectCSIDriveStatus_To_v1alpha1_DirectCSIDriveStatus(in *DirectCSIDriveStatus, out *v1alpha1.DirectCSIDriveStatus, s conversion.Scope) error {
	return autoConvert_v1beta1_DirectCSIDriveStatus_To_v1alpha1_DirectCSIDriveStatus(in, out, s)
}

func autoConvert_v1alpha1_DirectCSIDriveStatus_To_v1beta1_DirectCSIDriveStatus(in *v1alpha1.DirectCSIDriveStatus, out *DirectCSIDriveStatus, s conversion.Scope) error {
	out.Path = in.Path
	out.AllocatedCapacity = in.AllocatedCapacity
	out.FreeCapacity = in.FreeCapacity
	out.RootPartition = in.RootPartition
	out.PartitionNum = in.PartitionNum
	out.Filesystem = in.Filesystem
	out.Mountpoint = in.Mountpoint
	out.MountOptions = *(*[]string)(unsafe.Pointer(&in.MountOptions))
	out.NodeName = in.NodeName
	out.DriveStatus = DriveStatus(in.DriveStatus)
	out.ModelNumber = in.ModelNumber
	out.SerialNumber = in.SerialNumber
	out.TotalCapacity = in.TotalCapacity
	out.PhysicalBlockSize = in.PhysicalBlockSize
	out.LogicalBlockSize = in.LogicalBlockSize
	out.Topology = *(*map[string]string)(unsafe.Pointer(&in.Topology))
	out.Conditions = *(*[]v1.Condition)(unsafe.Pointer(&in.Conditions))
	return nil
}

// Convert_v1alpha1_DirectCSIDriveStatus_To_v1beta1_DirectCSIDriveStatus is an autogenerated conversion function.
func Convert_v1alpha1_DirectCSIDriveStatus_To_v1beta1_DirectCSIDriveStatus(in *v1alpha1.DirectCSIDriveStatus, out *DirectCSIDriveStatus, s conversion.Scope) error {
	return autoConvert_v1alpha1_DirectCSIDriveStatus_To_v1beta1_DirectCSIDriveStatus(in, out, s)
}

func autoConvert_v1beta1_DirectCSIVolume_To_v1alpha1_DirectCSIVolume(in *DirectCSIVolume, out *v1alpha1.DirectCSIVolume, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta1_DirectCSIVolumeStatus_To_v1alpha1_DirectCSIVolumeStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_DirectCSIVolume_To_v1alpha1_DirectCSIVolume is an autogenerated conversion function.
func Convert_v1beta1_DirectCSIVolume_To_v1alpha1_DirectCSIVolume(in *DirectCSIVolume, out *v1alpha1.DirectCSIVolume, s conversion.Scope) error {
	return autoConvert_v1beta1_DirectCSIVolume_To_v1alpha1_DirectCSIVolume(in, out, s)
}

func autoConvert_v1alpha1_DirectCSIVolume_To_v1beta1_DirectCSIVolume(in *v1alpha1.DirectCSIVolume, out *DirectCSIVolume, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha1_DirectCSIVolumeStatus_To_v1beta1_DirectCSIVolumeStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_DirectCSIVolume_To_v1beta1_DirectCSIVolume is an autogenerated conversion function.
func Convert_v1alpha1_DirectCSIVolume_To_v1beta1_DirectCSIVolume(in *v1alpha1.DirectCSIVolume, out *DirectCSIVolume, s conversion.Scope) error {
	return autoConvert_v1alpha1_DirectCSIVolume_To_v1beta1_DirectCSIVolume(in, out, s)
}

func autoConvert_v1beta1_DirectCSIVolumeList_To_v1alpha1_DirectCSIVolumeList(in *DirectCSIVolumeList, out *v1alpha1.DirectCSIVolumeList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1alpha1.DirectCSIVolume)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1beta1_DirectCSIVolumeList_To_v1alpha1_DirectCSIVolumeList is an autogenerated conversion function.
func Convert_v1beta1_DirectCSIVolumeList_To_v1alpha1_DirectCSIVolumeList(in *DirectCSIVolumeList, out *v1alpha1.DirectCSIVolumeList, s conversion.Scope) error {
	return autoConvert_v1beta1_DirectCSIVolumeList_To_v1alpha1_DirectCSIVolumeList(in, out, s)
}

func autoConvert_v1alpha1_DirectCSIVolumeList_To_v1beta1_DirectCSIVolumeList(in *v1alpha1.DirectCSIVolumeList, out *DirectCSIVolumeList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]DirectCSIVolume)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha1_DirectCSIVolumeList_To_v1beta1_DirectCSIVolumeList is an autogenerated conversion function.
func Convert_v1alpha1_DirectCSIVolumeList_To_v1beta1_DirectCSIVolumeList(in *v1alpha1.DirectCSIVolumeList, out *DirectCSIVolumeList, s conversion.Scope) error {
	return autoConvert_v1alpha1_DirectCSIVolumeList_To_v1beta1_DirectCSIVolumeList(in, out, s)
}

func autoConvert_v1beta1_DirectCSIVolumeStatus_To_v1alpha1_DirectCSIVolumeStatus(in *DirectCSIVolumeStatus, out *v1alpha1.DirectCSIVolumeStatus, s conversion.Scope) error {
	out.Drive = in.Drive
	out.NodeName = in.NodeName
	out.HostPath = in.HostPath
	out.StagingPath = in.StagingPath
	out.ContainerPath = in.ContainerPath
	out.TotalCapacity = in.TotalCapacity
	out.AvailableCapacity = in.AvailableCapacity
	out.UsedCapacity = in.UsedCapacity
	out.Conditions = *(*[]v1.Condition)(unsafe.Pointer(&in.Conditions))
	return nil
}

// Convert_v1beta1_DirectCSIVolumeStatus_To_v1alpha1_DirectCSIVolumeStatus is an autogenerated conversion function.
func Convert_v1beta1_DirectCSIVolumeStatus_To_v1alpha1_DirectCSIVolumeStatus(in *DirectCSIVolumeStatus, out *v1alpha1.DirectCSIVolumeStatus, s conversion.Scope) error {
	return autoConvert_v1beta1_DirectCSIVolumeStatus_To_v1alpha1_DirectCSIVolumeStatus(in, out, s)
}

func autoConvert_v1alpha1_DirectCSIVolumeStatus_To_v1beta1_DirectCSIVolumeStatus(in *v1alpha1.DirectCSIVolumeStatus, out *DirectCSIVolumeStatus, s conversion.Scope) error {
	out.Drive = in.Drive
	out.NodeName = in.NodeName
	out.HostPath = in.HostPath
	out.StagingPath = in.StagingPath
	out.ContainerPath = in.ContainerPath
	out.TotalCapacity = in.TotalCapacity
	out.AvailableCapacity = in.AvailableCapacity
	out.UsedCapacity = in.UsedCapacity
	out.Conditions = *(*[]v1.Condition)(unsafe.Pointer(&in.Conditions))
	return nil
}

// Convert_v1alpha1_DirectCSIVolumeStatus_To_v1beta1_DirectCSIVolumeStatus is an autogenerated conversion function.
func Convert_v1alpha1_DirectCSIVolumeStatus_To_v1beta1_DirectCSIVolumeStatus(in *v1alpha1.DirectCSIVolumeStatus, out *DirectCSIVolumeStatus, s conversion.Scope) error {
	return autoConvert_v1alpha1_DirectCSIVolumeStatus_To_v1beta1_DirectCSIVolumeStatus(in, out, s)
}

func autoConvert_v1beta1_RequestedFormat_To_v1alpha1_RequestedFormat(in *RequestedFormat, out *v1alpha1.RequestedFormat, s conversion.Scope) error {
	out.Force = in.Force
	out.Purge = in.Purge
	out.Filesystem = in.Filesystem
	out.Mountpoint = in.Mountpoint
	out.MountOptions = *(*[]string)(unsafe.Pointer(&in.MountOptions))
	return nil
}

// Convert_v1beta1_RequestedFormat_To_v1alpha1_RequestedFormat is an autogenerated conversion function.
func Convert_v1beta1_RequestedFormat_To_v1alpha1_RequestedFormat(in *RequestedFormat, out *v1alpha1.RequestedFormat, s conversion.Scope) error {
	return autoConvert_v1beta1_RequestedFormat_To_v1alpha1_RequestedFormat(in, out, s)
}

func autoConvert_v1alpha1_RequestedFormat_To_v1beta1_RequestedFormat(in *v1alpha1.RequestedFormat, out *RequestedFormat, s conversion.Scope) error {
	out.Force = in.Force
	out.Purge = in.Purge
	out.Filesystem = in.Filesystem
	out.Mountpoint = in.Mountpoint
	out.MountOptions = *(*[]string)(unsafe.Pointer(&in.MountOptions))
	return nil
}

// Convert_v1alpha1_RequestedFormat_To_v1beta1_RequestedFormat is an autogenerated conversion function.
func Convert_v1alpha1_RequestedFormat_To_v1beta1_RequestedFormat(in *v1alpha1.RequestedFormat, out *RequestedFormat, s conversion.Scope) error {
	return autoConvert_v1alpha1_RequestedFormat_To_v1beta1_RequestedFormat(in, out, s)
}
