// This file is part of MinIO DirectPV
// Copyright (c) 2021, 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1alpha1 "github.com/minio/directpv/pkg/apis/direct.csi.min.io/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeDirectCSIDrives implements DirectCSIDriveInterface
type FakeDirectCSIDrives struct {
	Fake *FakeDirectV1alpha1
}

var directcsidrivesResource = schema.GroupVersionResource{Group: "direct.csi.min.io", Version: "v1alpha1", Resource: "directcsidrives"}

var directcsidrivesKind = schema.GroupVersionKind{Group: "direct.csi.min.io", Version: "v1alpha1", Kind: "DirectCSIDrive"}

// Get takes name of the directCSIDrive, and returns the corresponding directCSIDrive object, and an error if there is any.
func (c *FakeDirectCSIDrives) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.DirectCSIDrive, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(directcsidrivesResource, name), &v1alpha1.DirectCSIDrive{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.DirectCSIDrive), err
}

// List takes label and field selectors, and returns the list of DirectCSIDrives that match those selectors.
func (c *FakeDirectCSIDrives) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.DirectCSIDriveList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(directcsidrivesResource, directcsidrivesKind, opts), &v1alpha1.DirectCSIDriveList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.DirectCSIDriveList{ListMeta: obj.(*v1alpha1.DirectCSIDriveList).ListMeta}
	for _, item := range obj.(*v1alpha1.DirectCSIDriveList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested directCSIDrives.
func (c *FakeDirectCSIDrives) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(directcsidrivesResource, opts))
}

// Create takes the representation of a directCSIDrive and creates it.  Returns the server's representation of the directCSIDrive, and an error, if there is any.
func (c *FakeDirectCSIDrives) Create(ctx context.Context, directCSIDrive *v1alpha1.DirectCSIDrive, opts v1.CreateOptions) (result *v1alpha1.DirectCSIDrive, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(directcsidrivesResource, directCSIDrive), &v1alpha1.DirectCSIDrive{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.DirectCSIDrive), err
}

// Update takes the representation of a directCSIDrive and updates it. Returns the server's representation of the directCSIDrive, and an error, if there is any.
func (c *FakeDirectCSIDrives) Update(ctx context.Context, directCSIDrive *v1alpha1.DirectCSIDrive, opts v1.UpdateOptions) (result *v1alpha1.DirectCSIDrive, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(directcsidrivesResource, directCSIDrive), &v1alpha1.DirectCSIDrive{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.DirectCSIDrive), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeDirectCSIDrives) UpdateStatus(ctx context.Context, directCSIDrive *v1alpha1.DirectCSIDrive, opts v1.UpdateOptions) (*v1alpha1.DirectCSIDrive, error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateSubresourceAction(directcsidrivesResource, "status", directCSIDrive), &v1alpha1.DirectCSIDrive{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.DirectCSIDrive), err
}

// Delete takes name of the directCSIDrive and deletes it. Returns an error if one occurs.
func (c *FakeDirectCSIDrives) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteActionWithOptions(directcsidrivesResource, name, opts), &v1alpha1.DirectCSIDrive{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeDirectCSIDrives) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(directcsidrivesResource, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha1.DirectCSIDriveList{})
	return err
}

// Patch applies the patch and returns the patched directCSIDrive.
func (c *FakeDirectCSIDrives) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.DirectCSIDrive, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(directcsidrivesResource, name, pt, data, subresources...), &v1alpha1.DirectCSIDrive{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.DirectCSIDrive), err
}
