# Generate output into the same package

To output the generated implementation into the package containing the converter
interface you can follow these steps:

## Configure generation

Configure [`output`](../reference/output.md) to output the file into the same
directory, define the full package path, and then run [`goverter
gen`](../reference/cli.md).

::: code-group
<<< @../../example/samepackage/input.go
<<< @../../example/samepackage/generated.go
:::

## Use implementation

Goverter will ignore files generated by goverter when generating the
implementation. (See [Build Constraint](../reference/build-constraint.md))

This means if you want to use the implementation in the same package e.g

```go
package samepackage

import "errors"

func ValidateAndConvert(source *Input) (*Output, error) {
	if source.Name == "" {
		return nil, errors.New("Name may not be nil")
	}

	c := &ConverterImpl{}
	return c.Convert(source)
}
```

Goverter will fail with an complilation error like this:

```
could not load package github.com/jmattheis/goverter/example/samepackage

-: # github.com/jmattheis/goverter/example/samepackage
samepackage/use.go:12:8: undefined: ConverterImpl

Goverter cannot generate converters when there are compile errors because it
requires the type information from the compiled sources.
```

You can fix this by adding the [Build
Constraint](../reference/build-constraint.md) to the newly added file like this:

::: code-group
<<< @../../example/samepackage/use.go
<<< @../../example/samepackage/input.go
<<< @../../example/samepackage/generated.go
:::

or by defining a global variable with the type of the interface and then
assigning it in a different file containing a [Build
Constraint](../reference/build-constraint.md).

::: code-group
<<< @../../example/samepackage/use2.go
<<< @../../example/samepackage/assign.go
<<< @../../example/samepackage/input.go
<<< @../../example/samepackage/generated.go
:::
