//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/privatedns/armprivatedns"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// RecordSetsServer is a fake server for instances of the armprivatedns.RecordSetsClient type.
type RecordSetsServer struct {
	// CreateOrUpdate is the fake for method RecordSetsClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, privateZoneName string, recordType armprivatedns.RecordType, relativeRecordSetName string, parameters armprivatedns.RecordSet, options *armprivatedns.RecordSetsClientCreateOrUpdateOptions) (resp azfake.Responder[armprivatedns.RecordSetsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method RecordSetsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, privateZoneName string, recordType armprivatedns.RecordType, relativeRecordSetName string, options *armprivatedns.RecordSetsClientDeleteOptions) (resp azfake.Responder[armprivatedns.RecordSetsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method RecordSetsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, privateZoneName string, recordType armprivatedns.RecordType, relativeRecordSetName string, options *armprivatedns.RecordSetsClientGetOptions) (resp azfake.Responder[armprivatedns.RecordSetsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method RecordSetsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, privateZoneName string, options *armprivatedns.RecordSetsClientListOptions) (resp azfake.PagerResponder[armprivatedns.RecordSetsClientListResponse])

	// NewListByTypePager is the fake for method RecordSetsClient.NewListByTypePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByTypePager func(resourceGroupName string, privateZoneName string, recordType armprivatedns.RecordType, options *armprivatedns.RecordSetsClientListByTypeOptions) (resp azfake.PagerResponder[armprivatedns.RecordSetsClientListByTypeResponse])

	// Update is the fake for method RecordSetsClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, privateZoneName string, recordType armprivatedns.RecordType, relativeRecordSetName string, parameters armprivatedns.RecordSet, options *armprivatedns.RecordSetsClientUpdateOptions) (resp azfake.Responder[armprivatedns.RecordSetsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewRecordSetsServerTransport creates a new instance of RecordSetsServerTransport with the provided implementation.
// The returned RecordSetsServerTransport instance is connected to an instance of armprivatedns.RecordSetsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewRecordSetsServerTransport(srv *RecordSetsServer) *RecordSetsServerTransport {
	return &RecordSetsServerTransport{
		srv:                srv,
		newListPager:       newTracker[azfake.PagerResponder[armprivatedns.RecordSetsClientListResponse]](),
		newListByTypePager: newTracker[azfake.PagerResponder[armprivatedns.RecordSetsClientListByTypeResponse]](),
	}
}

// RecordSetsServerTransport connects instances of armprivatedns.RecordSetsClient to instances of RecordSetsServer.
// Don't use this type directly, use NewRecordSetsServerTransport instead.
type RecordSetsServerTransport struct {
	srv                *RecordSetsServer
	newListPager       *tracker[azfake.PagerResponder[armprivatedns.RecordSetsClientListResponse]]
	newListByTypePager *tracker[azfake.PagerResponder[armprivatedns.RecordSetsClientListByTypeResponse]]
}

// Do implements the policy.Transporter interface for RecordSetsServerTransport.
func (r *RecordSetsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "RecordSetsClient.CreateOrUpdate":
		resp, err = r.dispatchCreateOrUpdate(req)
	case "RecordSetsClient.Delete":
		resp, err = r.dispatchDelete(req)
	case "RecordSetsClient.Get":
		resp, err = r.dispatchGet(req)
	case "RecordSetsClient.NewListPager":
		resp, err = r.dispatchNewListPager(req)
	case "RecordSetsClient.NewListByTypePager":
		resp, err = r.dispatchNewListByTypePager(req)
	case "RecordSetsClient.Update":
		resp, err = r.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *RecordSetsServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if r.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/privateDnsZones/(?P<privateZoneName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<recordType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<relativeRecordSetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armprivatedns.RecordSet](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	privateZoneNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateZoneName")])
	if err != nil {
		return nil, err
	}
	recordTypeParam, err := parseWithCast(matches[regex.SubexpIndex("recordType")], func(v string) (armprivatedns.RecordType, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armprivatedns.RecordType(p), nil
	})
	if err != nil {
		return nil, err
	}
	relativeRecordSetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("relativeRecordSetName")])
	if err != nil {
		return nil, err
	}
	ifMatchParam := getOptional(getHeaderValue(req.Header, "If-Match"))
	ifNoneMatchParam := getOptional(getHeaderValue(req.Header, "If-None-Match"))
	var options *armprivatedns.RecordSetsClientCreateOrUpdateOptions
	if ifMatchParam != nil || ifNoneMatchParam != nil {
		options = &armprivatedns.RecordSetsClientCreateOrUpdateOptions{
			IfMatch:     ifMatchParam,
			IfNoneMatch: ifNoneMatchParam,
		}
	}
	respr, errRespr := r.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, privateZoneNameParam, recordTypeParam, relativeRecordSetNameParam, body, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RecordSet, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RecordSetsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if r.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/privateDnsZones/(?P<privateZoneName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<recordType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<relativeRecordSetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	privateZoneNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateZoneName")])
	if err != nil {
		return nil, err
	}
	recordTypeParam, err := parseWithCast(matches[regex.SubexpIndex("recordType")], func(v string) (armprivatedns.RecordType, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armprivatedns.RecordType(p), nil
	})
	if err != nil {
		return nil, err
	}
	relativeRecordSetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("relativeRecordSetName")])
	if err != nil {
		return nil, err
	}
	ifMatchParam := getOptional(getHeaderValue(req.Header, "If-Match"))
	var options *armprivatedns.RecordSetsClientDeleteOptions
	if ifMatchParam != nil {
		options = &armprivatedns.RecordSetsClientDeleteOptions{
			IfMatch: ifMatchParam,
		}
	}
	respr, errRespr := r.srv.Delete(req.Context(), resourceGroupNameParam, privateZoneNameParam, recordTypeParam, relativeRecordSetNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RecordSetsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if r.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/privateDnsZones/(?P<privateZoneName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<recordType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<relativeRecordSetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	privateZoneNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateZoneName")])
	if err != nil {
		return nil, err
	}
	recordTypeParam, err := parseWithCast(matches[regex.SubexpIndex("recordType")], func(v string) (armprivatedns.RecordType, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armprivatedns.RecordType(p), nil
	})
	if err != nil {
		return nil, err
	}
	relativeRecordSetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("relativeRecordSetName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.Get(req.Context(), resourceGroupNameParam, privateZoneNameParam, recordTypeParam, relativeRecordSetNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RecordSet, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RecordSetsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := r.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/privateDnsZones/(?P<privateZoneName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/ALL`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		privateZoneNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateZoneName")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		recordsetnamesuffixUnescaped, err := url.QueryUnescape(qp.Get("$recordsetnamesuffix"))
		if err != nil {
			return nil, err
		}
		recordsetnamesuffixParam := getOptional(recordsetnamesuffixUnescaped)
		var options *armprivatedns.RecordSetsClientListOptions
		if topParam != nil || recordsetnamesuffixParam != nil {
			options = &armprivatedns.RecordSetsClientListOptions{
				Top:                 topParam,
				Recordsetnamesuffix: recordsetnamesuffixParam,
			}
		}
		resp := r.srv.NewListPager(resourceGroupNameParam, privateZoneNameParam, options)
		newListPager = &resp
		r.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armprivatedns.RecordSetsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		r.newListPager.remove(req)
	}
	return resp, nil
}

func (r *RecordSetsServerTransport) dispatchNewListByTypePager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListByTypePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByTypePager not implemented")}
	}
	newListByTypePager := r.newListByTypePager.get(req)
	if newListByTypePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/privateDnsZones/(?P<privateZoneName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<recordType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		privateZoneNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateZoneName")])
		if err != nil {
			return nil, err
		}
		recordTypeParam, err := parseWithCast(matches[regex.SubexpIndex("recordType")], func(v string) (armprivatedns.RecordType, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armprivatedns.RecordType(p), nil
		})
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		recordsetnamesuffixUnescaped, err := url.QueryUnescape(qp.Get("$recordsetnamesuffix"))
		if err != nil {
			return nil, err
		}
		recordsetnamesuffixParam := getOptional(recordsetnamesuffixUnescaped)
		var options *armprivatedns.RecordSetsClientListByTypeOptions
		if topParam != nil || recordsetnamesuffixParam != nil {
			options = &armprivatedns.RecordSetsClientListByTypeOptions{
				Top:                 topParam,
				Recordsetnamesuffix: recordsetnamesuffixParam,
			}
		}
		resp := r.srv.NewListByTypePager(resourceGroupNameParam, privateZoneNameParam, recordTypeParam, options)
		newListByTypePager = &resp
		r.newListByTypePager.add(req, newListByTypePager)
		server.PagerResponderInjectNextLinks(newListByTypePager, req, func(page *armprivatedns.RecordSetsClientListByTypeResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByTypePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListByTypePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByTypePager) {
		r.newListByTypePager.remove(req)
	}
	return resp, nil
}

func (r *RecordSetsServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if r.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/privateDnsZones/(?P<privateZoneName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<recordType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<relativeRecordSetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armprivatedns.RecordSet](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	privateZoneNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateZoneName")])
	if err != nil {
		return nil, err
	}
	recordTypeParam, err := parseWithCast(matches[regex.SubexpIndex("recordType")], func(v string) (armprivatedns.RecordType, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armprivatedns.RecordType(p), nil
	})
	if err != nil {
		return nil, err
	}
	relativeRecordSetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("relativeRecordSetName")])
	if err != nil {
		return nil, err
	}
	ifMatchParam := getOptional(getHeaderValue(req.Header, "If-Match"))
	var options *armprivatedns.RecordSetsClientUpdateOptions
	if ifMatchParam != nil {
		options = &armprivatedns.RecordSetsClientUpdateOptions{
			IfMatch: ifMatchParam,
		}
	}
	respr, errRespr := r.srv.Update(req.Context(), resourceGroupNameParam, privateZoneNameParam, recordTypeParam, relativeRecordSetNameParam, body, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RecordSet, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
