//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armprivatedns_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/privatedns/armprivatedns"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e4991356eec55985c1af47096c9c2091126a7d0f/specification/privatedns/resource-manager/Microsoft.Network/stable/2024-06-01/examples/PrivateZonePut.json
func ExamplePrivateZonesClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armprivatedns.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewPrivateZonesClient().BeginCreateOrUpdate(ctx, "resourceGroup1", "privatezone1.com", armprivatedns.PrivateZone{
		Location: to.Ptr("Global"),
		Tags: map[string]*string{
			"key1": to.Ptr("value1"),
		},
	}, &armprivatedns.PrivateZonesClientBeginCreateOrUpdateOptions{IfMatch: nil,
		IfNoneMatch: nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.PrivateZone = armprivatedns.PrivateZone{
	// 	Name: to.Ptr("privatezone1.com"),
	// 	Type: to.Ptr("Microsoft.Network/privateDnsZones"),
	// 	ID: to.Ptr("/subscriptions/subscriptionId/resourceGroups/resourceGroup1/providers/Microsoft.Network/privateDnsZones/privatezone1.com"),
	// 	Location: to.Ptr("global"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 	},
	// 	Etag: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 	Properties: &armprivatedns.PrivateZoneProperties{
	// 		MaxNumberOfRecordSets: to.Ptr[int64](5000),
	// 		MaxNumberOfVirtualNetworkLinks: to.Ptr[int64](100),
	// 		MaxNumberOfVirtualNetworkLinksWithRegistration: to.Ptr[int64](50),
	// 		NumberOfRecordSets: to.Ptr[int64](1),
	// 		NumberOfVirtualNetworkLinks: to.Ptr[int64](0),
	// 		NumberOfVirtualNetworkLinksWithRegistration: to.Ptr[int64](0),
	// 		ProvisioningState: to.Ptr(armprivatedns.ProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e4991356eec55985c1af47096c9c2091126a7d0f/specification/privatedns/resource-manager/Microsoft.Network/stable/2024-06-01/examples/PrivateZonePatch.json
func ExamplePrivateZonesClient_BeginUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armprivatedns.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewPrivateZonesClient().BeginUpdate(ctx, "resourceGroup1", "privatezone1.com", armprivatedns.PrivateZone{
		Tags: map[string]*string{
			"key2": to.Ptr("value2"),
		},
	}, &armprivatedns.PrivateZonesClientBeginUpdateOptions{IfMatch: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.PrivateZone = armprivatedns.PrivateZone{
	// 	Name: to.Ptr("privatezone1.com"),
	// 	Type: to.Ptr("Microsoft.Network/privateDnsZones"),
	// 	ID: to.Ptr("/subscriptions/subscriptionId/resourceGroups/resourceGroup1/providers/Microsoft.Network/privateDnsZones/privatezone1.com"),
	// 	Location: to.Ptr("global"),
	// 	Tags: map[string]*string{
	// 		"key2": to.Ptr("value2"),
	// 	},
	// 	Etag: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 	Properties: &armprivatedns.PrivateZoneProperties{
	// 		MaxNumberOfRecordSets: to.Ptr[int64](5000),
	// 		MaxNumberOfVirtualNetworkLinks: to.Ptr[int64](100),
	// 		MaxNumberOfVirtualNetworkLinksWithRegistration: to.Ptr[int64](50),
	// 		NumberOfRecordSets: to.Ptr[int64](1),
	// 		NumberOfVirtualNetworkLinks: to.Ptr[int64](0),
	// 		NumberOfVirtualNetworkLinksWithRegistration: to.Ptr[int64](0),
	// 		ProvisioningState: to.Ptr(armprivatedns.ProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e4991356eec55985c1af47096c9c2091126a7d0f/specification/privatedns/resource-manager/Microsoft.Network/stable/2024-06-01/examples/PrivateZoneDelete.json
func ExamplePrivateZonesClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armprivatedns.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewPrivateZonesClient().BeginDelete(ctx, "resourceGroup1", "privatezone1.com", &armprivatedns.PrivateZonesClientBeginDeleteOptions{IfMatch: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e4991356eec55985c1af47096c9c2091126a7d0f/specification/privatedns/resource-manager/Microsoft.Network/stable/2024-06-01/examples/PrivateZoneGet.json
func ExamplePrivateZonesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armprivatedns.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewPrivateZonesClient().Get(ctx, "resourceGroup1", "privatezone1.com", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.PrivateZone = armprivatedns.PrivateZone{
	// 	Name: to.Ptr("privatezone1.com"),
	// 	Type: to.Ptr("Microsoft.Network/privateDnsZones"),
	// 	ID: to.Ptr("/subscriptions/subscriptionId/resourceGroups/resourceGroup1/providers/Microsoft.Network/privateDnsZones/privatezone1.com"),
	// 	Location: to.Ptr("global"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 	},
	// 	Etag: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 	Properties: &armprivatedns.PrivateZoneProperties{
	// 		MaxNumberOfRecordSets: to.Ptr[int64](5000),
	// 		MaxNumberOfVirtualNetworkLinks: to.Ptr[int64](100),
	// 		MaxNumberOfVirtualNetworkLinksWithRegistration: to.Ptr[int64](50),
	// 		NumberOfRecordSets: to.Ptr[int64](1),
	// 		NumberOfVirtualNetworkLinks: to.Ptr[int64](0),
	// 		NumberOfVirtualNetworkLinksWithRegistration: to.Ptr[int64](0),
	// 		ProvisioningState: to.Ptr(armprivatedns.ProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e4991356eec55985c1af47096c9c2091126a7d0f/specification/privatedns/resource-manager/Microsoft.Network/stable/2024-06-01/examples/PrivateZoneListInSubscription.json
func ExamplePrivateZonesClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armprivatedns.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewPrivateZonesClient().NewListPager(&armprivatedns.PrivateZonesClientListOptions{Top: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.PrivateZoneListResult = armprivatedns.PrivateZoneListResult{
		// 	Value: []*armprivatedns.PrivateZone{
		// 		{
		// 			Name: to.Ptr("privatezone1.com"),
		// 			Type: to.Ptr("Microsoft.Network/privateDnsZones"),
		// 			ID: to.Ptr("/subscriptions/subscriptionId/resourceGroups/resourceGroup1/providers/Microsoft.Network/privateDnsZones/privatezone1.com"),
		// 			Location: to.Ptr("global"),
		// 			Tags: map[string]*string{
		// 				"key1": to.Ptr("value1"),
		// 			},
		// 			Etag: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 			Properties: &armprivatedns.PrivateZoneProperties{
		// 				MaxNumberOfRecordSets: to.Ptr[int64](5000),
		// 				MaxNumberOfVirtualNetworkLinks: to.Ptr[int64](100),
		// 				MaxNumberOfVirtualNetworkLinksWithRegistration: to.Ptr[int64](50),
		// 				NumberOfRecordSets: to.Ptr[int64](1),
		// 				NumberOfVirtualNetworkLinks: to.Ptr[int64](0),
		// 				NumberOfVirtualNetworkLinksWithRegistration: to.Ptr[int64](0),
		// 				ProvisioningState: to.Ptr(armprivatedns.ProvisioningStateSucceeded),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("privatezone2.com"),
		// 			Type: to.Ptr("Microsoft.Network/privateDnsZones"),
		// 			ID: to.Ptr("/subscriptions/subscriptionId/resourceGroups/resourceGroup2/providers/Microsoft.Network/privateDnsZones/privatezone2.com"),
		// 			Location: to.Ptr("global"),
		// 			Etag: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 			Properties: &armprivatedns.PrivateZoneProperties{
		// 				MaxNumberOfRecordSets: to.Ptr[int64](5000),
		// 				MaxNumberOfVirtualNetworkLinks: to.Ptr[int64](100),
		// 				MaxNumberOfVirtualNetworkLinksWithRegistration: to.Ptr[int64](50),
		// 				NumberOfRecordSets: to.Ptr[int64](1),
		// 				NumberOfVirtualNetworkLinks: to.Ptr[int64](0),
		// 				NumberOfVirtualNetworkLinksWithRegistration: to.Ptr[int64](0),
		// 				ProvisioningState: to.Ptr(armprivatedns.ProvisioningStateSucceeded),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e4991356eec55985c1af47096c9c2091126a7d0f/specification/privatedns/resource-manager/Microsoft.Network/stable/2024-06-01/examples/PrivateZoneListInResourceGroup.json
func ExamplePrivateZonesClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armprivatedns.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewPrivateZonesClient().NewListByResourceGroupPager("resourceGroup1", &armprivatedns.PrivateZonesClientListByResourceGroupOptions{Top: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.PrivateZoneListResult = armprivatedns.PrivateZoneListResult{
		// 	Value: []*armprivatedns.PrivateZone{
		// 		{
		// 			Name: to.Ptr("privatezone1.com"),
		// 			Type: to.Ptr("Microsoft.Network/privateDnsZones"),
		// 			ID: to.Ptr("/subscriptions/subscriptionId/resourceGroups/resourceGroup1/providers/Microsoft.Network/privateDnsZones/privatezone1.com"),
		// 			Location: to.Ptr("global"),
		// 			Tags: map[string]*string{
		// 				"key1": to.Ptr("value1"),
		// 			},
		// 			Etag: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 			Properties: &armprivatedns.PrivateZoneProperties{
		// 				MaxNumberOfRecordSets: to.Ptr[int64](5000),
		// 				MaxNumberOfVirtualNetworkLinks: to.Ptr[int64](100),
		// 				MaxNumberOfVirtualNetworkLinksWithRegistration: to.Ptr[int64](50),
		// 				NumberOfRecordSets: to.Ptr[int64](1),
		// 				NumberOfVirtualNetworkLinks: to.Ptr[int64](0),
		// 				NumberOfVirtualNetworkLinksWithRegistration: to.Ptr[int64](0),
		// 				ProvisioningState: to.Ptr(armprivatedns.ProvisioningStateSucceeded),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("privatezone2.com"),
		// 			Type: to.Ptr("Microsoft.Network/privateDnsZones"),
		// 			ID: to.Ptr("/subscriptions/subscriptionId/resourceGroups/resourceGroup1/providers/Microsoft.Network/privateDnsZones/privatezone2.com"),
		// 			Location: to.Ptr("global"),
		// 			Etag: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 			Properties: &armprivatedns.PrivateZoneProperties{
		// 				MaxNumberOfRecordSets: to.Ptr[int64](5000),
		// 				MaxNumberOfVirtualNetworkLinks: to.Ptr[int64](100),
		// 				MaxNumberOfVirtualNetworkLinksWithRegistration: to.Ptr[int64](50),
		// 				NumberOfRecordSets: to.Ptr[int64](1),
		// 				NumberOfVirtualNetworkLinks: to.Ptr[int64](0),
		// 				NumberOfVirtualNetworkLinksWithRegistration: to.Ptr[int64](0),
		// 				ProvisioningState: to.Ptr(armprivatedns.ProvisioningStateSucceeded),
		// 			},
		// 	}},
		// }
	}
}
