﻿package main

import (
	"fmt"
	"github.com/tencentcloud/tencentcloud-sdk-go/tencentcloud/common"
	"github.com/tencentcloud/tencentcloud-sdk-go/tencentcloud/common/profile"
	"github.com/tencentcloud/tencentcloud-sdk-go/tencentcloud/common/errors"
	ecc "github.com/tencentcloud/tencentcloud-sdk-go/tencentcloud/ecc/v20181213"
)

func main() {
	// 必要步骤：
	// 实例化一个认证对象，入参需要传入腾讯云账户密钥对secretId，secretKey。
	// 这里采用的是从环境变量读取的方式，需要在环境变量中先设置这两个值。
	// 你也可以直接在代码中写死密钥对，但是小心不要将代码复制、上传或者分享给他人，
	// 以免泄露密钥对危及你的财产安全。
	credential := common.NewCredential(
		// os.Getenv("TENCENTCLOUD_SECRET_ID"),
		// os.Getenv("TENCENTCLOUD_SECRET_KEY"),
		"",
		"",
	)

	// 非必要步骤
	// 实例化一个客户端配置对象，可以指定超时时间等配置
	cpf := profile.NewClientProfile()
	// SDK默认使用POST方法。
	// 如果你一定要使用GET方法，可以在这里设置。GET方法无法处理一些较大的请求。
	cpf.HttpProfile.ReqMethod = "POST"
	// SDK有默认的超时时间，非必要请不要进行调整。
	// 如有需要请在代码中查阅以获取最新的默认值。
	cpf.HttpProfile.ReqTimeout = 30
	// SDK会自动指定域名。通常是不需要特地指定域名的
	cpf.HttpProfile.Endpoint = "ecc.tencentcloudapi.com"

	// 实例化要请求产品的client对象
	// 第二个参数是地域信息
	client, _ := ecc.NewClient(credential, "ap-guangzhou", cpf)
	// 实例化一个请求对象，根据调用的接口和实际情况，可以进一步设置请求参数
	// 你可以直接查询SDK源码确定NewEnglishCompositionCorrectRequest有哪些属性可以设置，
	// 属性可能是基本类型，也可能引用了另一个数据结构。
	// 推荐使用IDE进行开发，可以方便的跳转查阅各个接口和数据结构的文档说明。
	request := ecc.NewEHOCRRequest()

	// 基本类型的设置。
	// 此接口允许设置返回的实例数量。此处指定为只返回一个。
	// SDK采用的是指针风格指定参数，即使对于基本类型你也需要用指针来对参数赋值。
	// SDK提供对基本类型的指针引用封装函数
	userImageData := "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" 

    request.InputType=common.Int64Ptr(1)
    request.Image = common.StringPtr(userImageData)

	// 通过client对象调用想要访问的接口，需要传入请求对象
	response, err := client.EHOCR(request)
	// 处理异常
	fmt.Println(err)
	if _, ok := err.(*errors.TencentCloudSDKError); ok {
		fmt.Printf("An API error has returned: %s", err)
		return
	}
	// 非SDK异常，直接失败。实际代码中可以加入其他的处理。
	if err != nil {
		panic(err)
	}
	// 打印返回的json字符串
	fmt.Printf("%s", response.ToJsonString())
}
