//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/eng/tools/profileBuilder

package databoxedge

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/databoxedge/mgmt/2020-12-01/databoxedge"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type AccountType = original.AccountType

const (
	BlobStorage           AccountType = original.BlobStorage
	GeneralPurposeStorage AccountType = original.GeneralPurposeStorage
)

type AddonState = original.AddonState

const (
	Created       AddonState = original.Created
	Creating      AddonState = original.Creating
	Deleting      AddonState = original.Deleting
	Failed        AddonState = original.Failed
	Invalid       AddonState = original.Invalid
	Reconfiguring AddonState = original.Reconfiguring
	Updating      AddonState = original.Updating
)

type AlertSeverity = original.AlertSeverity

const (
	Critical      AlertSeverity = original.Critical
	Informational AlertSeverity = original.Informational
	Warning       AlertSeverity = original.Warning
)

type AuthenticationType = original.AuthenticationType

const (
	AuthenticationTypeAzureActiveDirectory AuthenticationType = original.AuthenticationTypeAzureActiveDirectory
	AuthenticationTypeInvalid              AuthenticationType = original.AuthenticationTypeInvalid
)

type AzureContainerDataFormat = original.AzureContainerDataFormat

const (
	AzureFile AzureContainerDataFormat = original.AzureFile
	BlockBlob AzureContainerDataFormat = original.BlockBlob
	PageBlob  AzureContainerDataFormat = original.PageBlob
)

type ClientPermissionType = original.ClientPermissionType

const (
	NoAccess  ClientPermissionType = original.NoAccess
	ReadOnly  ClientPermissionType = original.ReadOnly
	ReadWrite ClientPermissionType = original.ReadWrite
)

type ContainerStatus = original.ContainerStatus

const (
	ContainerStatusNeedsAttention ContainerStatus = original.ContainerStatusNeedsAttention
	ContainerStatusOffline        ContainerStatus = original.ContainerStatusOffline
	ContainerStatusOK             ContainerStatus = original.ContainerStatusOK
	ContainerStatusUnknown        ContainerStatus = original.ContainerStatusUnknown
	ContainerStatusUpdating       ContainerStatus = original.ContainerStatusUpdating
)

type CreatedByType = original.CreatedByType

const (
	CreatedByTypeApplication     CreatedByType = original.CreatedByTypeApplication
	CreatedByTypeKey             CreatedByType = original.CreatedByTypeKey
	CreatedByTypeManagedIdentity CreatedByType = original.CreatedByTypeManagedIdentity
	CreatedByTypeUser            CreatedByType = original.CreatedByTypeUser
)

type DataPolicy = original.DataPolicy

const (
	Cloud DataPolicy = original.Cloud
	Local DataPolicy = original.Local
)

type DayOfWeek = original.DayOfWeek

const (
	Friday    DayOfWeek = original.Friday
	Monday    DayOfWeek = original.Monday
	Saturday  DayOfWeek = original.Saturday
	Sunday    DayOfWeek = original.Sunday
	Thursday  DayOfWeek = original.Thursday
	Tuesday   DayOfWeek = original.Tuesday
	Wednesday DayOfWeek = original.Wednesday
)

type DeviceKind = original.DeviceKind

const (
	AzureDataBoxGateway    DeviceKind = original.AzureDataBoxGateway
	AzureModularDataCentre DeviceKind = original.AzureModularDataCentre
	AzureStackEdge         DeviceKind = original.AzureStackEdge
	AzureStackHub          DeviceKind = original.AzureStackHub
)

type DeviceStatus = original.DeviceStatus

const (
	Disconnected          DeviceStatus = original.Disconnected
	Maintenance           DeviceStatus = original.Maintenance
	NeedsAttention        DeviceStatus = original.NeedsAttention
	Offline               DeviceStatus = original.Offline
	Online                DeviceStatus = original.Online
	PartiallyDisconnected DeviceStatus = original.PartiallyDisconnected
	ReadyToSetup          DeviceStatus = original.ReadyToSetup
)

type DeviceType = original.DeviceType

const (
	DataBoxEdgeDevice DeviceType = original.DataBoxEdgeDevice
)

type DownloadPhase = original.DownloadPhase

const (
	Downloading  DownloadPhase = original.Downloading
	Initializing DownloadPhase = original.Initializing
	Unknown      DownloadPhase = original.Unknown
	Verifying    DownloadPhase = original.Verifying
)

type EncryptionAlgorithm = original.EncryptionAlgorithm

const (
	AES256        EncryptionAlgorithm = original.AES256
	None          EncryptionAlgorithm = original.None
	RSAESPKCS1V15 EncryptionAlgorithm = original.RSAESPKCS1V15
)

type HostPlatformType = original.HostPlatformType

const (
	KubernetesCluster HostPlatformType = original.KubernetesCluster
	LinuxVM           HostPlatformType = original.LinuxVM
)

type InstallRebootBehavior = original.InstallRebootBehavior

const (
	NeverReboots   InstallRebootBehavior = original.NeverReboots
	RequestReboot  InstallRebootBehavior = original.RequestReboot
	RequiresReboot InstallRebootBehavior = original.RequiresReboot
)

type JobStatus = original.JobStatus

const (
	JobStatusCanceled  JobStatus = original.JobStatusCanceled
	JobStatusFailed    JobStatus = original.JobStatusFailed
	JobStatusInvalid   JobStatus = original.JobStatusInvalid
	JobStatusPaused    JobStatus = original.JobStatusPaused
	JobStatusRunning   JobStatus = original.JobStatusRunning
	JobStatusScheduled JobStatus = original.JobStatusScheduled
	JobStatusSucceeded JobStatus = original.JobStatusSucceeded
)

type JobType = original.JobType

const (
	JobTypeBackup                JobType = original.JobTypeBackup
	JobTypeDownloadUpdates       JobType = original.JobTypeDownloadUpdates
	JobTypeInstallUpdates        JobType = original.JobTypeInstallUpdates
	JobTypeInvalid               JobType = original.JobTypeInvalid
	JobTypeRefreshContainer      JobType = original.JobTypeRefreshContainer
	JobTypeRefreshShare          JobType = original.JobTypeRefreshShare
	JobTypeRestore               JobType = original.JobTypeRestore
	JobTypeScanForUpdates        JobType = original.JobTypeScanForUpdates
	JobTypeTriggerSupportPackage JobType = original.JobTypeTriggerSupportPackage
)

type KeyVaultSyncStatus = original.KeyVaultSyncStatus

const (
	KeyVaultNotConfigured KeyVaultSyncStatus = original.KeyVaultNotConfigured
	KeyVaultSynced        KeyVaultSyncStatus = original.KeyVaultSynced
	KeyVaultSyncFailed    KeyVaultSyncStatus = original.KeyVaultSyncFailed
	KeyVaultSyncing       KeyVaultSyncStatus = original.KeyVaultSyncing
	KeyVaultSyncPending   KeyVaultSyncStatus = original.KeyVaultSyncPending
)

type Kind = original.Kind

const (
	KindAddon            Kind = original.KindAddon
	KindArcForKubernetes Kind = original.KindArcForKubernetes
	KindIotEdge          Kind = original.KindIotEdge
)

type KindBasicRole = original.KindBasicRole

const (
	KindCloudEdgeManagement KindBasicRole = original.KindCloudEdgeManagement
	KindIOT                 KindBasicRole = original.KindIOT
	KindKubernetes          KindBasicRole = original.KindKubernetes
	KindMEC                 KindBasicRole = original.KindMEC
	KindRole                KindBasicRole = original.KindRole
)

type KindBasicTrigger = original.KindBasicTrigger

const (
	KindFileEvent          KindBasicTrigger = original.KindFileEvent
	KindPeriodicTimerEvent KindBasicTrigger = original.KindPeriodicTimerEvent
	KindTrigger            KindBasicTrigger = original.KindTrigger
)

type KubernetesNodeType = original.KubernetesNodeType

const (
	KubernetesNodeTypeInvalid KubernetesNodeType = original.KubernetesNodeTypeInvalid
	KubernetesNodeTypeMaster  KubernetesNodeType = original.KubernetesNodeTypeMaster
	KubernetesNodeTypeWorker  KubernetesNodeType = original.KubernetesNodeTypeWorker
)

type KubernetesState = original.KubernetesState

const (
	KubernetesStateCreated       KubernetesState = original.KubernetesStateCreated
	KubernetesStateCreating      KubernetesState = original.KubernetesStateCreating
	KubernetesStateDeleting      KubernetesState = original.KubernetesStateDeleting
	KubernetesStateFailed        KubernetesState = original.KubernetesStateFailed
	KubernetesStateInvalid       KubernetesState = original.KubernetesStateInvalid
	KubernetesStateReconfiguring KubernetesState = original.KubernetesStateReconfiguring
	KubernetesStateUpdating      KubernetesState = original.KubernetesStateUpdating
)

type MetricAggregationType = original.MetricAggregationType

const (
	MetricAggregationTypeAverage      MetricAggregationType = original.MetricAggregationTypeAverage
	MetricAggregationTypeCount        MetricAggregationType = original.MetricAggregationTypeCount
	MetricAggregationTypeMaximum      MetricAggregationType = original.MetricAggregationTypeMaximum
	MetricAggregationTypeMinimum      MetricAggregationType = original.MetricAggregationTypeMinimum
	MetricAggregationTypeNone         MetricAggregationType = original.MetricAggregationTypeNone
	MetricAggregationTypeNotSpecified MetricAggregationType = original.MetricAggregationTypeNotSpecified
	MetricAggregationTypeTotal        MetricAggregationType = original.MetricAggregationTypeTotal
)

type MetricCategory = original.MetricCategory

const (
	Capacity    MetricCategory = original.Capacity
	Transaction MetricCategory = original.Transaction
)

type MetricUnit = original.MetricUnit

const (
	Bytes          MetricUnit = original.Bytes
	BytesPerSecond MetricUnit = original.BytesPerSecond
	Count          MetricUnit = original.Count
	CountPerSecond MetricUnit = original.CountPerSecond
	Milliseconds   MetricUnit = original.Milliseconds
	NotSpecified   MetricUnit = original.NotSpecified
	Percent        MetricUnit = original.Percent
	Seconds        MetricUnit = original.Seconds
)

type MonitoringStatus = original.MonitoringStatus

const (
	Disabled MonitoringStatus = original.Disabled
	Enabled  MonitoringStatus = original.Enabled
)

type MountType = original.MountType

const (
	HostPath MountType = original.HostPath
	Volume   MountType = original.Volume
)

type MsiIdentityType = original.MsiIdentityType

const (
	MsiIdentityTypeNone           MsiIdentityType = original.MsiIdentityTypeNone
	MsiIdentityTypeSystemAssigned MsiIdentityType = original.MsiIdentityTypeSystemAssigned
	MsiIdentityTypeUserAssigned   MsiIdentityType = original.MsiIdentityTypeUserAssigned
)

type NetworkAdapterDHCPStatus = original.NetworkAdapterDHCPStatus

const (
	NetworkAdapterDHCPStatusDisabled NetworkAdapterDHCPStatus = original.NetworkAdapterDHCPStatusDisabled
	NetworkAdapterDHCPStatusEnabled  NetworkAdapterDHCPStatus = original.NetworkAdapterDHCPStatusEnabled
)

type NetworkAdapterRDMAStatus = original.NetworkAdapterRDMAStatus

const (
	Capable   NetworkAdapterRDMAStatus = original.Capable
	Incapable NetworkAdapterRDMAStatus = original.Incapable
)

type NetworkAdapterStatus = original.NetworkAdapterStatus

const (
	Active   NetworkAdapterStatus = original.Active
	Inactive NetworkAdapterStatus = original.Inactive
)

type NetworkGroup = original.NetworkGroup

const (
	NetworkGroupNone    NetworkGroup = original.NetworkGroupNone
	NetworkGroupNonRDMA NetworkGroup = original.NetworkGroupNonRDMA
	NetworkGroupRDMA    NetworkGroup = original.NetworkGroupRDMA
)

type NodeStatus = original.NodeStatus

const (
	NodeStatusDown         NodeStatus = original.NodeStatusDown
	NodeStatusRebooting    NodeStatus = original.NodeStatusRebooting
	NodeStatusShuttingDown NodeStatus = original.NodeStatusShuttingDown
	NodeStatusUnknown      NodeStatus = original.NodeStatusUnknown
	NodeStatusUp           NodeStatus = original.NodeStatusUp
)

type OrderState = original.OrderState

const (
	Arriving               OrderState = original.Arriving
	AwaitingDrop           OrderState = original.AwaitingDrop
	AwaitingFulfilment     OrderState = original.AwaitingFulfilment
	AwaitingPickup         OrderState = original.AwaitingPickup
	AwaitingPreparation    OrderState = original.AwaitingPreparation
	AwaitingReturnShipment OrderState = original.AwaitingReturnShipment
	AwaitingShipment       OrderState = original.AwaitingShipment
	CollectedAtMicrosoft   OrderState = original.CollectedAtMicrosoft
	Declined               OrderState = original.Declined
	Delivered              OrderState = original.Delivered
	LostDevice             OrderState = original.LostDevice
	PickupCompleted        OrderState = original.PickupCompleted
	ReplacementRequested   OrderState = original.ReplacementRequested
	ReturnInitiated        OrderState = original.ReturnInitiated
	Shipped                OrderState = original.Shipped
	ShippedBack            OrderState = original.ShippedBack
	Untracked              OrderState = original.Untracked
)

type PlatformType = original.PlatformType

const (
	Linux   PlatformType = original.Linux
	Windows PlatformType = original.Windows
)

type PosixComplianceStatus = original.PosixComplianceStatus

const (
	PosixComplianceStatusDisabled PosixComplianceStatus = original.PosixComplianceStatusDisabled
	PosixComplianceStatusEnabled  PosixComplianceStatus = original.PosixComplianceStatusEnabled
	PosixComplianceStatusInvalid  PosixComplianceStatus = original.PosixComplianceStatusInvalid
)

type ResourceMoveStatus = original.ResourceMoveStatus

const (
	ResourceMoveStatusNone                   ResourceMoveStatus = original.ResourceMoveStatusNone
	ResourceMoveStatusResourceMoveFailed     ResourceMoveStatus = original.ResourceMoveStatusResourceMoveFailed
	ResourceMoveStatusResourceMoveInProgress ResourceMoveStatus = original.ResourceMoveStatusResourceMoveInProgress
)

type RoleStatus = original.RoleStatus

const (
	RoleStatusDisabled RoleStatus = original.RoleStatusDisabled
	RoleStatusEnabled  RoleStatus = original.RoleStatusEnabled
)

type RoleTypes = original.RoleTypes

const (
	ASA                 RoleTypes = original.ASA
	CloudEdgeManagement RoleTypes = original.CloudEdgeManagement
	Cognitive           RoleTypes = original.Cognitive
	Functions           RoleTypes = original.Functions
	IOT                 RoleTypes = original.IOT
	Kubernetes          RoleTypes = original.Kubernetes
	MEC                 RoleTypes = original.MEC
)

type SSLStatus = original.SSLStatus

const (
	SSLStatusDisabled SSLStatus = original.SSLStatusDisabled
	SSLStatusEnabled  SSLStatus = original.SSLStatusEnabled
)

type ShareAccessProtocol = original.ShareAccessProtocol

const (
	NFS ShareAccessProtocol = original.NFS
	SMB ShareAccessProtocol = original.SMB
)

type ShareAccessType = original.ShareAccessType

const (
	Change ShareAccessType = original.Change
	Custom ShareAccessType = original.Custom
	Read   ShareAccessType = original.Read
)

type ShareStatus = original.ShareStatus

const (
	ShareStatusNeedsAttention ShareStatus = original.ShareStatusNeedsAttention
	ShareStatusOffline        ShareStatus = original.ShareStatusOffline
	ShareStatusOK             ShareStatus = original.ShareStatusOK
	ShareStatusUnknown        ShareStatus = original.ShareStatusUnknown
	ShareStatusUpdating       ShareStatus = original.ShareStatusUpdating
)

type ShipmentType = original.ShipmentType

const (
	NotApplicable     ShipmentType = original.NotApplicable
	SelfPickup        ShipmentType = original.SelfPickup
	ShippedToCustomer ShipmentType = original.ShippedToCustomer
)

type SkuAvailability = original.SkuAvailability

const (
	Available   SkuAvailability = original.Available
	Unavailable SkuAvailability = original.Unavailable
)

type SkuName = original.SkuName

const (
	Edge              SkuName = original.Edge
	EdgeMRMini        SkuName = original.EdgeMRMini
	EdgePBase         SkuName = original.EdgePBase
	EdgePHigh         SkuName = original.EdgePHigh
	EdgePRBase        SkuName = original.EdgePRBase
	EdgePRBaseUPS     SkuName = original.EdgePRBaseUPS
	Gateway           SkuName = original.Gateway
	GPU               SkuName = original.GPU
	RCALarge          SkuName = original.RCALarge
	RCASmall          SkuName = original.RCASmall
	RDC               SkuName = original.RDC
	TCALarge          SkuName = original.TCALarge
	TCASmall          SkuName = original.TCASmall
	TDC               SkuName = original.TDC
	TEA1Node          SkuName = original.TEA1Node
	TEA1NodeHeater    SkuName = original.TEA1NodeHeater
	TEA1NodeUPS       SkuName = original.TEA1NodeUPS
	TEA1NodeUPSHeater SkuName = original.TEA1NodeUPSHeater
	TEA4NodeHeater    SkuName = original.TEA4NodeHeater
	TEA4NodeUPSHeater SkuName = original.TEA4NodeUPSHeater
	TMA               SkuName = original.TMA
)

type SkuSignupOption = original.SkuSignupOption

const (
	SkuSignupOptionAvailable SkuSignupOption = original.SkuSignupOptionAvailable
	SkuSignupOptionNone      SkuSignupOption = original.SkuSignupOptionNone
)

type SkuTier = original.SkuTier

const (
	Standard SkuTier = original.Standard
)

type SkuVersion = original.SkuVersion

const (
	Preview SkuVersion = original.Preview
	Stable  SkuVersion = original.Stable
)

type StorageAccountStatus = original.StorageAccountStatus

const (
	StorageAccountStatusNeedsAttention StorageAccountStatus = original.StorageAccountStatusNeedsAttention
	StorageAccountStatusOffline        StorageAccountStatus = original.StorageAccountStatusOffline
	StorageAccountStatusOK             StorageAccountStatus = original.StorageAccountStatusOK
	StorageAccountStatusUnknown        StorageAccountStatus = original.StorageAccountStatusUnknown
	StorageAccountStatusUpdating       StorageAccountStatus = original.StorageAccountStatusUpdating
)

type SubscriptionState = original.SubscriptionState

const (
	Deleted      SubscriptionState = original.Deleted
	Registered   SubscriptionState = original.Registered
	Suspended    SubscriptionState = original.Suspended
	Unregistered SubscriptionState = original.Unregistered
	Warned       SubscriptionState = original.Warned
)

type TimeGrain = original.TimeGrain

const (
	PT12H TimeGrain = original.PT12H
	PT15M TimeGrain = original.PT15M
	PT1D  TimeGrain = original.PT1D
	PT1H  TimeGrain = original.PT1H
	PT1M  TimeGrain = original.PT1M
	PT30M TimeGrain = original.PT30M
	PT5M  TimeGrain = original.PT5M
	PT6H  TimeGrain = original.PT6H
)

type UpdateOperation = original.UpdateOperation

const (
	UpdateOperationDownload UpdateOperation = original.UpdateOperationDownload
	UpdateOperationInstall  UpdateOperation = original.UpdateOperationInstall
	UpdateOperationNone     UpdateOperation = original.UpdateOperationNone
	UpdateOperationScan     UpdateOperation = original.UpdateOperationScan
)

type UpdateOperationStage = original.UpdateOperationStage

const (
	UpdateOperationStageDownloadComplete UpdateOperationStage = original.UpdateOperationStageDownloadComplete
	UpdateOperationStageDownloadFailed   UpdateOperationStage = original.UpdateOperationStageDownloadFailed
	UpdateOperationStageDownloadStarted  UpdateOperationStage = original.UpdateOperationStageDownloadStarted
	UpdateOperationStageFailure          UpdateOperationStage = original.UpdateOperationStageFailure
	UpdateOperationStageInitial          UpdateOperationStage = original.UpdateOperationStageInitial
	UpdateOperationStageInstallComplete  UpdateOperationStage = original.UpdateOperationStageInstallComplete
	UpdateOperationStageInstallFailed    UpdateOperationStage = original.UpdateOperationStageInstallFailed
	UpdateOperationStageInstallStarted   UpdateOperationStage = original.UpdateOperationStageInstallStarted
	UpdateOperationStageRebootInitiated  UpdateOperationStage = original.UpdateOperationStageRebootInitiated
	UpdateOperationStageRescanComplete   UpdateOperationStage = original.UpdateOperationStageRescanComplete
	UpdateOperationStageRescanFailed     UpdateOperationStage = original.UpdateOperationStageRescanFailed
	UpdateOperationStageRescanStarted    UpdateOperationStage = original.UpdateOperationStageRescanStarted
	UpdateOperationStageScanComplete     UpdateOperationStage = original.UpdateOperationStageScanComplete
	UpdateOperationStageScanFailed       UpdateOperationStage = original.UpdateOperationStageScanFailed
	UpdateOperationStageScanStarted      UpdateOperationStage = original.UpdateOperationStageScanStarted
	UpdateOperationStageSuccess          UpdateOperationStage = original.UpdateOperationStageSuccess
	UpdateOperationStageUnknown          UpdateOperationStage = original.UpdateOperationStageUnknown
)

type UserType = original.UserType

const (
	UserTypeARM             UserType = original.UserTypeARM
	UserTypeLocalManagement UserType = original.UserTypeLocalManagement
	UserTypeShare           UserType = original.UserTypeShare
)

type ARMBaseModel = original.ARMBaseModel
type Addon = original.Addon
type AddonList = original.AddonList
type AddonListIterator = original.AddonListIterator
type AddonListPage = original.AddonListPage
type AddonModel = original.AddonModel
type AddonsClient = original.AddonsClient
type AddonsCreateOrUpdateFuture = original.AddonsCreateOrUpdateFuture
type AddonsDeleteFuture = original.AddonsDeleteFuture
type Address = original.Address
type Alert = original.Alert
type AlertErrorDetails = original.AlertErrorDetails
type AlertList = original.AlertList
type AlertListIterator = original.AlertListIterator
type AlertListPage = original.AlertListPage
type AlertProperties = original.AlertProperties
type AlertsClient = original.AlertsClient
type ArcAddon = original.ArcAddon
type ArcAddonProperties = original.ArcAddonProperties
type AsymmetricEncryptedSecret = original.AsymmetricEncryptedSecret
type Authentication = original.Authentication
type AvailableSkusClient = original.AvailableSkusClient
type AzureContainerInfo = original.AzureContainerInfo
type BandwidthSchedule = original.BandwidthSchedule
type BandwidthScheduleProperties = original.BandwidthScheduleProperties
type BandwidthSchedulesClient = original.BandwidthSchedulesClient
type BandwidthSchedulesCreateOrUpdateFuture = original.BandwidthSchedulesCreateOrUpdateFuture
type BandwidthSchedulesDeleteFuture = original.BandwidthSchedulesDeleteFuture
type BandwidthSchedulesList = original.BandwidthSchedulesList
type BandwidthSchedulesListIterator = original.BandwidthSchedulesListIterator
type BandwidthSchedulesListPage = original.BandwidthSchedulesListPage
type BaseClient = original.BaseClient
type BasicAddon = original.BasicAddon
type BasicRole = original.BasicRole
type BasicTrigger = original.BasicTrigger
type ClientAccessRight = original.ClientAccessRight
type CloudEdgeManagementRole = original.CloudEdgeManagementRole
type CloudEdgeManagementRoleProperties = original.CloudEdgeManagementRoleProperties
type CloudError = original.CloudError
type CloudErrorBody = original.CloudErrorBody
type CniConfig = original.CniConfig
type ComputeResource = original.ComputeResource
type ContactDetails = original.ContactDetails
type Container = original.Container
type ContainerList = original.ContainerList
type ContainerListIterator = original.ContainerListIterator
type ContainerListPage = original.ContainerListPage
type ContainerProperties = original.ContainerProperties
type ContainersClient = original.ContainersClient
type ContainersCreateOrUpdateFuture = original.ContainersCreateOrUpdateFuture
type ContainersDeleteFuture = original.ContainersDeleteFuture
type ContainersRefreshFuture = original.ContainersRefreshFuture
type DCAccessCode = original.DCAccessCode
type DCAccessCodeProperties = original.DCAccessCodeProperties
type Device = original.Device
type DeviceExtendedInfo = original.DeviceExtendedInfo
type DeviceExtendedInfoPatch = original.DeviceExtendedInfoPatch
type DeviceExtendedInfoProperties = original.DeviceExtendedInfoProperties
type DeviceList = original.DeviceList
type DeviceListIterator = original.DeviceListIterator
type DeviceListPage = original.DeviceListPage
type DevicePatch = original.DevicePatch
type DeviceProperties = original.DeviceProperties
type DevicePropertiesPatch = original.DevicePropertiesPatch
type DeviceSecrets = original.DeviceSecrets
type DevicesClient = original.DevicesClient
type DevicesCreateOrUpdateFuture = original.DevicesCreateOrUpdateFuture
type DevicesCreateOrUpdateSecuritySettingsFuture = original.DevicesCreateOrUpdateSecuritySettingsFuture
type DevicesDeleteFuture = original.DevicesDeleteFuture
type DevicesDownloadUpdatesFuture = original.DevicesDownloadUpdatesFuture
type DevicesInstallUpdatesFuture = original.DevicesInstallUpdatesFuture
type DevicesScanForUpdatesFuture = original.DevicesScanForUpdatesFuture
type EdgeProfile = original.EdgeProfile
type EdgeProfilePatch = original.EdgeProfilePatch
type EdgeProfileSubscription = original.EdgeProfileSubscription
type EdgeProfileSubscriptionPatch = original.EdgeProfileSubscriptionPatch
type EtcdInfo = original.EtcdInfo
type FileEventTrigger = original.FileEventTrigger
type FileSourceInfo = original.FileSourceInfo
type FileTriggerProperties = original.FileTriggerProperties
type GenerateCertResponse = original.GenerateCertResponse
type ImageRepositoryCredential = original.ImageRepositoryCredential
type IoTAddon = original.IoTAddon
type IoTAddonProperties = original.IoTAddonProperties
type IoTDeviceInfo = original.IoTDeviceInfo
type IoTEdgeAgentInfo = original.IoTEdgeAgentInfo
type IoTRole = original.IoTRole
type IoTRoleProperties = original.IoTRoleProperties
type Ipv4Config = original.Ipv4Config
type Ipv6Config = original.Ipv6Config
type Job = original.Job
type JobErrorDetails = original.JobErrorDetails
type JobErrorItem = original.JobErrorItem
type JobProperties = original.JobProperties
type JobsClient = original.JobsClient
type KubernetesClusterInfo = original.KubernetesClusterInfo
type KubernetesIPConfiguration = original.KubernetesIPConfiguration
type KubernetesRole = original.KubernetesRole
type KubernetesRoleCompute = original.KubernetesRoleCompute
type KubernetesRoleNetwork = original.KubernetesRoleNetwork
type KubernetesRoleProperties = original.KubernetesRoleProperties
type KubernetesRoleResources = original.KubernetesRoleResources
type KubernetesRoleStorage = original.KubernetesRoleStorage
type KubernetesRoleStorageClassInfo = original.KubernetesRoleStorageClassInfo
type LoadBalancerConfig = original.LoadBalancerConfig
type MECRole = original.MECRole
type MECRoleProperties = original.MECRoleProperties
type MetricConfiguration = original.MetricConfiguration
type MetricCounter = original.MetricCounter
type MetricCounterSet = original.MetricCounterSet
type MetricDimension = original.MetricDimension
type MetricDimensionV1 = original.MetricDimensionV1
type MetricSpecificationV1 = original.MetricSpecificationV1
type MonitoringConfigClient = original.MonitoringConfigClient
type MonitoringConfigCreateOrUpdateFuture = original.MonitoringConfigCreateOrUpdateFuture
type MonitoringConfigDeleteFuture = original.MonitoringConfigDeleteFuture
type MonitoringMetricConfiguration = original.MonitoringMetricConfiguration
type MonitoringMetricConfigurationList = original.MonitoringMetricConfigurationList
type MonitoringMetricConfigurationListIterator = original.MonitoringMetricConfigurationListIterator
type MonitoringMetricConfigurationListPage = original.MonitoringMetricConfigurationListPage
type MonitoringMetricConfigurationProperties = original.MonitoringMetricConfigurationProperties
type MountPointMap = original.MountPointMap
type MoveRequest = original.MoveRequest
type NetworkAdapter = original.NetworkAdapter
type NetworkAdapterPosition = original.NetworkAdapterPosition
type NetworkSettings = original.NetworkSettings
type NetworkSettingsProperties = original.NetworkSettingsProperties
type Node = original.Node
type NodeInfo = original.NodeInfo
type NodeList = original.NodeList
type NodeListIterator = original.NodeListIterator
type NodeListPage = original.NodeListPage
type NodeProperties = original.NodeProperties
type NodesClient = original.NodesClient
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationProperties = original.OperationProperties
type OperationsClient = original.OperationsClient
type OperationsList = original.OperationsList
type OperationsListIterator = original.OperationsListIterator
type OperationsListPage = original.OperationsListPage
type OperationsStatusClient = original.OperationsStatusClient
type Order = original.Order
type OrderList = original.OrderList
type OrderListIterator = original.OrderListIterator
type OrderListPage = original.OrderListPage
type OrderProperties = original.OrderProperties
type OrderStatus = original.OrderStatus
type OrdersClient = original.OrdersClient
type OrdersCreateOrUpdateFuture = original.OrdersCreateOrUpdateFuture
type OrdersDeleteFuture = original.OrdersDeleteFuture
type PeriodicTimerEventTrigger = original.PeriodicTimerEventTrigger
type PeriodicTimerProperties = original.PeriodicTimerProperties
type PeriodicTimerSourceInfo = original.PeriodicTimerSourceInfo
type RawCertificateData = original.RawCertificateData
type RefreshDetails = original.RefreshDetails
type ResourceIdentity = original.ResourceIdentity
type ResourceMoveDetails = original.ResourceMoveDetails
type ResourceTypeSku = original.ResourceTypeSku
type Role = original.Role
type RoleList = original.RoleList
type RoleListIterator = original.RoleListIterator
type RoleListPage = original.RoleListPage
type RoleModel = original.RoleModel
type RoleSinkInfo = original.RoleSinkInfo
type RolesClient = original.RolesClient
type RolesCreateOrUpdateFuture = original.RolesCreateOrUpdateFuture
type RolesDeleteFuture = original.RolesDeleteFuture
type Secret = original.Secret
type SecuritySettings = original.SecuritySettings
type SecuritySettingsProperties = original.SecuritySettingsProperties
type ServiceSpecification = original.ServiceSpecification
type Share = original.Share
type ShareAccessRight = original.ShareAccessRight
type ShareList = original.ShareList
type ShareListIterator = original.ShareListIterator
type ShareListPage = original.ShareListPage
type ShareProperties = original.ShareProperties
type SharesClient = original.SharesClient
type SharesCreateOrUpdateFuture = original.SharesCreateOrUpdateFuture
type SharesDeleteFuture = original.SharesDeleteFuture
type SharesRefreshFuture = original.SharesRefreshFuture
type Sku = original.Sku
type SkuCapability = original.SkuCapability
type SkuCost = original.SkuCost
type SkuInformation = original.SkuInformation
type SkuInformationList = original.SkuInformationList
type SkuList = original.SkuList
type SkuListIterator = original.SkuListIterator
type SkuListPage = original.SkuListPage
type SkuLocationInfo = original.SkuLocationInfo
type SkuType = original.SkuType
type StorageAccount = original.StorageAccount
type StorageAccountCredential = original.StorageAccountCredential
type StorageAccountCredentialList = original.StorageAccountCredentialList
type StorageAccountCredentialListIterator = original.StorageAccountCredentialListIterator
type StorageAccountCredentialListPage = original.StorageAccountCredentialListPage
type StorageAccountCredentialProperties = original.StorageAccountCredentialProperties
type StorageAccountCredentialsClient = original.StorageAccountCredentialsClient
type StorageAccountCredentialsCreateOrUpdateFuture = original.StorageAccountCredentialsCreateOrUpdateFuture
type StorageAccountCredentialsDeleteFuture = original.StorageAccountCredentialsDeleteFuture
type StorageAccountList = original.StorageAccountList
type StorageAccountListIterator = original.StorageAccountListIterator
type StorageAccountListPage = original.StorageAccountListPage
type StorageAccountProperties = original.StorageAccountProperties
type StorageAccountsClient = original.StorageAccountsClient
type StorageAccountsCreateOrUpdateFuture = original.StorageAccountsCreateOrUpdateFuture
type StorageAccountsDeleteFuture = original.StorageAccountsDeleteFuture
type SubscriptionProperties = original.SubscriptionProperties
type SubscriptionRegisteredFeatures = original.SubscriptionRegisteredFeatures
type SymmetricKey = original.SymmetricKey
type SystemData = original.SystemData
type TrackingInfo = original.TrackingInfo
type Trigger = original.Trigger
type TriggerList = original.TriggerList
type TriggerListIterator = original.TriggerListIterator
type TriggerListPage = original.TriggerListPage
type TriggerModel = original.TriggerModel
type TriggersClient = original.TriggersClient
type TriggersCreateOrUpdateFuture = original.TriggersCreateOrUpdateFuture
type TriggersDeleteFuture = original.TriggersDeleteFuture
type UpdateDownloadProgress = original.UpdateDownloadProgress
type UpdateInstallProgress = original.UpdateInstallProgress
type UpdateSummary = original.UpdateSummary
type UpdateSummaryProperties = original.UpdateSummaryProperties
type UploadCertificateRequest = original.UploadCertificateRequest
type UploadCertificateResponse = original.UploadCertificateResponse
type User = original.User
type UserAccessRight = original.UserAccessRight
type UserList = original.UserList
type UserListIterator = original.UserListIterator
type UserListPage = original.UserListPage
type UserProperties = original.UserProperties
type UsersClient = original.UsersClient
type UsersCreateOrUpdateFuture = original.UsersCreateOrUpdateFuture
type UsersDeleteFuture = original.UsersDeleteFuture

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewAddonListIterator(page AddonListPage) AddonListIterator {
	return original.NewAddonListIterator(page)
}
func NewAddonListPage(cur AddonList, getNextPage func(context.Context, AddonList) (AddonList, error)) AddonListPage {
	return original.NewAddonListPage(cur, getNextPage)
}
func NewAddonsClient(subscriptionID string) AddonsClient {
	return original.NewAddonsClient(subscriptionID)
}
func NewAddonsClientWithBaseURI(baseURI string, subscriptionID string) AddonsClient {
	return original.NewAddonsClientWithBaseURI(baseURI, subscriptionID)
}
func NewAlertListIterator(page AlertListPage) AlertListIterator {
	return original.NewAlertListIterator(page)
}
func NewAlertListPage(cur AlertList, getNextPage func(context.Context, AlertList) (AlertList, error)) AlertListPage {
	return original.NewAlertListPage(cur, getNextPage)
}
func NewAlertsClient(subscriptionID string) AlertsClient {
	return original.NewAlertsClient(subscriptionID)
}
func NewAlertsClientWithBaseURI(baseURI string, subscriptionID string) AlertsClient {
	return original.NewAlertsClientWithBaseURI(baseURI, subscriptionID)
}
func NewAvailableSkusClient(subscriptionID string) AvailableSkusClient {
	return original.NewAvailableSkusClient(subscriptionID)
}
func NewAvailableSkusClientWithBaseURI(baseURI string, subscriptionID string) AvailableSkusClient {
	return original.NewAvailableSkusClientWithBaseURI(baseURI, subscriptionID)
}
func NewBandwidthSchedulesClient(subscriptionID string) BandwidthSchedulesClient {
	return original.NewBandwidthSchedulesClient(subscriptionID)
}
func NewBandwidthSchedulesClientWithBaseURI(baseURI string, subscriptionID string) BandwidthSchedulesClient {
	return original.NewBandwidthSchedulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewBandwidthSchedulesListIterator(page BandwidthSchedulesListPage) BandwidthSchedulesListIterator {
	return original.NewBandwidthSchedulesListIterator(page)
}
func NewBandwidthSchedulesListPage(cur BandwidthSchedulesList, getNextPage func(context.Context, BandwidthSchedulesList) (BandwidthSchedulesList, error)) BandwidthSchedulesListPage {
	return original.NewBandwidthSchedulesListPage(cur, getNextPage)
}
func NewContainerListIterator(page ContainerListPage) ContainerListIterator {
	return original.NewContainerListIterator(page)
}
func NewContainerListPage(cur ContainerList, getNextPage func(context.Context, ContainerList) (ContainerList, error)) ContainerListPage {
	return original.NewContainerListPage(cur, getNextPage)
}
func NewContainersClient(subscriptionID string) ContainersClient {
	return original.NewContainersClient(subscriptionID)
}
func NewContainersClientWithBaseURI(baseURI string, subscriptionID string) ContainersClient {
	return original.NewContainersClientWithBaseURI(baseURI, subscriptionID)
}
func NewDeviceListIterator(page DeviceListPage) DeviceListIterator {
	return original.NewDeviceListIterator(page)
}
func NewDeviceListPage(cur DeviceList, getNextPage func(context.Context, DeviceList) (DeviceList, error)) DeviceListPage {
	return original.NewDeviceListPage(cur, getNextPage)
}
func NewDevicesClient(subscriptionID string) DevicesClient {
	return original.NewDevicesClient(subscriptionID)
}
func NewDevicesClientWithBaseURI(baseURI string, subscriptionID string) DevicesClient {
	return original.NewDevicesClientWithBaseURI(baseURI, subscriptionID)
}
func NewJobsClient(subscriptionID string) JobsClient {
	return original.NewJobsClient(subscriptionID)
}
func NewJobsClientWithBaseURI(baseURI string, subscriptionID string) JobsClient {
	return original.NewJobsClientWithBaseURI(baseURI, subscriptionID)
}
func NewMonitoringConfigClient(subscriptionID string) MonitoringConfigClient {
	return original.NewMonitoringConfigClient(subscriptionID)
}
func NewMonitoringConfigClientWithBaseURI(baseURI string, subscriptionID string) MonitoringConfigClient {
	return original.NewMonitoringConfigClientWithBaseURI(baseURI, subscriptionID)
}
func NewMonitoringMetricConfigurationListIterator(page MonitoringMetricConfigurationListPage) MonitoringMetricConfigurationListIterator {
	return original.NewMonitoringMetricConfigurationListIterator(page)
}
func NewMonitoringMetricConfigurationListPage(cur MonitoringMetricConfigurationList, getNextPage func(context.Context, MonitoringMetricConfigurationList) (MonitoringMetricConfigurationList, error)) MonitoringMetricConfigurationListPage {
	return original.NewMonitoringMetricConfigurationListPage(cur, getNextPage)
}
func NewNodeListIterator(page NodeListPage) NodeListIterator {
	return original.NewNodeListIterator(page)
}
func NewNodeListPage(cur NodeList, getNextPage func(context.Context, NodeList) (NodeList, error)) NodeListPage {
	return original.NewNodeListPage(cur, getNextPage)
}
func NewNodesClient(subscriptionID string) NodesClient {
	return original.NewNodesClient(subscriptionID)
}
func NewNodesClientWithBaseURI(baseURI string, subscriptionID string) NodesClient {
	return original.NewNodesClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationsListIterator(page OperationsListPage) OperationsListIterator {
	return original.NewOperationsListIterator(page)
}
func NewOperationsListPage(cur OperationsList, getNextPage func(context.Context, OperationsList) (OperationsList, error)) OperationsListPage {
	return original.NewOperationsListPage(cur, getNextPage)
}
func NewOperationsStatusClient(subscriptionID string) OperationsStatusClient {
	return original.NewOperationsStatusClient(subscriptionID)
}
func NewOperationsStatusClientWithBaseURI(baseURI string, subscriptionID string) OperationsStatusClient {
	return original.NewOperationsStatusClientWithBaseURI(baseURI, subscriptionID)
}
func NewOrderListIterator(page OrderListPage) OrderListIterator {
	return original.NewOrderListIterator(page)
}
func NewOrderListPage(cur OrderList, getNextPage func(context.Context, OrderList) (OrderList, error)) OrderListPage {
	return original.NewOrderListPage(cur, getNextPage)
}
func NewOrdersClient(subscriptionID string) OrdersClient {
	return original.NewOrdersClient(subscriptionID)
}
func NewOrdersClientWithBaseURI(baseURI string, subscriptionID string) OrdersClient {
	return original.NewOrdersClientWithBaseURI(baseURI, subscriptionID)
}
func NewRoleListIterator(page RoleListPage) RoleListIterator {
	return original.NewRoleListIterator(page)
}
func NewRoleListPage(cur RoleList, getNextPage func(context.Context, RoleList) (RoleList, error)) RoleListPage {
	return original.NewRoleListPage(cur, getNextPage)
}
func NewRolesClient(subscriptionID string) RolesClient {
	return original.NewRolesClient(subscriptionID)
}
func NewRolesClientWithBaseURI(baseURI string, subscriptionID string) RolesClient {
	return original.NewRolesClientWithBaseURI(baseURI, subscriptionID)
}
func NewShareListIterator(page ShareListPage) ShareListIterator {
	return original.NewShareListIterator(page)
}
func NewShareListPage(cur ShareList, getNextPage func(context.Context, ShareList) (ShareList, error)) ShareListPage {
	return original.NewShareListPage(cur, getNextPage)
}
func NewSharesClient(subscriptionID string) SharesClient {
	return original.NewSharesClient(subscriptionID)
}
func NewSharesClientWithBaseURI(baseURI string, subscriptionID string) SharesClient {
	return original.NewSharesClientWithBaseURI(baseURI, subscriptionID)
}
func NewSkuListIterator(page SkuListPage) SkuListIterator {
	return original.NewSkuListIterator(page)
}
func NewSkuListPage(cur SkuList, getNextPage func(context.Context, SkuList) (SkuList, error)) SkuListPage {
	return original.NewSkuListPage(cur, getNextPage)
}
func NewStorageAccountCredentialListIterator(page StorageAccountCredentialListPage) StorageAccountCredentialListIterator {
	return original.NewStorageAccountCredentialListIterator(page)
}
func NewStorageAccountCredentialListPage(cur StorageAccountCredentialList, getNextPage func(context.Context, StorageAccountCredentialList) (StorageAccountCredentialList, error)) StorageAccountCredentialListPage {
	return original.NewStorageAccountCredentialListPage(cur, getNextPage)
}
func NewStorageAccountCredentialsClient(subscriptionID string) StorageAccountCredentialsClient {
	return original.NewStorageAccountCredentialsClient(subscriptionID)
}
func NewStorageAccountCredentialsClientWithBaseURI(baseURI string, subscriptionID string) StorageAccountCredentialsClient {
	return original.NewStorageAccountCredentialsClientWithBaseURI(baseURI, subscriptionID)
}
func NewStorageAccountListIterator(page StorageAccountListPage) StorageAccountListIterator {
	return original.NewStorageAccountListIterator(page)
}
func NewStorageAccountListPage(cur StorageAccountList, getNextPage func(context.Context, StorageAccountList) (StorageAccountList, error)) StorageAccountListPage {
	return original.NewStorageAccountListPage(cur, getNextPage)
}
func NewStorageAccountsClient(subscriptionID string) StorageAccountsClient {
	return original.NewStorageAccountsClient(subscriptionID)
}
func NewStorageAccountsClientWithBaseURI(baseURI string, subscriptionID string) StorageAccountsClient {
	return original.NewStorageAccountsClientWithBaseURI(baseURI, subscriptionID)
}
func NewTriggerListIterator(page TriggerListPage) TriggerListIterator {
	return original.NewTriggerListIterator(page)
}
func NewTriggerListPage(cur TriggerList, getNextPage func(context.Context, TriggerList) (TriggerList, error)) TriggerListPage {
	return original.NewTriggerListPage(cur, getNextPage)
}
func NewTriggersClient(subscriptionID string) TriggersClient {
	return original.NewTriggersClient(subscriptionID)
}
func NewTriggersClientWithBaseURI(baseURI string, subscriptionID string) TriggersClient {
	return original.NewTriggersClientWithBaseURI(baseURI, subscriptionID)
}
func NewUserListIterator(page UserListPage) UserListIterator {
	return original.NewUserListIterator(page)
}
func NewUserListPage(cur UserList, getNextPage func(context.Context, UserList) (UserList, error)) UserListPage {
	return original.NewUserListPage(cur, getNextPage)
}
func NewUsersClient(subscriptionID string) UsersClient {
	return original.NewUsersClient(subscriptionID)
}
func NewUsersClientWithBaseURI(baseURI string, subscriptionID string) UsersClient {
	return original.NewUsersClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleAccountTypeValues() []AccountType {
	return original.PossibleAccountTypeValues()
}
func PossibleAddonStateValues() []AddonState {
	return original.PossibleAddonStateValues()
}
func PossibleAlertSeverityValues() []AlertSeverity {
	return original.PossibleAlertSeverityValues()
}
func PossibleAuthenticationTypeValues() []AuthenticationType {
	return original.PossibleAuthenticationTypeValues()
}
func PossibleAzureContainerDataFormatValues() []AzureContainerDataFormat {
	return original.PossibleAzureContainerDataFormatValues()
}
func PossibleClientPermissionTypeValues() []ClientPermissionType {
	return original.PossibleClientPermissionTypeValues()
}
func PossibleContainerStatusValues() []ContainerStatus {
	return original.PossibleContainerStatusValues()
}
func PossibleCreatedByTypeValues() []CreatedByType {
	return original.PossibleCreatedByTypeValues()
}
func PossibleDataPolicyValues() []DataPolicy {
	return original.PossibleDataPolicyValues()
}
func PossibleDayOfWeekValues() []DayOfWeek {
	return original.PossibleDayOfWeekValues()
}
func PossibleDeviceKindValues() []DeviceKind {
	return original.PossibleDeviceKindValues()
}
func PossibleDeviceStatusValues() []DeviceStatus {
	return original.PossibleDeviceStatusValues()
}
func PossibleDeviceTypeValues() []DeviceType {
	return original.PossibleDeviceTypeValues()
}
func PossibleDownloadPhaseValues() []DownloadPhase {
	return original.PossibleDownloadPhaseValues()
}
func PossibleEncryptionAlgorithmValues() []EncryptionAlgorithm {
	return original.PossibleEncryptionAlgorithmValues()
}
func PossibleHostPlatformTypeValues() []HostPlatformType {
	return original.PossibleHostPlatformTypeValues()
}
func PossibleInstallRebootBehaviorValues() []InstallRebootBehavior {
	return original.PossibleInstallRebootBehaviorValues()
}
func PossibleJobStatusValues() []JobStatus {
	return original.PossibleJobStatusValues()
}
func PossibleJobTypeValues() []JobType {
	return original.PossibleJobTypeValues()
}
func PossibleKeyVaultSyncStatusValues() []KeyVaultSyncStatus {
	return original.PossibleKeyVaultSyncStatusValues()
}
func PossibleKindBasicRoleValues() []KindBasicRole {
	return original.PossibleKindBasicRoleValues()
}
func PossibleKindBasicTriggerValues() []KindBasicTrigger {
	return original.PossibleKindBasicTriggerValues()
}
func PossibleKindValues() []Kind {
	return original.PossibleKindValues()
}
func PossibleKubernetesNodeTypeValues() []KubernetesNodeType {
	return original.PossibleKubernetesNodeTypeValues()
}
func PossibleKubernetesStateValues() []KubernetesState {
	return original.PossibleKubernetesStateValues()
}
func PossibleMetricAggregationTypeValues() []MetricAggregationType {
	return original.PossibleMetricAggregationTypeValues()
}
func PossibleMetricCategoryValues() []MetricCategory {
	return original.PossibleMetricCategoryValues()
}
func PossibleMetricUnitValues() []MetricUnit {
	return original.PossibleMetricUnitValues()
}
func PossibleMonitoringStatusValues() []MonitoringStatus {
	return original.PossibleMonitoringStatusValues()
}
func PossibleMountTypeValues() []MountType {
	return original.PossibleMountTypeValues()
}
func PossibleMsiIdentityTypeValues() []MsiIdentityType {
	return original.PossibleMsiIdentityTypeValues()
}
func PossibleNetworkAdapterDHCPStatusValues() []NetworkAdapterDHCPStatus {
	return original.PossibleNetworkAdapterDHCPStatusValues()
}
func PossibleNetworkAdapterRDMAStatusValues() []NetworkAdapterRDMAStatus {
	return original.PossibleNetworkAdapterRDMAStatusValues()
}
func PossibleNetworkAdapterStatusValues() []NetworkAdapterStatus {
	return original.PossibleNetworkAdapterStatusValues()
}
func PossibleNetworkGroupValues() []NetworkGroup {
	return original.PossibleNetworkGroupValues()
}
func PossibleNodeStatusValues() []NodeStatus {
	return original.PossibleNodeStatusValues()
}
func PossibleOrderStateValues() []OrderState {
	return original.PossibleOrderStateValues()
}
func PossiblePlatformTypeValues() []PlatformType {
	return original.PossiblePlatformTypeValues()
}
func PossiblePosixComplianceStatusValues() []PosixComplianceStatus {
	return original.PossiblePosixComplianceStatusValues()
}
func PossibleResourceMoveStatusValues() []ResourceMoveStatus {
	return original.PossibleResourceMoveStatusValues()
}
func PossibleRoleStatusValues() []RoleStatus {
	return original.PossibleRoleStatusValues()
}
func PossibleRoleTypesValues() []RoleTypes {
	return original.PossibleRoleTypesValues()
}
func PossibleSSLStatusValues() []SSLStatus {
	return original.PossibleSSLStatusValues()
}
func PossibleShareAccessProtocolValues() []ShareAccessProtocol {
	return original.PossibleShareAccessProtocolValues()
}
func PossibleShareAccessTypeValues() []ShareAccessType {
	return original.PossibleShareAccessTypeValues()
}
func PossibleShareStatusValues() []ShareStatus {
	return original.PossibleShareStatusValues()
}
func PossibleShipmentTypeValues() []ShipmentType {
	return original.PossibleShipmentTypeValues()
}
func PossibleSkuAvailabilityValues() []SkuAvailability {
	return original.PossibleSkuAvailabilityValues()
}
func PossibleSkuNameValues() []SkuName {
	return original.PossibleSkuNameValues()
}
func PossibleSkuSignupOptionValues() []SkuSignupOption {
	return original.PossibleSkuSignupOptionValues()
}
func PossibleSkuTierValues() []SkuTier {
	return original.PossibleSkuTierValues()
}
func PossibleSkuVersionValues() []SkuVersion {
	return original.PossibleSkuVersionValues()
}
func PossibleStorageAccountStatusValues() []StorageAccountStatus {
	return original.PossibleStorageAccountStatusValues()
}
func PossibleSubscriptionStateValues() []SubscriptionState {
	return original.PossibleSubscriptionStateValues()
}
func PossibleTimeGrainValues() []TimeGrain {
	return original.PossibleTimeGrainValues()
}
func PossibleUpdateOperationStageValues() []UpdateOperationStage {
	return original.PossibleUpdateOperationStageValues()
}
func PossibleUpdateOperationValues() []UpdateOperation {
	return original.PossibleUpdateOperationValues()
}
func PossibleUserTypeValues() []UserType {
	return original.PossibleUserTypeValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/latest"
}
func Version() string {
	return original.Version()
}
