//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/eng/tools/profileBuilder

package automanage

import original "github.com/Azure/azure-sdk-for-go/services/preview/automanage/mgmt/2021-04-30-preview/automanage"

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type ActionType = original.ActionType

const (
	ActionTypeInternal ActionType = original.ActionTypeInternal
)

type CreatedByType = original.CreatedByType

const (
	CreatedByTypeApplication     CreatedByType = original.CreatedByTypeApplication
	CreatedByTypeKey             CreatedByType = original.CreatedByTypeKey
	CreatedByTypeManagedIdentity CreatedByType = original.CreatedByTypeManagedIdentity
	CreatedByTypeUser            CreatedByType = original.CreatedByTypeUser
)

type Origin = original.Origin

const (
	OriginSystem     Origin = original.OriginSystem
	OriginUser       Origin = original.OriginUser
	OriginUsersystem Origin = original.OriginUsersystem
)

type AssignmentReportProperties = original.AssignmentReportProperties
type AzureEntityResource = original.AzureEntityResource
type BaseClient = original.BaseClient
type BestPractice = original.BestPractice
type BestPracticeList = original.BestPracticeList
type BestPracticesClient = original.BestPracticesClient
type BestPracticesVersionsClient = original.BestPracticesVersionsClient
type ConfigurationProfile = original.ConfigurationProfile
type ConfigurationProfileAssignment = original.ConfigurationProfileAssignment
type ConfigurationProfileAssignmentList = original.ConfigurationProfileAssignmentList
type ConfigurationProfileAssignmentProperties = original.ConfigurationProfileAssignmentProperties
type ConfigurationProfileAssignmentsClient = original.ConfigurationProfileAssignmentsClient
type ConfigurationProfileList = original.ConfigurationProfileList
type ConfigurationProfileProperties = original.ConfigurationProfileProperties
type ConfigurationProfileUpdate = original.ConfigurationProfileUpdate
type ConfigurationProfilesClient = original.ConfigurationProfilesClient
type ConfigurationProfilesVersionsClient = original.ConfigurationProfilesVersionsClient
type ErrorAdditionalInfo = original.ErrorAdditionalInfo
type ErrorDetail = original.ErrorDetail
type ErrorResponse = original.ErrorResponse
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationListResult = original.OperationListResult
type OperationsClient = original.OperationsClient
type ProxyResource = original.ProxyResource
type Report = original.Report
type ReportList = original.ReportList
type ReportResource = original.ReportResource
type ReportsClient = original.ReportsClient
type Resource = original.Resource
type SystemData = original.SystemData
type TrackedResource = original.TrackedResource
type UpdateResource = original.UpdateResource

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewBestPracticesClient(subscriptionID string) BestPracticesClient {
	return original.NewBestPracticesClient(subscriptionID)
}
func NewBestPracticesClientWithBaseURI(baseURI string, subscriptionID string) BestPracticesClient {
	return original.NewBestPracticesClientWithBaseURI(baseURI, subscriptionID)
}
func NewBestPracticesVersionsClient(subscriptionID string) BestPracticesVersionsClient {
	return original.NewBestPracticesVersionsClient(subscriptionID)
}
func NewBestPracticesVersionsClientWithBaseURI(baseURI string, subscriptionID string) BestPracticesVersionsClient {
	return original.NewBestPracticesVersionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewConfigurationProfileAssignmentsClient(subscriptionID string) ConfigurationProfileAssignmentsClient {
	return original.NewConfigurationProfileAssignmentsClient(subscriptionID)
}
func NewConfigurationProfileAssignmentsClientWithBaseURI(baseURI string, subscriptionID string) ConfigurationProfileAssignmentsClient {
	return original.NewConfigurationProfileAssignmentsClientWithBaseURI(baseURI, subscriptionID)
}
func NewConfigurationProfilesClient(subscriptionID string) ConfigurationProfilesClient {
	return original.NewConfigurationProfilesClient(subscriptionID)
}
func NewConfigurationProfilesClientWithBaseURI(baseURI string, subscriptionID string) ConfigurationProfilesClient {
	return original.NewConfigurationProfilesClientWithBaseURI(baseURI, subscriptionID)
}
func NewConfigurationProfilesVersionsClient(subscriptionID string) ConfigurationProfilesVersionsClient {
	return original.NewConfigurationProfilesVersionsClient(subscriptionID)
}
func NewConfigurationProfilesVersionsClientWithBaseURI(baseURI string, subscriptionID string) ConfigurationProfilesVersionsClient {
	return original.NewConfigurationProfilesVersionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewReportsClient(subscriptionID string) ReportsClient {
	return original.NewReportsClient(subscriptionID)
}
func NewReportsClientWithBaseURI(baseURI string, subscriptionID string) ReportsClient {
	return original.NewReportsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleActionTypeValues() []ActionType {
	return original.PossibleActionTypeValues()
}
func PossibleCreatedByTypeValues() []CreatedByType {
	return original.PossibleCreatedByTypeValues()
}
func PossibleOriginValues() []Origin {
	return original.PossibleOriginValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
