// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v4.25.3
// source: envoy/extensions/filters/http/jwt_authn/v3/config.proto

package jwt_authnv3

import (
	_ "github.com/cncf/xds/go/udpa/annotations"
	v31 "github.com/envoyproxy/go-control-plane/envoy/config/core/v3"
	v32 "github.com/envoyproxy/go-control-plane/envoy/config/route/v3"
	v3 "github.com/envoyproxy/go-control-plane/envoy/type/matcher/v3"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Please see following for JWT authentication flow:
//
// * `JSON Web Token (JWT) <https://tools.ietf.org/html/rfc7519>`_
// * `The OAuth 2.0 Authorization Framework <https://tools.ietf.org/html/rfc6749>`_
// * `OpenID Connect <http://openid.net/connect>`_
//
// A JwtProvider message specifies how a JSON Web Token (JWT) can be verified. It specifies:
//
// * issuer: the principal that issues the JWT. If specified, it has to match the “iss“ field in JWT.
// * allowed audiences: the ones in the token have to be listed here.
// * how to fetch public key JWKS to verify the token signature.
// * how to extract JWT token in the request.
// * how to pass successfully verified token payload.
//
// Example:
//
// .. code-block:: yaml
//
//	issuer: https://example.com
//	audiences:
//	- bookstore_android.apps.googleusercontent.com
//	- bookstore_web.apps.googleusercontent.com
//	remote_jwks:
//	  http_uri:
//	    uri: https://example.com/.well-known/jwks.json
//	    cluster: example_jwks_cluster
//	    timeout: 1s
//	  cache_duration:
//	    seconds: 300
//
// [#next-free-field: 22]
type JwtProvider struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specify the `principal <https://tools.ietf.org/html/rfc7519#section-4.1.1>`_ that issued
	// the JWT, usually a URL or an email address.
	//
	// It is optional. If specified, it has to match the “iss“ field in JWT,
	// otherwise the JWT “iss“ field is not checked.
	//
	// Note: “JwtRequirement“ :ref:`allow_missing <envoy_v3_api_field_extensions.filters.http.jwt_authn.v3.JwtRequirement.allow_missing>`
	// and :ref:`allow_missing_or_failed <envoy_v3_api_field_extensions.filters.http.jwt_authn.v3.JwtRequirement.allow_missing_or_failed>`
	// are implemented differently than other “JwtRequirements“. Hence the usage of this field
	// is different as follows if “allow_missing“ or “allow_missing_or_failed“ is used:
	//
	// * If a JWT has “iss“ field, it needs to be specified by this field in one of “JwtProviders“.
	// * If a JWT doesn't have “iss“ field, one of “JwtProviders“ should fill this field empty.
	// * Multiple “JwtProviders“ should not have same value in this field.
	//
	// Example: https://securetoken.google.com
	// Example: 1234567-compute@developer.gserviceaccount.com
	Issuer string `protobuf:"bytes,1,opt,name=issuer,proto3" json:"issuer,omitempty"`
	// The list of JWT `audiences <https://tools.ietf.org/html/rfc7519#section-4.1.3>`_ are
	// allowed to access. A JWT containing any of these audiences will be accepted. If not specified,
	// will not check audiences in the token.
	//
	// Example:
	//
	// .. code-block:: yaml
	//
	//	audiences:
	//	- bookstore_android.apps.googleusercontent.com
	//	- bookstore_web.apps.googleusercontent.com
	Audiences []string `protobuf:"bytes,2,rep,name=audiences,proto3" json:"audiences,omitempty"`
	// Restrict the `subjects <https://tools.ietf.org/html/rfc7519#section-4.1.2>`_
	// that the JwtProvider can assert. For instance, this could implement JWT-SVID
	// `subject restrictions <https://github.com/spiffe/spiffe/blob/main/standards/JWT-SVID.md#31-subject>`_.
	// If not specified, will not check subjects in the token.
	//
	// Example:
	//
	// .. code-block:: yaml
	//
	//	subjects:
	//	  prefix: spiffe://spiffe.example.com/
	Subjects *v3.StringMatcher `protobuf:"bytes,19,opt,name=subjects,proto3" json:"subjects,omitempty"`
	// Requires that the credential contains an `expiration <https://tools.ietf.org/html/rfc7519#section-4.1.4>`_.
	// For instance, this could implement JWT-SVID
	// `expiration restrictions <https://github.com/spiffe/spiffe/blob/main/standards/JWT-SVID.md#33-expiration-time>`_.
	// Unlike “max_lifetime“, this only requires that expiration is present, where “max_lifetime“ also checks the value.
	//
	// Example:
	//
	// .. code-block:: yaml
	//
	//	require_expiration: true
	RequireExpiration bool `protobuf:"varint,20,opt,name=require_expiration,json=requireExpiration,proto3" json:"require_expiration,omitempty"`
	// Restrict the maximum remaining lifetime of a credential from the JwtProvider. Credential lifetime
	// is the difference between the current time and the expiration of the credential. For instance,
	// the following example will reject credentials that have a lifetime longer than 24 hours. If not set,
	// expiration checking still occurs, but there is no limit on credential lifetime. If set, takes precedence
	// over “require_expiration“.
	//
	// Example:
	//
	// .. code-block:: yaml
	//
	//	max_lifetime:
	//	  seconds: 86400
	MaxLifetime *durationpb.Duration `protobuf:"bytes,21,opt,name=max_lifetime,json=maxLifetime,proto3" json:"max_lifetime,omitempty"`
	// `JSON Web Key Set (JWKS) <https://tools.ietf.org/html/rfc7517#appendix-A>`_ is needed to
	// validate signature of a JWT. This field specifies where to fetch JWKS.
	//
	// Types that are assignable to JwksSourceSpecifier:
	//
	//	*JwtProvider_RemoteJwks
	//	*JwtProvider_LocalJwks
	JwksSourceSpecifier isJwtProvider_JwksSourceSpecifier `protobuf_oneof:"jwks_source_specifier"`
	// If false, the JWT is removed in the request after a success verification. If true, the JWT is
	// not removed in the request. Default value is false.
	// caveat: only works for from_header & has no effect for JWTs extracted through from_params & from_cookies.
	Forward bool `protobuf:"varint,5,opt,name=forward,proto3" json:"forward,omitempty"`
	// Two fields below define where to extract the JWT from an HTTP request.
	//
	// If no explicit location is specified, the following default locations are tried in order:
	//
	// 1. The Authorization header using the `Bearer schema
	// <https://tools.ietf.org/html/rfc6750#section-2.1>`_. Example::
	//
	//	Authorization: Bearer <token>.
	//
	// 2. `access_token <https://tools.ietf.org/html/rfc6750#section-2.3>`_ query parameter.
	//
	// Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
	// its provider specified or from the default locations.
	//
	// Specify the HTTP headers to extract JWT token. For examples, following config:
	//
	// .. code-block:: yaml
	//
	//	from_headers:
	//	- name: x-goog-iap-jwt-assertion
	//
	// can be used to extract token from header::
	//
	//	``x-goog-iap-jwt-assertion: <JWT>``.
	FromHeaders []*JwtHeader `protobuf:"bytes,6,rep,name=from_headers,json=fromHeaders,proto3" json:"from_headers,omitempty"`
	// JWT is sent in a query parameter. “jwt_params“ represents the query parameter names.
	//
	// For example, if config is:
	//
	// .. code-block:: yaml
	//
	//	from_params:
	//	- jwt_token
	//
	// The JWT format in query parameter is::
	//
	//	/path?jwt_token=<JWT>
	FromParams []string `protobuf:"bytes,7,rep,name=from_params,json=fromParams,proto3" json:"from_params,omitempty"`
	// JWT is sent in a cookie. “from_cookies“ represents the cookie names to extract from.
	//
	// For example, if config is:
	//
	// .. code-block:: yaml
	//
	//	from_cookies:
	//	- auth-token
	//
	// Then JWT will be extracted from “auth-token“ cookie in the request.
	FromCookies []string `protobuf:"bytes,13,rep,name=from_cookies,json=fromCookies,proto3" json:"from_cookies,omitempty"`
	// This field specifies the header name to forward a successfully verified JWT payload to the
	// backend. The forwarded data is::
	//
	//	base64url_encoded(jwt_payload_in_JSON)
	//
	// If it is not specified, the payload will not be forwarded.
	ForwardPayloadHeader string `protobuf:"bytes,8,opt,name=forward_payload_header,json=forwardPayloadHeader,proto3" json:"forward_payload_header,omitempty"`
	// When :ref:`forward_payload_header <envoy_v3_api_field_extensions.filters.http.jwt_authn.v3.JwtProvider.forward_payload_header>`
	// is specified, the base64 encoded payload will be added to the headers.
	// Normally JWT based64 encode doesn't add padding. If this field is true,
	// the header will be padded.
	//
	// This field is only relevant if :ref:`forward_payload_header <envoy_v3_api_field_extensions.filters.http.jwt_authn.v3.JwtProvider.forward_payload_header>`
	// is specified.
	PadForwardPayloadHeader bool `protobuf:"varint,11,opt,name=pad_forward_payload_header,json=padForwardPayloadHeader,proto3" json:"pad_forward_payload_header,omitempty"`
	// If non empty, successfully verified JWT payloads will be written to StreamInfo DynamicMetadata
	// in the format as: “namespace“ is the jwt_authn filter name as ````envoy.filters.http.jwt_authn````
	// The value is the “protobuf::Struct“. The value of this field will be the key for its “fields“
	// and the value is the “protobuf::Struct“ converted from JWT JSON payload.
	//
	// For example, if payload_in_metadata is “my_payload“:
	//
	// .. code-block:: yaml
	//
	//	envoy.filters.http.jwt_authn:
	//	  my_payload:
	//	    iss: https://example.com
	//	    sub: test@example.com
	//	    aud: https://example.com
	//	    exp: 1501281058
	PayloadInMetadata string `protobuf:"bytes,9,opt,name=payload_in_metadata,json=payloadInMetadata,proto3" json:"payload_in_metadata,omitempty"`
	// Normalizes the payload representation in the request metadata.
	NormalizePayloadInMetadata *JwtProvider_NormalizePayload `protobuf:"bytes,18,opt,name=normalize_payload_in_metadata,json=normalizePayloadInMetadata,proto3" json:"normalize_payload_in_metadata,omitempty"`
	// If not empty, similar to :ref:`payload_in_metadata <envoy_v3_api_field_extensions.filters.http.jwt_authn.v3.JwtProvider.payload_in_metadata>`,
	// a successfully verified JWT header will be written to :ref:`Dynamic State <arch_overview_data_sharing_between_filters>`
	// as an entry (“protobuf::Struct“) in “envoy.filters.http.jwt_authn“ “namespace“ with the
	// value of this field as the key.
	//
	// For example, if “header_in_metadata“ is “my_header“:
	//
	// .. code-block:: yaml
	//
	//	envoy.filters.http.jwt_authn:
	//	  my_header:
	//	    alg: JWT
	//	    kid: EF71iSaosbC5C4tC6Syq1Gm647M
	//	    alg: PS256
	//
	// When the metadata has “envoy.filters.http.jwt_authn“ entry already (for example if
	// :ref:`payload_in_metadata <envoy_v3_api_field_extensions.filters.http.jwt_authn.v3.JwtProvider.payload_in_metadata>`
	// is not empty), it will be inserted as a new entry in the same “namespace“ as shown below:
	//
	// .. code-block:: yaml
	//
	//	envoy.filters.http.jwt_authn:
	//	  my_payload:
	//	    iss: https://example.com
	//	    sub: test@example.com
	//	    aud: https://example.com
	//	    exp: 1501281058
	//	  my_header:
	//	    alg: JWT
	//	    kid: EF71iSaosbC5C4tC6Syq1Gm647M
	//	    alg: PS256
	//
	// .. warning::
	//
	//	Using the same key name for :ref:`header_in_metadata <envoy_v3_api_field_extensions.filters.http.jwt_authn.v3.JwtProvider.payload_in_metadata>`
	//	and :ref:`payload_in_metadata <envoy_v3_api_field_extensions.filters.http.jwt_authn.v3.JwtProvider.payload_in_metadata>`
	//	is not suggested due to potential override of existing entry, while it is not enforced during
	//	config validation.
	HeaderInMetadata string `protobuf:"bytes,14,opt,name=header_in_metadata,json=headerInMetadata,proto3" json:"header_in_metadata,omitempty"`
	// If non empty, the failure status “::google::jwt_verify::Status“ for a non verified JWT will be written to StreamInfo DynamicMetadata
	// in the format as: “namespace“ is the jwt_authn filter name as “envoy.filters.http.jwt_authn“
	// The value is the “protobuf::Struct“. The values of this field will be “code“ and “message“
	// and they will contain the JWT authentication failure status code and a message describing the failure.
	//
	// For example, if failed_status_in_metadata is “my_auth_failure_status“:
	//
	// .. code-block:: yaml
	//
	//	envoy.filters.http.jwt_authn:
	//	  my_auth_failure_status:
	//	    code: 3
	//	    message: Jwt expired
	FailedStatusInMetadata string `protobuf:"bytes,16,opt,name=failed_status_in_metadata,json=failedStatusInMetadata,proto3" json:"failed_status_in_metadata,omitempty"`
	// Specify the clock skew in seconds when verifying JWT time constraint,
	// such as “exp“, and “nbf“. If not specified, default is 60 seconds.
	ClockSkewSeconds uint32 `protobuf:"varint,10,opt,name=clock_skew_seconds,json=clockSkewSeconds,proto3" json:"clock_skew_seconds,omitempty"`
	// Enables JWT cache, its size is specified by “jwt_cache_size“.
	// Only valid JWT tokens are cached.
	JwtCacheConfig *JwtCacheConfig `protobuf:"bytes,12,opt,name=jwt_cache_config,json=jwtCacheConfig,proto3" json:"jwt_cache_config,omitempty"`
	// Add JWT claim to HTTP Header
	// Specify the claim name you want to copy in which HTTP header. For examples, following config:
	// The claim must be of type; string, int, double, bool. Array type claims are not supported
	//
	// .. code-block:: yaml
	//
	//	claim_to_headers:
	//	  - name: x-jwt-claim-nested-claim
	//	    claim: claim.nested.key
	//
	// This header is only reserved for jwt claim; any other value will be overwritten.
	ClaimToHeaders []*JwtClaimToHeader `protobuf:"bytes,15,rep,name=claim_to_headers,json=claimToHeaders,proto3" json:"claim_to_headers,omitempty"`
	// Clears route cache in order to allow JWT token to correctly affect
	// routing decisions. Filter clears all cached routes when:
	//
	// 1. The field is set to “true“.
	//
	//  2. At least one “claim_to_headers“ header is added to the request OR
	//     if “payload_in_metadata“ is set.
	ClearRouteCache bool `protobuf:"varint,17,opt,name=clear_route_cache,json=clearRouteCache,proto3" json:"clear_route_cache,omitempty"`
}

func (x *JwtProvider) Reset() {
	*x = JwtProvider{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JwtProvider) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JwtProvider) ProtoMessage() {}

func (x *JwtProvider) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JwtProvider.ProtoReflect.Descriptor instead.
func (*JwtProvider) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_rawDescGZIP(), []int{0}
}

func (x *JwtProvider) GetIssuer() string {
	if x != nil {
		return x.Issuer
	}
	return ""
}

func (x *JwtProvider) GetAudiences() []string {
	if x != nil {
		return x.Audiences
	}
	return nil
}

func (x *JwtProvider) GetSubjects() *v3.StringMatcher {
	if x != nil {
		return x.Subjects
	}
	return nil
}

func (x *JwtProvider) GetRequireExpiration() bool {
	if x != nil {
		return x.RequireExpiration
	}
	return false
}

func (x *JwtProvider) GetMaxLifetime() *durationpb.Duration {
	if x != nil {
		return x.MaxLifetime
	}
	return nil
}

func (m *JwtProvider) GetJwksSourceSpecifier() isJwtProvider_JwksSourceSpecifier {
	if m != nil {
		return m.JwksSourceSpecifier
	}
	return nil
}

func (x *JwtProvider) GetRemoteJwks() *RemoteJwks {
	if x, ok := x.GetJwksSourceSpecifier().(*JwtProvider_RemoteJwks); ok {
		return x.RemoteJwks
	}
	return nil
}

func (x *JwtProvider) GetLocalJwks() *v31.DataSource {
	if x, ok := x.GetJwksSourceSpecifier().(*JwtProvider_LocalJwks); ok {
		return x.LocalJwks
	}
	return nil
}

func (x *JwtProvider) GetForward() bool {
	if x != nil {
		return x.Forward
	}
	return false
}

func (x *JwtProvider) GetFromHeaders() []*JwtHeader {
	if x != nil {
		return x.FromHeaders
	}
	return nil
}

func (x *JwtProvider) GetFromParams() []string {
	if x != nil {
		return x.FromParams
	}
	return nil
}

func (x *JwtProvider) GetFromCookies() []string {
	if x != nil {
		return x.FromCookies
	}
	return nil
}

func (x *JwtProvider) GetForwardPayloadHeader() string {
	if x != nil {
		return x.ForwardPayloadHeader
	}
	return ""
}

func (x *JwtProvider) GetPadForwardPayloadHeader() bool {
	if x != nil {
		return x.PadForwardPayloadHeader
	}
	return false
}

func (x *JwtProvider) GetPayloadInMetadata() string {
	if x != nil {
		return x.PayloadInMetadata
	}
	return ""
}

func (x *JwtProvider) GetNormalizePayloadInMetadata() *JwtProvider_NormalizePayload {
	if x != nil {
		return x.NormalizePayloadInMetadata
	}
	return nil
}

func (x *JwtProvider) GetHeaderInMetadata() string {
	if x != nil {
		return x.HeaderInMetadata
	}
	return ""
}

func (x *JwtProvider) GetFailedStatusInMetadata() string {
	if x != nil {
		return x.FailedStatusInMetadata
	}
	return ""
}

func (x *JwtProvider) GetClockSkewSeconds() uint32 {
	if x != nil {
		return x.ClockSkewSeconds
	}
	return 0
}

func (x *JwtProvider) GetJwtCacheConfig() *JwtCacheConfig {
	if x != nil {
		return x.JwtCacheConfig
	}
	return nil
}

func (x *JwtProvider) GetClaimToHeaders() []*JwtClaimToHeader {
	if x != nil {
		return x.ClaimToHeaders
	}
	return nil
}

func (x *JwtProvider) GetClearRouteCache() bool {
	if x != nil {
		return x.ClearRouteCache
	}
	return false
}

type isJwtProvider_JwksSourceSpecifier interface {
	isJwtProvider_JwksSourceSpecifier()
}

type JwtProvider_RemoteJwks struct {
	// JWKS can be fetched from remote server via HTTP/HTTPS. This field specifies the remote HTTP
	// URI and how the fetched JWKS should be cached.
	//
	// Example:
	//
	// .. code-block:: yaml
	//
	//	remote_jwks:
	//	  http_uri:
	//	    uri: https://www.googleapis.com/oauth2/v1/certs
	//	    cluster: jwt.www.googleapis.com|443
	//	    timeout: 1s
	//	  cache_duration:
	//	    seconds: 300
	RemoteJwks *RemoteJwks `protobuf:"bytes,3,opt,name=remote_jwks,json=remoteJwks,proto3,oneof"`
}

type JwtProvider_LocalJwks struct {
	// JWKS is in local data source. It could be either in a local file or embedded in the
	// inline_string.
	//
	// Example: local file
	//
	// .. code-block:: yaml
	//
	//	local_jwks:
	//	  filename: /etc/envoy/jwks/jwks1.txt
	//
	// Example: inline_string
	//
	// .. code-block:: yaml
	//
	//	local_jwks:
	//	  inline_string: ACADADADADA
	LocalJwks *v31.DataSource `protobuf:"bytes,4,opt,name=local_jwks,json=localJwks,proto3,oneof"`
}

func (*JwtProvider_RemoteJwks) isJwtProvider_JwksSourceSpecifier() {}

func (*JwtProvider_LocalJwks) isJwtProvider_JwksSourceSpecifier() {}

// This message specifies JWT Cache configuration.
type JwtCacheConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unit is number of JWT tokens, default to 100.
	JwtCacheSize uint32 `protobuf:"varint,1,opt,name=jwt_cache_size,json=jwtCacheSize,proto3" json:"jwt_cache_size,omitempty"`
}

func (x *JwtCacheConfig) Reset() {
	*x = JwtCacheConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JwtCacheConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JwtCacheConfig) ProtoMessage() {}

func (x *JwtCacheConfig) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JwtCacheConfig.ProtoReflect.Descriptor instead.
func (*JwtCacheConfig) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_rawDescGZIP(), []int{1}
}

func (x *JwtCacheConfig) GetJwtCacheSize() uint32 {
	if x != nil {
		return x.JwtCacheSize
	}
	return 0
}

// This message specifies how to fetch JWKS from remote and how to cache it.
type RemoteJwks struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The HTTP URI to fetch the JWKS. For example:
	//
	// .. code-block:: yaml
	//
	//	http_uri:
	//	  uri: https://www.googleapis.com/oauth2/v1/certs
	//	  cluster: jwt.www.googleapis.com|443
	//	  timeout: 1s
	HttpUri *v31.HttpUri `protobuf:"bytes,1,opt,name=http_uri,json=httpUri,proto3" json:"http_uri,omitempty"`
	// Duration after which the cached JWKS should be expired. If not specified, default cache
	// duration is 10 minutes.
	CacheDuration *durationpb.Duration `protobuf:"bytes,2,opt,name=cache_duration,json=cacheDuration,proto3" json:"cache_duration,omitempty"`
	// Fetch Jwks asynchronously in the main thread before the listener is activated.
	// Fetched Jwks can be used by all worker threads.
	//
	// If this feature is not enabled:
	//
	//   - The Jwks is fetched on-demand when the requests come. During the fetching, first
	//     few requests are paused until the Jwks is fetched.
	//   - Each worker thread fetches its own Jwks since Jwks cache is per worker thread.
	//
	// If this feature is enabled:
	//
	//   - Fetched Jwks is done in the main thread before the listener is activated. Its fetched
	//     Jwks can be used by all worker threads. Each worker thread doesn't need to fetch its own.
	//   - Jwks is ready when the requests come, not need to wait for the Jwks fetching.
	AsyncFetch *JwksAsyncFetch `protobuf:"bytes,3,opt,name=async_fetch,json=asyncFetch,proto3" json:"async_fetch,omitempty"`
	// Retry policy for fetching Jwks. optional. turned off by default.
	//
	// For example:
	//
	// .. code-block:: yaml
	//
	//	retry_policy:
	//	  retry_back_off:
	//	    base_interval: 0.01s
	//	    max_interval: 20s
	//	  num_retries: 10
	//
	// will yield a randomized truncated exponential backoff policy with an initial delay of 10ms
	// 10 maximum attempts spaced at most 20s seconds.
	//
	// .. code-block:: yaml
	//
	//	retry_policy:
	//	  num_retries:1
	//
	// uses the default :ref:`retry backoff strategy <envoy_v3_api_msg_config.core.v3.BackoffStrategy>`.
	// with the default base interval is 1000 milliseconds. and the default maximum interval of 10 times the base interval.
	//
	// if num_retries is omitted, the default is to allow only one retry.
	//
	// If enabled, the retry policy will apply to all Jwks fetching approaches, e.g. on demand or asynchronously in background.
	RetryPolicy *v31.RetryPolicy `protobuf:"bytes,4,opt,name=retry_policy,json=retryPolicy,proto3" json:"retry_policy,omitempty"`
}

func (x *RemoteJwks) Reset() {
	*x = RemoteJwks{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoteJwks) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoteJwks) ProtoMessage() {}

func (x *RemoteJwks) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoteJwks.ProtoReflect.Descriptor instead.
func (*RemoteJwks) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_rawDescGZIP(), []int{2}
}

func (x *RemoteJwks) GetHttpUri() *v31.HttpUri {
	if x != nil {
		return x.HttpUri
	}
	return nil
}

func (x *RemoteJwks) GetCacheDuration() *durationpb.Duration {
	if x != nil {
		return x.CacheDuration
	}
	return nil
}

func (x *RemoteJwks) GetAsyncFetch() *JwksAsyncFetch {
	if x != nil {
		return x.AsyncFetch
	}
	return nil
}

func (x *RemoteJwks) GetRetryPolicy() *v31.RetryPolicy {
	if x != nil {
		return x.RetryPolicy
	}
	return nil
}

// Fetch Jwks asynchronously in the main thread when the filter config is parsed.
// The listener is activated only after the Jwks is fetched.
// When the Jwks is expired in the cache, it is fetched again in the main thread.
// The fetched Jwks from the main thread can be used by all worker threads.
type JwksAsyncFetch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If false, the listener is activated after the initial fetch is completed.
	// The initial fetch result can be either successful or failed.
	// If true, it is activated without waiting for the initial fetch to complete.
	// Default is false.
	FastListener bool `protobuf:"varint,1,opt,name=fast_listener,json=fastListener,proto3" json:"fast_listener,omitempty"`
	// The duration to refetch after a failed fetch. If not specified, default is 1 second.
	FailedRefetchDuration *durationpb.Duration `protobuf:"bytes,2,opt,name=failed_refetch_duration,json=failedRefetchDuration,proto3" json:"failed_refetch_duration,omitempty"`
}

func (x *JwksAsyncFetch) Reset() {
	*x = JwksAsyncFetch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JwksAsyncFetch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JwksAsyncFetch) ProtoMessage() {}

func (x *JwksAsyncFetch) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JwksAsyncFetch.ProtoReflect.Descriptor instead.
func (*JwksAsyncFetch) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_rawDescGZIP(), []int{3}
}

func (x *JwksAsyncFetch) GetFastListener() bool {
	if x != nil {
		return x.FastListener
	}
	return false
}

func (x *JwksAsyncFetch) GetFailedRefetchDuration() *durationpb.Duration {
	if x != nil {
		return x.FailedRefetchDuration
	}
	return nil
}

// This message specifies a header location to extract JWT token.
type JwtHeader struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The HTTP header name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The value prefix. The value format is "value_prefix<token>"
	// For example, for "Authorization: Bearer <token>", value_prefix="Bearer " with a space at the
	// end.
	ValuePrefix string `protobuf:"bytes,2,opt,name=value_prefix,json=valuePrefix,proto3" json:"value_prefix,omitempty"`
}

func (x *JwtHeader) Reset() {
	*x = JwtHeader{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JwtHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JwtHeader) ProtoMessage() {}

func (x *JwtHeader) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JwtHeader.ProtoReflect.Descriptor instead.
func (*JwtHeader) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_rawDescGZIP(), []int{4}
}

func (x *JwtHeader) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *JwtHeader) GetValuePrefix() string {
	if x != nil {
		return x.ValuePrefix
	}
	return ""
}

// Specify a required provider with audiences.
type ProviderWithAudiences struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specify a required provider name.
	ProviderName string `protobuf:"bytes,1,opt,name=provider_name,json=providerName,proto3" json:"provider_name,omitempty"`
	// This field overrides the one specified in the JwtProvider.
	Audiences []string `protobuf:"bytes,2,rep,name=audiences,proto3" json:"audiences,omitempty"`
}

func (x *ProviderWithAudiences) Reset() {
	*x = ProviderWithAudiences{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProviderWithAudiences) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProviderWithAudiences) ProtoMessage() {}

func (x *ProviderWithAudiences) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProviderWithAudiences.ProtoReflect.Descriptor instead.
func (*ProviderWithAudiences) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_rawDescGZIP(), []int{5}
}

func (x *ProviderWithAudiences) GetProviderName() string {
	if x != nil {
		return x.ProviderName
	}
	return ""
}

func (x *ProviderWithAudiences) GetAudiences() []string {
	if x != nil {
		return x.Audiences
	}
	return nil
}

// This message specifies a Jwt requirement. An empty message means JWT verification is not
// required. Here are some config examples:
//
// .. code-block:: yaml
//
//	# Example 1: not required with an empty message
//
//	# Example 2: require A
//	provider_name: provider-A
//
//	# Example 3: require A or B
//	requires_any:
//	  requirements:
//	    - provider_name: provider-A
//	    - provider_name: provider-B
//
//	# Example 4: require A and B
//	requires_all:
//	  requirements:
//	    - provider_name: provider-A
//	    - provider_name: provider-B
//
//	# Example 5: require A and (B or C)
//	requires_all:
//	  requirements:
//	    - provider_name: provider-A
//	    - requires_any:
//	      requirements:
//	        - provider_name: provider-B
//	        - provider_name: provider-C
//
//	# Example 6: require A or (B and C)
//	requires_any:
//	  requirements:
//	    - provider_name: provider-A
//	    - requires_all:
//	      requirements:
//	        - provider_name: provider-B
//	        - provider_name: provider-C
//
//	# Example 7: A is optional (if token from A is provided, it must be valid, but also allows
//	missing token.)
//	requires_any:
//	  requirements:
//	  - provider_name: provider-A
//	  - allow_missing: {}
//
//	# Example 8: A is optional and B is required.
//	requires_all:
//	  requirements:
//	  - requires_any:
//	      requirements:
//	      - provider_name: provider-A
//	      - allow_missing: {}
//	  - provider_name: provider-B
//
// [#next-free-field: 7]
type JwtRequirement struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to RequiresType:
	//
	//	*JwtRequirement_ProviderName
	//	*JwtRequirement_ProviderAndAudiences
	//	*JwtRequirement_RequiresAny
	//	*JwtRequirement_RequiresAll
	//	*JwtRequirement_AllowMissingOrFailed
	//	*JwtRequirement_AllowMissing
	RequiresType isJwtRequirement_RequiresType `protobuf_oneof:"requires_type"`
}

func (x *JwtRequirement) Reset() {
	*x = JwtRequirement{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JwtRequirement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JwtRequirement) ProtoMessage() {}

func (x *JwtRequirement) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JwtRequirement.ProtoReflect.Descriptor instead.
func (*JwtRequirement) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_rawDescGZIP(), []int{6}
}

func (m *JwtRequirement) GetRequiresType() isJwtRequirement_RequiresType {
	if m != nil {
		return m.RequiresType
	}
	return nil
}

func (x *JwtRequirement) GetProviderName() string {
	if x, ok := x.GetRequiresType().(*JwtRequirement_ProviderName); ok {
		return x.ProviderName
	}
	return ""
}

func (x *JwtRequirement) GetProviderAndAudiences() *ProviderWithAudiences {
	if x, ok := x.GetRequiresType().(*JwtRequirement_ProviderAndAudiences); ok {
		return x.ProviderAndAudiences
	}
	return nil
}

func (x *JwtRequirement) GetRequiresAny() *JwtRequirementOrList {
	if x, ok := x.GetRequiresType().(*JwtRequirement_RequiresAny); ok {
		return x.RequiresAny
	}
	return nil
}

func (x *JwtRequirement) GetRequiresAll() *JwtRequirementAndList {
	if x, ok := x.GetRequiresType().(*JwtRequirement_RequiresAll); ok {
		return x.RequiresAll
	}
	return nil
}

func (x *JwtRequirement) GetAllowMissingOrFailed() *emptypb.Empty {
	if x, ok := x.GetRequiresType().(*JwtRequirement_AllowMissingOrFailed); ok {
		return x.AllowMissingOrFailed
	}
	return nil
}

func (x *JwtRequirement) GetAllowMissing() *emptypb.Empty {
	if x, ok := x.GetRequiresType().(*JwtRequirement_AllowMissing); ok {
		return x.AllowMissing
	}
	return nil
}

type isJwtRequirement_RequiresType interface {
	isJwtRequirement_RequiresType()
}

type JwtRequirement_ProviderName struct {
	// Specify a required provider name.
	ProviderName string `protobuf:"bytes,1,opt,name=provider_name,json=providerName,proto3,oneof"`
}

type JwtRequirement_ProviderAndAudiences struct {
	// Specify a required provider with audiences.
	ProviderAndAudiences *ProviderWithAudiences `protobuf:"bytes,2,opt,name=provider_and_audiences,json=providerAndAudiences,proto3,oneof"`
}

type JwtRequirement_RequiresAny struct {
	// Specify list of JwtRequirement. Their results are OR-ed.
	// If any one of them passes, the result is passed.
	RequiresAny *JwtRequirementOrList `protobuf:"bytes,3,opt,name=requires_any,json=requiresAny,proto3,oneof"`
}

type JwtRequirement_RequiresAll struct {
	// Specify list of JwtRequirement. Their results are AND-ed.
	// All of them must pass, if one of them fails or missing, it fails.
	RequiresAll *JwtRequirementAndList `protobuf:"bytes,4,opt,name=requires_all,json=requiresAll,proto3,oneof"`
}

type JwtRequirement_AllowMissingOrFailed struct {
	// The requirement is always satisfied even if JWT is missing or the JWT
	// verification fails. A typical usage is: this filter is used to only verify
	// JWTs and pass the verified JWT payloads to another filter, the other filter
	// will make decision. In this mode, all JWT tokens will be verified.
	AllowMissingOrFailed *emptypb.Empty `protobuf:"bytes,5,opt,name=allow_missing_or_failed,json=allowMissingOrFailed,proto3,oneof"`
}

type JwtRequirement_AllowMissing struct {
	// The requirement is satisfied if JWT is missing, but failed if JWT is
	// presented but invalid. Similar to allow_missing_or_failed, this is used
	// to only verify JWTs and pass the verified payload to another filter. The
	// different is this mode will reject requests with invalid tokens.
	AllowMissing *emptypb.Empty `protobuf:"bytes,6,opt,name=allow_missing,json=allowMissing,proto3,oneof"`
}

func (*JwtRequirement_ProviderName) isJwtRequirement_RequiresType() {}

func (*JwtRequirement_ProviderAndAudiences) isJwtRequirement_RequiresType() {}

func (*JwtRequirement_RequiresAny) isJwtRequirement_RequiresType() {}

func (*JwtRequirement_RequiresAll) isJwtRequirement_RequiresType() {}

func (*JwtRequirement_AllowMissingOrFailed) isJwtRequirement_RequiresType() {}

func (*JwtRequirement_AllowMissing) isJwtRequirement_RequiresType() {}

// This message specifies a list of RequiredProvider.
// Their results are OR-ed; if any one of them passes, the result is passed
type JwtRequirementOrList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specify a list of JwtRequirement.
	Requirements []*JwtRequirement `protobuf:"bytes,1,rep,name=requirements,proto3" json:"requirements,omitempty"`
}

func (x *JwtRequirementOrList) Reset() {
	*x = JwtRequirementOrList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JwtRequirementOrList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JwtRequirementOrList) ProtoMessage() {}

func (x *JwtRequirementOrList) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JwtRequirementOrList.ProtoReflect.Descriptor instead.
func (*JwtRequirementOrList) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_rawDescGZIP(), []int{7}
}

func (x *JwtRequirementOrList) GetRequirements() []*JwtRequirement {
	if x != nil {
		return x.Requirements
	}
	return nil
}

// This message specifies a list of RequiredProvider.
// Their results are AND-ed; all of them must pass, if one of them fails or missing, it fails.
type JwtRequirementAndList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specify a list of JwtRequirement.
	Requirements []*JwtRequirement `protobuf:"bytes,1,rep,name=requirements,proto3" json:"requirements,omitempty"`
}

func (x *JwtRequirementAndList) Reset() {
	*x = JwtRequirementAndList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JwtRequirementAndList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JwtRequirementAndList) ProtoMessage() {}

func (x *JwtRequirementAndList) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JwtRequirementAndList.ProtoReflect.Descriptor instead.
func (*JwtRequirementAndList) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_rawDescGZIP(), []int{8}
}

func (x *JwtRequirementAndList) GetRequirements() []*JwtRequirement {
	if x != nil {
		return x.Requirements
	}
	return nil
}

// This message specifies a Jwt requirement for a specific Route condition.
// Example 1:
//
// .. code-block:: yaml
//
//   - match:
//     prefix: /healthz
//
// In above example, "requires" field is empty for /healthz prefix match,
// it means that requests matching the path prefix don't require JWT authentication.
//
// Example 2:
//
// .. code-block:: yaml
//
//   - match:
//     prefix: /
//     requires: { provider_name: provider-A }
//
// In above example, all requests matched the path prefix require jwt authentication
// from "provider-A".
type RequirementRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The route matching parameter. Only when the match is satisfied, the "requires" field will
	// apply.
	//
	// For example: following match will match all requests.
	//
	// .. code-block:: yaml
	//
	//	match:
	//	  prefix: /
	Match *v32.RouteMatch `protobuf:"bytes,1,opt,name=match,proto3" json:"match,omitempty"`
	// Specify a Jwt requirement.
	// If not specified, Jwt verification is disabled.
	//
	// Types that are assignable to RequirementType:
	//
	//	*RequirementRule_Requires
	//	*RequirementRule_RequirementName
	RequirementType isRequirementRule_RequirementType `protobuf_oneof:"requirement_type"`
}

func (x *RequirementRule) Reset() {
	*x = RequirementRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RequirementRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RequirementRule) ProtoMessage() {}

func (x *RequirementRule) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RequirementRule.ProtoReflect.Descriptor instead.
func (*RequirementRule) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_rawDescGZIP(), []int{9}
}

func (x *RequirementRule) GetMatch() *v32.RouteMatch {
	if x != nil {
		return x.Match
	}
	return nil
}

func (m *RequirementRule) GetRequirementType() isRequirementRule_RequirementType {
	if m != nil {
		return m.RequirementType
	}
	return nil
}

func (x *RequirementRule) GetRequires() *JwtRequirement {
	if x, ok := x.GetRequirementType().(*RequirementRule_Requires); ok {
		return x.Requires
	}
	return nil
}

func (x *RequirementRule) GetRequirementName() string {
	if x, ok := x.GetRequirementType().(*RequirementRule_RequirementName); ok {
		return x.RequirementName
	}
	return ""
}

type isRequirementRule_RequirementType interface {
	isRequirementRule_RequirementType()
}

type RequirementRule_Requires struct {
	// Specify a Jwt requirement. Please see detail comment in message JwtRequirement.
	Requires *JwtRequirement `protobuf:"bytes,2,opt,name=requires,proto3,oneof"`
}

type RequirementRule_RequirementName struct {
	// Use requirement_name to specify a Jwt requirement.
	// This requirement_name MUST be specified at the
	// :ref:`requirement_map <envoy_v3_api_field_extensions.filters.http.jwt_authn.v3.JwtAuthentication.requirement_map>`
	// in “JwtAuthentication“.
	RequirementName string `protobuf:"bytes,3,opt,name=requirement_name,json=requirementName,proto3,oneof"`
}

func (*RequirementRule_Requires) isRequirementRule_RequirementType() {}

func (*RequirementRule_RequirementName) isRequirementRule_RequirementType() {}

// This message specifies Jwt requirements based on stream_info.filterState.
// This FilterState should use “Router::StringAccessor“ object to set a string value.
// Other HTTP filters can use it to specify Jwt requirements dynamically.
//
// Example:
//
// .. code-block:: yaml
//
//	name: jwt_selector
//	requires:
//	  issuer_1:
//	    provider_name: issuer1
//	  issuer_2:
//	    provider_name: issuer2
//
// If a filter set "jwt_selector" with "issuer_1" to FilterState for a request,
// jwt_authn filter will use JwtRequirement{"provider_name": "issuer1"} to verify.
type FilterStateRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The filter state name to retrieve the “Router::StringAccessor“ object.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A map of string keys to requirements. The string key is the string value
	// in the FilterState with the name specified in the “name“ field above.
	Requires map[string]*JwtRequirement `protobuf:"bytes,3,rep,name=requires,proto3" json:"requires,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *FilterStateRule) Reset() {
	*x = FilterStateRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FilterStateRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FilterStateRule) ProtoMessage() {}

func (x *FilterStateRule) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FilterStateRule.ProtoReflect.Descriptor instead.
func (*FilterStateRule) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_rawDescGZIP(), []int{10}
}

func (x *FilterStateRule) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FilterStateRule) GetRequires() map[string]*JwtRequirement {
	if x != nil {
		return x.Requires
	}
	return nil
}

// This is the Envoy HTTP filter config for JWT authentication.
//
// For example:
//
// .. code-block:: yaml
//
//	providers:
//	   provider1:
//	     issuer: issuer1
//	     audiences:
//	     - audience1
//	     - audience2
//	     remote_jwks:
//	       http_uri:
//	         uri: https://example.com/.well-known/jwks.json
//	         cluster: example_jwks_cluster
//	         timeout: 1s
//	   provider2:
//	     issuer: issuer2
//	     local_jwks:
//	       inline_string: jwks_string
//
//	rules:
//	   # Not jwt verification is required for /health path
//	   - match:
//	       prefix: /health
//
//	   # Jwt verification for provider1 is required for path prefixed with "prefix"
//	   - match:
//	       prefix: /prefix
//	     requires:
//	       provider_name: provider1
//
//	   # Jwt verification for either provider1 or provider2 is required for all other requests.
//	   - match:
//	       prefix: /
//	     requires:
//	       requires_any:
//	         requirements:
//	           - provider_name: provider1
//	           - provider_name: provider2
//
// [#next-free-field: 6]
type JwtAuthentication struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Map of provider names to JwtProviders.
	//
	// .. code-block:: yaml
	//
	//	providers:
	//	  provider1:
	//	     issuer: issuer1
	//	     audiences:
	//	     - audience1
	//	     - audience2
	//	     remote_jwks:
	//	       http_uri:
	//	         uri: https://example.com/.well-known/jwks.json
	//	         cluster: example_jwks_cluster
	//	         timeout: 1s
	//	   provider2:
	//	     issuer: provider2
	//	     local_jwks:
	//	       inline_string: jwks_string
	Providers map[string]*JwtProvider `protobuf:"bytes,1,rep,name=providers,proto3" json:"providers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Specifies requirements based on the route matches. The first matched requirement will be
	// applied. If there are overlapped match conditions, please put the most specific match first.
	//
	// # Examples
	//
	// .. code-block:: yaml
	//
	//	rules:
	//	  - match:
	//	      prefix: /healthz
	//	  - match:
	//	      prefix: /baz
	//	    requires:
	//	      provider_name: provider1
	//	  - match:
	//	      prefix: /foo
	//	    requires:
	//	      requires_any:
	//	        requirements:
	//	          - provider_name: provider1
	//	          - provider_name: provider2
	//	  - match:
	//	      prefix: /bar
	//	    requires:
	//	      requires_all:
	//	        requirements:
	//	          - provider_name: provider1
	//	          - provider_name: provider2
	Rules []*RequirementRule `protobuf:"bytes,2,rep,name=rules,proto3" json:"rules,omitempty"`
	// This message specifies Jwt requirements based on stream_info.filterState.
	// Other HTTP filters can use it to specify Jwt requirements dynamically.
	// The “rules“ field above is checked first, if it could not find any matches,
	// check this one.
	FilterStateRules *FilterStateRule `protobuf:"bytes,3,opt,name=filter_state_rules,json=filterStateRules,proto3" json:"filter_state_rules,omitempty"`
	// When set to true, bypass the `CORS preflight request
	// <http://www.w3.org/TR/cors/#cross-origin-request-with-preflight>`_ regardless of JWT
	// requirements specified in the rules.
	BypassCorsPreflight bool `protobuf:"varint,4,opt,name=bypass_cors_preflight,json=bypassCorsPreflight,proto3" json:"bypass_cors_preflight,omitempty"`
	// A map of unique requirement_names to JwtRequirements.
	// :ref:`requirement_name <envoy_v3_api_field_extensions.filters.http.jwt_authn.v3.PerRouteConfig.requirement_name>`
	// in “PerRouteConfig“ uses this map to specify a JwtRequirement.
	RequirementMap map[string]*JwtRequirement `protobuf:"bytes,5,rep,name=requirement_map,json=requirementMap,proto3" json:"requirement_map,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *JwtAuthentication) Reset() {
	*x = JwtAuthentication{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JwtAuthentication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JwtAuthentication) ProtoMessage() {}

func (x *JwtAuthentication) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JwtAuthentication.ProtoReflect.Descriptor instead.
func (*JwtAuthentication) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_rawDescGZIP(), []int{11}
}

func (x *JwtAuthentication) GetProviders() map[string]*JwtProvider {
	if x != nil {
		return x.Providers
	}
	return nil
}

func (x *JwtAuthentication) GetRules() []*RequirementRule {
	if x != nil {
		return x.Rules
	}
	return nil
}

func (x *JwtAuthentication) GetFilterStateRules() *FilterStateRule {
	if x != nil {
		return x.FilterStateRules
	}
	return nil
}

func (x *JwtAuthentication) GetBypassCorsPreflight() bool {
	if x != nil {
		return x.BypassCorsPreflight
	}
	return false
}

func (x *JwtAuthentication) GetRequirementMap() map[string]*JwtRequirement {
	if x != nil {
		return x.RequirementMap
	}
	return nil
}

// Specify per-route config.
type PerRouteConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to RequirementSpecifier:
	//
	//	*PerRouteConfig_Disabled
	//	*PerRouteConfig_RequirementName
	RequirementSpecifier isPerRouteConfig_RequirementSpecifier `protobuf_oneof:"requirement_specifier"`
}

func (x *PerRouteConfig) Reset() {
	*x = PerRouteConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PerRouteConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PerRouteConfig) ProtoMessage() {}

func (x *PerRouteConfig) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PerRouteConfig.ProtoReflect.Descriptor instead.
func (*PerRouteConfig) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_rawDescGZIP(), []int{12}
}

func (m *PerRouteConfig) GetRequirementSpecifier() isPerRouteConfig_RequirementSpecifier {
	if m != nil {
		return m.RequirementSpecifier
	}
	return nil
}

func (x *PerRouteConfig) GetDisabled() bool {
	if x, ok := x.GetRequirementSpecifier().(*PerRouteConfig_Disabled); ok {
		return x.Disabled
	}
	return false
}

func (x *PerRouteConfig) GetRequirementName() string {
	if x, ok := x.GetRequirementSpecifier().(*PerRouteConfig_RequirementName); ok {
		return x.RequirementName
	}
	return ""
}

type isPerRouteConfig_RequirementSpecifier interface {
	isPerRouteConfig_RequirementSpecifier()
}

type PerRouteConfig_Disabled struct {
	// Disable Jwt Authentication for this route.
	Disabled bool `protobuf:"varint,1,opt,name=disabled,proto3,oneof"`
}

type PerRouteConfig_RequirementName struct {
	// Use requirement_name to specify a JwtRequirement.
	// This requirement_name MUST be specified at the
	// :ref:`requirement_map <envoy_v3_api_field_extensions.filters.http.jwt_authn.v3.JwtAuthentication.requirement_map>`
	// in “JwtAuthentication“. If no, the requests using this route will be rejected with 403.
	RequirementName string `protobuf:"bytes,2,opt,name=requirement_name,json=requirementName,proto3,oneof"`
}

func (*PerRouteConfig_Disabled) isPerRouteConfig_RequirementSpecifier() {}

func (*PerRouteConfig_RequirementName) isPerRouteConfig_RequirementSpecifier() {}

// This message specifies a combination of header name and claim name.
type JwtClaimToHeader struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The HTTP header name to copy the claim to.
	// The header name will be sanitized and replaced.
	HeaderName string `protobuf:"bytes,1,opt,name=header_name,json=headerName,proto3" json:"header_name,omitempty"`
	// The field name for the JWT Claim : it can be a nested claim of type (eg. "claim.nested.key", "sub")
	// String separated with "." in case of nested claims. The nested claim name must use dot "." to separate
	// the JSON name path.
	ClaimName string `protobuf:"bytes,2,opt,name=claim_name,json=claimName,proto3" json:"claim_name,omitempty"`
}

func (x *JwtClaimToHeader) Reset() {
	*x = JwtClaimToHeader{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JwtClaimToHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JwtClaimToHeader) ProtoMessage() {}

func (x *JwtClaimToHeader) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JwtClaimToHeader.ProtoReflect.Descriptor instead.
func (*JwtClaimToHeader) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_rawDescGZIP(), []int{13}
}

func (x *JwtClaimToHeader) GetHeaderName() string {
	if x != nil {
		return x.HeaderName
	}
	return ""
}

func (x *JwtClaimToHeader) GetClaimName() string {
	if x != nil {
		return x.ClaimName
	}
	return ""
}

// Alters the payload representation in the request dynamic metadata to facilitate its use in matching.
type JwtProvider_NormalizePayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Each claim in this list will be interpreted as a space-delimited string
	// and converted to a list of strings based on the delimited values.
	// Example: a token with a claim “scopes: "email profile"“ is translated
	// to dynamic metadata  “scopes: ["email", "profile"]“ if this field is
	// set value “["scopes"]“. This special handling of “scopes“ is
	// recommended by `RFC8693
	// <https://datatracker.ietf.org/doc/html/rfc8693#name-scope-scopes-claim>`_.
	SpaceDelimitedClaims []string `protobuf:"bytes,1,rep,name=space_delimited_claims,json=spaceDelimitedClaims,proto3" json:"space_delimited_claims,omitempty"`
}

func (x *JwtProvider_NormalizePayload) Reset() {
	*x = JwtProvider_NormalizePayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JwtProvider_NormalizePayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JwtProvider_NormalizePayload) ProtoMessage() {}

func (x *JwtProvider_NormalizePayload) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JwtProvider_NormalizePayload.ProtoReflect.Descriptor instead.
func (*JwtProvider_NormalizePayload) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_rawDescGZIP(), []int{0, 0}
}

func (x *JwtProvider_NormalizePayload) GetSpaceDelimitedClaims() []string {
	if x != nil {
		return x.SpaceDelimitedClaims
	}
	return nil
}

var File_envoy_extensions_filters_http_jwt_authn_v3_config_proto protoreflect.FileDescriptor

var file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_rawDesc = []byte{
	0x0a, 0x37, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x68, 0x74, 0x74, 0x70, 0x2f,
	0x6a, 0x77, 0x74, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6e, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2a, 0x65, 0x6e, 0x76, 0x6f, 0x79,
	0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x6a, 0x77, 0x74, 0x5f, 0x61, 0x75, 0x74,
	0x68, 0x6e, 0x2e, 0x76, 0x33, 0x1a, 0x1f, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2f, 0x63, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x33, 0x2f, 0x62, 0x61, 0x73, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2f, 0x63, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x33, 0x2f, 0x68, 0x74, 0x74,
	0x70, 0x5f, 0x75, 0x72, 0x69, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x65, 0x6e, 0x76,
	0x6f, 0x79, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x2f,
	0x76, 0x33, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65,
	0x6e, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x22, 0x65, 0x6e, 0x76, 0x6f, 0x79,
	0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2f, 0x76, 0x33,
	0x2f, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65,
	0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1d, 0x75, 0x64, 0x70, 0x61,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x21, 0x75, 0x64, 0x70, 0x61, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xbe, 0x0b, 0x0a, 0x0b, 0x4a, 0x77, 0x74, 0x50, 0x72, 0x6f,
	0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x16, 0x0a, 0x06, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x12, 0x1c, 0x0a,
	0x09, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x09, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x40, 0x0a, 0x08, 0x73,
	0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x6d, 0x61, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x2e, 0x76, 0x33, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x65, 0x72, 0x52, 0x08, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x12, 0x2d, 0x0a,
	0x12, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x5f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x14, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x72, 0x65, 0x71, 0x75, 0x69,
	0x72, 0x65, 0x45, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x0a, 0x0c,
	0x6d, 0x61, 0x78, 0x5f, 0x6c, 0x69, 0x66, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x15, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x6d,
	0x61, 0x78, 0x4c, 0x69, 0x66, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x59, 0x0a, 0x0b, 0x72, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x6a, 0x77, 0x6b, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x36, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e,
	0x6a, 0x77, 0x74, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x6d,
	0x6f, 0x74, 0x65, 0x4a, 0x77, 0x6b, 0x73, 0x48, 0x00, 0x52, 0x0a, 0x72, 0x65, 0x6d, 0x6f, 0x74,
	0x65, 0x4a, 0x77, 0x6b, 0x73, 0x12, 0x41, 0x0a, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x6a,
	0x77, 0x6b, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x65, 0x6e, 0x76, 0x6f,
	0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x33,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x09, 0x6c,
	0x6f, 0x63, 0x61, 0x6c, 0x4a, 0x77, 0x6b, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x66, 0x6f, 0x72, 0x77,
	0x61, 0x72, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x66, 0x6f, 0x72, 0x77, 0x61,
	0x72, 0x64, 0x12, 0x58, 0x0a, 0x0c, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79,
	0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x6a, 0x77, 0x74, 0x5f, 0x61, 0x75, 0x74,
	0x68, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4a, 0x77, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52,
	0x0b, 0x66, 0x72, 0x6f, 0x6d, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x1f, 0x0a, 0x0b,
	0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0a, 0x66, 0x72, 0x6f, 0x6d, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x21, 0x0a,
	0x0c, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x63, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x73, 0x18, 0x0d, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0b, 0x66, 0x72, 0x6f, 0x6d, 0x43, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x73,
	0x12, 0x41, 0x0a, 0x16, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x5f, 0x70, 0x61, 0x79, 0x6c,
	0x6f, 0x61, 0x64, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x0b, 0xfa, 0x42, 0x08, 0x72, 0x06, 0xc8, 0x01, 0x00, 0xc0, 0x01, 0x01, 0x52, 0x14, 0x66,
	0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x48, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x12, 0x3b, 0x0a, 0x1a, 0x70, 0x61, 0x64, 0x5f, 0x66, 0x6f, 0x72, 0x77, 0x61,
	0x72, 0x64, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x17, 0x70, 0x61, 0x64, 0x46, 0x6f, 0x72, 0x77,
	0x61, 0x72, 0x64, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x12, 0x2e, 0x0a, 0x13, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x69, 0x6e, 0x5f, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x70,
	0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x8b, 0x01, 0x0a, 0x1d, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x5f, 0x70,
	0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x69, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79,
	0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x6a, 0x77, 0x74, 0x5f, 0x61, 0x75, 0x74,
	0x68, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4a, 0x77, 0x74, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65,
	0x72, 0x2e, 0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x52, 0x1a, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x50, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x49, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x2c,
	0x0a, 0x12, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x68, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x49, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x39, 0x0a, 0x19,
	0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x69, 0x6e,
	0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x16, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x49, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x2c, 0x0a, 0x12, 0x63, 0x6c, 0x6f, 0x63, 0x6b,
	0x5f, 0x73, 0x6b, 0x65, 0x77, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x10, 0x63, 0x6c, 0x6f, 0x63, 0x6b, 0x53, 0x6b, 0x65, 0x77, 0x53, 0x65,
	0x63, 0x6f, 0x6e, 0x64, 0x73, 0x12, 0x64, 0x0a, 0x10, 0x6a, 0x77, 0x74, 0x5f, 0x63, 0x61, 0x63,
	0x68, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3a, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e,
	0x6a, 0x77, 0x74, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4a, 0x77, 0x74,
	0x43, 0x61, 0x63, 0x68, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0e, 0x6a, 0x77, 0x74,
	0x43, 0x61, 0x63, 0x68, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x66, 0x0a, 0x10, 0x63,
	0x6c, 0x61, 0x69, 0x6d, 0x5f, 0x74, 0x6f, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18,
	0x0f, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73,
	0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x6a, 0x77, 0x74, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x4a, 0x77, 0x74, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x54, 0x6f, 0x48, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x52, 0x0e, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x54, 0x6f, 0x48, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x63, 0x6c, 0x65, 0x61, 0x72, 0x5f, 0x72, 0x6f, 0x75,
	0x74, 0x65, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f,
	0x63, 0x6c, 0x65, 0x61, 0x72, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x1a,
	0x48, 0x0a, 0x10, 0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x50, 0x61, 0x79, 0x6c,
	0x6f, 0x61, 0x64, 0x12, 0x34, 0x0a, 0x16, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x64, 0x65, 0x6c,
	0x69, 0x6d, 0x69, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x14, 0x73, 0x70, 0x61, 0x63, 0x65, 0x44, 0x65, 0x6c, 0x69, 0x6d, 0x69,
	0x74, 0x65, 0x64, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x73, 0x3a, 0x3d, 0x9a, 0xc5, 0x88, 0x1e, 0x38,
	0x0a, 0x36, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x6a, 0x77, 0x74, 0x5f, 0x61,
	0x75, 0x74, 0x68, 0x6e, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4a, 0x77, 0x74,
	0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x42, 0x1c, 0x0a, 0x15, 0x6a, 0x77, 0x6b, 0x73,
	0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x65,
	0x72, 0x12, 0x03, 0xf8, 0x42, 0x01, 0x22, 0x36, 0x0a, 0x0e, 0x4a, 0x77, 0x74, 0x43, 0x61, 0x63,
	0x68, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x24, 0x0a, 0x0e, 0x6a, 0x77, 0x74, 0x5f,
	0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x0c, 0x6a, 0x77, 0x74, 0x43, 0x61, 0x63, 0x68, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x22, 0xff,
	0x02, 0x0a, 0x0a, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x4a, 0x77, 0x6b, 0x73, 0x12, 0x38, 0x0a,
	0x08, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1d, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x63,
	0x6f, 0x72, 0x65, 0x2e, 0x76, 0x33, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x55, 0x72, 0x69, 0x52, 0x07,
	0x68, 0x74, 0x74, 0x70, 0x55, 0x72, 0x69, 0x12, 0x56, 0x0a, 0x0e, 0x63, 0x61, 0x63, 0x68, 0x65,
	0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x14, 0xfa, 0x42, 0x11, 0xaa,
	0x01, 0x0e, 0x1a, 0x06, 0x08, 0x80, 0xb4, 0xc4, 0xc3, 0x21, 0x32, 0x04, 0x10, 0xc0, 0x84, 0x3d,
	0x52, 0x0d, 0x63, 0x61, 0x63, 0x68, 0x65, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x5b, 0x0a, 0x0b, 0x61, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x66, 0x65, 0x74, 0x63, 0x68, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e,
	0x68, 0x74, 0x74, 0x70, 0x2e, 0x6a, 0x77, 0x74, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x4a, 0x77, 0x6b, 0x73, 0x41, 0x73, 0x79, 0x6e, 0x63, 0x46, 0x65, 0x74, 0x63, 0x68,
	0x52, 0x0a, 0x61, 0x73, 0x79, 0x6e, 0x63, 0x46, 0x65, 0x74, 0x63, 0x68, 0x12, 0x44, 0x0a, 0x0c,
	0x72, 0x65, 0x74, 0x72, 0x79, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x21, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x74, 0x72, 0x79, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x0b, 0x72, 0x65, 0x74, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x3a, 0x3c, 0x9a, 0xc5, 0x88, 0x1e, 0x37, 0x0a, 0x35, 0x65, 0x6e, 0x76, 0x6f, 0x79,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x68,
	0x74, 0x74, 0x70, 0x2e, 0x6a, 0x77, 0x74, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6e, 0x2e, 0x76, 0x32,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x4a, 0x77, 0x6b, 0x73,
	0x22, 0x88, 0x01, 0x0a, 0x0e, 0x4a, 0x77, 0x6b, 0x73, 0x41, 0x73, 0x79, 0x6e, 0x63, 0x46, 0x65,
	0x74, 0x63, 0x68, 0x12, 0x23, 0x0a, 0x0d, 0x66, 0x61, 0x73, 0x74, 0x5f, 0x6c, 0x69, 0x73, 0x74,
	0x65, 0x6e, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x66, 0x61, 0x73, 0x74,
	0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x12, 0x51, 0x0a, 0x17, 0x66, 0x61, 0x69, 0x6c,
	0x65, 0x64, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x74, 0x63, 0x68, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x15, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x52, 0x65, 0x66, 0x65,
	0x74, 0x63, 0x68, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9b, 0x01, 0x0a, 0x09,
	0x4a, 0x77, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x21, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0d, 0xfa, 0x42, 0x0a, 0x72, 0x08, 0x10, 0x01,
	0xc8, 0x01, 0x00, 0xc0, 0x01, 0x01, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2e, 0x0a, 0x0c,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x0b, 0xfa, 0x42, 0x08, 0x72, 0x06, 0xc8, 0x01, 0x00, 0xc0, 0x01, 0x02, 0x52,
	0x0b, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x3a, 0x3b, 0x9a, 0xc5,
	0x88, 0x1e, 0x36, 0x0a, 0x34, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x6a, 0x77,
	0x74, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6e, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x4a, 0x77, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x22, 0xa3, 0x01, 0x0a, 0x15, 0x50, 0x72,
	0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x57, 0x69, 0x74, 0x68, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e,
	0x63, 0x65, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x72, 0x6f, 0x76,
	0x69, 0x64, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x61, 0x75, 0x64, 0x69,
	0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x61, 0x75, 0x64,
	0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x3a, 0x47, 0x9a, 0xc5, 0x88, 0x1e, 0x42, 0x0a, 0x40, 0x65,
	0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x6a, 0x77, 0x74, 0x5f, 0x61, 0x75, 0x74, 0x68,
	0x6e, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64,
	0x65, 0x72, 0x57, 0x69, 0x74, 0x68, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x22,
	0xe4, 0x04, 0x0a, 0x0e, 0x4a, 0x77, 0x74, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0x25, 0x0a, 0x0d, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0c, 0x70, 0x72, 0x6f,
	0x76, 0x69, 0x64, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x79, 0x0a, 0x16, 0x70, 0x72, 0x6f,
	0x76, 0x69, 0x64, 0x65, 0x72, 0x5f, 0x61, 0x6e, 0x64, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e,
	0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x65, 0x6e, 0x76, 0x6f,
	0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x6a, 0x77, 0x74, 0x5f, 0x61, 0x75,
	0x74, 0x68, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x57,
	0x69, 0x74, 0x68, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x48, 0x00, 0x52, 0x14,
	0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x41, 0x6e, 0x64, 0x41, 0x75, 0x64, 0x69, 0x65,
	0x6e, 0x63, 0x65, 0x73, 0x12, 0x65, 0x0a, 0x0c, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x73,
	0x5f, 0x61, 0x6e, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x65, 0x6e, 0x76,
	0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x6a, 0x77, 0x74, 0x5f, 0x61,
	0x75, 0x74, 0x68, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4a, 0x77, 0x74, 0x52, 0x65, 0x71, 0x75, 0x69,
	0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x4f, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x00, 0x52, 0x0b,
	0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x73, 0x41, 0x6e, 0x79, 0x12, 0x66, 0x0a, 0x0c, 0x72,
	0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x73, 0x5f, 0x61, 0x6c, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x41, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74,
	0x70, 0x2e, 0x6a, 0x77, 0x74, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4a,
	0x77, 0x74, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x6e, 0x64,
	0x4c, 0x69, 0x73, 0x74, 0x48, 0x00, 0x52, 0x0b, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x73,
	0x41, 0x6c, 0x6c, 0x12, 0x4f, 0x0a, 0x17, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6e, 0x67, 0x5f, 0x6f, 0x72, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x48, 0x00, 0x52, 0x14,
	0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x4f, 0x72, 0x46, 0x61,
	0x69, 0x6c, 0x65, 0x64, 0x12, 0x3d, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x48, 0x00, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73,
	0x69, 0x6e, 0x67, 0x3a, 0x40, 0x9a, 0xc5, 0x88, 0x1e, 0x3b, 0x0a, 0x39, 0x65, 0x6e, 0x76, 0x6f,
	0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e,
	0x68, 0x74, 0x74, 0x70, 0x2e, 0x6a, 0x77, 0x74, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6e, 0x2e, 0x76,
	0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4a, 0x77, 0x74, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x0f, 0x0a, 0x0d, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65,
	0x73, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0xc8, 0x01, 0x0a, 0x14, 0x4a, 0x77, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x4f, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x12,
	0x68, 0x0a, 0x0c, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73,
	0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x6a, 0x77, 0x74, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x4a, 0x77, 0x74, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x92, 0x01, 0x02, 0x08, 0x02, 0x52, 0x0c, 0x72, 0x65, 0x71,
	0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x46, 0x9a, 0xc5, 0x88, 0x1e, 0x41,
	0x0a, 0x3f, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x6a, 0x77, 0x74, 0x5f, 0x61,
	0x75, 0x74, 0x68, 0x6e, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4a, 0x77, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x4f, 0x72, 0x4c, 0x69, 0x73,
	0x74, 0x22, 0xca, 0x01, 0x0a, 0x15, 0x4a, 0x77, 0x74, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x41, 0x6e, 0x64, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x68, 0x0a, 0x0c, 0x72,
	0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x3a, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74,
	0x70, 0x2e, 0x6a, 0x77, 0x74, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4a,
	0x77, 0x74, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x08, 0xfa,
	0x42, 0x05, 0x92, 0x01, 0x02, 0x08, 0x02, 0x52, 0x0c, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x47, 0x9a, 0xc5, 0x88, 0x1e, 0x42, 0x0a, 0x40, 0x65, 0x6e,
	0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x6a, 0x77, 0x74, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6e,
	0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4a, 0x77, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x6e, 0x64, 0x4c, 0x69, 0x73, 0x74, 0x22, 0xbb,
	0x02, 0x0a, 0x0f, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x75,
	0x6c, 0x65, 0x12, 0x41, 0x0a, 0x05, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x21, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x05,
	0x6d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x58, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e,
	0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x6a, 0x77, 0x74, 0x5f, 0x61, 0x75, 0x74, 0x68,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4a, 0x77, 0x74, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x73, 0x12,
	0x34, 0x0a, 0x10, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x72, 0x02,
	0x10, 0x01, 0x48, 0x00, 0x52, 0x0f, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x4e, 0x61, 0x6d, 0x65, 0x3a, 0x41, 0x9a, 0xc5, 0x88, 0x1e, 0x3c, 0x0a, 0x3a, 0x65, 0x6e,
	0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x6a, 0x77, 0x74, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6e,
	0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x75, 0x6c, 0x65, 0x42, 0x12, 0x0a, 0x10, 0x72, 0x65, 0x71, 0x75,
	0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0xd1, 0x02, 0x0a,
	0x0f, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65,
	0x12, 0x1b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07,
	0xfa, 0x42, 0x04, 0x72, 0x02, 0x10, 0x01, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x65, 0x0a,
	0x08, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x49, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e,
	0x6a, 0x77, 0x74, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x52, 0x65, 0x71,
	0x75, 0x69, 0x72, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75,
	0x69, 0x72, 0x65, 0x73, 0x1a, 0x77, 0x0a, 0x0d, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x50, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65,
	0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x6a, 0x77, 0x74, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x4a, 0x77, 0x74, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x41, 0x9a,
	0xc5, 0x88, 0x1e, 0x3c, 0x0a, 0x3a, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x6a,
	0x77, 0x74, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6e, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65,
	0x22, 0xa8, 0x06, 0x0a, 0x11, 0x4a, 0x77, 0x74, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6a, 0x0a, 0x09, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64,
	0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x65, 0x6e, 0x76, 0x6f,
	0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x6a, 0x77, 0x74, 0x5f, 0x61, 0x75,
	0x74, 0x68, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4a, 0x77, 0x74, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e,
	0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65,
	0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65,
	0x72, 0x73, 0x12, 0x51, 0x0a, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x3b, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74,
	0x70, 0x2e, 0x6a, 0x77, 0x74, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52,
	0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x05,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x69, 0x0a, 0x12, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3b, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74,
	0x70, 0x2e, 0x6a, 0x77, 0x74, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x10,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x73,
	0x12, 0x32, 0x0a, 0x15, 0x62, 0x79, 0x70, 0x61, 0x73, 0x73, 0x5f, 0x63, 0x6f, 0x72, 0x73, 0x5f,
	0x70, 0x72, 0x65, 0x66, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x13, 0x62, 0x79, 0x70, 0x61, 0x73, 0x73, 0x43, 0x6f, 0x72, 0x73, 0x50, 0x72, 0x65, 0x66, 0x6c,
	0x69, 0x67, 0x68, 0x74, 0x12, 0x7a, 0x0a, 0x0f, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x61, 0x70, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x51, 0x2e,
	0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x6a, 0x77,
	0x74, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4a, 0x77, 0x74, 0x41, 0x75,
	0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x71,
	0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x0e, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x61, 0x70,
	0x1a, 0x75, 0x0a, 0x0e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x4d, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68,
	0x74, 0x74, 0x70, 0x2e, 0x6a, 0x77, 0x74, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x4a, 0x77, 0x74, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x7d, 0x0a, 0x13, 0x52, 0x65, 0x71, 0x75, 0x69,
	0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x50, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3a, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e,
	0x6a, 0x77, 0x74, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4a, 0x77, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x43, 0x9a, 0xc5, 0x88, 0x1e, 0x3e, 0x0a, 0x3c, 0x65,
	0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x6a, 0x77, 0x74, 0x5f, 0x61, 0x75, 0x74, 0x68,
	0x6e, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4a, 0x77, 0x74, 0x41, 0x75, 0x74,
	0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8b, 0x01, 0x0a, 0x0e,
	0x50, 0x65, 0x72, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x25,
	0x0a, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x07, 0xfa, 0x42, 0x04, 0x6a, 0x02, 0x08, 0x01, 0x48, 0x00, 0x52, 0x08, 0x64, 0x69, 0x73,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x34, 0x0a, 0x10, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x07, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x10, 0x01, 0x48, 0x00, 0x52, 0x0f, 0x72, 0x65, 0x71, 0x75,
	0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x42, 0x1c, 0x0a, 0x15, 0x72,
	0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x69,
	0x66, 0x69, 0x65, 0x72, 0x12, 0x03, 0xf8, 0x42, 0x01, 0x22, 0x6a, 0x0a, 0x10, 0x4a, 0x77, 0x74,
	0x43, 0x6c, 0x61, 0x69, 0x6d, 0x54, 0x6f, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x2e, 0x0a,
	0x0b, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x0d, 0xfa, 0x42, 0x0a, 0x72, 0x08, 0x10, 0x01, 0xc8, 0x01, 0x00, 0xc0, 0x01,
	0x01, 0x52, 0x0a, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a,
	0x0a, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x10, 0x01, 0x52, 0x09, 0x63, 0x6c, 0x61, 0x69,
	0x6d, 0x4e, 0x61, 0x6d, 0x65, 0x42, 0xb0, 0x01, 0xba, 0x80, 0xc8, 0xd1, 0x06, 0x02, 0x10, 0x02,
	0x0a, 0x38, 0x69, 0x6f, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x2e,
	0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x6a, 0x77,
	0x74, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6e, 0x2e, 0x76, 0x33, 0x42, 0x0b, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x5d, 0x67, 0x69, 0x74, 0x68, 0x75,
	0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x70, 0x72, 0x6f, 0x78, 0x79,
	0x2f, 0x67, 0x6f, 0x2d, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2d, 0x70, 0x6c, 0x61, 0x6e,
	0x65, 0x2f, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x68, 0x74, 0x74, 0x70, 0x2f,
	0x6a, 0x77, 0x74, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6e, 0x2f, 0x76, 0x33, 0x3b, 0x6a, 0x77, 0x74,
	0x5f, 0x61, 0x75, 0x74, 0x68, 0x6e, 0x76, 0x33, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_rawDescOnce sync.Once
	file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_rawDescData = file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_rawDesc
)

func file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_rawDescGZIP() []byte {
	file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_rawDescOnce.Do(func() {
		file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_rawDescData = protoimpl.X.CompressGZIP(file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_rawDescData)
	})
	return file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_rawDescData
}

var file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes = make([]protoimpl.MessageInfo, 18)
var file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_goTypes = []interface{}{
	(*JwtProvider)(nil),                  // 0: envoy.extensions.filters.http.jwt_authn.v3.JwtProvider
	(*JwtCacheConfig)(nil),               // 1: envoy.extensions.filters.http.jwt_authn.v3.JwtCacheConfig
	(*RemoteJwks)(nil),                   // 2: envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks
	(*JwksAsyncFetch)(nil),               // 3: envoy.extensions.filters.http.jwt_authn.v3.JwksAsyncFetch
	(*JwtHeader)(nil),                    // 4: envoy.extensions.filters.http.jwt_authn.v3.JwtHeader
	(*ProviderWithAudiences)(nil),        // 5: envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences
	(*JwtRequirement)(nil),               // 6: envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement
	(*JwtRequirementOrList)(nil),         // 7: envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList
	(*JwtRequirementAndList)(nil),        // 8: envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList
	(*RequirementRule)(nil),              // 9: envoy.extensions.filters.http.jwt_authn.v3.RequirementRule
	(*FilterStateRule)(nil),              // 10: envoy.extensions.filters.http.jwt_authn.v3.FilterStateRule
	(*JwtAuthentication)(nil),            // 11: envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication
	(*PerRouteConfig)(nil),               // 12: envoy.extensions.filters.http.jwt_authn.v3.PerRouteConfig
	(*JwtClaimToHeader)(nil),             // 13: envoy.extensions.filters.http.jwt_authn.v3.JwtClaimToHeader
	(*JwtProvider_NormalizePayload)(nil), // 14: envoy.extensions.filters.http.jwt_authn.v3.JwtProvider.NormalizePayload
	nil,                                  // 15: envoy.extensions.filters.http.jwt_authn.v3.FilterStateRule.RequiresEntry
	nil,                                  // 16: envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication.ProvidersEntry
	nil,                                  // 17: envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication.RequirementMapEntry
	(*v3.StringMatcher)(nil),             // 18: envoy.type.matcher.v3.StringMatcher
	(*durationpb.Duration)(nil),          // 19: google.protobuf.Duration
	(*v31.DataSource)(nil),               // 20: envoy.config.core.v3.DataSource
	(*v31.HttpUri)(nil),                  // 21: envoy.config.core.v3.HttpUri
	(*v31.RetryPolicy)(nil),              // 22: envoy.config.core.v3.RetryPolicy
	(*emptypb.Empty)(nil),                // 23: google.protobuf.Empty
	(*v32.RouteMatch)(nil),               // 24: envoy.config.route.v3.RouteMatch
}
var file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_depIdxs = []int32{
	18, // 0: envoy.extensions.filters.http.jwt_authn.v3.JwtProvider.subjects:type_name -> envoy.type.matcher.v3.StringMatcher
	19, // 1: envoy.extensions.filters.http.jwt_authn.v3.JwtProvider.max_lifetime:type_name -> google.protobuf.Duration
	2,  // 2: envoy.extensions.filters.http.jwt_authn.v3.JwtProvider.remote_jwks:type_name -> envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks
	20, // 3: envoy.extensions.filters.http.jwt_authn.v3.JwtProvider.local_jwks:type_name -> envoy.config.core.v3.DataSource
	4,  // 4: envoy.extensions.filters.http.jwt_authn.v3.JwtProvider.from_headers:type_name -> envoy.extensions.filters.http.jwt_authn.v3.JwtHeader
	14, // 5: envoy.extensions.filters.http.jwt_authn.v3.JwtProvider.normalize_payload_in_metadata:type_name -> envoy.extensions.filters.http.jwt_authn.v3.JwtProvider.NormalizePayload
	1,  // 6: envoy.extensions.filters.http.jwt_authn.v3.JwtProvider.jwt_cache_config:type_name -> envoy.extensions.filters.http.jwt_authn.v3.JwtCacheConfig
	13, // 7: envoy.extensions.filters.http.jwt_authn.v3.JwtProvider.claim_to_headers:type_name -> envoy.extensions.filters.http.jwt_authn.v3.JwtClaimToHeader
	21, // 8: envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks.http_uri:type_name -> envoy.config.core.v3.HttpUri
	19, // 9: envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks.cache_duration:type_name -> google.protobuf.Duration
	3,  // 10: envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks.async_fetch:type_name -> envoy.extensions.filters.http.jwt_authn.v3.JwksAsyncFetch
	22, // 11: envoy.extensions.filters.http.jwt_authn.v3.RemoteJwks.retry_policy:type_name -> envoy.config.core.v3.RetryPolicy
	19, // 12: envoy.extensions.filters.http.jwt_authn.v3.JwksAsyncFetch.failed_refetch_duration:type_name -> google.protobuf.Duration
	5,  // 13: envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement.provider_and_audiences:type_name -> envoy.extensions.filters.http.jwt_authn.v3.ProviderWithAudiences
	7,  // 14: envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement.requires_any:type_name -> envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList
	8,  // 15: envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement.requires_all:type_name -> envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList
	23, // 16: envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement.allow_missing_or_failed:type_name -> google.protobuf.Empty
	23, // 17: envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement.allow_missing:type_name -> google.protobuf.Empty
	6,  // 18: envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementOrList.requirements:type_name -> envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement
	6,  // 19: envoy.extensions.filters.http.jwt_authn.v3.JwtRequirementAndList.requirements:type_name -> envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement
	24, // 20: envoy.extensions.filters.http.jwt_authn.v3.RequirementRule.match:type_name -> envoy.config.route.v3.RouteMatch
	6,  // 21: envoy.extensions.filters.http.jwt_authn.v3.RequirementRule.requires:type_name -> envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement
	15, // 22: envoy.extensions.filters.http.jwt_authn.v3.FilterStateRule.requires:type_name -> envoy.extensions.filters.http.jwt_authn.v3.FilterStateRule.RequiresEntry
	16, // 23: envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication.providers:type_name -> envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication.ProvidersEntry
	9,  // 24: envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication.rules:type_name -> envoy.extensions.filters.http.jwt_authn.v3.RequirementRule
	10, // 25: envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication.filter_state_rules:type_name -> envoy.extensions.filters.http.jwt_authn.v3.FilterStateRule
	17, // 26: envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication.requirement_map:type_name -> envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication.RequirementMapEntry
	6,  // 27: envoy.extensions.filters.http.jwt_authn.v3.FilterStateRule.RequiresEntry.value:type_name -> envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement
	0,  // 28: envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication.ProvidersEntry.value:type_name -> envoy.extensions.filters.http.jwt_authn.v3.JwtProvider
	6,  // 29: envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication.RequirementMapEntry.value:type_name -> envoy.extensions.filters.http.jwt_authn.v3.JwtRequirement
	30, // [30:30] is the sub-list for method output_type
	30, // [30:30] is the sub-list for method input_type
	30, // [30:30] is the sub-list for extension type_name
	30, // [30:30] is the sub-list for extension extendee
	0,  // [0:30] is the sub-list for field type_name
}

func init() { file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_init() }
func file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_init() {
	if File_envoy_extensions_filters_http_jwt_authn_v3_config_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JwtProvider); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JwtCacheConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoteJwks); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JwksAsyncFetch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JwtHeader); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProviderWithAudiences); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JwtRequirement); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JwtRequirementOrList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JwtRequirementAndList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RequirementRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FilterStateRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JwtAuthentication); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PerRouteConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JwtClaimToHeader); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JwtProvider_NormalizePayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*JwtProvider_RemoteJwks)(nil),
		(*JwtProvider_LocalJwks)(nil),
	}
	file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*JwtRequirement_ProviderName)(nil),
		(*JwtRequirement_ProviderAndAudiences)(nil),
		(*JwtRequirement_RequiresAny)(nil),
		(*JwtRequirement_RequiresAll)(nil),
		(*JwtRequirement_AllowMissingOrFailed)(nil),
		(*JwtRequirement_AllowMissing)(nil),
	}
	file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*RequirementRule_Requires)(nil),
		(*RequirementRule_RequirementName)(nil),
	}
	file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes[12].OneofWrappers = []interface{}{
		(*PerRouteConfig_Disabled)(nil),
		(*PerRouteConfig_RequirementName)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   18,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_goTypes,
		DependencyIndexes: file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_depIdxs,
		MessageInfos:      file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_msgTypes,
	}.Build()
	File_envoy_extensions_filters_http_jwt_authn_v3_config_proto = out.File
	file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_rawDesc = nil
	file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_goTypes = nil
	file_envoy_extensions_filters_http_jwt_authn_v3_config_proto_depIdxs = nil
}
